/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.MatrixConfigure;
import lsedit.SortVector;
import lsedit.ToolBarEventHandler;

public class MatrixLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public static final double BORDER = 0.0333;
    public static final double XGAP = 0.2;
    public static final double YGAP = 0.2;
    protected static double m_border = 0.0333;
    protected static double m_xgap = 0.2;
    protected static double m_ygap = 0.2;

    public MatrixLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Matrix";
    }

    public String getMenuLabel() {
        return "Layout in a matrix";
    }

    public static double getBorder() {
        return m_border;
    }

    public void setBorder(double d) {
        m_border = d;
    }

    public static double getXGap() {
        return m_xgap;
    }

    public void setXGap(double d) {
        m_xgap = d;
    }

    public static double getYGap() {
        return m_ygap;
    }

    public void setYGap(double d) {
        m_ygap = d;
    }

    public boolean isConfigurable() {
        return true;
    }

    public void configure(LandscapeEditorCore landscapeEditorCore) {
        MatrixConfigure matrixConfigure = new MatrixConfigure(this, 0.0333, 0.2, 0.2, m_border, m_xgap, m_ygap);
        matrixConfigure.dispose();
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = vector.size();
        int n7 = entityInstance.getWidth();
        int n8 = entityInstance.getHeight();
        int n9 = (int)((double)n7 * m_border / 2.0);
        int n10 = (int)((double)n8 * m_border / 2.0);
        int n11 = n7 - 2 * n9;
        int n12 = n8 - 2 * n10;
        if (n11 < 1 || n12 < 1) {
            return;
        }
        switch (n6) {
            case 0: {
                return;
            }
            case 1: {
                n5 = 1;
                n4 = 0;
                n3 = 0;
                n2 = n11;
                n = n12;
                break;
            }
            default: {
                n5 = (int)Math.ceil(Math.sqrt(n6));
                int n13 = n5 - 1;
                double d = n13;
                n4 = (int)(m_xgap * (double)n11 / d);
                n3 = (int)(m_ygap * (double)n12 / d);
                n2 = (n11 - n4 * n13) / n5;
                n = (n12 - n3 * n13) / n5;
            }
        }
        if (n2 < 1 || n < 1) {
            return;
        }
        double d = (double)(n2 - n4) / (double)n7;
        double d2 = (double)(n - n3) / (double)n8;
        SortVector.byString(vector, true);
        int n14 = 0;
        int n15 = 0;
        for (int i = 0; i < n6; ++i) {
            EntityInstance entityInstance2 = (EntityInstance)vector.elementAt(i);
            int n16 = n9;
            if (n14 != 0) {
                n16 += n14 * n2 + n4;
            }
            double d3 = (double)n16 / (double)n7;
            int n17 = n10;
            if (n15 != 0) {
                n17 += n15 * n + n3;
            }
            double d4 = (double)n17 / (double)n8;
            if (bl) {
                entityInstance2.updateRelLocal(d3, d4, d, d2);
            } else {
                entityInstance2.setRelLocal(d3, d4, d, d2);
            }
            if (++n14 != n5) continue;
            ++n15;
            n14 = 0;
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_ls.setLayouter(this);
        this.m_ls.setCursor(3);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            this.beep();
            return "No group selected";
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Matrix layouter requires that all things laid out share same parent";
        }
        diagram.beginUndoRedo("Matrix layout");
        this.doLayout1(vector, entityInstance, true);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        return "Graph redrawn using Matrix Layout";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }
}

