/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import lsedit.Diagram;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;
import lsedit.RelnChkBox;

public class QueryBox
extends JComponent {
    public static final String DEFAULT_QUERY_TITLE_FONT_NAME = "Helvetica";
    public static final int DEFAULT_QUERY_TITLE_FONT_STYLE = 1;
    public static final int DEFAULT_QUERY_TITLE_FONT_SIZE = 12;
    protected static Font m_titleFont = FontCache.get("Helvetica", 1, 12);
    public static final String DEFAULT_QUERY_TEXT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_QUERY_TEXT_FONT_STYLE = 0;
    public static final int DEFAULT_QUERY_TEXT_FONT_SIZE = 11;
    protected static Font m_textFont = FontCache.get("Helvetica", 0, 11);
    public static final String m_helpStr = "This box shows the relations which are active during queries";
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected JLabel m_ulabel;
    protected JLabel m_footer1;
    protected JLabel m_footer2;
    protected int m_width;
    protected int m_height;
    protected GrpChkBox m_grpChk;

    public QueryBox(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        this.setBackground(Diagram.boxColour);
        this.m_ulabel = new JLabel("Relations");
        this.m_ulabel.setFont(m_titleFont);
        this.m_ulabel.setForeground(Color.black);
        this.m_ulabel.setBackground(Diagram.boxColour);
        this.m_footer1 = new JLabel("Checkboxes select active relations.");
        this.m_footer1.setFont(m_textFont);
        this.m_footer1.setForeground(Color.black);
        this.m_footer1.setBackground(Diagram.boxColour);
        this.m_footer2 = new JLabel("Click relation arrow for description.");
        this.m_footer2.setFont(m_textFont);
        this.m_footer2.setForeground(Color.black);
        this.m_footer2.setBackground(Diagram.boxColour);
        this.m_grpChk = new GrpChkBox(this.m_ls, "Group with queries");
        this.m_grpChk.setFont(m_textFont);
        this.m_grpChk.setForeground(Color.black);
        this.m_grpChk.setBackground(Diagram.boxColour);
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab("Queries", null, this.m_scrollPane, m_helpStr);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component component = this.m_tabbedPane.getSelectedComponent();
        return component != null && this.m_scrollPane == component;
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public static Font getTitleFont() {
        return m_titleFont;
    }

    public static void setTitleFont(Font font) {
        m_titleFont = font;
    }

    public void titleFontChanged(Font font) {
        this.m_ulabel.setFont(font);
        this.fillQueryBox();
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void textFontChanged(Font font) {
        this.m_footer1.setFont(font);
        this.m_footer2.setFont(font);
        this.m_grpChk.setFont(font);
        this.fillQueryBox();
    }

    protected void add(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n > this.m_width) {
            this.m_width = n;
        }
        jComponent.setBounds(5, this.m_height, n, n2);
        super.add(jComponent);
        this.m_height += n2;
    }

    public void fillQueryBox() {
        this.removeAll();
        this.m_width = 0;
        this.m_height = 10;
        this.add(this.m_ulabel);
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            int n = 0;
            this.m_height += 5;
            Enumeration enumeration = diagram.enumRelationClassesInOrder();
            while (enumeration.hasMoreElements()) {
                RelationClass relationClass = (RelationClass)enumeration.nextElement();
                String string = relationClass.getId();
                if (relationClass.isContainsClass()) continue;
                this.add(new ActiveRelnChkBox(relationClass, ++n, m_textFont));
            }
        }
        this.m_height += 20;
        this.add(this.m_footer1);
        this.add(this.m_footer2);
        this.m_height += 10;
        this.add(this.m_grpChk);
        Dimension dimension = new Dimension(this.m_width, this.m_height);
        this.setPreferredSize(dimension);
        this.setBounds(0, 0, this.m_width, this.m_height);
    }

    public void toggleRelationActivity(int n) {
        int n2 = this.getComponentCount();
        if (n == 0) {
            Component component;
            int n3;
            boolean bl = true;
            for (n3 = 0; n3 < n2; ++n3) {
                component = this.getComponent(n3);
                if (!(component instanceof ActiveRelnChkBox) || ((ActiveRelnChkBox)component).getIndex() != 1) continue;
                bl = !((ActiveRelnChkBox)component).isActive();
                break;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                component = this.getComponent(n3);
                if (!(component instanceof ActiveRelnChkBox) || ((ActiveRelnChkBox)component).isActive() == bl) continue;
                ((ActiveRelnChkBox)component).doClick();
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof ActiveRelnChkBox) || ((ActiveRelnChkBox)component).getIndex() != n) continue;
                ((ActiveRelnChkBox)component).doClick();
                break;
            }
        }
    }

    public void toggleGroupingFlag() {
        this.m_grpChk.doClick();
    }

    public boolean getGroupingFlag() {
        return this.m_grpChk.isSelected();
    }

    protected class GrpChkBox
    extends JCheckBox
    implements ItemListener {
        protected LandscapeEditorCore m_ls;

        GrpChkBox(LandscapeEditorCore landscapeEditorCore, String string) {
            super(string);
            this.m_ls = landscapeEditorCore;
            this.addItemListener(this);
        }

        protected void grpStateInfo() {
            this.m_ls.doFeedback("Entities " + (this.isSelected() ? "are" : "aren't") + " grouped with queries");
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.grpStateInfo();
            this.m_ls.requestFocus();
        }
    }

    class ActiveRelnChkBox
    extends RelnChkBox
    implements ItemListener {
        public ActiveRelnChkBox(RelationClass relationClass, int n, Font font) {
            super(relationClass, n, relationClass.isActive(), font);
            this.addItemListener(this);
        }

        public boolean isActive() {
            return this.m_rc.isActive();
        }

        public void setActive(boolean bl) {
            if (this.m_rc.isActive() != bl) {
                this.m_rc.setActiveState(bl);
                this.repaint();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.setActive(itemEvent.getStateChange() == 1);
        }
    }
}

