/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.RelationInstance;
import lsedit.Util;

public class RelationClass
extends LandscapeClassObject {
    protected static final String FACTOR_ID = "class_iofactor";
    protected static final String RELATION_BASE_CLASS_ID = "$RELATION";
    protected boolean m_active = true;
    protected boolean m_visible = true;
    protected boolean m_contains = false;
    private Vector m_relationList = new Vector();
    protected int m_ordinal;

    public RelationClass(String string, int n, RelationClass relationClass, Diagram diagram) {
        this.setId(string);
        this.setNid(n);
        this.setLabel(string);
        this.setLandscapeObjectDiagram(diagram);
        this.setStyle(0);
        this.addParentClass(relationClass);
        this.setObjectColor(Color.black);
    }

    public String getStyleName(int n) {
        return Util.getLineStyleName(n);
    }

    public void setContainsClass(boolean bl) {
        this.m_contains = bl;
    }

    public boolean isContainsClass() {
        return this.m_contains;
    }

    public void addRelation(EntityClass entityClass, EntityClass entityClass2) {
        EntityClassPair entityClassPair = new EntityClassPair(entityClass, entityClass2);
        if (this.m_relationList == null) {
            this.m_relationList = new Vector();
        }
        this.m_relationList.addElement(entityClassPair);
    }

    public RelationInstance newRelation(EntityInstance entityInstance, EntityInstance entityInstance2) {
        RelationInstance relationInstance = new RelationInstance(this, entityInstance, entityInstance2);
        this.makeInstanceOfUs(relationInstance);
        return relationInstance;
    }

    public void writeRelations(PrintStream printStream) throws IOException {
        Enumeration enumeration = this.m_relationList.elements();
        while (enumeration.hasMoreElements()) {
            EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
            printStream.print(this.qt(this.getId()) + " " + this.qt(entityClassPair.entityClass1.getId()) + " " + this.qt(entityClassPair.entityClass2.getId()) + "\n");
        }
    }

    public void getRelationsRaw(Vector vector, Hashtable hashtable) {
        Enumeration enumeration = this.m_relationList.elements();
        while (enumeration.hasMoreElements()) {
            EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
            Integer[] integerArray = new Integer[]{(Integer)hashtable.get(this.getId()), (Integer)hashtable.get(entityClassPair.entityClass1.getId()), (Integer)hashtable.get(entityClassPair.entityClass2.getId())};
            vector.addElement(integerArray);
        }
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        if (this.getNid() >= 2) {
            printStream.print("(" + this.qt(this.getId()) + ") {\n");
            super.writeAttributes(printStream);
            printStream.print("}\n\n");
        }
    }

    public boolean isClassVisible() {
        return this.m_visible && !this.m_contains;
    }

    public void setClassVisible(boolean bl) {
        this.m_visible = bl;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActiveState(boolean bl) {
        this.m_active = bl;
    }

    public String addParentClass(RelationClass relationClass) {
        return this.addParentClass(relationClass, RELATION_BASE_CLASS_ID);
    }

    public void setOrdinal(int n) {
        this.m_ordinal = n;
    }

    public double getIOfactor() {
        Attribute attribute = this.getLsAttribute(FACTOR_ID);
        if (attribute != null) {
            return Util.parseReal(attribute.avi.value);
        }
        Diagram diagram = this.getDiagram();
        if (diagram.allowElision()) {
            double d = diagram.numVisibleRelationClasses();
            return (double)(this.m_ordinal + 1) / (d + 1.0);
        }
        double d = diagram.numRelationClasses();
        return d > 2.0 ? (double)(this.getNid() - 1) / (d - 1.0) : 0.5;
    }

    public int getPrimaryAttributeCount() {
        return 6;
    }

    public String getLsAttributeNameAt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "id";
                break;
            }
            case 1: {
                string = "class_label";
                break;
            }
            case 2: {
                string = "class_description";
                break;
            }
            case 3: {
                string = "class_style";
                break;
            }
            case 4: {
                string = "color";
                break;
            }
            case 5: {
                string = "labelcolor";
                break;
            }
            default: {
                string = super.getLsAttributeNameAt(n);
            }
        }
        return string;
    }

    public Object getLsAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
                break;
            }
            case 1: {
                object = this.getLabel();
                break;
            }
            case 2: {
                object = this.getDescription();
                break;
            }
            case 3: {
                object = new Integer(this.getStyle());
                break;
            }
            case 4: {
                object = this.getObjectColor();
                break;
            }
            case 5: {
                object = this.getLabelColor();
                break;
            }
            default: {
                object = super.getLsAttributeValueAt(n);
            }
        }
        return object;
    }

    public void setAttributeValueAt(int n, Object object) {
        switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                this.updateLabel((String)object);
                break;
            }
            case 2: {
                this.updateDescription((String)object);
                break;
            }
            case 3: {
                this.updateStyle((Integer)object);
                break;
            }
            case 4: {
                this.updateObjectColor((Color)object);
                break;
            }
            case 5: {
                this.updateLabelColor((Color)object);
                break;
            }
            default: {
                super.setAttributeValueAt(n, object);
            }
        }
    }

    public int getLsAttributeTypeAt(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 14;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 7;
                break;
            }
            default: {
                n2 = super.getLsAttributeTypeAt(n);
            }
        }
        return n2;
    }
}

