/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.MsgOut;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.Util;

public class RelationComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    protected static final Color HIGHLIGHT_COLOUR = Color.yellow;
    protected static final int HIGHLIGHT_DIM = 4;
    protected static final int RECURSIVE_LOOP_RADIUS = 8;
    protected static final int RECURSIVE_LOOP_DIAMETER = 16;
    protected static final int[] m_arc_xp = new int[]{0, 0, 7};
    protected static final int[] m_arc_yp = new int[]{7, 0, 7};
    protected static final int NEAR_POINT_THRESHOLD = 1;
    protected static final int NEAR_LINE_THRESHOLD2 = 1;
    protected static final int NEAR_LOOP_THRESHOLD = 1;
    public static final int DRAW_TAIL_MARK = 1;
    public static final int DRAW_CENTRE_MARK = 2;
    public static final int DRAW_ARROW_MARK = 4;
    private RelationInstance m_relationInstance;
    private Object m_drawInfo;
    private int timeStamp = -1;

    public static void getLineBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n <= n3) {
            n8 = n;
            n7 = n3;
        } else {
            n8 = n3;
            n7 = n;
        }
        if (n2 <= n4) {
            n6 = n2;
            n5 = n4;
        } else {
            n6 = n4;
            n5 = n2;
        }
        if (Util.LINE_W > 1) {
            int n9 = n7 - n8;
            int n10 = n5 - n6;
            int n11 = Util.LINE_W / 2;
            if (n10 > 2 * n9) {
                n8 -= n11;
                n7 += n11;
            }
            if (n9 >= 2 * n10) {
                n6 -= n11;
                n5 += n11;
            }
        }
        rectangle.setBounds(n8, n6, n7 - n8, n5 - n6);
    }

    public static void includeTailBounds(int n, int n2, Rectangle rectangle) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = n3 + rectangle.width;
        int n6 = n4 + rectangle.height;
        int n7 = n - 3;
        int n8 = n2 - 3;
        if (n7 < n3) {
            n3 = n7;
        }
        if (n8 < n4) {
            n4 = n8;
        }
        n8 += 6;
        if ((n7 += 6) > n5) {
            n5 = n7;
        }
        if (n8 > n6) {
            n6 = n8;
        }
        rectangle.setBounds(n3, n4, n5 - n3, n6 - n4);
    }

    public static void includeCentreBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = n5 + rectangle.width;
        int n8 = n6 + rectangle.height;
        int n9 = (n + n3 - 4) / 2;
        int n10 = (n2 + n4 - 4) / 2;
        if (n9 < n5) {
            n5 = n9;
        }
        if (n10 < n6) {
            n6 = n10;
        }
        n10 += 4;
        if ((n9 += 4) > n7) {
            n7 = n9;
        }
        if (n10 > n8) {
            n8 = n10;
        }
        rectangle.setBounds(n5, n6, n7 - n5, n8 - n6);
    }

    public static void includeArrowBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = n5 + rectangle.width;
        int n8 = n6 + rectangle.height;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (Util.getArrow(n, n2, n3, n4, nArray, nArray2) != 0.0) {
            for (int i = 0; i < 3; ++i) {
                int n9 = nArray[i];
                int n10 = nArray2[i];
                if (n9 < n5) {
                    n5 = n9;
                }
                if (n10 < n6) {
                    n6 = n10;
                }
                if (n9 > n7) {
                    n7 = n9;
                }
                if (n10 <= n8) continue;
                n8 = n10;
            }
        }
        rectangle.setBounds(n5, n6, n7 - n5, n8 - n6);
    }

    public static boolean nearPoint(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n5 > 1) {
            return false;
        }
        n5 = n4 - n2;
        if (n5 < 0) {
            n5 = -n5;
        }
        return n5 <= 1;
    }

    public static boolean nearLine(int n, int n2, int n3, int n4, int n5, int n6) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        if (n == n3 && n2 == n4) {
            return RelationComponent.nearPoint(n, n2, n5, n6);
        }
        double d6 = n5;
        double d7 = n3 - n;
        double d8 = n6;
        double d9 = n4 - n2;
        double d10 = ((d6 - (double)n) * d7 + (d8 - (double)n2) * d9) / (d7 * d7 + d9 * d9);
        return d10 >= 0.0 && d10 <= 1.0 && (d5 = (d4 = d6 - (d3 = (double)n + d10 * d7)) * d4 + (d2 = d8 - (d = (double)n2 + d10 * d9)) * d2) <= 1.0;
    }

    protected Vector points(boolean bl) {
        EdgeInfo edgeInfo;
        EntityInstance entityInstance;
        EntityInstance entityInstance2;
        EntityInstance entityInstance3;
        EntityInstance entityInstance4;
        boolean bl2;
        RelationInstance relationInstance = this.m_relationInstance;
        Diagram diagram = relationInstance.getDiagram();
        EntityInstance entityInstance5 = diagram.getDrawRoot();
        EntityInstance entityInstance6 = relationInstance.getDrawSrc();
        EntityInstance entityInstance7 = relationInstance.getDrawDst();
        RelationClass relationClass = relationInstance.getRelationClass();
        OutElidedInfo outElidedInfo = null;
        InElidedInfo inElidedInfo = null;
        boolean bl3 = !entityInstance5.hasDescendantOrSelf(entityInstance6);
        boolean bl4 = bl2 = !entityInstance5.hasDescendantOrSelf(entityInstance7);
        if (!bl3 && !bl2) {
            entityInstance3 = entityInstance4 = entityInstance6.commonAncestor(entityInstance7);
        } else if (bl3) {
            entityInstance4 = entityInstance6.getContainedBy();
            entityInstance3 = entityInstance5.getContainedBy();
        } else {
            entityInstance4 = entityInstance5.getContainedBy();
            entityInstance3 = entityInstance7.getContainedBy();
        }
        if (entityInstance4 == null) {
            System.out.println("C Error: " + relationInstance + " " + bl3 + " " + bl2);
            return null;
        }
        if (entityInstance3 == null) {
            System.out.println("S Error: " + relationInstance + " " + bl3 + " " + bl2);
            return null;
        }
        Vector<LineInfo> vector = new Vector<LineInfo>();
        Vector<LineInfo> vector2 = new Vector<LineInfo>();
        int n = diagram.getEdgeMode();
        EntityInstance entityInstance8 = entityInstance6;
        while ((entityInstance2 = entityInstance8.getContainedBy()) != entityInstance4) {
            entityInstance8 = entityInstance2;
        }
        EntityInstance entityInstance9 = entityInstance7;
        while ((entityInstance2 = entityInstance9.getContainedBy()) != entityInstance3) {
            entityInstance9 = entityInstance2;
        }
        Rectangle rectangle = entityInstance8.getDiagramBounds();
        Rectangle rectangle2 = entityInstance9.getDiagramBounds();
        int n2 = bl && (relationInstance.getSrc() != entityInstance6 || relationInstance.getDst() != entityInstance7) ? 2 : relationInstance.getStyle();
        int n3 = 1;
        if (relationInstance.isMarked(512)) {
            n3 |= 2;
        }
        EdgePoint edgePoint = null;
        EdgePoint edgePoint2 = null;
        EntityInstance entityInstance10 = entityInstance6;
        while (entityInstance10 != entityInstance4) {
            if (entityInstance10 == null) {
                MsgOut.println("Error in points: (" + relationClass.getId() + " " + relationInstance + ")");
                return null;
            }
            entityInstance = entityInstance10.getContainedBy();
            edgePoint = entityInstance10.getOutPoint(relationInstance, n, rectangle, rectangle2);
            if (edgePoint2 != null) {
                if (bl && entityInstance10.isExitingRelationElided(relationClass)) {
                    outElidedInfo = new OutElidedInfo();
                    outElidedInfo.setOutElidedInfo(edgePoint, rectangle2);
                    outElidedInfo.setStyle(n2);
                    vector.addElement(outElidedInfo);
                    break;
                }
                edgeInfo = new EdgeInfo();
                edgeInfo.setEdgeInfo(edgePoint2, edgePoint);
                edgeInfo.setStyle(n2);
                edgeInfo.setEmbellished(n3);
                n3 &= 0xFFFFFFFE;
                vector.addElement(edgeInfo);
            }
            edgePoint2 = edgePoint;
            entityInstance10 = entityInstance;
        }
        n3 &= 0xFFFFFFFE;
        n3 |= 4;
        EdgePoint edgePoint3 = null;
        edgePoint2 = null;
        entityInstance10 = entityInstance7;
        while (entityInstance10 != entityInstance3) {
            entityInstance = entityInstance10.getContainedBy();
            edgePoint3 = entityInstance10.getOutPoint(relationInstance, n, rectangle2, rectangle);
            if (edgePoint2 != null) {
                if (bl && entityInstance10.isEnteringRelationElided(relationClass)) {
                    inElidedInfo = new InElidedInfo();
                    inElidedInfo.setInElidedInfo(rectangle, edgePoint3);
                    inElidedInfo.setStyle(n2);
                    vector2.addElement(inElidedInfo);
                    break;
                }
                edgeInfo = new EdgeInfo();
                edgeInfo.setEdgeInfo(edgePoint3, edgePoint2);
                edgeInfo.setStyle(n2);
                edgeInfo.setEmbellished(n3);
                n3 &= 0xFFFFFFFB;
                vector2.addElement(edgeInfo);
            }
            edgePoint2 = edgePoint3;
            entityInstance10 = entityInstance;
        }
        if (outElidedInfo == null && inElidedInfo == null) {
            edgeInfo = new EdgeInfo();
            edgeInfo.setEdgeInfo(edgePoint, edgePoint3);
            vector.addElement(edgeInfo);
        } else if (inElidedInfo == null) {
            vector2.removeAllElements();
        } else if (outElidedInfo == null) {
            vector.removeAllElements();
        }
        for (int i = vector2.size() - 1; i >= 0; --i) {
            vector.addElement((LineInfo)vector2.elementAt(i));
        }
        return vector;
    }

    public RelationComponent(RelationInstance relationInstance) {
        this.setLayout(null);
        this.m_relationInstance = relationInstance;
        relationInstance.setSwingObject(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void computeBounds(Rectangle rectangle) {
        if (this.m_drawInfo == null) {
            rectangle.setBounds(0, 0, 0, 0);
        } else if (this.m_drawInfo instanceof DrawInfo) {
            ((DrawInfo)this.m_drawInfo).getBounds(rectangle);
        } else {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            Enumeration enumeration = ((Vector)this.m_drawInfo).elements();
            while (enumeration.hasMoreElements()) {
                int n5;
                DrawInfo drawInfo = (DrawInfo)enumeration.nextElement();
                drawInfo.getBounds(rectangle);
                int n6 = rectangle.x;
                if (n6 < n) {
                    n = n6;
                }
                if ((n5 = rectangle.y) < n3) {
                    n3 = n5;
                }
                n5 += rectangle.height;
                if ((n6 += rectangle.width) > n2) {
                    n2 = n6;
                }
                if (n5 <= n4) continue;
                n4 = n5;
            }
            rectangle.setBounds(n, n3, n2 - n, n4 - 1);
        }
    }

    public boolean contains(int n, int n2) {
        if (super.contains(n, n2)) {
            n += this.getX();
            n2 += this.getY();
            if (this.m_drawInfo != null) {
                if (this.m_drawInfo instanceof DrawInfo) {
                    return ((DrawInfo)this.m_drawInfo).contains(n, n2);
                }
                Enumeration enumeration = ((Vector)this.m_drawInfo).elements();
                while (enumeration.hasMoreElements()) {
                    if (!((DrawInfo)enumeration.nextElement()).contains(n, n2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public EdgePoint mouseOverEdgePoint(int n, int n2) {
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                return ((DrawInfo)this.m_drawInfo).mouseOverEdgePoint(n, n2);
            }
            Enumeration enumeration = ((Vector)this.m_drawInfo).elements();
            while (enumeration.hasMoreElements()) {
                EdgePoint edgePoint = ((DrawInfo)enumeration.nextElement()).mouseOverEdgePoint(n, n2);
                if (edgePoint == null) continue;
                return edgePoint;
            }
        }
        return null;
    }

    public void validate() {
        RelationInstance relationInstance = this.m_relationInstance;
        Diagram diagram = relationInstance.getDiagram();
        super.validate();
        EntityInstance entityInstance = relationInstance.getDrawSrc();
        if (entityInstance == null) {
            return;
        }
        EntityInstance entityInstance2 = relationInstance.getDrawDst();
        if (entityInstance2 == null) {
            return;
        }
        if (relationInstance.isMarked(1)) {
            if (this.m_drawInfo == null || !(this.m_drawInfo instanceof ArcInfo)) {
                this.m_drawInfo = new ArcInfo();
            }
            ((ArcInfo)this.m_drawInfo).setArc(entityInstance.getDiagramX() + entityInstance.getWidth() - 8, entityInstance.getDiagramY() - 8);
        } else {
            Rectangle rectangle = entityInstance.getDiagramBounds();
            Rectangle rectangle2 = entityInstance2.getDiagramBounds();
            int n = diagram.getEdgeMode();
            if (relationInstance.isMarked(48)) {
                EdgePoint edgePoint;
                DrawInfo drawInfo;
                Enumeration enumeration;
                OutElidedInfo outElidedInfo = null;
                InElidedInfo inElidedInfo = null;
                if (relationInstance.isMarked(16)) {
                    if (this.m_drawInfo != null) {
                        if (this.m_drawInfo instanceof OutElidedInfo) {
                            outElidedInfo = (OutElidedInfo)this.m_drawInfo;
                        } else if (this.m_drawInfo instanceof Vector) {
                            enumeration = ((Vector)this.m_drawInfo).elements();
                            while (enumeration.hasMoreElements()) {
                                drawInfo = (DrawInfo)enumeration.nextElement();
                                if (!(drawInfo instanceof OutElidedInfo)) continue;
                                outElidedInfo = (OutElidedInfo)drawInfo;
                                break;
                            }
                        }
                    }
                    if (outElidedInfo == null) {
                        outElidedInfo = new OutElidedInfo();
                    }
                    edgePoint = entityInstance.getOutPoint(relationInstance, n, rectangle, rectangle2);
                    outElidedInfo.setOutElidedInfo(edgePoint, rectangle2);
                    outElidedInfo.setStyle(relationInstance.getStyle());
                }
                if (relationInstance.isMarked(32)) {
                    if (this.m_drawInfo != null) {
                        if (this.m_drawInfo instanceof InElidedInfo) {
                            inElidedInfo = (InElidedInfo)this.m_drawInfo;
                        } else if (this.m_drawInfo instanceof Vector) {
                            enumeration = ((Vector)this.m_drawInfo).elements();
                            while (enumeration.hasMoreElements()) {
                                drawInfo = (DrawInfo)enumeration.nextElement();
                                if (!(drawInfo instanceof InElidedInfo)) continue;
                                inElidedInfo = (InElidedInfo)drawInfo;
                                break;
                            }
                        }
                    }
                    if (inElidedInfo == null) {
                        inElidedInfo = new InElidedInfo();
                    }
                    edgePoint = entityInstance2.getOutPoint(relationInstance, n, rectangle2, rectangle);
                    inElidedInfo.setInElidedInfo(rectangle, edgePoint);
                    inElidedInfo.setStyle(relationInstance.getStyle());
                }
                if (outElidedInfo == null) {
                    this.m_drawInfo = inElidedInfo;
                } else if (inElidedInfo == null) {
                    this.m_drawInfo = outElidedInfo;
                } else {
                    if (this.m_drawInfo instanceof Vector) {
                        ((Vector)this.m_drawInfo).removeAllElements();
                    } else {
                        this.m_drawInfo = new Vector();
                    }
                    ((Vector)this.m_drawInfo).addElement(outElidedInfo);
                    ((Vector)this.m_drawInfo).addElement(inElidedInfo);
                }
            } else if (relationInstance.isMarked(2)) {
                if (n == 2 || n == 3 || entityInstance.getContainedBy() == entityInstance2.getContainedBy() || !relationInstance.isMarked(4)) {
                    if (this.m_drawInfo == null || !(this.m_drawInfo instanceof EdgeInfo)) {
                        this.m_drawInfo = new EdgeInfo();
                    }
                    EdgeInfo edgeInfo = (EdgeInfo)this.m_drawInfo;
                    EdgePoint edgePoint = null;
                    EdgePoint edgePoint2 = null;
                    if (n == 3) {
                        if (entityInstance.hasDescendant(entityInstance2)) {
                            edgePoint2 = entityInstance.getLeftOutPoint(relationInstance);
                        } else if (entityInstance2.hasDescendant(entityInstance)) {
                            edgePoint = entityInstance2.getRightOutPoint(relationInstance);
                        }
                    }
                    if (edgePoint2 == null) {
                        edgePoint2 = entityInstance.getOutPoint(relationInstance, n, rectangle, rectangle2);
                    }
                    if (edgePoint == null) {
                        edgePoint = entityInstance2.getOutPoint(relationInstance, n, rectangle2, rectangle);
                    }
                    edgeInfo.setEdgeInfo(edgePoint2, edgePoint);
                    if (relationInstance.getSrc() != entityInstance || relationInstance.getDst() != entityInstance2) {
                        edgeInfo.setStyle(2);
                    } else {
                        edgeInfo.setStyle(relationInstance.getStyle());
                    }
                    int n2 = 4;
                    if (relationInstance.isMarked(512)) {
                        n2 |= 2;
                    }
                    edgeInfo.setEmbellished(n2);
                } else {
                    this.m_drawInfo = this.points(relationInstance.isMarked(4));
                }
            }
        }
        if (this.m_drawInfo != null) {
            Rectangle rectangle = new Rectangle();
            this.computeBounds(rectangle);
            ++rectangle.width;
            ++rectangle.height;
            this.setBounds(rectangle);
            this.repaint();
        }
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getX();
        int n2 = this.getY();
        graphics.setColor(this.m_relationInstance.getObjectColor());
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                ((DrawInfo)this.m_drawInfo).paintComponent(graphics, n, n2);
            } else {
                Enumeration enumeration = ((Vector)this.m_drawInfo).elements();
                while (enumeration.hasMoreElements()) {
                    DrawInfo drawInfo = (DrawInfo)enumeration.nextElement();
                    drawInfo.paintComponent(graphics, n, n2);
                }
            }
        }
    }

    public String toString() {
        return "RelationComponent: " + this.m_relationInstance;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseEntered();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseExited();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_relationInstance.mousePressed(mouseEvent, mouseEvent.getX() + this.getX(), mouseEvent.getY() + this.getY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseReleased(mouseEvent, mouseEvent.getX() + this.getX(), mouseEvent.getY() + this.getY());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseDragged(mouseEvent, mouseEvent.getX() + this.getX(), mouseEvent.getY() + this.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseMoved(mouseEvent, mouseEvent.getX() + this.getX(), mouseEvent.getY() + this.getY());
    }

    class EdgeInfo
    extends LineInfo {
        private int m_embellished;
        private EdgePoint m_src;
        private EdgePoint m_dst;

        EdgeInfo() {
        }

        public void setEdgeInfo(EdgePoint edgePoint, EdgePoint edgePoint2) {
            this.m_src = edgePoint;
            this.m_dst = edgePoint2;
        }

        public void setEmbellished(int n) {
            this.m_embellished = n;
        }

        public void getBounds(Rectangle rectangle) {
            RelationComponent.getLineBounds((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), rectangle);
            if ((this.m_embellished & 1) != 0) {
                RelationComponent.includeTailBounds((int)this.m_src.getX(), (int)this.m_src.getY(), rectangle);
            }
            if ((this.m_embellished & 2) != 0) {
                RelationComponent.includeCentreBounds((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), rectangle);
            }
            if ((this.m_embellished & 4) != 0) {
                RelationComponent.includeArrowBounds((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), rectangle);
            }
        }

        public boolean contains(int n, int n2) {
            return RelationComponent.nearLine((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), n, n2);
        }

        public EdgePoint mouseOverEdgePoint(int n, int n2) {
            if (RelationComponent.nearPoint((int)this.m_src.getX(), (int)this.m_src.getY(), n, n2)) {
                return this.m_src;
            }
            if (RelationComponent.nearPoint((int)this.m_dst.getX(), (int)this.m_dst.getY(), n, n2)) {
                return this.m_dst;
            }
            return null;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            int n3 = (int)(this.m_src.getX() - (double)n);
            int n4 = (int)(this.m_src.getY() - (double)n2);
            int n5 = (int)(this.m_dst.getX() - (double)n);
            int n6 = (int)(this.m_dst.getY() - (double)n2);
            if ((this.m_embellished & 4) != 0) {
                Util.drawArrow(graphics, this.m_style, n3, n4, n5, n6);
            } else {
                Util.drawSegment(graphics, this.m_style, n3, n4, n5, n6);
            }
            if ((this.m_embellished & 1) != 0) {
                graphics.fillOval(n3 - 3, n4 - 3, 6, 6);
            }
            if ((this.m_embellished & 2) != 0) {
                Color color = graphics.getColor();
                graphics.setColor(HIGHLIGHT_COLOUR);
                graphics.fillRect((n3 + n5 - 4) / 2, (n4 + n6 - 4) / 2, 4, 4);
                graphics.setColor(color);
            }
        }
    }

    class InElidedInfo
    extends ElidedInfo {
        int m_srcX;
        int m_srcY;
        private EdgePoint m_dst;

        InElidedInfo() {
        }

        public void setInElidedInfo(Rectangle rectangle, EdgePoint edgePoint) {
            double d = rectangle.x + rectangle.width / 2;
            double d2 = rectangle.y + rectangle.height / 2;
            double d3 = d - edgePoint.getX();
            double d4 = d2 - edgePoint.getY();
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            this.m_srcX = (int)(edgePoint.getX() + d3 * 2.0 * Util.ARROW_L / d5);
            this.m_srcY = (int)(edgePoint.getY() + d4 * 2.0 * Util.ARROW_L / d5);
            this.m_dst = edgePoint;
        }

        public void getBounds(Rectangle rectangle) {
            this.getBounds(this.m_srcX, this.m_srcY, (int)this.m_dst.getX(), (int)this.m_dst.getY(), rectangle);
        }

        public boolean contains(int n, int n2) {
            return RelationComponent.nearLine(this.m_srcX, this.m_srcY, (int)this.m_dst.getX(), (int)this.m_dst.getY(), n, n2);
        }

        public EdgePoint mouseOverEdgePoint(int n, int n2) {
            if (RelationComponent.nearPoint((int)this.m_dst.getX(), (int)this.m_dst.getY(), n, n2)) {
                return this.m_dst;
            }
            return null;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponent(graphics, this.m_srcX - n, this.m_srcY - n2, (int)(this.m_dst.getX() - (double)n), (int)(this.m_dst.getY() - (double)n2));
        }
    }

    class OutElidedInfo
    extends ElidedInfo {
        private EdgePoint m_src;
        int m_dstX;
        int m_dstY;

        OutElidedInfo() {
        }

        public void setOutElidedInfo(EdgePoint edgePoint, Rectangle rectangle) {
            this.m_src = edgePoint;
            double d = rectangle.x + rectangle.width / 2;
            double d2 = rectangle.y + rectangle.height / 2;
            double d3 = edgePoint.getX() - d;
            double d4 = edgePoint.getY() - d2;
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            this.m_src = edgePoint;
            this.m_dstX = (int)(edgePoint.getX() - d3 * 2.0 * Util.ARROW_L / d5);
            this.m_dstY = (int)(edgePoint.getY() - d4 * 2.0 * Util.ARROW_L / d5);
        }

        public void getBounds(Rectangle rectangle) {
            this.getBounds((int)this.m_src.getX(), (int)this.m_src.getY(), this.m_dstX, this.m_dstY, rectangle);
        }

        public boolean contains(int n, int n2) {
            return RelationComponent.nearLine((int)this.m_src.getX(), (int)this.m_src.getY(), this.m_dstX, this.m_dstY, n, n2);
        }

        public EdgePoint mouseOverEdgePoint(int n, int n2) {
            if (RelationComponent.nearPoint((int)this.m_src.getX(), (int)this.m_src.getY(), n, n2)) {
                return this.m_src;
            }
            return null;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponent(graphics, (int)(this.m_src.getX() - (double)n), (int)(this.m_src.getY() - (double)n2), this.m_dstX - n, this.m_dstY - n2);
        }
    }

    class ElidedInfo
    extends LineInfo {
        ElidedInfo() {
        }

        public void getBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
            RelationComponent.getLineBounds(n, n2, n3, n4, rectangle);
            RelationComponent.includeArrowBounds(n, n2, n3, n4, rectangle);
        }

        public void paintComponent(Graphics graphics, int n, int n2, int n3, int n4) {
            Util.drawArrow(graphics, this.m_style, n, n2, n3, n4);
        }
    }

    class LineInfo
    extends DrawInfo {
        int m_style;

        LineInfo() {
        }

        public void setStyle(int n) {
            this.m_style = n;
        }
    }

    class ArcInfo
    extends DrawInfo {
        int m_x;
        int m_y;

        public void setArc(int n, int n2) {
            this.m_x = n;
            this.m_y = n2;
        }

        public void getBounds(Rectangle rectangle) {
            rectangle.setBounds(this.m_x, this.m_y, 16, 16);
        }

        public boolean contains(int n, int n2) {
            int n3;
            int n4 = n - this.m_x - 8;
            int n5 = n2 - this.m_y - 8;
            return (n4 >= 0 || n5 <= 0) && (n3 = n4 * n4 + n5 * n5) >= 49 && n3 <= 81;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            graphics.drawArc(0, 0, 16, 16, 270, 270);
            graphics.fillPolygon(m_arc_xp, m_arc_yp, 3);
        }
    }

    class DrawInfo {
        DrawInfo() {
        }

        public void getBounds(Rectangle rectangle) {
            rectangle.setBounds(0, 0, 0, 0);
        }

        public boolean contains(int n, int n2) {
            return false;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
        }

        public boolean overEdgePoint(int n, int n2) {
            return false;
        }

        public EdgePoint mouseOverEdgePoint(int n, int n2) {
            return null;
        }
    }
}

