/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.Graph;
import lsedit.LandscapeEditorCore;
import lsedit.MatrixConfigure;
import lsedit.MatrixLayout;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;

public class SugiyamaLayout
extends MatrixLayout
implements ToolBarEventHandler {
    public static final double BORDER = 0.0333;
    public static final double XGAP = 0.2;
    public static final double YGAP = 0.2;
    protected static double m_border = 0.0333;
    protected static double m_xgap = 0.2;
    protected static double m_ygap = 0.2;

    public SugiyamaLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Sugiyama";
    }

    public String getMenuLabel() {
        return "Layout using Coffman-Graham-Sugiyama algorithm";
    }

    public static double getBorder() {
        return m_border;
    }

    public void setBorder(double d) {
        m_border = d;
    }

    public static double getXGap() {
        return m_xgap;
    }

    public void setXGap(double d) {
        m_xgap = d;
    }

    public static double getYGap() {
        return m_ygap;
    }

    public void setYGap(double d) {
        m_ygap = d;
    }

    public boolean isConfigurable() {
        return true;
    }

    public void configure(LandscapeEditorCore landscapeEditorCore) {
        MatrixConfigure matrixConfigure = new MatrixConfigure(this, 0.0333, 0.2, 0.2, m_border, m_xgap, m_ygap);
        matrixConfigure.dispose();
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        Enumeration enumeration;
        Vector vector2;
        int n;
        EntityInstance entityInstance2;
        int n2 = 0;
        int n3 = vector.size();
        int n4 = entityInstance.getWidth();
        int n5 = entityInstance.getHeight();
        Graph graph = new Graph(n3);
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration2.nextElement();
            graph.addVertex(entityInstance2.widthRelLocal());
            entityInstance2.orMark(0x400000);
        }
        enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration2.nextElement();
            Enumeration enumeration3 = entityInstance2.srcRelationElements();
            while (enumeration3.hasMoreElements()) {
                EntityInstance entityInstance3;
                RelationInstance relationInstance = (RelationInstance)enumeration3.nextElement();
                RelationClass relationClass = (RelationClass)relationInstance.getParentClass();
                if (relationClass != null && !relationClass.isClassVisible() || (entityInstance3 = relationInstance.getDst()) == entityInstance2 || !entityInstance3.isMarked(0x400000)) continue;
                for (n = 0; n < vector.size() && entityInstance3 != vector.elementAt(n); ++n) {
                }
                graph.addEdge(n2, n);
            }
            ++n2;
        }
        enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration2.nextElement();
            entityInstance2.nandMark(0x400000);
        }
        Vector vector3 = graph.doCoffmanGrahamSugiyama();
        int n6 = 0;
        enumeration2 = vector3.elements();
        while (enumeration2.hasMoreElements()) {
            vector2 = (Vector)enumeration2.nextElement();
            int n7 = vector2.size();
            if (n7 <= n6) continue;
            n6 = n7;
        }
        int n8 = (int)((1.0 - m_border) * (double)n4);
        int n9 = (int)((1.0 - m_border) * (double)n5);
        int n10 = n6 < 2 ? 0 : (int)(m_xgap * (double)n8 / (double)(n6 - 1));
        int n11 = vector3.size();
        int n12 = n11 < 2 ? 0 : (int)(m_ygap * (double)n9 / (double)(n11 - 1));
        int n13 = 0;
        int n14 = 0;
        enumeration2 = vector3.elements();
        while (enumeration2.hasMoreElements()) {
            vector2 = (Vector)enumeration2.nextElement();
            int n15 = 0;
            int n16 = 0;
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                int n17 = (Integer)enumeration.nextElement();
                if (n17 >= n3) continue;
                entityInstance2 = (EntityInstance)vector.elementAt(n17);
                d4 = entityInstance2.widthRelLocal();
                d3 = entityInstance2.heightRelLocal();
                n15 += n10 + (int)(d4 * (double)n4);
                int n18 = (int)(d3 * (double)n5);
                if (n18 <= n16) continue;
                n16 = n18;
            }
            if ((n15 -= n10) > n13) {
                n13 = n15;
            }
            n14 += n12 + n16;
        }
        n14 -= n12;
        double d5 = (double)n8 / (double)n13;
        if (d5 < 1.0) {
            d2 = m_border / 2.0;
        } else {
            d2 = (double)(n4 - n13) / (2.0 * (double)n4);
            d5 = 1.0;
        }
        double d6 = (double)n9 / (double)n14;
        if (d6 < 1.0) {
            d = m_border / 2.0;
        } else {
            d = (double)(n5 - n14) / (2.0 * (double)n5);
            d6 = 1.0;
        }
        double d7 = d5 * (double)n10 / (double)n4;
        double d8 = d6 * (double)n12 / (double)n5;
        double d9 = d;
        n = vector3.size();
        while (n > 0) {
            vector2 = (Vector)vector3.elementAt(--n);
            double d10 = d2;
            double d11 = 0.0;
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                int n19 = (Integer)enumeration.nextElement();
                if (n19 >= n3) continue;
                entityInstance2 = (EntityInstance)vector.elementAt(n19);
                d4 = entityInstance2.widthRelLocal() * d5;
                d3 = entityInstance2.heightRelLocal() * d6;
                if (d3 > d11) {
                    d11 = d3;
                }
                if (bl) {
                    entityInstance2.updateRelLocal(d10, d9, d4, d3);
                } else {
                    entityInstance2.setRelLocal(d10, d9, d4, d3);
                }
                d10 += d4 + d7;
            }
            d9 += d11 + d8;
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_ls.setLayouter(this);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            this.beep();
            return "No group selected";
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Sugiyama requires that all things laid out share same parent";
        }
        diagram.beginUndoRedo("Sugiyama layout");
        this.doLayout1(vector, entityInstance, true);
        diagram.endUndoRedo();
        return "Graph redrawn with Coffman-Graham-Sugiyama method";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }
}

