/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import lsedit.Attribute;
import lsedit.AttributeRecord;
import lsedit.AttributeValueItem;
import lsedit.Diagram;
import lsedit.EntityCache;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject3D;
import lsedit.LandscapeTokenStream;
import lsedit.MsgOut;
import lsedit.OrderedHashTableEnumeration;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.StringCache;
import lsedit.Tuple;
import lsedit.Util;

public class Ta
extends JPanel {
    public static final String INSTANCE_ID = "$INSTANCE";
    public static final String INHERIT_RELN = "$INHERIT";
    public static final String CONTAIN_ID = "contain";
    public static final String EDGEMODE_ID = "edgemode";
    public static final String TOPCLIENTS_ID = "topclients";
    public static final String WANTCLIENTS_ID = "wantclients";
    public static final String WANTSUPPLIERS_ID = "wantsuppliers";
    public static final String WANTCARDINALS_ID = "wantcardinals";
    public static final String SCALE_ID = "scale";
    public static final String RELN_HIDDEN_ID = "reln_hidden";
    public static final String NAVLINK_ID = "navlink";
    public static final String HIERARCHY_ID = "hierarchy";
    private static final int UPDATE_FREQ = 250;
    public static final String ROOT_ID = "$ROOT";
    private static final String BG_STR = "0.75";
    private static final String[] g_optionsAttributes = new String[]{"scale", "reln_hidden", "edgemode", "navlink", "topclients", "wantclients", "wantsuppliers", "wantcardinals", "hierarchy"};
    protected LandscapeEditorCore m_ls;
    private Diagram m_diagram;
    protected EntityInstance m_optionsInstance;
    protected EntityInstance m_rootInstance;
    protected RelationClass m_containsClass;
    private Hashtable m_entityClasses = new Hashtable(10);
    protected Hashtable m_relationClasses = new Hashtable(5);
    private Hashtable m_attrNames = new Hashtable(20);
    private Vector m_numToRel = new Vector(10);
    public RelationClass m_relationBaseClass;
    public EntityClass m_entityBaseClass;
    protected RelationClass m_defaultRelationClass = null;
    protected int m_numRelationClasses = 0;
    protected EntityClass m_defaultEntityClass = null;
    private int m_numEntityClasses = 0;
    private boolean m_universalScheme = false;
    private Object m_context;
    private String m_zipEntry;
    boolean m_uses_local_coordinates;
    private boolean m_schemeSetup = false;
    protected String m_resString = null;
    protected int progressCount;
    protected boolean m_changedFlag = false;
    protected int m_numberRelations;

    protected Diagram getDiagram() {
        return null;
    }

    public boolean getChangedFlag() {
        return this.m_changedFlag;
    }

    private void updateProgress() {
        ++this.progressCount;
        StringBuffer stringBuffer = new StringBuffer("Loading: ");
        for (int i = 0; i < this.progressCount; ++i) {
            stringBuffer.append('*');
        }
        this.m_ls.doFeedback(new String(stringBuffer));
    }

    private EntityClass addEntityClass(String string) {
        EntityClass entityClass = (EntityClass)this.m_entityClasses.get(string);
        if (entityClass == null) {
            entityClass = new EntityClass(string, this.m_numEntityClasses++, this.m_entityBaseClass, this.m_diagram);
            this.m_entityClasses.put(string, entityClass);
            if (this.m_defaultEntityClass == null) {
                this.m_defaultEntityClass = entityClass;
            }
        }
        return entityClass;
    }

    private RelationClass addRelationClass(String string) {
        RelationClass relationClass = (RelationClass)this.m_relationClasses.get(string);
        if (relationClass == null) {
            relationClass = new RelationClass(string, this.m_numRelationClasses, this.m_relationBaseClass, this.m_diagram);
            this.m_relationClasses.put(string, relationClass);
            this.m_numToRel.addElement(relationClass);
            ++this.m_numRelationClasses;
            if (this.m_defaultRelationClass == null) {
                this.m_defaultRelationClass = relationClass;
            }
        }
        return relationClass;
    }

    private void registerAttrName(String string) {
        if (this.m_attrNames.get(string) == null) {
            this.m_attrNames.put(string, string);
        }
    }

    private void registerAttrNames(Attribute attribute) {
        while (attribute != null) {
            this.registerAttrName(attribute.id);
            attribute = attribute.next;
        }
    }

    public void addEdge(EntityInstance entityInstance, EntityInstance entityInstance2, RelationClass relationClass) {
        RelationInstance relationInstance = relationClass.newRelation(entityInstance, entityInstance2);
        entityInstance.addRelation(relationInstance, entityInstance2);
    }

    public boolean isUniversalScheme() {
        return this.m_universalScheme;
    }

    private void setupUniversalScheme() {
        this.m_relationBaseClass.addRelation(this.m_entityBaseClass, this.m_entityBaseClass);
        this.m_universalScheme = true;
    }

    private void processSchemeTuples(LandscapeTokenStream landscapeTokenStream) throws IOException {
        Tuple tuple;
        while ((tuple = landscapeTokenStream.nextTuple()) != null) {
            RelationClass relationClass = null;
            boolean bl = tuple.token1.equals(INHERIT_RELN);
            if (bl) {
                if (tuple.token2.equals("$ENTITY")) {
                    landscapeTokenStream.errorNS("Improper use of $ENTITY with $INHERIT");
                    return;
                }
            } else {
                relationClass = this.addRelationClass(tuple.token1);
            }
            EntityClass entityClass = this.addEntityClass(tuple.token2);
            EntityClass entityClass2 = this.addEntityClass(tuple.token3);
            if (bl) {
                String string = entityClass.addParentClass(entityClass2);
                if (string == null) continue;
                landscapeTokenStream.errorNS(string);
                continue;
            }
            relationClass.addRelation(entityClass, entityClass2);
        }
        return;
    }

    private void processSchemeAttributes(LandscapeTokenStream landscapeTokenStream) throws IOException {
        AttributeRecord attributeRecord;
        while ((attributeRecord = landscapeTokenStream.nextRecord()) != null) {
            Object object;
            Object object2;
            if (attributeRecord.id.startsWith("(")) {
                object2 = new StringTokenizer(attributeRecord.id, "() ");
                object = ((StringTokenizer)object2).nextToken();
                RelationClass relationClass = (RelationClass)this.m_relationClasses.get(object);
                if (relationClass != null) {
                    Attribute attribute = attributeRecord.attributes;
                    while (attribute != null) {
                        relationClass.addAttribute(attribute);
                        attribute = attribute.next;
                    }
                    this.registerAttrNames(attributeRecord.attributes);
                    continue;
                }
                landscapeTokenStream.errorNS("Can't process record. Missing relation class '" + (String)object + "'");
                continue;
            }
            if (attributeRecord.id.equals(ROOT_ID)) {
                object2 = attributeRecord.attributes;
                while (object2 != null) {
                    this.m_optionsInstance.addAttribute((Attribute)object2);
                    object2 = ((Attribute)object2).next;
                }
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            object2 = (EntityClass)this.m_entityClasses.get(attributeRecord.id);
            if (object2 != null) {
                object = attributeRecord.attributes;
                while (object != null) {
                    ((LandscapeClassObject)object2).addAttribute((Attribute)object);
                    object = ((Attribute)object).next;
                }
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            landscapeTokenStream.errorNS("Can't process record. Missing entity class '" + attributeRecord.id + "'");
        }
        return;
    }

    private void processFactTuples(LandscapeTokenStream landscapeTokenStream) throws IOException {
        Tuple tuple;
        int n = 0;
        int n2 = 0;
        MsgOut.vprint("\nFACT TUPLE : ");
        while ((tuple = landscapeTokenStream.nextTuple()) != null) {
            LandscapeObject3D landscapeObject3D;
            LandscapeObject3D landscapeObject3D2;
            if (tuple.token1.equals(INSTANCE_ID)) {
                if (++n % 250 == 0) {
                    MsgOut.vprint(".");
                    this.updateProgress();
                    this.m_ls.showInfo("Entities: " + n);
                }
                if ((landscapeObject3D2 = EntityCache.get(tuple.token2)) == null) {
                    landscapeObject3D = (EntityClass)this.m_entityClasses.get(tuple.token3);
                    if (landscapeObject3D == null && this.isUniversalScheme()) {
                        landscapeObject3D = this.m_entityBaseClass;
                    }
                    if (landscapeObject3D != null) {
                        landscapeObject3D2 = ((EntityClass)landscapeObject3D).newEntity(tuple.token2);
                        EntityCache.put((EntityInstance)landscapeObject3D2);
                        continue;
                    }
                    landscapeTokenStream.errorNS("EntityClass '" + tuple.token3 + "' has not been declared");
                    continue;
                }
                landscapeObject3D = ((EntityInstance)landscapeObject3D2).getEntityClass();
                if (landscapeObject3D.hasId(tuple.token3)) {
                    landscapeTokenStream.warning("Redeclaration of " + ((EntityInstance)landscapeObject3D2).toString());
                    continue;
                }
                landscapeTokenStream.errorNS("Attempt to declare " + landscapeObject3D2.getId() + " as instanceof " + tuple.token3 + ". Currently declared as instanceof " + landscapeObject3D.getId());
                continue;
            }
            if (++n2 % 250 == 0) {
                MsgOut.vprint(".");
                this.updateProgress();
                this.m_ls.showInfo("Relations: " + n2);
            }
            landscapeObject3D2 = (RelationClass)this.m_relationClasses.get(tuple.token1);
            landscapeObject3D = EntityCache.get(tuple.token2);
            EntityInstance entityInstance = EntityCache.get(tuple.token3);
            if (this.m_universalScheme) {
                if (landscapeObject3D2 == null) {
                    landscapeObject3D2 = this.m_relationBaseClass;
                }
                if (landscapeObject3D == null) {
                    landscapeObject3D = this.m_entityBaseClass.newEntity(tuple.token2);
                    EntityCache.put((EntityInstance)landscapeObject3D);
                }
                if (entityInstance == null) {
                    entityInstance = this.m_entityBaseClass.newEntity(tuple.token3);
                    EntityCache.put(entityInstance);
                }
            }
            if (landscapeObject3D2 == null) {
                landscapeTokenStream.errorNS("Can't process: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token1 + "'");
                continue;
            }
            if (landscapeObject3D == null) {
                landscapeTokenStream.errorNS("Can't process: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token2 + "'");
                continue;
            }
            if (entityInstance == null) {
                landscapeTokenStream.errorNS("Can't process: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token3 + "'");
                continue;
            }
            this.addEdge((EntityInstance)landscapeObject3D, entityInstance, (RelationClass)landscapeObject3D2);
        }
        this.m_numberRelations = n2;
    }

    private void processFactAttributes(LandscapeTokenStream landscapeTokenStream) throws IOException {
        AttributeRecord attributeRecord;
        int n = 0;
        MsgOut.vprint("\nFACT ATTRIBUTE : ");
        while ((attributeRecord = landscapeTokenStream.nextRecord()) != null) {
            Object object;
            if (++n % 250 == 0) {
                MsgOut.vprint(".");
                this.updateProgress();
                this.m_ls.showInfo("Attr Records: " + n);
            }
            MsgOut.vprintln("Processing record: " + attributeRecord.id);
            if (attributeRecord.id.startsWith("(")) {
                object = new Tuple(attributeRecord.id);
                RelationClass relationClass = (RelationClass)this.m_relationClasses.get(((Tuple)object).token1);
                EntityInstance entityInstance = EntityCache.get(((Tuple)object).token2);
                EntityInstance entityInstance2 = EntityCache.get(((Tuple)object).token3);
                if (relationClass == null) {
                    landscapeTokenStream.errorNS("Can't process record for " + attributeRecord.id + ". " + "Missing relation '" + ((Tuple)object).token1 + "'");
                    continue;
                }
                if (entityInstance == null) {
                    landscapeTokenStream.errorNS("Can't process record for " + attributeRecord.id + ". " + "Missing entity '" + ((Tuple)object).token2 + "'");
                    continue;
                }
                if (entityInstance2 == null) {
                    landscapeTokenStream.errorNS("Can't process record for " + attributeRecord.id + ". " + "Missing entity '" + ((Tuple)object).token3 + "'");
                    continue;
                }
                RelationInstance relationInstance = entityInstance.getRelation(relationClass, entityInstance2);
                if (relationInstance == null) {
                    landscapeTokenStream.errorNS("Can't process record. Missing relation " + attributeRecord.id);
                    continue;
                }
                relationInstance.assignAttributes(attributeRecord.attributes);
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            object = attributeRecord.id.equals(ROOT_ID) ? this.m_optionsInstance : EntityCache.get(attributeRecord.id);
            if (object != null) {
                ((EntityInstance)object).assignAttributes(attributeRecord.attributes);
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            if (this.m_universalScheme) {
                object = this.m_entityBaseClass.newEntity(attributeRecord.id);
                EntityCache.put((EntityInstance)object);
                ((EntityInstance)object).assignAttributes(attributeRecord.attributes);
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            landscapeTokenStream.errorNS("Can't process record. Missing entity '" + attributeRecord.id + "'");
        }
    }

    private void writeSchemeTuples(PrintStream printStream) throws IOException {
        LandscapeClassObject landscapeClassObject;
        printStream.print("// Landscape TA file\n\n");
        printStream.print("SCHEME TUPLE :\n\n// The ERD\n\n");
        Enumeration enumeration = this.enumEntityClassesInOrder();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (EntityClass)enumeration.nextElement();
            if (landscapeClassObject == this.m_entityBaseClass) continue;
            Enumeration enumeration2 = landscapeClassObject.getParentElements();
            while (enumeration2.hasMoreElements()) {
                EntityClass entityClass = (EntityClass)enumeration2.nextElement();
                if (entityClass == this.m_entityBaseClass) continue;
                printStream.print("$INHERIT " + landscapeClassObject.getId() + " " + entityClass.getId() + "\n");
            }
        }
        printStream.print("\n");
        enumeration = this.enumRelationClassesInOrder();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (RelationClass)enumeration.nextElement();
            ((RelationClass)landscapeClassObject).writeRelations(printStream);
        }
    }

    private void writeSchemeAttributes(PrintStream printStream) throws IOException {
        LandscapeClassObject landscapeClassObject;
        printStream.print("\n\nSCHEME ATTRIBUTE :\n\n");
        printStream.print("// EntityClass attributes\n\n");
        Enumeration enumeration = this.m_entityClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (EntityClass)enumeration.nextElement();
            ((EntityClass)landscapeClassObject).writeAttributes(printStream);
        }
        enumeration = this.m_relationClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (RelationClass)enumeration.nextElement();
            ((RelationClass)landscapeClassObject).writeAttributes(printStream);
        }
    }

    private void writeFactAttributes(PrintStream printStream) throws IOException {
        printStream.print("\n\nFACT ATTRIBUTE :\n\n");
        this.m_optionsInstance.writeOptionsAttributes(printStream);
        this.m_rootInstance.writeAttributes(printStream);
    }

    private void writeFactTuples(PrintStream printStream) throws IOException {
        printStream.print("\n\nFACT TUPLE :\n\n");
        printStream.print("// Instances of entity classes\n\n");
        this.m_rootInstance.writeInstances(printStream);
        this.m_rootInstance.writeRelations(printStream);
    }

    public RelationClass getContainsClass() {
        return this.m_containsClass;
    }

    public String getContainsId() {
        return this.m_containsClass.getLabel();
    }

    public void setContainsClass(RelationClass relationClass) {
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass2;
            relationClass2.setContainsClass((relationClass2 = (RelationClass)enumeration.nextElement()) == relationClass);
        }
        this.m_containsClass = relationClass;
    }

    protected boolean establishRootInstance(RelationClass relationClass) {
        RelationClass relationClass2 = this.m_containsClass;
        JFrame jFrame = this.m_ls.getFrame();
        this.setContainsClass(relationClass);
        EntityInstance entityInstance = EntityCache.someEntity();
        if (entityInstance != null) {
            int n;
            int n2 = EntityCache.size();
            for (n = 0; n < n2; ++n) {
                if (n > n2) {
                    JOptionPane.showMessageDialog(jFrame, relationClass.getLabel() + " relation class does not form a tree", "Unable to build visualisation tree", 0);
                    entityInstance = null;
                    break;
                }
                EntityInstance entityInstance2 = entityInstance.getContainedBy();
                if (entityInstance2 == null || entityInstance2 == this.m_optionsInstance) break;
                entityInstance = entityInstance2;
            }
            if (entityInstance != null) {
                n = entityInstance.cntNodesInSubtree();
                entityInstance.clearTreeMark();
                if (n != n2) {
                    if (n < 0) {
                        JOptionPane.showMessageDialog(jFrame, relationClass.getLabel() + " has multiple in edges to the same node", "Unable to build visualisation tree", 0);
                    } else {
                        JOptionPane.showMessageDialog(jFrame, relationClass.getLabel() + " does not span entities", "Unable to build visualisation tree", 0);
                    }
                    entityInstance = null;
                }
            }
        }
        if (entityInstance != null) {
            this.m_rootInstance = entityInstance;
            return true;
        }
        this.setContainsClass(relationClass2);
        return false;
    }

    private void computeRelCoordinates() {
        this.m_rootInstance.computeRelCoordinates(this.m_rootInstance.xRelLocal(), this.m_rootInstance.yRelLocal(), this.m_rootInstance.widthRelLocal(), this.m_rootInstance.heightRelLocal());
    }

    public void emptyDiagram() {
        this.m_uses_local_coordinates = false;
        this.m_schemeSetup = true;
        this.setupUniversalScheme();
        this.m_defaultEntityClass = this.m_entityBaseClass;
        this.m_defaultRelationClass = this.m_relationBaseClass;
        EntityInstance entityInstance = this.m_entityBaseClass.newEntity("BLANK");
        EntityCache.put(entityInstance);
        this.m_rootInstance = entityInstance;
    }

    private void parseStream(InputStream inputStream, String string, URL uRL) {
        MsgOut.vprintln("Parse TA file: " + string);
        this.m_uses_local_coordinates = false;
        try {
            String string2;
            RelationClass relationClass;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            LandscapeTokenStream landscapeTokenStream = new LandscapeTokenStream(bufferedInputStream, string);
            while (true) {
                int n;
                if ((n = landscapeTokenStream.nextSection()) == 99) {
                    MsgOut.vprintln("");
                    break;
                }
                try {
                    switch (n) {
                        case 0: {
                            this.m_schemeSetup = true;
                            this.m_universalScheme = false;
                            this.processSchemeTuples(landscapeTokenStream);
                            this.updateProgress();
                            break;
                        }
                        case 1: {
                            if (!this.m_schemeSetup) {
                                this.m_schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            this.processSchemeAttributes(landscapeTokenStream);
                            this.updateProgress();
                            break;
                        }
                        case 2: {
                            if (!this.m_schemeSetup) {
                                this.m_schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            this.processFactTuples(landscapeTokenStream);
                            break;
                        }
                        case 3: {
                            this.processFactAttributes(landscapeTokenStream);
                            break;
                        }
                        case 4: {
                            if (this.m_context == null) {
                                this.parseFile(landscapeTokenStream.getIncludeFile(), null);
                            } else {
                                this.parseURL(landscapeTokenStream.getIncludeFile(), uRL);
                            }
                            MsgOut.vprintln("Back to TA file: " + string);
                        }
                    }
                }
                catch (IOException iOException) {
                    MsgOut.println("IO error reading landscape");
                    this.m_resString = iOException.toString();
                    break;
                }
            }
            StringCache.clear();
            bufferedInputStream.close();
            inputStream.close();
            Attribute attribute = this.m_optionsInstance.getLsAttribute(HIERARCHY_ID);
            if (attribute.avi == null) {
                attribute.avi = new AttributeValueItem(String.valueOf(CONTAIN_ID));
            }
            if ((relationClass = (RelationClass)this.m_relationClasses.get(string2 = attribute.avi.value)) == null) {
                JOptionPane.showMessageDialog(this.m_ls.getFrame(), string2 + " relation class not defined", "Unable to build visualisation tree", 0);
                return;
            }
            if (!this.establishRootInstance(relationClass)) {
                return;
            }
            if (this.m_uses_local_coordinates) {
                this.computeRelCoordinates();
            }
        }
        catch (Exception exception) {
            this.m_resString = exception.toString();
            System.out.println("Parse error: " + this.m_resString);
        }
    }

    private InputStream decompress(InputStream inputStream, String string, String string2) {
        InputStream inputStream2 = inputStream;
        int n = string.length();
        if (n > 4) {
            String string3 = string.substring(n - 4);
            if (string3.equalsIgnoreCase(".zip")) {
                ZipInputStream zipInputStream;
                try {
                    zipInputStream = new ZipInputStream(inputStream);
                    while (true) {
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (string2 != null && !string2.equalsIgnoreCase(zipEntry.getName())) {
                            zipInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Attempt to open " + string + (string2 == null ? "" : "#" + string2) + " as zip file failed");
                    this.m_resString = exception.toString();
                    zipInputStream = null;
                }
                return zipInputStream;
            }
            if (string3.equalsIgnoreCase(".jar")) {
                JarInputStream jarInputStream;
                try {
                    jarInputStream = new JarInputStream(inputStream);
                    while (true) {
                        ZipEntry zipEntry = jarInputStream.getNextEntry();
                        if (string2 != null && !string2.equalsIgnoreCase(zipEntry.getName())) {
                            jarInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Attempt to open " + string + (string2 == null ? "" : "#" + string2) + " as jar file failed");
                    this.m_resString = exception.toString();
                    jarInputStream = null;
                }
                return jarInputStream;
            }
            if (n > 5 && (string3 = string.substring(n - 5)).equalsIgnoreCase(".gzip")) {
                GZIPInputStream gZIPInputStream;
                try {
                    gZIPInputStream = new GZIPInputStream(inputStream);
                }
                catch (Exception exception) {
                    System.out.println("Attempt to open " + string + " as gzip file failed");
                    this.m_resString = exception.toString();
                    gZIPInputStream = null;
                }
                return gZIPInputStream;
            }
        }
        return inputStream;
    }

    private URL parseURL(String string, URL uRL) {
        int n;
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        String string2 = null;
        if (n2 > 2 && c == ']' && (n = string.lastIndexOf(91)) > 0 && n < n2 - 2) {
            string2 = string.substring(n + 1, n2 - 1);
            string = string.substring(0, n);
            if (this.m_zipEntry == null) {
                this.m_zipEntry = string2;
            }
            n2 = n;
            c = string.charAt(n2 - 1);
        }
        if (c == File.separatorChar) {
            string = string.substring(0, n2 - 1);
        }
        this.progressCount = 0;
        this.updateProgress();
        try {
            URL uRL2 = uRL == null ? new URL(string) : new URL(uRL, string);
            MsgOut.dprintln("Opening URL: " + string);
            InputStream inputStream = uRL2.openStream();
            inputStream = this.decompress(inputStream, string, string2);
            if (inputStream == null) {
                return null;
            }
            MsgOut.dprintln("opened");
            this.parseStream(inputStream, string, uRL2);
            return uRL2;
        }
        catch (Exception exception) {
            this.m_resString = exception.toString();
            return null;
        }
    }

    private File parseFile(String string, File file) {
        int n;
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        String string2 = null;
        if (n2 > 2 && c == ']' && (n = string.lastIndexOf(91)) > 0 && n < n2 - 2) {
            string2 = string.substring(n + 1, n2 - 1);
            if (this.m_zipEntry == null) {
                this.m_zipEntry = string2;
            }
            string = string.substring(0, n);
            n2 = n;
            c = string.charAt(n2 - 1);
        }
        if (c == File.separatorChar) {
            string = string.substring(0, n2 - 1);
        }
        this.progressCount = 0;
        this.updateProgress();
        try {
            Object object;
            File file2;
            if (file == null) {
                file2 = new File(string);
            } else {
                object = this.getDir(file);
                file2 = new File((String)object, string);
            }
            object = new FileInputStream(file2);
            object = this.decompress((InputStream)object, string, string2);
            if (object == null) {
                return null;
            }
            this.parseStream((InputStream)object, string, null);
            return file2;
        }
        catch (Exception exception) {
            this.m_resString = exception.toString();
            return null;
        }
    }

    public Ta(LandscapeEditorCore landscapeEditorCore) {
        this.m_ls = landscapeEditorCore;
        this.m_diagram = this.getDiagram();
        this.m_entityBaseClass = new EntityClass("$ENTITY", this.m_numEntityClasses++, null, this.m_diagram);
        this.m_entityClasses.put("$ENTITY", this.m_entityBaseClass);
        this.m_optionsInstance = new EntityInstance(this.m_entityBaseClass, ROOT_ID);
        this.m_optionsInstance.setRelLocal(0.0, 0.0, 1.0, 1.0);
        for (int i = 0; i < g_optionsAttributes.length; ++i) {
            this.m_optionsInstance.addAttribute(new Attribute(g_optionsAttributes[i], null));
        }
        AttributeValueItem attributeValueItem = new AttributeValueItem(BG_STR);
        attributeValueItem.next = new AttributeValueItem(BG_STR);
        attributeValueItem.next.next = new AttributeValueItem(BG_STR);
        this.m_optionsInstance.addAttribute(new Attribute("color", attributeValueItem));
        this.m_relationBaseClass = new RelationClass("$RELATION", this.m_numRelationClasses++, null, this.m_diagram);
        this.m_relationClasses.put("$RELATION", this.m_relationBaseClass);
        this.m_numToRel.addElement(this.m_relationBaseClass);
        RelationClass relationClass = new RelationClass(CONTAIN_ID, this.m_numRelationClasses++, this.m_relationBaseClass, this.m_diagram);
        this.m_relationClasses.put(CONTAIN_ID, relationClass);
        this.m_numToRel.addElement(relationClass);
    }

    public LandscapeEditorCore getLs() {
        return this.m_ls;
    }

    public RelationClass nameToRelationClass(String string) {
        if (this.m_relationClasses.containsKey(string)) {
            return (RelationClass)this.m_relationClasses.get(string);
        }
        return null;
    }

    public Enumeration enumRelationClasses() {
        return this.m_relationClasses.elements();
    }

    public Enumeration enumRelationClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_relationClasses);
    }

    public int numRelationClasses() {
        return this.m_numRelationClasses;
    }

    public Enumeration enumEntityClasses() {
        return this.m_entityClasses.elements();
    }

    public Enumeration enumEntityClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_entityClasses);
    }

    public int numEntityClasses() {
        return this.m_numEntityClasses;
    }

    public Object getContext() {
        return this.m_context;
    }

    public void setContext(Object object) {
        this.m_context = object;
    }

    public String getContextName() {
        String string = this.m_context instanceof File ? Util.nameFromPath(((File)this.m_context).getPath()) : this.m_optionsInstance.getEntityLabel();
        if (this.m_zipEntry != null) {
            string = string + "[" + this.m_zipEntry + "]";
        }
        return string;
    }

    public String getDir(File file) {
        if (file.isAbsolute()) {
            return file.getParent();
        }
        return new File(file.getAbsolutePath()).getParent();
    }

    public String getDir() {
        return this.getDir((File)this.m_context);
    }

    public String getAbsolutePath() {
        if (this.m_context != null && this.m_context instanceof File) {
            return ((File)this.m_context).getAbsolutePath();
        }
        return null;
    }

    public RelationClass numToRelationClass(int n) {
        return (RelationClass)this.m_numToRel.elementAt(n);
    }

    public void saveDiagram(OutputStream outputStream, boolean bl) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        PrintStream printStream = new PrintStream(bufferedOutputStream);
        this.writeSchemeTuples(printStream);
        this.writeSchemeAttributes(printStream);
        this.writeFactTuples(printStream);
        this.writeFactAttributes(printStream);
        if (bl) {
            printStream.print("END\n");
        }
        printStream.flush();
        printStream.close();
        this.m_changedFlag = false;
    }

    public String loadTA(String string, Object object) {
        this.m_rootInstance = null;
        this.m_containsClass = null;
        this.m_resString = null;
        this.m_zipEntry = null;
        if (string == null) {
            this.emptyDiagram();
        } else {
            int n = string.length();
            if (n == 0) {
                this.emptyDiagram();
            } else if (object instanceof URL || Util.isHTTP(string)) {
                MsgOut.dprintln("Parse a URL");
                this.setContext(this.parseURL(string, (URL)object));
            } else {
                MsgOut.dprintln("Parse a file");
                this.setContext(this.parseFile(string, (File)object));
            }
        }
        if (this.m_defaultEntityClass == null) {
            this.m_defaultEntityClass = this.m_entityBaseClass;
        }
        if (this.m_defaultRelationClass == null) {
            this.m_defaultRelationClass = this.m_relationBaseClass;
        }
        if (this.m_context == null) {
            return this.m_resString;
        }
        return null;
    }

    public int getNumberEntitiesLoaded() {
        return EntityCache.size();
    }

    public int getNumberRelationsLoaded() {
        return this.m_numberRelations;
    }
}

