/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import lsedit.FontCache;
import lsedit.HelpBox;
import lsedit.ToolBarEventHandler;

public abstract class ToolBarButton
extends JButton
implements MouseListener,
MouseMotionListener {
    protected static final double ARROW_L = 5.0;
    protected static final double ARROW_TH = 0.4;
    protected static final Font font = FontCache.get("Helvetica", 0, 12);
    protected static final Font font1 = FontCache.get("Helvetica", 0, 8);
    public static final int MARGIN = 2;
    public static final int HEIGHT = 24;
    public static final int WIDTH = 40;
    protected boolean depressed = false;
    protected boolean mouseIn = false;
    protected boolean mouseDown = false;
    private int m_key = 0;
    private int m_modifier = 0;
    protected ToolBarEventHandler teh;
    protected static HelpBox popup = null;

    protected abstract void paintIcon(Graphics var1);

    protected abstract String getDesc();

    protected void setKeystroke(int n, int n2) {
        if (n2 <= 90) {
            if (n2 >= 65) {
                n |= 1;
            }
        } else if (n2 <= 122) {
            if (n2 >= 97) {
                n &= 0xFFFFFFFE;
                n2 -= 32;
            }
        } else if (n2 >= 1024) {
            n2 -= 1024;
        }
        this.m_key = n2;
        this.m_modifier = n;
    }

    protected void drawEdge(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
        double d = n - n3;
        double d2 = n2 - n4;
        double d3 = Math.atan2(d2, d);
        double d4 = Math.min(5.0, Math.sqrt(d * d + d2 * d2));
        double d5 = (double)n3 + d4 * Math.cos(d3 - 0.4);
        double d6 = (double)n4 + d4 * Math.sin(d3 - 0.4);
        double d7 = (double)n3 + d4 * Math.cos(d3 + 0.4);
        double d8 = (double)n4 + d4 * Math.sin(d3 + 0.4);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = Math.round(n3);
        nArray2[0] = Math.round(n4);
        nArray[1] = (int)Math.round(d5);
        nArray2[1] = (int)Math.round(d6);
        nArray[2] = (int)Math.round(d7);
        nArray2[2] = (int)Math.round(d8);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public ToolBarButton(ToolBarEventHandler toolBarEventHandler) {
        this.teh = toolBarEventHandler;
        this.setSize(40, 24);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setAlignmentY(0.5f);
        this.setToolTipText(this.getDesc());
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getBackground());
        if (this.depressed) {
            graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
        } else if (this.mouseIn) {
            graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, !this.mouseDown);
        }
        graphics.setColor(Color.black);
        this.paintIcon(graphics);
        String string = null;
        int n = this.m_key;
        int n2 = 0;
        if (n >= 65 && n <= 90) {
            int n3 = this.m_modifier;
            string = (n3 & 8) != 0 ? "Alt-" : "";
            if ((n3 & 1) == 0) {
                n += 32;
            }
            string = string + (char)n;
            n2 = 0;
        } else if (n > 0 && n < 27) {
            string = "^" + (char)(this.m_key + 64);
            n2 = 2;
        }
        if (string != null) {
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.stringWidth(string);
            int n5 = fontMetrics.getHeight();
            graphics.drawString(string, dimension.width - n4 + n2 - 4, dimension.height - (dimension.height - n5) / 2 - 2);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(40, 24);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setState(boolean bl) {
        this.depressed = bl;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.teh.showInfo(this.getDesc());
        this.mouseIn = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseIn = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDown = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseDown) {
            this.teh.processKeyEvent(this.m_key, this.m_modifier, null);
            this.mouseDown = false;
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

