package lsedit;

import java.awt.Dimension;
import java.awt.Graphics;
import java.io.*;
import java.util.*;
import javax.swing.*;

public class Arrow extends JComponent { 

	private	int[]	  m_x;
	private int[]     m_y;

	protected Arrow(int width, int height)
	{
		Dimension dimension = new Dimension(width, height);
		m_x         = new int[3];
		m_y         = new int[3];

		Util.getArrow(0, height/2, width, height/2, m_x, m_y);

		setMinimumSize(dimension);
		setPreferredSize(dimension);
		setMaximumSize(dimension);
		setSize(dimension);

	}

	public void paintComponent(Graphics g)
	{
		int	height = getHeight() / 2;

		g.setColor(getBackground());
		g.drawLine(0,height, getWidth(), height);
		g.fillPolygon(m_x, m_y, 3);
}	}
