package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ArrowDimensions extends JDialog implements ActionListener { 

	static double	m_old_length;
	static double	m_old_arc;
	static int		m_old_width;
	static double	m_new_length;
	static double	m_new_arc;
	static int		m_new_width;
	static boolean  m_old_fill_arrowhead;
	static boolean  m_fill_arrowhead;
	static boolean  m_old_center_arrowhead;
	static boolean  m_center_arrowhead;
	
	JTextField		m_length;
	JTextField		m_arc;
	JTextField		m_width;
	JCheckBox		m_fill_checkbox;
	JCheckBox		m_center_checkbox;
	JButton			m_ok;
	JButton			m_cancel;
	JButton			m_default;
	JLabel			m_message;

	protected ArrowDimensions(LandscapeEditorCore ls) //Constructor
	{
		super(ls.getFrame(), "Modify arrow settings",true); //false if non-modal

		Container	contentPane;
		JLabel		label;
		Font		font, bold;
		JCheckBox	checkbox;

		font         = FontCache.getDialogFont();
		bold         = font.deriveFont(Font.BOLD);

		m_old_width  = Util.LINE_W;
		m_old_length = Util.ARROW_L;
		m_old_arc    = Util.ARROW_TH;
		m_new_width  = Util.LINE_W;
		m_new_length = Util.ARROW_L;
		m_new_arc    = Util.ARROW_TH;

		m_fill_arrowhead   = m_old_fill_arrowhead   = ls.isFillArrowhead();
		m_center_arrowhead = m_old_center_arrowhead = ls.isCenterArrowhead();

		contentPane = getContentPane();
        contentPane.setLayout( new BorderLayout() );

		setForeground(ColorCache.get(0,0,0));
		setBackground(ColorCache.get(192,192,192));

		setFont(font);

		JPanel topPanel    = new JPanel();
		JPanel leftPanel   = new JPanel();
		JPanel centerPanel = new JPanel();
		JPanel rightPanel  = new JPanel();

		GridLayout gridLayout;

		topPanel.setLayout( new BorderLayout() );
		gridLayout = new GridLayout(5,1);
		gridLayout.setVgap(10);
		leftPanel.setLayout( gridLayout);

		gridLayout = new GridLayout(5,1);
		gridLayout.setVgap(10);
		centerPanel.setLayout( gridLayout);

		gridLayout = new GridLayout(5,1);
		gridLayout.setVgap(10);
		rightPanel.setLayout( gridLayout);

		topPanel.add( BorderLayout.WEST, leftPanel);
		topPanel.add( BorderLayout.EAST, rightPanel);
		topPanel.add( BorderLayout.CENTER, centerPanel);

		// ----------

		label = new JLabel("Width of edge:", JLabel.RIGHT);
		label.setFont(bold);
		leftPanel.add(label);

		m_width = new JTextField("" + m_old_width, 6);
		m_width.setFont(font);
		centerPanel.add(m_width);

		label = new JLabel("pixels", JLabel.LEFT);
		label.setFont(bold);
		rightPanel.add(label);

		// ----------

		label = new JLabel("Length of arrow edge:", JLabel.RIGHT);
		label.setFont(bold);
		leftPanel.add(label);

		m_length = new JTextField("" + m_old_length, 6);
		m_length.setFont(font);
		centerPanel.add(m_length);

		label = new JLabel("pixels", JLabel.LEFT);
		label.setFont(bold);
		rightPanel.add(label);

		label = new JLabel("Arc between edge and arrow edge:", JLabel.RIGHT);
		label.setFont(bold);
		leftPanel.add(label);

		m_arc = new JTextField("" + m_old_arc, 6);
		m_arc.setFont(font);
		centerPanel.add(m_arc);

		
		label = new JLabel("radians", JLabel.LEFT);
		label.setFont(bold);
		rightPanel.add(label);


		label = new JLabel("Fill arrow head:", JLabel.RIGHT);
		label.setFont(bold);
		leftPanel.add(label);
		m_fill_checkbox = checkbox = new JCheckBox();
//		checkbox.setBackground(Color.WHITE);
		checkbox.setBorderPaintedFlat(false);
		checkbox.setSelected(m_fill_arrowhead);
		checkbox.setEnabled(true);
		checkbox.setVisible(true);

		centerPanel.add(checkbox);

		label = new JLabel("Center arrow head:", JLabel.RIGHT);
		label.setFont(bold);
		leftPanel.add(label);
		m_center_checkbox = checkbox = new JCheckBox();
		
//		checkbox.setBackground(Color.WHITE);
		checkbox.setBorderPaintedFlat(false);
		checkbox.setSelected(m_center_arrowhead);
		checkbox.setEnabled(true);
		checkbox.setVisible(true);
		centerPanel.add(m_center_checkbox);

		// --------

        contentPane.add( BorderLayout.NORTH, topPanel );

		// ------------

		m_message = new JLabel(" ", JLabel.CENTER);
		m_message.setFont(font);
		m_message.setForeground(Color.RED);

		m_message.setSize(400,50);
		contentPane.add( BorderLayout.CENTER, m_message);

		// --------------
		// Use a FlowLayout to center the button and give it margins.

		JPanel bottomPanel = new JPanel();

		bottomPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));

		m_ok = new JButton("Ok");
		m_ok.setFont(bold);
		bottomPanel.add(m_ok);
		m_ok.addActionListener(this);

		m_default = new JButton("Default");
		m_default.setFont(bold);
		bottomPanel.add(m_default);
		m_default.addActionListener(this);

		m_cancel = new JButton("Cancel");
		m_cancel.setFont(bold);
		bottomPanel.add(m_cancel);
		m_cancel.addActionListener(this);

		contentPane.add( BorderLayout.SOUTH, bottomPanel);

		// Resize the window to the preferred size of its components
		pack();
		show();
	}

	public static void create(LandscapeEditorCore ls) 
	{
		ArrowDimensions arrowDimensions = new ArrowDimensions(ls);

		arrowDimensions.dispose();

		if (m_old_length != m_new_length || m_old_arc != m_new_arc || m_old_width != m_new_width || m_old_fill_arrowhead != m_fill_arrowhead || m_old_center_arrowhead != m_center_arrowhead) {
			Util.LINE_W   = m_new_width;
			Util.ARROW_L  = m_new_length;
			Util.ARROW_TH = m_new_arc;
			ls.setFillArrowheadState(m_fill_arrowhead);
			ls.setCenterArrowheadState(m_center_arrowhead);
			ls.repaint(); 
		} 
	}

	// ActionListener interface

	public void actionPerformed(ActionEvent ev)
	{
		Object	source;
		String	string;
		double	length, arc;
		int		width;

		// Pop down the window when the button is clicked.
		// System.out.println("event: " + ev);

		source = ev.getSource();

		if (source == m_default) {
			m_width.setText("" + Util.LINE_W_DEFAULT);
			m_length.setText("" + Util.ARROW_L_DEFAULT);
			m_arc.setText("" + Util.ARROW_TH_DEFAULT);
			m_message.setText("Values set to initial default");
			m_fill_checkbox.setSelected(Do.FILL_ARROWHEAD_DEFAULT);
			m_center_checkbox.setSelected(Do.CENTER_ARROWHEAD_DEFAULT);
			return;
		}

		if (source != m_cancel && source != m_ok) {
			return;
		}
		if (source == m_ok) {
			string = m_width.getText();
			try {
				width = Integer.parseInt(string);
				if (width < 0) {
					m_message.setText("Width negative");
					return;
				}
			} catch (Throwable exception) {
				m_message.setText("Width not an integer string value");
				return;
			}

			string = m_length.getText();
			try {
				length = Double.parseDouble(string);
				if (Double.isNaN(length)) {
					m_message.setText("Length is not a double precision number");
					return;
				}
			} catch (Throwable exception) {
				m_message.setText("Length is not a double precision string value");
				return;
			}
				
			if (length < 0) {
				m_message.setText("Length is negative");
				return;
			}
			string = m_arc.getText();
			try {
				arc    = Double.parseDouble(string);
				if (Double.isNaN(arc)) {
					m_message.setText("Arc is not a double precision number");
					return;
				}
			} catch (Throwable exception) {
				m_message.setText("Arc is not a double precision string value");
				return;
			}
			
			if (arc < 0) {
				m_message.setText("Arc is negative");
				return;
			}
			if (arc > 1.5) {
				m_message.setText("The maximum allowed arc angle is 1.5 (very near pi/2)");
				return;
			}
	
			m_new_width  = width;
			m_new_length = length;
			m_new_arc    = arc;

			m_fill_arrowhead   = m_fill_checkbox.isSelected();

			m_center_arrowhead = m_center_checkbox.isSelected();
		}
		this.setVisible(false);
		return;
	}
} 



