package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;

/* Attribute.java
 *
 * Each attribute declaration is represented as an instance of this
 * class on an EntityClass or RelationClass attribute list.
 *
 * Each attribute instance is represented as an instance of this class
 * on a EntityInstance or RelationInstance attribute list.
 *
 */

public class Attribute extends Object 
{
	public static final Integer NULL			= new Integer(0);
	public static final Integer INT				= new Integer(1);
	public static final Integer DOUBLE			= new Integer(2);
	public static final Integer STRING			= new Integer(3);
	public static final Integer INT_LIST		= new Integer(4);
	public static final Integer DOUBLE_LIST		= new Integer(5);
	public static final Integer STRING_LIST		= new Integer(6);

	public static final int NULL_TYPE			= 0;
	public static final int INT_TYPE			= 1;
	public static final int DOUBLE_TYPE			= 2;
	public static final int STRING_TYPE			= 3;
	public static final int INT_LIST_TYPE		= 4;
	public static final int DOUBLE_LIST_TYPE	= 5;
	public static final int STRING_LIST_TYPE	= 6;

	// Extra types

	public static final	int COLOR_TYPE			= 7;
	public static final int COLOR_OR_NULL_TYPE  = 8;
	public static final int POINT_TYPE          = 9;
	public static final int ELISION_TYPE        = 10;
	public static final int AVI_TYPE			= 11;	// Generic AVI value
	public static final int TEXT_TYPE			= 12;	// Multiline input string
	public static final int ENTITY_STYLE_TYPE	= 13;	// Entity class style
	public static final int REL_STYLE_TYPE		= 14;	// Relational style
	public static final int ENTITY_CLASS_TYPE   = 15;	// The class of this entity
	public static final int RELATION_CLASS_TYPE = 16;	// The class of this relation

	public static final String indent = " ";			// one space indent 

	public String id;
	public AttributeValueItem avi;		// May be object or list
	public boolean m_cloneOnAssign;

	public Attribute next;								// Next attribute in database 

	public Attribute(String id, AttributeValueItem avi) 
	{
		this.id = id;
		this.avi = avi;
	}

	public boolean hasId(String id) 
	{
		return this.id.equals(id);
	}

	public String toString() 
	{
		String					ret;
		AttributeValueItem		avi1;

		ret = id;
		if (avi != null) {
			ret += "=";
		}
		for (avi1 = avi; avi1 != null; avi1 = avi1.nextList) {
			if (avi1 != avi) {
				ret += ",";
			}
			ret += avi1;
		}
		return(ret);
	}

	public Object clone() {

		AttributeValueItem av;

		if (avi == null) {
			av = null; 
		} else {	
			av = (AttributeValueItem) avi.clone();
		}
		return new Attribute(id, av);	
	}



	// Parse methods. Convert attribute value into a particular form.



	public String parseString() 
	{
		return avi.value;
	}


	protected double cachedReal = Double.POSITIVE_INFINITY;

	public double parseReal()
	{
		if (avi.value == null) {
			return 0.0;
		}
		if (cachedReal == Double.POSITIVE_INFINITY) {
			cachedReal = Util.parseReal(avi.value);
		} 
		return cachedReal;
	}



	public int parseInt() 
	{
		if (avi.value == null) {	
			return 0;
		}
		return Util.parseInt(avi.value);
	}



	public boolean parseBoolean() 
	{
		if (avi.value == null) {
			return false;
		}
		return Util.parseBoolean(avi.value);
	}



	protected Color cachedColor = null;

	public Color parseColour() 
	{
		if (cachedColor != null) {
			return cachedColor;
		}
		// Value is chain of three normalized reals

		AttributeValueItem av = avi; 

		if (av.value == null) {
			MsgOut.println("parseColor: missing values"); 
			return Color.black; 
		}

		float r = (new Float(av.value)).floatValue();
		av = av.next;

		if (av == null) {
			MsgOut.println("parseColor: missing green and blue values");
			return Color.black; 
		}

		float g = (new Float(av.value)).floatValue();
		av = av.next;

		if (av == null) {
			MsgOut.println("parseColor: missing blue value");
			return Color.black;
		}

		float b = (new Float(av.value)).floatValue();

		cachedColor = ColorCache.get(r, g, b);		

		return cachedColor;
	}

	public Color parseColor() {
		return parseColour();
	}


	// Adding and deleting value nodes in a list

	public void addToList(String value) {

		AttributeValueItem avi = new AttributeValueItem(value);

		avi.next = this.avi; 
		this.avi = avi; 
	}

	public void removeFromList(String value) {

		AttributeValueItem prev = null;
		AttributeValueItem avi	= this.avi; 

		while(avi != null) {
			if (avi.value.equals(value)) {
				// Delete this avi node
				if (prev != null) {
					prev.next = avi.next; 
				} else {
					// Removing the head
					this.avi = avi.next; 
				}
				return;
			}
			prev = avi; 
			avi = avi.next; 
		}
	}

	// Output this attribute entry 

	public void writeAttribute(PrintStream ps, LandscapeObject parentClass, boolean classType) throws IOException 
	{
		// Classes and Instances which have overwritten class default

		if (avi == null) {
			// Null value possible in class definitions 
			// Acts as a declarer of a attribute variable 
			// Output just the id 

			if (classType) {
				ps.print(indent + id + "\n");  
			}
		} else if (classType || !m_cloneOnAssign) {

			// General case. Output ID and value.  
			// Value could be single item, list, or nested. 

			if (parentClass == null || !parentClass.defaultValue(id, avi)) {
				ps.print(indent + id + " = ");
				avi.writeAttribute(ps); 
		}	}
	}
}

