package lsedit;

import java.awt.Dimension;
import java.util.Enumeration;

import javax.swing.JLabel;

// This object has the responsibility for laying out clients and supplier lists

public class ClientSet extends ClientSupplierSet implements DiagramCoordinates
{
	protected void addSet()
	{
		super.addSet();

		if (m_fullSize != 0 && m_displayedSize == 0) {
			int	w, h;

			if (m_label == null) {
				m_label = new JLabel();
				m_label.setFont(ClientSupplierSet.getClientSupplierFont());
			}
			m_label.setText("All clients are also suppliers");
			m_label.setHorizontalAlignment(JLabel.CENTER);
			w = getWidth();
			h = getHeight();
			m_label.setBounds(0, 0, w, h);
			add(m_label);		// Add this message to the diagram
	}	}

	public void validate()
	{
		super.validate();
	
		if (m_label != null) {
			Dimension dim = m_label.getPreferredSize();
			m_label.setBounds((getWidth()-dim.width)/2, (getHeight()-dim.height)/2, dim.width, dim.height);
	}	}
			
	// --------------
	// Public methods
	// --------------

	public ClientSet(Diagram diagram) 
	{
		super(diagram);

		setToolTipText("Clients are things outside the diagram that have edges into the diagram");
	}

	public void findClients(EntityInstance root, EntityInstance drawRoot, boolean liftEdges)
	{
		EntityInstance	e;
		Enumeration		en;

		m_drawRoot = drawRoot;
		root.addClients(m_set, drawRoot, m_ls.isVisibleEdges(), liftEdges);
		m_fullSize = m_set.size();
		setToolTipText(m_fullSize + " clients");
	}
	
	// Diagram coordinates interface (no multiple inheritence in Java)
	
	public int getDiagramX()
	{
		return(super.getDiagramX());
	}
	
	public int getDiagramY()
	{
		return(super.getDiagramY());
	}
}
