package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

// Used by legend box

class EntityChkBox extends JComponent
{
	protected static final int GAP    = 5; 
	protected static final int WIDTH  = 45;
	protected static final int HEIGHT = 20;

	protected   JCheckBox			m_checkbox;
	protected	EntityClass			m_ec;
	protected	EntityInstance		m_e;
	protected	int					m_index;
	protected	JLabel				m_label;

	public EntityChkBox(EntityClass ec, int index, int height, boolean value) 
	{
		FlowLayout	flowLayout;
		Color		color;
		JCheckBox	checkbox;
		EntityComponent	entityComponent;
		JLabel		label;
		Dimension	d;
		int			bh  = height*2;
		int			bw  = (bh*4)/3;

		flowLayout = new FlowLayout(FlowLayout.LEFT);
		flowLayout.setHgap(GAP);
		setLayout(new FlowLayout(FlowLayout.LEFT));

		m_ec    = ec;
		m_index = index;

		color       = ec.getObjectColor();

		m_checkbox = checkbox = new JCheckBox();
//		checkbox.setBackground(Color.WHITE);
		checkbox.setBorderPaintedFlat(false);
		checkbox.setSelected(ec.isShown());
		checkbox.setEnabled(true);
		checkbox.setVisible(true);
		add(checkbox);

		m_e = ec.newEntity("");
		entityComponent = m_e.neededPlainComponent();
		m_e.setSize(bw, bh);
		m_e.setLocation(0,0);
		entityComponent.setPreferredSize(new Dimension(bw, bh));
		add(entityComponent);

		m_label = label = new JLabel(ec.getLabel());
		label.setForeground(ec.getLabelColor());
		add(label);

		setToolTipText(ec.getDescription());
	}

	public void setFont(Font font)
	{
		m_label.setFont(font);
	}

	public void addItemListener(ItemListener listener)
	{
		m_checkbox.addItemListener(listener);
	}

	public boolean isSelected()
	{
		return(m_checkbox.isSelected());
	}

	public void doClick()
	{
		m_checkbox.doClick();
	}

	public int getIndex()
	{
		return(m_index);
	}
}
