package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;

// Entities in a landscape 

class EntityChildren implements Enumeration
{
	Vector				m_srcRelList;
	int					m_next;
	RelationInstance	m_ri;

	private void advance(int i)
	{
		Vector				srcRelList    = m_srcRelList;
		int					size          = srcRelList.size();
		RelationInstance	ri;
		RelationClass		rc;

		for (;;) {
			if (++i >= size) {
				m_ri = null;
				break;
			}
			ri = (RelationInstance) srcRelList.elementAt(i);
			rc = ri.getRelationClass();
			if (rc.isContainsClass()) {
				m_ri = ri;
				break;
		}	}
		m_next = i;
	}
			

	public EntityChildren(EntityInstance e, Vector srcRelList)
	{
		m_srcRelList    = srcRelList;
		advance(-1);
	}

	public boolean hasMoreElements()
	{
		return (m_ri != null);
	}

	public Object nextElement()
	{
		RelationInstance ri = m_ri;
		advance(m_next);
		return ri.getDst();
}	}

class EntityPosition
{
	double	m_xrelLocal	     = -1.0;
	double	m_yrelLocal      = -1.0;
	double	m_widthrelLocal  = -1.0;
	double	m_heightrelLocal = -1.0;
};

public class EntityInstance extends LandscapeObject3D /* extends LandscapeObject */ implements Icon, DiagramCoordinates, MouseListener, MouseMotionListener {

	class UpdateTitle extends MyUndoableEdit implements UndoableEdit
	{
		String				 m_old;
		String				 m_new;

		UpdateTitle(String value)
		{
			m_old = m_title;
			m_new = value;
			if (logEdit(this)) {
				m_title = value;
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " Title";
		}

		public void undo()
		{
			m_title = m_old;
		}

		public void redo()
		{
			m_title = m_new;
		}
	}	

	class UpdateFontDelta extends MyUndoableEdit implements UndoableEdit
	{
		int                  m_old;
		int                  m_new;

		UpdateFontDelta(int value)
		{
			m_old = m_fontDelta;
			m_new = value;
			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " FontDelta " + m_new;
		}

		public void undo()
		{
			m_fontDelta = m_old;
			repaint();
		}

		public void redo()
		{
			m_fontDelta = m_new;
			repaint();
	}	}

	class UpdateXRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_old;
		double               m_new;

		UpdateXRelLocal(double value)
		{
			m_old = m_xrelLocal;
			m_new = value;
			if (logEdit(this)) {
				setXRelLocal(value);
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " xRelLocal " + Util.formatFraction(m_new);
		}

		public void undo()
		{
			setXRelLocal(m_old);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setXRelLocal(m_new);
			getDiagram().redrawDiagram();
	}	}

	class UpdateYRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_old;
		double               m_new;

		UpdateYRelLocal(double value)
		{
			m_old = m_yrelLocal;
			m_new = value;
			if (logEdit(this)) {
				setYRelLocal(value);
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " yRelLocal " + Util.formatFraction(m_new);
		}

		public void undo()
		{
			setYRelLocal(m_old);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setYRelLocal(m_new);
			getDiagram().redrawDiagram();
	}	}

	class UpdateWidthRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_old;
		double               m_new;

		UpdateWidthRelLocal(double value)
		{
			m_old = m_widthrelLocal;
			m_new = value;
			if (logEdit(this)) {
				setWidthRelLocal(value);
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " widthRelLocal " + Util.formatFraction(m_new);
		}

		public void undo()
		{
			setWidthRelLocal(m_old);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setWidthRelLocal(m_new);
			getDiagram().redrawDiagram();
	}	}

	class UpdateHeightRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_old;
		double               m_new;

		UpdateHeightRelLocal(double value)
		{
			m_old = m_heightrelLocal;
			m_new = value;
			if (logEdit(this)) {
				setHeightRelLocal(value);
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " heightRelLocal " + Util.formatFraction(m_new);
		}

		public void undo()
		{
			setHeightRelLocal(m_old);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setHeightRelLocal(m_new);
			getDiagram().redrawDiagram();
	}	}

	class UpdateRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_oldX, m_oldY, m_oldWidth, m_oldHeight;
		double               m_newX, m_newY, m_newWidth, m_newHeight;

		UpdateRelLocal(double x, double y, double width, double height)
		{
			m_oldX      = m_xrelLocal;
			m_oldY      = m_yrelLocal;
			m_oldWidth  = m_widthrelLocal;
			m_oldHeight = m_heightrelLocal;
			m_newX      = x;
			m_newY      = y;
			m_newWidth  = width;
			m_newHeight = height;
			if (logEdit(this)) {
				setRelLocal(x, y, width, height);
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " RelLocal {" + Util.formatFraction(m_newX) + "x" + Util.formatFraction(m_newY) + "," + Util.formatFraction(m_newWidth) + "x" + Util.formatFraction(m_newHeight) + "}";
		}

		public void undo()
		{
			setRelLocal(m_oldX, m_oldY, m_oldWidth, m_oldHeight);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setRelLocal(m_newX, m_newY, m_newWidth, m_newHeight);
			getDiagram().redrawDiagram();
	}	}

	class UpdateDelete extends MyUndoableEdit implements UndoableEdit
	{
		UpdateDelete()
		{
			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " Deleted";
		}

		public void undo()
		{
			Diagram diagram = getDiagram();

			diagram.pasteEntity(null, EntityInstance.this);
			diagram.redrawDiagram();
		}

		public void redo()
		{

			Diagram	diagram	= getDiagram();

			diagram.cutEntity(EntityInstance.this);
			diagram.redrawDiagram();
	}	}

	class UpdateDeleteContainer extends MyUndoableEdit implements UndoableEdit
	{
		UpdateDeleteContainer()
		{
			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " Container Deleted";
		}

		public void undo()
		{
			Diagram	diagram = getDiagram();

			diagram.uncutContainer(EntityInstance.this);
		}

		public void redo()
		{
			Diagram	diagram = getDiagram();

			diagram.cutContainer(EntityInstance.this);
	}	}

	class UpdateContainment extends MyUndoableEdit implements UndoableEdit
	{
		EntityInstance	m_containedByOld;
		EntityInstance	m_containedByNew;

		UpdateContainment(EntityInstance value)
		{
			m_containedByOld = getContainedBy();
			m_containedByNew = value;

			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " moved from " + m_containedByOld + " to " + m_containedByNew;
		}

		public void undo()
		{
			Diagram	diagram = getDiagram();

			diagram.cutAndPasteEntity(m_containedByOld, EntityInstance.this);
			diagram.redrawDiagram();
		}

		public void redo()
		{
			Diagram	diagram	= getDiagram();

			diagram.cutAndPasteEntity(m_containedByNew, EntityInstance.this);
			diagram.redrawDiagram();
	}	}

	// Final values
	
	public final static int SMALL_FONT = 0;
	public final static int REG_FONT   = 1;

	public final static String LABEL_ID =			 "label";
	public final static String XPOSITION_ID =		 "x";
	public final static String YPOSITION_ID =		 "y";
	public final static String WIDTH_ID =			 "width";
	public final static String HEIGHT_ID =			 "height";

	public final static String XRELPOSITION_ID =	 "xrel";
	public final static String YRELPOSITION_ID =	 "yrel";
	public final static String WIDTHREL_ID =		 "widthrel";
	public final static String HEIGHTREL_ID =		 "heightrel";

	public final static String IN_ELISION_ID =		 "elision";
	public final static String OUT_ELISION_ID =		 "outelision";
	public final static String CLIENT_ELISION_ID =	 "clientelision";
	public final static String SUPPLIER_ELISION_ID = "supplierelision";
	public final static String INTERNAL_ELISION_ID = "internalelision";
	public final static String AGG_ELISION_ID =		 "aggelision";
	public final static String LINK_ID =			 "navlink";
	public final static String INPOINT_ID =			 "inpoints";
	public final static String OUTPOINT_ID =		 "outpoints";
	public final static String LEFTPOINT_ID =		 "leftpoints";
	public final static String RIGHTPOINT_ID =		 "rightpoints";
	public final static String DESC_ID =			 "description";
	public final static String TITLE_ID =			 "title";
	public final static String FONTDELTA_ID =		 "fontdelta";

	public  final static int RSZ_NONE = -1;
	private final static int RSZ_NW	= 0;
	private final static int RSZ_N	= 1;
	private final static int RSZ_NE	= 2; 
	private final static int RSZ_E	= 3;
	private final static int RSZ_SE	= 4;
	private final static int RSZ_S	= 5;
	private final static int RSZ_SW	= 6;
	private final static int RSZ_W	= 7;

	// Annotation tab constants

	private final static double TAB_HEIGHT = 16.0; 

	private final static int MOUSE_NEAR_EDGE_THRESHOLD = 4;
	private final static int SEP_THRESHOLD = 8;

	// Static font info 

	private final static int MARGIN = 5; 
	private final static int MIN_HEIGHT = 10;
	private final static int MIN_WIDTH = 30;

	private final static int CONTENTS_FLAG_DIM = 8;


	public final static String DEFAULT_OPEN_CLASS_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int	   DEFAULT_OPEN_CLASS_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_OPEN_CLASS_FONT_SIZE  = 12;

	protected     static Font	m_openClassFont = FontCache.get(DEFAULT_OPEN_CLASS_FONT_NAME, DEFAULT_OPEN_CLASS_FONT_STYLE, DEFAULT_OPEN_CLASS_FONT_SIZE);

	public final static String DEFAULT_CLOSED_FONT_NAME      = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_CLOSED_FONT_STYLE     = Font.PLAIN;
	public final static int    DEFAULT_CLOSED_FONT_SIZE      = 12;

	protected	  static Font   m_closedFont    = FontCache.get(DEFAULT_CLOSED_FONT_NAME, DEFAULT_CLOSED_FONT_STYLE, DEFAULT_CLOSED_FONT_SIZE);

	public final static String DEFAULT_SMALL_FONT_NAME       = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_SMALL_FONT_STYLE      = Font.PLAIN;
	public final static int    DEFAULT_SMALL_FONT_SIZE      = 10;

	protected     static Font   m_smallFont     = FontCache.get(DEFAULT_SMALL_FONT_NAME, DEFAULT_SMALL_FONT_STYLE, DEFAULT_SMALL_FONT_SIZE);

	// Bits set in m_mark
	
	public final static int	DIAGRAM_MARK		= 0x01;		// This entity is visible in the main diagram  (at present)
	public final static int	CLIENT_MARK			= 0x02;		// This entity is in the set of clients   (at present)
	public final static int SUPPLIER_MARK		= 0x04;		// This entity is in the set of suppliers (at present)

	public final static int HIGHLIGHT_EDGE_MARK	= 0x01000;		// Highlight the edge of the object
	public final static int REDBOX_MARK         = 0x08000;	// Mark this box in deep red for (forward/back) edge tracing     
	public final static int	GROUP_MARK			= 0x10000;	// This entity is part of a group
	public final static int GROUPKEY_MARK		= 0x20000;	// This entity is the key entity in the group
	public final static int	OPEN_MARK			= 0x40000;	// This entity is open
	public final static int CLOSED_MARK			= 0x80000;	// This entity is closed

	public final static int CLIENT_SUPPLIER     = CLIENT_MARK | SUPPLIER_MARK;
	public final static int IN_DIAGRAM          = CLIENT_SUPPLIER | DIAGRAM_MARK;
	public final static int PRESENTATION_MARKS  = HIGHLIGHT_EDGE_MARK | REDBOX_MARK | GROUP_MARK | GROUPKEY_MARK;

	public final static int	IN_TREE_MARK		= 0x100000;
	public final static int	LIFTED_MARK			= 0x200000;
	public final static int IN_GRAPH_MARK       = 0x400000;

	/* Conceptually an EntityInstance should derive from a BendPoint but it is hard to change
	 * everything to have relations point at bend points that may or may not be EntityInstances
	 * For now take the hit of wasting memory by having a bend point internally represented by
	 * a zero size EentityInstance.
	 */

	public final static int DUMMY_NODE_MARK     = 0x800000;
	public final static int HAS_LABEL_MARK      = 0x1000000;
	public final static int DELETED_MARK        = 0x2000000;

	public final static int PERMANENT_MARKS     = DUMMY_NODE_MARK | HAS_LABEL_MARK | DELETED_MARK;

	
	public final static double WIDTHRELLOCAL_DEFAULT  = 15.0/16.0;
	public final static double HEIGHTRELLOCAL_DEFAULT = 15.0/16.0;

	private static EntityInstance m_currentDescEntity = null;	// The current entry being described in the feedback box
	
	private int				m_mark = 0;
	private String			m_title;					// The title of this entity

	// First order attributes

	private Vector	 m_dstElision;
	private Vector	 m_srcElision;
	private Vector	 m_enteringElision;
	private Vector	 m_exitingElision;
	private Vector	 m_internalElision;

	private EdgePoint[] topPoints, bottomPoints, leftPoints, rightPoints;


	// We need the position within the diagram to compute coordinates for edges quickly

	private int		m_diagramX         = Integer.MIN_VALUE;
	private int		m_diagramY         = Integer.MIN_VALUE;

	// We need the bounds to be used when EntityComponents are created and manipulated

	private int		m_x;
	private int		m_y;
	private int		m_width;
	private int		m_height;

	// These are the master coordinates with respect to the parent node

	protected double	m_xrelLocal	     = -1.0;
	protected double	m_yrelLocal      = -1.0;
	protected double	m_widthrelLocal  = -1.0;
	protected double	m_heightrelLocal = -1.0;

	protected EntityPosition[] m_positions = null;

	// These are the top left coordinates of the object on the screen

	private int			m_fontDelta     = 0;

	private int			m_preorder;
	private int			m_postorder;
	
	/* keep tight control over the group flags so can draw changes at a low level */

	private Vector m_srcRelList    = new Vector();	// List of relations for which this entity is the source 
	private Vector m_dstRelList    = new Vector();	// List of relations for which this entity is the destination 
	private Vector m_srcLiftedList = new Vector();	// List of relations whose source is lifted to leave this entity
	private Vector m_dstLiftedList = new Vector();	// List of relations whose destination is lifted to address this entity

	// Stat gathering

/*
	private int m_debug_x      = Integer.MIN_VALUE;
	private int m_debug_y      = Integer.MIN_VALUE;
	private int m_debug_width  = Integer.MIN_VALUE;
	private int m_debug_height = Integer.MIN_VALUE;
*/
	// ---------------
	// Wrapper methods
	// ---------------

	// Used by legend box

	public EntityComponent neededPlainComponent()
	{
		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent == null) {
			entityComponent = new EntityComponent(this);
		}
		return(entityComponent);
	} 

	public void setToolTipText(EntityComponent entityComponent)
	{
		String text;

		if (isDrawRoot()) {
			text = null;
		} else {
			text = getEntityLabel();
		}
		entityComponent.setToolTipText(text);
	}
	
	public void setToolTipText()
	{
		EntityComponent	component = (EntityComponent) getSwingObject();
		
		if (component != null) {
			setToolTipText(component);
	}	}
		
	public EntityComponent neededComponent()
	{
		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent == null) {
			entityComponent = new EntityComponent(this);
			// Do this here so that the legend use of entities isn't compromised
			setToolTipText(entityComponent);
			entityComponent.addMouseListener(this);
			entityComponent.addMouseMotionListener(this);

		}
		return(entityComponent);
	} 

	private Vector neededDstElision()
	{
		Vector dstElision = m_dstElision;
		if (dstElision == null) {
			m_dstElision = dstElision = new Vector();
		}
		return(dstElision);
	}
	
	private Vector neededSrcElision()
	{
		Vector srcElision = m_srcElision;
		if (srcElision == null) {
			m_srcElision = srcElision = new Vector();
		}
		return(srcElision);
	}
	
	private Vector neededEnteringElision()
	{
		Vector enteringElision = m_enteringElision;
		if (enteringElision == null) {
			m_enteringElision = enteringElision = new Vector();
		}
		return(enteringElision);
	}
	
	private Vector neededExitingElision()
	{
		Vector exitingElision = m_exitingElision;
		if (exitingElision == null) {
			m_exitingElision = exitingElision = new Vector();
		}
		return(exitingElision);
	}
	
	private Vector neededInternalElision()
	{
		Vector internalElision = m_internalElision;
		if (internalElision == null) {
			m_internalElision = internalElision = new Vector();
		}
		return(internalElision);
	}

	public static Font getClosedFont()
	{
		return m_closedFont;
	}

	public Font getAdjustedClosedFont()
	{
		Font closedFont = m_closedFont;
		int	 delta      = m_fontDelta;

		if (delta != 0) {
			String fontname = closedFont.getFamily();
			int    style    = closedFont.getStyle();
			int	   size     = closedFont.getSize();
		
			size += delta;
			if (size < 1) {
				size = 1;
			}
			closedFont = FontCache.get(fontname, style, size);
		}
		return closedFont;
	}

	public static void setClosedFont(Font font)
	{
		m_closedFont = font;
	}

	public static Font getOpenClassFont()
	{
		return m_openClassFont;
	}
			    
	public static void setOpenClassFont(Font font)
	{
		m_openClassFont = font;
	}

	public static Font getSmallFont() 
	{
		return m_smallFont;
	}

	public static void setSmallFont(Font font)
	{
		m_smallFont = font;
	}

	public void removeTreeFromCache()
	{
		Enumeration			children;
		EntityInstance		child;


		EntityCache.remove(this);
		for (children = getChildren(); children.hasMoreElements(); ) {
			child = (EntityInstance) children.nextElement();
			child.removeTreeFromCache();
	}	}

	public void addTreeToCache()
	{
		Enumeration			children;
		EntityInstance		child;


		EntityCache.put(this);
		for (children = getChildren(); children.hasMoreElements(); ) {
			child = (EntityInstance) children.nextElement();
			child.addTreeToCache();
	}	}

	public void removeAll()
	{
		JComponent entityComponent = getSwingObject();
		if (entityComponent != null) {
			entityComponent.removeAll();
	}	}

	public void setVisible(boolean value)
	{
		JComponent entityComponent;
		
		if (value) {
			entityComponent = neededComponent();
			entityComponent.setVisible(true);
		} else {
			entityComponent = (EntityComponent) getSwingObject();
			if (entityComponent != null) {
				entityComponent.setVisible(false);
	}	}	}
	
	public void repaint()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			entityComponent.repaint();
	}	}
		
	public void validate()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			entityComponent.validate();
	}	}

	public void paintMap(Graphics g, int x, int y, int width, int height, EntityInstance onPath, int depth)
	{
		EntityComponent entityComponent = neededComponent();

		entityComponent.paintMap(g, x, y, width, height, onPath, depth);
	}

	public int getX()
	{
		return(m_x);
	}

	public int getY()
	{
		return(m_y);
	}

	public int getWidth()
	{
		return(m_width);
	}

	public int getHeight()
	{
		return(m_height);
	}

	// --------------
	// Wrapper methods
	// ---------------

	protected EntityInstance getDrawRoot()
	{
		return(getDiagram().getDrawRoot());
	}

	public boolean isDrawRoot()
	{
		return (this == getDrawRoot());
	}

	protected int numRelationClasses()
	{
		return(getDiagram().numRelationClasses());
	}

	protected RelationClass numToRelationClass(int i)
	{
		return(getDiagram().numToRelationClass(i));
	}

	// -----------------
	// Protected methods
	// -----------------

	protected void setFont(Graphics g, int type) 
	{
		switch(type) {
		case SMALL_FONT:
			g.setFont(m_smallFont);
			return;
		default:
			g.setFont(getAdjustedClosedFont());
			return;
	}	}

	public int getFontDelta()
	{
		return(m_fontDelta);
	}

	protected void setFontDelta(int value) 
	{
		m_fontDelta = value;
		repaint();
	}

	public void updateFontDelta(int value)
	{
		if (value != m_fontDelta) {
			new UpdateFontDelta(value);
	}	}


	public Color getCurrentLabelColor() 
	{
		if (isMarked(REDBOX_MARK) && !isOpen()) {
			return Color.yellow;
		}
		return getLabelColor();
	}

	//
	// Parse an attribute record to set the appropriate edge point factors
	// supplied in an attribute record.

	protected void parsePoints(EdgePoint[] ept, Attribute attr) 
	{
		AttributeValueItem avi;

		for (avi = attr.avi; avi != null; avi = avi.nextList) {
			RelationClass rc = getDiagram().getRelationClass(avi.value);

			if (rc != null) {
				int nid = rc.getNid();

				double wf = Util.parseReal(avi.next.value);
				double hf = Util.parseReal(avi.next.next.value);

				if (ept[nid] == null) {
					ept[nid] = new EdgePoint(this, rc, wf, hf);
				} else {
					if (rc != ept[nid].getRc()) {
						MsgOut.println("Class nid mismatch");
					}
					ept[nid].m_wf = wf;
					ept[nid].m_hf = hf;
				}
				ept[nid].isDefault = false;
			}
		}
	}

	static protected Hashtable est = new Hashtable();

	protected void processElision(Attribute attr, Vector list) 
	{
		AttributeValueItem av;

		for (av = attr.avi; av != null; av = av.next) {
			String str = (String) est.get(av.value);
			if (str == null) {
				str = av.value;
				est.put(str, str);
			}
			if (!list.contains(str)) {
				list.addElement(str);
	}	}	}

	protected void processRawElision(String[] sl, Vector list) 
	{
		for (int i = 0; i<sl.length; ++i) {
			list.addElement(sl[i]);
		}
	}

	private	void setPositionArraySize(int lth)
	{
		EntityPosition[]	positions = m_positions;

		if (positions == null) {
			m_positions = positions = new EntityPosition[lth];
		} else if (positions.length < lth) {
			EntityPosition[]	oldpositions = positions;
			int					i;
			
			m_positions = positions = new EntityPosition[lth];

			for (i = oldpositions.length; --i >= 0; ) {
				positions[i] = oldpositions[i];
	}	}	}

	//
	// Parse the values of any first order attributes into their storage.
	// 

	// First thing called by EntityInstance::AddAttributes
	// If the attribute is a known member of storage -- don't save attribute -- just store value

	protected boolean processFirstOrderAttributes(Attribute attr)
	{
		AttributeValueItem	avi = attr.avi;
		AttributeValueItem	avi1;
		int					values;

		values = 0;
		for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
			++values;
		}


		if (attr.hasId(XPOSITION_ID)) {			
			if (values > 0) {
				setxLocal(attr.parseReal());		// Only valid in legacy code
				attr.id = XRELPOSITION_ID;			// So right name gets registered (A cheat)
			}
			return true; 
		}

		if (attr.hasId(YPOSITION_ID)) {
			if (values > 0) {
				setyLocal(attr.parseReal());		// Only valid in legacy code
				attr.id = YRELPOSITION_ID;
			}
			return true; 
		}

		if (attr.hasId(WIDTH_ID)) {
			if (values > 0) {
				setwidthLocal(attr.parseReal());	// Only valid in legacy code
				attr.id = WIDTHREL_ID;
			}
			return true; 
		}

		if (attr.hasId(HEIGHT_ID)) {
			if (values > 0) {
				setheightLocal(attr.parseReal());	// Only valid in legacy code
				attr.id = HEIGHTREL_ID;
			}
			return true; 
		}

		if (attr.hasId(XRELPOSITION_ID)) {
			if (values > 0) {
				setXRelLocalBounded(attr.parseReal());
				if (values > 1) {
					setPositionArraySize(values);

					EntityPosition[] positions = m_positions;
					EntityPosition	 position;
					int				 i;

					i = 0;
					for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
						position = positions[i];
						if (position == null) {
							m_positions[i] = position = new EntityPosition();
						}
						position.m_xrelLocal = Util.parseReal(avi1.value);
						++i;
			}	}	}
			return true; 
		}

		if (attr.hasId(YRELPOSITION_ID)) {
			if (values > 0) {
				setYRelLocalBounded(attr.parseReal());
				if (values > 1) {
					setPositionArraySize(values);

					EntityPosition[] positions = m_positions;
					EntityPosition	 position;
					int				 i;

					i = 0;
					for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
						position = positions[i];
						if (position == null) {
							m_positions[i] = position = new EntityPosition();
						}
						position.m_yrelLocal = Util.parseReal(avi1.value);
						++i;
			}	}	}
			return true; 
		}

		if (attr.hasId(WIDTHREL_ID)) {
			if (values > 0) {
				setWidthRelLocalBounded(attr.parseReal());

				if (values > 1) {
					setPositionArraySize(values);

					EntityPosition[] positions = m_positions;
					EntityPosition	 position;
					int				 i;

					i = 0;
					for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
						position = positions[i];
						if (position == null) {
							m_positions[i] = position = new EntityPosition();
						}
						position.m_widthrelLocal = Util.parseReal(avi1.value);
						++i;
			}	}	}
			return true; 
		}

		if (attr.hasId(HEIGHTREL_ID)) {
			if (values > 0) {
				setHeightRelLocalBounded(attr.parseReal());
				if (values > 1) {
					setPositionArraySize(values);

					EntityPosition[] positions = m_positions;
					EntityPosition	 position;
					int				 i;

					i = 0;
					for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
						position = positions[i];
						if (position == null) {
							m_positions[i] = position = new EntityPosition();
						}
						position.m_heightrelLocal = Util.parseReal(avi1.value);
						++i;
			}	}	}
			return true; 
		}

		if (attr.hasId(LABEL_ID)) {
			if (values > 0) {
				setLabel(attr.parseString());
			}
			return true; 
		}

		if (attr.hasId(DESC_ID)) {
			if (values > 0) { 
				setDescription(attr.parseString());
			}
			return true; 
		} 

		if (attr.hasId(TITLE_ID)) {
			if (values > 0) {
				setTitle(attr.parseString());
			}
			return true;
		}

		if (attr.hasId(FONTDELTA_ID)) {
			if (values > 0) {
				setFontDelta(attr.parseInt());
			}
			return true; 
		}

		if (attr.hasId(COLOUR_ID)) {
			if (values > 0) {
				setObjectColor(attr.parseColour());
			}
			return true;
		}

		if (attr.hasId(OPEN_COLOUR_ID)) {
			if (values > 0) {
				setColorWhenOpen(attr.parseColour());
			}
			return true;
		}

		if (attr.hasId(LABEL_COLOUR_ID)) {
			if (values > 0) {
				setLabelColor(attr.parseColour());
			}
			return true;
		}

		if (attr.hasId(IN_ELISION_ID)) {
			if (values > 0) { 
				processElision(attr, neededDstElision()); 
			}
			return true; 
		}

		if (attr.hasId(OUT_ELISION_ID)) {
			if (values > 0) {
				processElision(attr, neededSrcElision());
			}
			return true;
		}

		if (attr.hasId(CLIENT_ELISION_ID)) {
			if (values > 0) {
				processElision(attr, neededEnteringElision());
			}
			return true;
		}

		if (attr.hasId(SUPPLIER_ELISION_ID)) {
			if (values > 0) {
				processElision(attr, neededExitingElision());
			}
			return true;
		}

		if (attr.hasId(INTERNAL_ELISION_ID)) {
			if (values > 0) {
				processElision(attr, neededInternalElision());
			}
			return true;
		}

		if (attr.hasId(INPOINT_ID)) {
			if (values > 0) {
				if (topPoints == null) {
					topPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(topPoints, attr);
			}
			return true; 
		}

		if (attr.hasId(OUTPOINT_ID)) {
			if (values > 0) {
				if (bottomPoints == null) {
					bottomPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(bottomPoints, attr); 
			}
			return true; 
		}

		if (attr.hasId(LEFTPOINT_ID)) {
			if (values > 0) {
				if (leftPoints == null) {
					leftPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(leftPoints, attr); 
			}
			return true; 
		}

		if (attr.hasId(RIGHTPOINT_ID)) {
			if (values > 0) {
				if (rightPoints == null) {
					rightPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(rightPoints, attr); 
			}
			return true; 
		}

		return false; 
	}

	protected String endSet[] = { 
		".ss",
		".dup",
		"__funcdef",
		"__funcdcl",
		"__vardef",
		"__vardcl",
		"__macro", 
		"__struct", 
		"__union", 
		"__enum", 
		"__type"
	}; 

	public String mungeId(String id) 
	{
		if (id.length() > 0) {

			for (int i = 0; i < endSet.length; ++i) {
				if (id.endsWith(endSet[i])) {
					id = id.substring(0, id.length()-endSet[i].length());
					break;
				}
			}

			if (id.charAt(0) != '<') {
				int lpi = id.lastIndexOf('/');

				if (lpi < 0) {
					lpi = id.lastIndexOf('\\');
				}
				if (lpi >= 0 && id.length() != lpi+1) {
					return id.substring(lpi+1);
				}
			}
		}
		return id;
	}

	// --------------
	// Public methods
	// --------------

 	public EntityInstance(EntityClass parentClass, String id) 
	{
		setParentClass(parentClass);
		super.setLabel(mungeId(id));	// The default
		setId(id);
	}

	/* We must know if we assign our label mungeId(id) as the default because we should write the TA we
	 * get in, and we don't want to loose explicit label statements al-la PR-82. Cludgy but don't want
	 * to incur storage cost of extra string field per Entity.
	 */

	public String getLabel()
	{
		if (isMarked(HAS_LABEL_MARK)) {
			return super.getLabel();
		}
		return null;
	}
		
	public void setLabel(String value)
	{
		if (value == null || Util.isBlank(value)) {
			if (isMarked(HAS_LABEL_MARK)) {
				super.setLabel(mungeId(getId()));
				m_mark &= ~HAS_LABEL_MARK;
			}
		} else {
			super.setLabel(value);
			orMark(HAS_LABEL_MARK);
	}	}

	public String getEntityLabel()
	{
		return super.getLabel();
	}

	public String getClassLabel()
	{
		return getEntityClass().getLabel();
	}

	public void closeAll(String containsId)
	{
		Enumeration			en;
		EntityInstance		e;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.setContainElision(containsId);
			e.closeAll(containsId);
	}	}

	public void openAll(String containsId)
	{
		Enumeration			en;
		EntityInstance		e;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.clearContainElision(containsId);
			e.openAll(containsId);
	}	}

	public String getTitle() 
	{
		return m_title;
	}

	public void setTitle(String title) 
	{
		m_title = title;
	}

	public String getStyleName(int style)
	{
		return EntityClass.getEntityStyleName(style);
	}

	public void exchangePositioning(int oldindex, int newindex, int lth)
	{
		setPositionArraySize(lth);

		Enumeration			en;
		EntityInstance		e;
		EntityPosition		position;
		EntityPosition[]	positions = m_positions;
		int					i;

		if (m_xrelLocal >= 0 || m_yrelLocal >= 0 || m_widthrelLocal >= 0 || m_heightrelLocal >= 0) {
			position = positions[oldindex];
			if (position == null) {
				positions[oldindex] = position = new EntityPosition();
			}
			position.m_xrelLocal      = m_xrelLocal;
			position.m_yrelLocal      = m_yrelLocal;
			position.m_widthrelLocal  = m_widthrelLocal;
			position.m_heightrelLocal = m_heightrelLocal;
		}

		position = positions[newindex];
		if (position == null) {
			m_xrelLocal      = -1.0;
			m_yrelLocal      = -1.0;
			m_widthrelLocal  = -1.0;
			m_heightrelLocal = -1.0;
		} else {
			m_xrelLocal      = position.m_xrelLocal;
			m_yrelLocal      = position.m_yrelLocal;
			m_widthrelLocal  = position.m_widthrelLocal;
			m_heightrelLocal = position.m_heightrelLocal;
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.exchangePositioning(oldindex, newindex, lth);
	}	}

	public void updateTitle(String title)
	{
		if (title == null) {
			if (m_title == null) {
				return;
			}
		} else if (title.equals(m_title)) {
			return;
		}
		new UpdateTitle(title);
	}

	// Destroy just the entity, leaving the children 

	public void deleteContainer() 
	{
		new UpdateDeleteContainer();
	}

	// Remove m_dstRelList relations from entities on our m_srcRelList.
	// Remove m_srcRelList relations from entities on our m_dstRelList. 
	// After this operation we continue to know all about all edges to/from
	// us, but other entitites know nothing about all edges to/from us.
	// Can't apply this to the root since no where to add children

	public EntityInstance disconnectEdgesJustMe(RelationClass containsClass)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		parent, other;

		// This entity can no longer belongs to any active group

		nandMark(GROUP_MARK|GROUPKEY_MARK);

		parent = null;
		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getSrc();
			if (other != this) {
				if (parent == null) {
					if (ri.getRelationClass() == containsClass) {
						parent = other;
				}	}
				other.removeSrcRelation(ri);
		}	}

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getDst();
			if (other != this) {
				other.removeDstRelation(ri); 
			}
			if (ri.getRelationClass() == containsClass) {
				// No longer a child of us -- make child of parent
				other.setContainedBy(parent);
				if (parent != null) {
					parent.addContainment(other);
		}	}	}
		return(parent);
	}

	// Add m_dstRelList relations from entities on our m_srcRelList.
	// Add m_srcRelList relations from entities on our m_dstRelList. 
	// Reverses changes made by disconnectEdgesJustMe
	
	public EntityInstance reconnectEdgesJustMe(RelationClass containsClass)
	{
		Enumeration			en;
		RelationInstance	ri, ri1;
		EntityInstance		other, parent;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getDst();
			if (other != this) {
				if (ri.getRelationClass() == containsClass) {
					ri1 = other.getContainedByRelation(containsClass);
					if (ri1 != null) {
						parent = ri1.getSrc();
						parent.removeSrcRelation(ri1);
						other.removeDstRelation(ri1);
						parent.removeContainment(other);
					}
					other.addDstRelation(ri);
					addContainment(other);
				} else {
					other.addDstRelation(ri);
		}	}	}

		parent = null;
		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getSrc();
			if (other != this) {
				other.addSrcRelation(ri);
				if (ri.getRelationClass() == containsClass) {
					parent = other;
					parent.addContainment(this);
		}	}	}
		return parent;
	}

	// After this operation everything in/under top knows about its
	// edges but nothing else does

	public void disconnectEdges(EntityInstance top)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		other;
		EntityInstance		e;

		markDeleted();

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getDst();
			if (!top.hasDescendantOrSelf(other)) {
				other.removeDstRelation(ri); 
		}	}

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getSrc();
			if (!top.hasDescendantOrSelf(other)) {
				other.removeSrcRelation(ri);
		}	}

		// We continue to know who our children are but by this point they
		// don't know who their parent is

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.disconnectEdges(top);
		} 
	}

	public void reconnectEdges()
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		other;
		EntityInstance		e;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.reconnectEdges();
		}

		clearDeleted();

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getDst();
			other.addDstRelationIfAbsent(ri); 
		}

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getSrc();
			other.addSrcRelationIfAbsent(ri);
	}	}

/*
	// Used to insure new entities are on top of old in Z order
	// Doesn't work

	public void setLastDst(RelationInstance ri)
	{
		int				 i    = m_dstRelList.indexOf(ri);
		int				 size = m_dstRelList.size();
		Object			 other;

		if (i >= 0) {
			for (; ++i < size; ) {
				other = m_dstRelList.elementAt(i);
				m_dstRelList.setElementAt(other, i-1);
			}
			m_dstRelList.setElementAt(ri, i-1);
	}	}
*/		 

	// Destroy entity and all it contains 

	public void updateDelete() 
	{
		new UpdateDelete();
	}

	public void addContainment(EntityInstance e) 
	{
		if (e.inDiagram()) {
			EntityComponent entityComponent = neededComponent();
			EntityComponent childComponent  = e.neededComponent();

			nandMark(OPEN_MARK|CLOSED_MARK);
			entityComponent.add(childComponent); // Add e back into new containment
		}
	}

	public boolean removeContainment(EntityInstance e) 
	{
		JComponent entityComponent = getSwingObject();
			
		if (entityComponent != null) {
			JComponent childComponent = e.getSwingObject();
			if (childComponent != null) {
				entityComponent.remove(childComponent);
		}	}
		e.m_mark       &= PERMANENT_MARKS;
		return true;
	}

	public void moveEntityContainment(EntityInstance newContainer) 
	{
		// Transfer containment iff we need to

		if (newContainer != getContainedBy()) {
			new UpdateContainment(newContainer);
		}
	}

	public RelationInstance getRelation(RelationClass rc, EntityInstance dst) 
	{
		// Return relation instance if present

		Enumeration		en;
		RelationInstance ri;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() == rc && ri.getDst() == dst) {
				return ri;
		}	}
		return null;
	}

	public void addSrcRelation(RelationInstance ri) 
	{
		m_srcRelList.addElement(ri); 
	}

	public void addSrcRelationIfAbsent(RelationInstance ri) 
	{
		if (!m_srcRelList.contains(ri)) {
			m_srcRelList.addElement(ri); 
	}	}

	public void removeSrcRelation(RelationInstance ri) 
	{
		m_srcRelList.removeElement(ri); 
	}

	public void addDstRelation(RelationInstance ri) 
	{
		m_dstRelList.addElement(ri); 
	}

	public void addDstRelationIfAbsent(RelationInstance ri) 
	{
		if (!m_dstRelList.contains(ri)) {
			m_dstRelList.addElement(ri); 
	}	}

	public void removeDstRelation(RelationInstance ri) 
	{
		m_dstRelList.removeElement(ri);
	}

	public void addAttribute(Attribute attr) {

		// Process first order attributes, and add all others 
		// to an attribute database

		if (processFirstOrderAttributes(attr)) {
			return;
		}
		super.addAttribute(attr);
	}

	public void assignAttributes(Attribute attr) 
	{
		// Passed list of attribute assignments

		for (; attr != null; attr = attr.next) {

			// For each attribute assignment, find the variable,
			// and assign the value.

			if (attr.avi == null) {
				MsgOut.println("Null attribute assignment");
			} else if (!processFirstOrderAttributes(attr)) {
				Attribute attrVar = getLsAttribute(attr.id);

				if (attrVar == null) {
					if (getDiagram().isUniversalScheme()) {
						putLsAttribute(attr);
					} else {
						MsgOut.println("Entity " + this + " missing attribute '" + attr.toString() + "'");
					}
				} else {
					if (attrVar.m_cloneOnAssign) {
						attrVar = (Attribute) attrVar.clone();
						attrVar.m_cloneOnAssign = false;
						replaceAttribute(attrVar);
					}
					attrVar.avi = attr.avi;
				}
			}
		}
	} 

	// Used when edge points move

	public void validateAllMyEdgesForClass(RelationClass rc) 
	{
		Enumeration			en;
		RelationInstance	ri;

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() != rc) {
				continue;
			}
			if (ri.m_drawSrc != this) {
				System.out.println("validateAllMyEdges() " + this + " drawsrc " + ri.m_drawSrc);
				continue;
			}
			ri.validate();
		}

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() != rc) {
				continue;
			}
			if (ri.m_drawDst != this) {
				System.out.println("validateAllMyEdges() " + this + " drawdst " + ri.m_drawDst);
				continue;
			}
			ri.validate();
	}	}

/*
		v6.0.3
		Stupid to rescale -- might as well recalculate 
 */

	public void validateAllMyEdges() 
	{
		Enumeration			en;
		RelationInstance	ri;

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.m_drawSrc != this) {
				System.out.println("validateAllMyEdges() " + this + " drawsrc " + ri.m_drawSrc);
				continue;
			}
			ri.validate();
		}

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.m_drawDst != this) {
				System.out.println("validateAllMyEdges() " + this + " drawdst " + ri.m_drawDst);
				continue;
			}
			ri.validate();
	}	}

	protected void rescale(EdgePoint[] pts) {

		if (pts != null) {
			for (int i = 0; i < pts.length; ++i) {
				if (pts[i] != null) {
					pts[i].clearRc();
	}	}	}	}


	/* Invoked when some of the children have no assigned relwidth/relheight 
	 * These operation never update only set
	 */

	protected void assignDimensions()
	{
		EntityInstance	e;
		Enumeration		en;
		int				total, rows;
		double			relWidth, relHeight;

		// Must be > 0 

		total     = numChildren();
		rows      = (int) Math.sqrt(total);
		relWidth  = (WIDTHRELLOCAL_DEFAULT  * rows) / (2 * total);
		relHeight = (HEIGHTRELLOCAL_DEFAULT * rows) / (2 * total);


		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if (e.m_widthrelLocal < 0) {
				e.setWidthRelLocalBounded(relWidth);
			}
			if (e.m_heightrelLocal < 0) {
				e.setHeightRelLocalBounded(relHeight);
			}
//			System.out.println("EntityInstance.assignDimensions " + e + " relWidth=" + e.m_widthrelLocal + " relHeight=" + e.m_heightrelLocal);
	}	}

	// Must invoke this after lifted all edges
	// Don't do when resizing because resizing must be done before
	// lifting of edges -- otherwise can't decide what is open and
	// what is closed

	protected void assignLocations()
	{
		Enumeration			en;
		EntityInstance		e;
		Vector				v = null;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if (e.m_xrelLocal < 0 || e.m_yrelLocal < 0) {
				if (v == null) {
					v = new Vector();
				}
				v.add(e);
		}	}

		if (v != null) {
			/* These vertices have no position */
			Diagram				diagram       = getDiagram();
			LandscapeEditorCore	ls            = diagram.getLs();
			int					parent_width  = getWidth();
			int					parent_height = getHeight();
			int					new_width, new_height;

			ls.getLayouter().doLayout1(v, this, false /* Not update */);

			// Handle the fact that sizes may have changed

			for (en = v.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();

				e.resize(parent_width, parent_height);
			}

/*
			{
				int i, cnt;

				cnt = v.size();
				for (i = 0; i < cnt; ++i) {
					e = (EntityInstance) v.elementAt(i);
					System.out.println("EntityInstance.assignLocations " + e + " relX=" + e.m_xrelLocal + " relY=" + e.m_yrelLocal);
			}	}
*/
			v = null;
	}	}

	// Global coordinate transform
	//
	// Calculate global values for Rectangle from local with scale.
	// The absolute x and y offsets of the parent are passed.
	//
	// This also handles calling the rescale on the containing entities.
	//

	public void setSize(int width, int height) 
	{
		JComponent entityComponent = getSwingObject();

		if (width <= 0 || height <= 0) {
			if (m_width > 0 && m_height > 0) {
				openStatusUnknown();
			}
			width = height = 0;
		} else if (m_width <= 0 || m_height <= 0) {
			openStatusUnknown();
		}

		m_width  = width;
		m_height = height;

		if (entityComponent != null) {
			entityComponent.setSize(width, height);
		}
		resizeChildren();
	}

	public void resize(int parent_width, int parent_height)
	{
		int 		new_width, new_height;

		new_width  = (int) (parent_width  * widthRelLocal());
		new_height = (int) (parent_height * heightRelLocal());

		// This set bounds causes children to be rescaled
		setSize(new_width, new_height);
	}

	public void resizeChildren() 
	{
		Enumeration		en;
		int				width, height;
		EntityInstance	e;
		
		width  = getWidth();
		height = getHeight();
		
		// rescale edge points

		rescale(topPoints);
		rescale(bottomPoints);
		rescale(leftPoints);
		rescale(rightPoints);
		
		if (isOpen()) {
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				if (e.m_widthrelLocal < 0 || e.m_heightrelLocal < 0) {
					assignDimensions();
					break;
			}	}

			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.resize(width, height);
	}	}	}

	public void setLocation(int x, int y) 
	{
		JComponent entityComponent = getSwingObject();

		m_x      = x;
		m_y      = y;

		if (entityComponent != null) {
			entityComponent.setLocation(x, y);
		}
		relocateChildren();
	}

	public void setBothLocations(int parentDiagramX, int parentDiagramY, int x, int y) 
	{
		m_diagramX = parentDiagramX + x;
		m_diagramY = parentDiagramY + y;
			
		setLocation(x, y);
	}

	public void relocate(int parentDiagramX, int parentDiagramY, int parent_width, int parent_height)
	{
		int 		new_x, new_y;

		new_x      = (int) (parent_width  * xRelLocal());
		new_y      = (int) (parent_height * yRelLocal());

		// This set bounds causes children to be rescaled
		setBothLocations(parentDiagramX, parentDiagramY, new_x, new_y);
	}

	public void relocateChildren() 
	{
		Enumeration		en;
		int				width, height;
		EntityInstance	e;
		
		width  = getWidth();
		height = getHeight();

		if (isOpen()) {
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				if (e.m_xrelLocal < 0 || e.m_yrelLocal < 0) {
					assignLocations();
					break;
			}	}

			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.relocate(m_diagramX, m_diagramY, width, height);
	}	}	}

	// This is an external entry point

	public void setBothBounds(int parentDiagramX, int parentDiagramY, int x, int y, int width, int height) 
	{
		setSize(width, height);
		setBothLocations(parentDiagramX, parentDiagramY, x, y);
	}

	public Rectangle getDiagramBounds() 
	{
		return new Rectangle(getDiagramX(), getDiagramY(), getWidth(), getHeight());
	}

	protected void scale(double wf, double hf, boolean doContainer, boolean doPos)
	{
		// Scale ourselves 

//		System.out.println("EntityInstance.scale(" + wf + "," + hf + "," + doContainer + "," + doPos + ")");

		if (doContainer) {
			double x1, y1, w1, h1; 

			x1 = xRelLocal();		
			y1 = yRelLocal();
			w1 = widthRelLocal()  * wf;
			h1 = heightRelLocal() * hf;

			if (doPos) {
				x1 *= wf;
				y1 *= hf;
			}
			updateRelLocal(x1, y1, w1, h1);
		} else {
			Enumeration en;
			for (en = getChildren(); en.hasMoreElements(); ) {
				EntityInstance e = (EntityInstance) en.nextElement();
				e.scale(wf, hf, true, true);
		}	}
	}

	public void scale(double sf, boolean doContainer, boolean doPos) 
	{
		scale(sf, sf, doContainer, doPos);
	}

	public void scale(double sf, boolean doContainer) 
	{
		scale(sf, sf, doContainer, false);
	}

	public void scale(double sf) 
	{
		scale(sf, sf, true, false);
	}

	public void scaleX(double sf, boolean doContainer, boolean doPos) 
	{
		scale(sf, 1.0, doContainer, doPos);
	}

	public void scaleX(double sf, boolean doContainer) 
	{
		scale(sf, 1.0, doContainer, false);
	}

	public void scaleX(double sf) 
	{
		scale(sf, 1.0, true, false);
	}

	public void scaleY(double sf, boolean doContainer, boolean doPos) 
	{
		scale(1.0, sf, doContainer, doPos);
	}

	public void scaleY(double sf, boolean doContainer) 
	{
		scale(1.0, sf, doContainer, false); 
	}

	public void scaleY(double sf) 
	{
		scale(1.0, sf, true, false);
	}

	// Attempt to fit children to us  

	private void doFitScale(double dx, double dy, double wf, double hf) 
	{
		updateRelLocal(xRelLocal() * wf + dx, yRelLocal() * hf - dy, dx + widthRelLocal() * wf, dy + heightRelLocal() * hf);	
	}

	// Determine the bounding box of all children

	public void deltaFont(int delta) 
	{
		updateFontDelta(m_fontDelta + delta);
	}

	public Dimension getLabelDim(Graphics g, int type, boolean wParent) 
	{
		setFont(g, type);

		FontMetrics fm = g.getFontMetrics();

		int h = fm.getHeight();
		int w = fm.stringWidth(getEntityLabel());

		if (wParent) {
			EntityInstance pe = getEnterableParent();

			if (pe != null) {
				w = Math.max(fm.stringWidth(pe.getEntityLabel() + " | "), w);
				h += h/2;
		}	} 
		return new Dimension(w, h);
	}

	public Dimension getLabelDim(Graphics g, int type) 
	{
		return getLabelDim(g, type, false);
	}

	public int getMinFitWidth(Graphics graphics)
	{
		Dimension	ld       = getLabelDim(graphics, EntityInstance.REG_FONT);
		int			minWidth = ld.width + EntityComponent.MARGIN*2;

		if (hasChildren()) {
			minWidth += EntityComponent.CONTENTS_FLAG_X_RESERVE;
		}
		return minWidth;
	}

	public boolean hasChildren() 
	{
		Diagram				diagram       = getDiagram();
		RelationClass		containsClass = diagram.getContainsClass();
		Vector				srcRelList    = m_srcRelList;
		int					size          = srcRelList.size();
		RelationInstance	ri;

		for (int i = 0; i < size; ++i) {
			ri = (RelationInstance) srcRelList.elementAt(i);
			if (ri.getRelationClass() == containsClass) {
				return true;
		}	}
		return false;
	}
			
	public int numChildren() 
	{
		Diagram				diagram       = getDiagram();
		RelationClass		containsClass = diagram.getContainsClass();
		Vector				srcRelList    = m_srcRelList;
		int					size          = srcRelList.size();
		RelationInstance	ri;
		int					ret = 0;

		for (int i = 0; i < size; ++i) {
			ri = (RelationInstance) srcRelList.elementAt(i);
			if (ri.getRelationClass() == containsClass) {
				++ret;
		}	}
		return ret;	
	}

	public EntityInstance getFirstChild() 
	{
		Diagram				diagram       = getDiagram();
		RelationClass		containsClass = diagram.getContainsClass();
		Vector				srcRelList    = m_srcRelList;
		int					size          = srcRelList.size();
		RelationInstance	ri;

		for (int i = 0; i < size; ++i) {
			ri = (RelationInstance) srcRelList.elementAt(i);
			if (ri.getRelationClass() == containsClass) {
				return ri.getDst();
		}	}
		return null;	
	}

	public Enumeration getChildren() 
	{
		return new EntityChildren(this, m_srcRelList);
	}

	public Dimension getFitDim(Graphics g, int type, boolean wParent) 
	{
		Dimension dim = getLabelDim(g, type, wParent);

		if (hasChildren() && !isOpen()) {
			dim.width += CONTENTS_FLAG_DIM;
		}
		dim.width  += MARGIN*3;
		dim.height += (MARGIN*3)/2;

		return dim;
	}

	public Dimension getFitDim(Graphics g, int type) 
	{
		return getFitDim(g, type, false);
	}

	// Edges

	public void invalidateAllEdges() 
	{ 
		Enumeration		 en;
		RelationInstance ri;

//		System.out.println("EntityInstance.drawAllEdges " + this);
		
		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.invalidateEdge();
		}	

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.invalidateEdge();
	}	}	

	public void drawAllEdges(EntityInstance under) 
	{ 
		Enumeration		 en;
		EntityInstance	 src;
		RelationInstance ri;

//		System.out.println("EntityInstance.drawAllEdges " + this);
		
		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.draw(true);	// allow elision from source
		}	

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.m_drawSrc;
			if (!under.hasDescendant(src)) {
				ri.draw(true);	// allow elision to destination
		}	}	

//		System.out.println("EntityInstance.drawAllEdges " + this + " done");
	}

	public void drawHighlightedEdges() 
	{ 
		Enumeration		 en;
		RelationInstance ri;

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.drawHighlighted();  
		}	

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.drawHighlighted(); 
		}	
	}

	public void getHighlightedEdges(Vector v) 
	{ 
		Enumeration en;
		RelationInstance ri;
		EntityInstance root, src, e;


		for (en = m_srcRelList.elements(); en.hasMoreElements();) {
			ri = (RelationInstance) en.nextElement();
			if (ri.getHighlightFlag() && ri.getRelationClass().isActive()) {
				v.addElement(ri);
			}
		}

		root = getDrawRoot();
		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.getSrc();

			if (!root.hasDescendant(src) && ri.getHighlightFlag() && ri.getRelationClass().isActive()) {
				v.addElement(ri);
			}
		}

		// Call method on each child

		for (en = getChildren(); en.hasMoreElements();) {
			e = (EntityInstance) en.nextElement();
			e.getHighlightedEdges(v);
		}
	}


	// TA raw info routines

	public void getInstancesRaw(Vector v, Hashtable st) 
	{
		Enumeration en;
		EntityInstance child;

		// Not $ROOT 
		Integer[] pair = new Integer[2];
		pair[0] = (Integer) st.get(getId());
		pair[1] = (Integer) st.get(getParentClass().getId());
		v.addElement(pair);
		for (en = getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			child.getInstancesRaw(v, st);
		}
	}

	// TA file output routines 

	public void writeInstances(PrintStream ps) throws IOException 
	{
		// Write an instance line for ourself, and then all our children

		ps.print(Diagram.INSTANCE_ID + " " + qt(getId()) + " " + qt(getParentClass().getId()) + "\n");

		Enumeration en;

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.writeInstances(ps);
		}
	}

	public void writeRelations(PrintStream ps) throws IOException {

		// Write out the relations on us, and then all our children
		// By writing out relations to us, we also include edges from m_rootInstance

		Enumeration		 en; 
		RelationInstance ri;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.writeRelation(ps); 
		}				

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.writeRelations(ps);
		}
	}

	protected void writeElision(PrintStream ps, Vector ev, String id) 
	{
		if (ev != null && ev.size() > 0) {
			ps.print(Attribute.indent + id + " = (");
			for (Enumeration en = ev.elements(); en.hasMoreElements(); ) {
				String rcId = (String) en.nextElement(); 
				ps.print(rcId);
				if (en.hasMoreElements()) {
					ps.print(" ");
			}	}
			ps.print(")\n"); 
		}
	}

	protected void writePoints(PrintStream ps, EdgePoint[] pts, String name) 
	{
		if (pts == null) {
			return;
		}

		boolean isDefault = true;

		for (int i = 1; i < pts.length; ++i) {
			if (pts[i] != null) {
				isDefault = isDefault && pts[i].isDefault;
		}	}

		if (isDefault) {
			return;
		}

		ps.print("	" + name + " = ( ");

		for (int i = 1; i < pts.length; ++i) {
			if (pts[i] != null && !pts[i].isDefault) {
				ps.print("(" + pts[i].getRc().getId() + " " + pts[i].m_wf + " " + pts[i].m_hf + ") ");
			}
		}
		ps.print(")\n");
	}

	protected void regRawElision(Vector v, Hashtable st, Vector ev, String id) 
	{
		if (ev != null && ev.size() > 0) {
			int len = ev.size();
			String[] sl = new String[len];

			for (int i=0; i<len; ++i) {
				sl[i] = (String) ev.elementAt(i);
			}
			regRawAttribute(v, st, id, sl);
		}
	}

	public void	writeOptionsAttributes(PrintStream ps) throws IOException
	{  
		LandscapeClassObject parentClass = getParentClass();
		Enumeration			 en;

		// Write out attribute record for us, and then our children

		ps.print(qt(getId()) + " {\n");

		String label = getLabel();

		if (label == null) {
			label = getEntityLabel();
		}

		if (label != null) {
			ps.print(Attribute.indent + LABEL_ID + " = " + qt(label) + "\n");
		}

		String description = getDescription();

		if (description != null) {
			ps.print(Attribute.indent + DESC_ID + " = " + AttributeValueItem.qt(description) + "\n");
		}

		// Finally output the second-class attributes 

		super.writeAttributes(ps, parentClass, false); 

		// End the record 

		ps.print("}\n"); 
	}

	public void	writeAttributes(PrintStream ps, int cIndex) throws IOException
	{  
		LandscapeClassObject parentClass = getParentClass();
		Enumeration			 en;
		double				 value;
		EntityPosition		 position;
		int					 i, last;

		// Write out attribute record for us, and then our children

		ps.print(qt(getId()) + " {\n");

		// Write out Rectangle attributes

		if (m_positions == null) {
			last = -1;
		} else {
			for (last = m_positions.length; --last >= 0;) {
				if (last == cIndex) {
					if (m_xrelLocal >= 0 || m_yrelLocal >=0 || m_widthrelLocal >= 0 || m_heightrelLocal >= 0) {
						break;
					} 
				} else {
					position = m_positions[last];
					if (position != null) {
						if (position.m_xrelLocal >= 0 || position.m_yrelLocal >= 0 || position.m_widthrelLocal >=0 || position.m_heightrelLocal >= 0) {
							break;
		}	}	}	}	}

		if (last < 0) {
			value = m_xrelLocal;		// Use the actual values
			if (value >= 0 && value <= 1.0) {
				ps.print(Attribute.indent + "xrel      = " + value + "\n");
			}
			value = m_yrelLocal;		// Use the actual values
			if (value >= 0 && value <= 1.0) {
				ps.print(Attribute.indent + "yrel      = " + value + "\n");
			}
			value = m_widthrelLocal;
			if (value >= 0 && value <= 1.0) {
				ps.print(Attribute.indent + "widthrel  = " + value + "\n"); 
			}
			value = m_heightrelLocal;
			if (value >= 0 && value <= 1.0) {
				ps.print(Attribute.indent + "heightrel = " + value + "\n");
			}

		} else {
			ps.print(Attribute.indent + "xrel      = (");
			for (i = 0; i <= last; ++i) {
				if (i != 0) {
					ps.print(" ");
				}
				if (i == cIndex) {
					value = m_xrelLocal;
				} else {
					position = m_positions[i];
					if (position == null) {
						value = -1.0;
					} else {
						value = position.m_xrelLocal;
				}	}
				ps.print(value);
			}
			ps.print(")\n");
		
			ps.print(Attribute.indent + "yrel      = (");
			for (i = 0; i <= last; ++i) {
				if (i != 0) {
					ps.print(" ");
				}
				if (i == cIndex) {
					value = m_yrelLocal;
				} else {
					position = m_positions[i];
					if (position == null) {
						value = -1.0;
					} else {
						value = position.m_yrelLocal;
				}	}
				ps.print(value);
			}
			ps.print(")\n");

			ps.print(Attribute.indent + "widthrel  = ("); 
			for (i = 0; i <= last; ++i) {
				if (i != 0) {
					ps.print(" ");
				}
				if (i == cIndex) {
					value = m_widthrelLocal;
				} else {
					position = m_positions[i];
					if (position == null) {
						value = -1.0;
					} else {
						value = position.m_widthrelLocal;
				}	}
				ps.print(value);
			}
			ps.print(")\n");

			ps.print(Attribute.indent + "heightrel = (");
			for (i = 0; i <= last; ++i) {
				if (i != 0) {
					ps.print(" ");
				}
				if (i == cIndex) {
					value = m_heightrelLocal;
				} else {
					position = m_positions[i];
					if (position == null) {
						value = -1.0;
					} else {
						value = position.m_heightrelLocal;
				}	}
				ps.print(value);
			}
			ps.print(")\n");
		}

		String label = getLabel();

		if (label != null) {
			ps.print(Attribute.indent + LABEL_ID + " = " + qt(label) + "\n");
		}

		int style = getStyle();

		if (style != -1) {
			if (parentClass == null || parentClass.getStyle() != style) {
				ps.print(Attribute.indent + STYLE_ID + " = " + style + "\n");
		}	}

		String description = getDescription();

		if (description != null) {
			if (isRoot() || !parentClass.defaultValue(DESC_ID, description)) {
				ps.print(Attribute.indent + DESC_ID + " = " + AttributeValueItem.qt(description) + "\n");
		}	}

		// First order attributes not associated with $ROOT 
		writeElision(ps, m_dstElision,      IN_ELISION_ID);
		writeElision(ps, m_srcElision,      OUT_ELISION_ID);
		writeElision(ps, m_enteringElision, CLIENT_ELISION_ID);
		writeElision(ps, m_exitingElision,  SUPPLIER_ELISION_ID);
		writeElision(ps, m_internalElision, INTERNAL_ELISION_ID);

		writePoints(ps, topPoints,    INPOINT_ID);
		writePoints(ps, bottomPoints, OUTPOINT_ID);
		writePoints(ps, leftPoints,   LEFTPOINT_ID);
		writePoints(ps, rightPoints,  RIGHTPOINT_ID);

		if (m_fontDelta != 0) {
			ps.print(Attribute.indent + FONTDELTA_ID + " = ");
			ps.print(m_fontDelta + "\n");
		}

		// Finally output the second-class attributes 

		super.writeAttributes(ps, parentClass, false); 

		// End the record 

		ps.print("}\n"); 

		// Write any attributes of src relations

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			RelationInstance ri = (RelationInstance) en.nextElement();
			ri.writeAttributes(ps);
		}

		// Recurse for contained children

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.writeAttributes(ps, cIndex);
		}
	}

	public void setOpen() 
	{
		if (!isMarked(OPEN_MARK)) {
			nandMark(CLOSED_MARK);
			orMark(OPEN_MARK);
	}	}

	public void setClosed()
	{
		if (!isMarked(CLOSED_MARK)) {
			nandMark(OPEN_MARK);
			orMark(CLOSED_MARK);
	}	}

	public void openStatusUnknown()
	{
		nandMark(OPEN_MARK|CLOSED_MARK);
	}

	public boolean isOpen() 
	{
		// If haven't yet decided if open or closed
		// We will treat zero sized objects as being closed so that we don't have to repaint edges to zero
		// sized objects which is very expensive if have huge tree and everything open

		if (!isMarked(OPEN_MARK|CLOSED_MARK)) {
			if (!hasChildren() || getWidth() <= 0 || getHeight() <= 0) {
				setClosed();
			} else {
				Diagram diagram    = getDiagram();
				String	containsId = diagram.getContainsId();
			
				if (!isDstRelationElided(containsId)) {
					setOpen();
				} else {
					setClosed();
		}	}	}

		return(isMarked(OPEN_MARK));
	}

	public boolean red_closed()
	{
		return(isMarked(REDBOX_MARK) && !isOpen());
	}

	public boolean red_open()
	{
		return(isMarked(REDBOX_MARK) && isOpen());
	}

	public boolean close_with_children_under_drawroot()
	{
		return(!isOpen() && hasChildren() && !isMarked(EntityInstance.CLIENT_SUPPLIER));
	}

	public void deleteAllEdges()
	{
		RelationInstance ri;
		int				 i;

		for (i = m_srcRelList.size(); i > 0;) {
			ri = (RelationInstance) m_srcRelList.elementAt(--i);
			ri.deleteEdge();
		}
		for (i = m_dstRelList.size(); i > 0;) {
			ri = (RelationInstance) m_dstRelList.elementAt(--i);
			ri.deleteEdge();
	}	}

	public RelationInstance getContainedByRelation(RelationClass containsClass) 
	{ 
		Enumeration			en;
		RelationInstance	ri;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() == containsClass) {
				return ri;
		}	}
		return null;
	}	

	public EntityInstance getContainedBy(RelationClass containsClass) 
	{ 
		Enumeration			en;
		RelationInstance	ri;

		ri = getContainedByRelation(containsClass);
		if (ri != null) {
			return ri.getSrc();
		}
		return null;
	}	

	public EntityInstance getContainedBy() 
	{ 
		Diagram				diagram       = getDiagram();
		RelationClass		containsClass = diagram.getContainsClass();

		return getContainedBy(containsClass);
	}	

	// Used by the undo paste operation

	public void setContainedBy(EntityInstance container) 
	{ 
		Diagram				diagram       = getDiagram();
		RelationClass		containsClass = diagram.getContainsClass();
		Enumeration			en;
		RelationInstance	ri;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() == containsClass) {
				if (ri.getSrc() == container) {
					return;
				}
				ri.deleteEdge();
		}	}
		if (container != null) {
			diagram.addEdge(container, this, containsClass);
	}	}	

	public EntityInstance getEnterableParent() 
	{
		EntityInstance e;
		
		for (e = getContainedBy(); e != null; e = e.getContainedBy()) {
			if (e.isEnterable()) {
				break;
		}	}
		return e;
	}

	public EntityClass getEntityClass() 
	{
		return (EntityClass) getParentClass();
	}

	public boolean isRoot() 
	{
		return (getContainedBy() == null);
	}

	public int cntNodesInSubtree(String containsClass)
	{
		int				ret, ret1;
		Enumeration		en;
		EntityInstance	e;

		if (isMarked(IN_TREE_MARK)) {
			Diagram				diagram = getDiagram();
			LandscapeEditorCore	ls      = diagram.getLs();
			JFrame				frame   = ls.getFrame();

			JOptionPane.showMessageDialog(frame, containsClass + " has multiple in edges to " + this, "Unable to build visualisation tree", JOptionPane.ERROR_MESSAGE | JOptionPane.OK_OPTION);
			return -1;
		}
		ret = 1;
		orMark(IN_TREE_MARK);
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			ret1 = e.cntNodesInSubtree(containsClass);
			if (ret1 < 0) {
				return ret1;
			}
			ret += ret1;
		}
		return ret;
	}

	public void clearTreeMark()
	{
		if (isMarked(IN_TREE_MARK)) {
			Enumeration		en;
			EntityInstance	e;

			nandMark(IN_TREE_MARK);
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.clearTreeMark();
	}	}	}

	public String toString() 
	{
		return getEntityLabel();
	}

	// Rectangle is global, adjust it to coords local to parent

	public void updateDiagramBounds(int diagramX, int diagramY, int width, int height) 
	{
		EntityInstance	parent;
		double			width1, height1;
		double			xRel, yRel, widthRel, heightRel;

		m_diagramX = diagramX;
		m_diagramY = diagramY;

		// Not sure what to do if parent not in diagram or null
		parent     = getContainedBy();
		width1     = parent.getWidth();
		height1    = parent.getHeight();
		if (width1 <= 0.0) {
			xRel     = 0;
			widthRel = 0;
		} else {
			xRel     = (diagramX - parent.m_diagramX)/width1;
			widthRel = width/width1;
		}

		if (height1 <= 0.0) {
			yRel      = 0;
			heightRel = 0;
		} else {
			yRel      = (diagramY - parent.m_diagramY)/height1;
			heightRel = height/height1;
		}
		updateRelLocal(xRel, yRel, widthRel, heightRel);
/*
		if (getEntityLabel().equals("code")) {
//			System.out.println("EntityInstance.updateDiagramBounds [" + diagramX + "," + diagramY + "," + width + "," + height + "]");
			m_debug_x = (int) (diagramX-getParentDiagramX());
			m_debug_y = (int) (diagramY-getParentDiagramY());
			m_debug_width  = width;
			m_debug_height = height;
		}
 */	
		
//		System.out.println("EntityInstance.updateDiagramBounds " + label + " xrel=" + m_xrelLocal + " yrel=" + m_yrelLocal + " widthrel=" + m_widthrelLocal + " heightrel=" + m_heightrelLocal );
		setSize(width, height);
		setLocation((int) (diagramX-getParentDiagramX()), (int) (diagramY-getParentDiagramY()));

		validateAllMyEdges();
		moveCardinals();
	} 

	public void updateDiagramBounds(Rectangle lyt) 
	{
		updateDiagramBounds(lyt.x, lyt.y, lyt.width, lyt.height);
	} 

	public Rectangle getChildBoundingBox() 
	{
		Enumeration en;
		EntityInstance e;

		// Calc the global bounding box of children

		if (!hasChildren()) {
			return null;
		}

		int x1 = Integer.MAX_VALUE;
		int x2 = Integer.MIN_VALUE;
		int y1 = Integer.MAX_VALUE;
		int y2 = Integer.MIN_VALUE;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if (e.getX() < x1) {
				x1 = e.getX();
			}
			if (e.getY() < y1) {
				y1 = e.getY();
			}
			if (e.getX() + e.getWidth() > x2) {
				x2 = e.getX() + e.getWidth();
			}
			if (e.getY() + e.getHeight() > y2) {
				y2 = e.getY() + e.getHeight();
		}	}
		return new Rectangle(x1, y1, x2-x1, y2-y1);
	}

	public Color getBackgroundWhenOpen() {

		Color c;

		// Container is handled specially
		// Find colour from depth

		c = getColorWhenOpen();
		if (c == null) {

			float v = Diagram.BG - 0.05f;

			EntityInstance b = this;

			if (isTransparent()) {
				b = b.getContainedBy();
			}

			EntityInstance root = getDrawRoot();

			if (!root.hasDescendant(this)) {
				root = root.commonAncestor(this);
			}


			for (; b != root; b = b.getContainedBy()) {
				v -= 0.05f;
			}

			c = ColorCache.get(v, v, v);

			if (Util.isBlack(c)) {
				c = Color.lightGray;
		}	}
		return c;
	}
			

	public Color getCurrentObjectColor() 
	{
		Color c;

		if (isOpen()) {
			c = getBackgroundWhenOpen();
		} else {
			c = getObjectColor();
		}
		return c;
	}

	public boolean isRelationElided(Vector v, String id) 
	{
		return (v != null && v.contains(id));
	}

	protected boolean toggleElision(Vector v, String id) 
	{
		if (isRelationElided(v, id)) {
			if (!v.removeElement(id)) {
				MsgOut.println("remove() failed");
			}
			return false; 
		} 

		v.addElement(id); 
		return true; 
	}

	public boolean toggleDstElision(String id) 
	{
		MsgOut.dprintln("toggle target " + id);
		return toggleElision(neededDstElision(), id);
	}

	public void toggleContainElision(String containsId) 
	{
		toggleDstElision(containsId);
		openStatusUnknown();
	}

	public boolean setContainElision(String containsId) 
	{
		if (!isDstRelationElided(containsId)) {
			toggleContainElision(containsId);
			openStatusUnknown();
			return true;
		}
		return false;
	}

	public void clearContainElision(String containsId) 
	{
		if (m_dstElision != null) {
			m_dstElision.removeElement(containsId);
	}	}

	public boolean toggleDstElision(RelationClass rc) 
	{
		return toggleDstElision(rc.getId());
	}

	public boolean toggleSrcElision(String id) 
	{
		MsgOut.dprintln("toggle out " + id);
		return toggleElision(neededSrcElision(), id);
	}

	public boolean toggleSrcElision(RelationClass rc)
	{
		return toggleSrcElision(rc.getId());
	}

	public boolean toggleEnteringElision(String id) 
	{
		MsgOut.dprintln("toggle client " + id);
		return toggleElision(neededEnteringElision(), id);
	}

	public boolean toggleEnteringElision(RelationClass rc) 
	{
		return toggleEnteringElision(rc.getId());
	}

	public boolean toggleExitingElision(String id) 
	{
		MsgOut.dprintln("toggle exiting " + id);
		return toggleElision(neededExitingElision(), id);
	}

	public boolean toggleExitingElision(RelationClass rc) 
	{
		return toggleExitingElision(rc.getId());
	}

	public boolean toggleInternalElision(String id) 
	{
		MsgOut.dprintln("toggle internal " + id);
		return toggleElision(neededInternalElision(), id);
	}

	public boolean toggleInternalElision(RelationClass rc) 
	{
		return toggleInternalElision(rc.getId());
	}

	// Queries 

	public boolean isDstRelationElided(RelationClass rc) 
	{
		return isRelationElided( m_dstElision, rc.getId() );
	}

	public boolean isDstRelationElided(String id) 
	{
		return isRelationElided(m_dstElision, id);
	}

	public boolean isSrcRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_srcElision, rc.getId());
	}

	public boolean isSrcRelationElided(String id) 
	{
		return isRelationElided(m_srcElision, id);
	}

	public boolean isEnteringRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_enteringElision, rc.getId());
	}

	public boolean isEnteringRelationElided(String id) 
	{
		return isRelationElided(m_enteringElision, id);
	}

	public boolean isExitingRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_exitingElision, rc.getId());
	}

	public boolean isExitingRelationElided(String id) 
	{
		return isRelationElided(m_exitingElision, id);
	}

	public boolean isInternalRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_internalElision, rc.getId());
	}

	public boolean isInternalRelationElided(String id) 
	{
		return isRelationElided(m_internalElision, id);
	}

	public int getPostorder()
	{
		return (m_postorder);
	}

	public boolean hasAncestor(EntityInstance e) 
	{
		return(e.m_preorder < m_preorder && m_postorder <= e.m_postorder);
	}


	// Returns true if e is a descendant of me

	public boolean hasDescendant(EntityInstance e) 
	{
		return(m_preorder < e.m_preorder && e.m_postorder <= m_postorder);
	}

	public boolean hasDescendantOrSelf(EntityInstance e) 
	{
		return(m_preorder <= e.m_preorder && e.m_postorder <= m_postorder);
	}

	/* Use when can't be certain that e is necessarily in the diagram 
	 * For example e was cut a long time ago and perhaps it has now been put back but then again perhaps it has not
	 */

	public boolean reallyHasDescendantOrSelf(EntityInstance e)
	{
		Enumeration en;
		EntityInstance e1;

		if (e == this) {
			return true;
		}
		for (en = getChildren(); en.hasMoreElements(); ) {
			e1 = (EntityInstance) en.nextElement();
			if (e1.hasDescendantOrSelf(e)) {
				return e1.reallyHasDescendantOrSelf(e);
		}	}
		return false;
	}

	public boolean isPathBetween(EntityInstance e)
	{
		return((m_preorder <= e.m_preorder && e.m_postorder <= m_postorder) || (e.m_preorder <= m_preorder && m_postorder <= e.m_postorder));
	}

	// Return the common ancestor entity

	public EntityInstance commonAncestor(EntityInstance e) 
	{
		EntityInstance e1;

		for (e1 = getContainedBy(); e1 != null; e1 = e1.getContainedBy()) {
			if (e1.hasDescendant(e)) {
				break;
		}	}
		return(e1);
	}

	// Finds that entity being displayed either as a client or a server
	// to which arrows to my entity should be addressed

	public EntityInstance clientServer() 
	{
		EntityInstance e1;

		for (e1 = this; e1 != null; e1 = e1.getContainedBy()) {
			if (e1.isMarked(CLIENT_MARK | SUPPLIER_MARK)) {
				break;
		}	}
		return(e1);
	}

	public boolean inDiagram()
	{
		return(isMarked(IN_DIAGRAM));
	}

	public EntityInstance getVisibleEntity() 
	{
		EntityInstance e;

		for (e = this; e != null; e = e.getContainedBy()) {
			if (inDiagram()) {
				break;
		}	}
		return e;
	}

	// Return reference to entity the cursor is over. 
	// Return null if none.

	public EntityInstance getMouseOver(int x, int y) 
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null && entityComponent.contains(x,y)) {
			if (isOpen()) {
				Enumeration en;
				EntityInstance e, over;

				for (en = getChildren(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();
					over = e.getMouseOver(x, y);
					if (over != null)
						return over; 
			}	}
			// It's not over any of our children, so it's over us.
			return this; 
		}
		return null;
	}

	public EntityInstance intersects(Rectangle lyt) 
	{
		if (containsRectangle(lyt)) {
			if (hasChildren()) {
				// Check children
				Enumeration en;

				for (en = getChildren(); en.hasMoreElements(); ) {
					EntityInstance e = (EntityInstance) en.nextElement();
					EntityInstance oe = e.intersects(lyt); 
					if (oe != null) {
						return oe; 
				}	}
				return null; 
			}
			return this;  // over us 
		} else if (intersectsLayout(lyt)) { 
			return this;
		}
		return null; 
	}

	public EntityInstance containing(Rectangle lyt) 
	{
		if (containsRectangle(lyt)) {
			if (hasChildren() && isOpen()) {
				// Check children
				Enumeration en;

				for (en = getChildren(); en.hasMoreElements(); ) {
					EntityInstance e = (EntityInstance) en.nextElement();
					EntityInstance oe = e.containing(lyt);
					if (oe != null) {
						return oe;
				}	}
			}
			return this;
		}
		return null;
	}

	public Enumeration srcRelationElements() 
	{
		return m_srcRelList.elements(); 
	}

	public Enumeration dstRelationElements() 
	{
		return m_dstRelList.elements(); 
	}

	public Enumeration srcLiftedRelationElements() 
	{
		return m_srcLiftedList.elements(); 
	}

	public Enumeration dstLiftedRelationElements() 
	{
		return m_dstLiftedList.elements(); 
	}

	protected void addSrcRels(Vector v) 
	{
		Enumeration en;
		EntityInstance e;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			v.addElement(en.nextElement());
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.addSrcRels(v);
		}
	}

	public Enumeration srcRelationAbstractedElements()
	{
		// Return enumeration for all edges which
		// have this entity as the source (real and abstracted).

		Vector v = new Vector();
		addSrcRels(v);
		return v.elements();
	}

	protected void addDstRels(Vector v) 
	{
		Enumeration en;
		EntityInstance e;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			v.addElement(en.nextElement());
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.addDstRels(v);
		}
	}

	public Enumeration dstRelationAbstractedElements() 
	{
		// Return enumeration for all edges which
		// have this entity as the destination (real and abstracted).

		Vector v = new Vector();
		addDstRels(v);
		return v.elements();
	}

	public Vector groupRegion(Rectangle lyt) 
	{
		// This entity isn't in the group, but any children which
		// intersect the passed region are.

		if (!hasChildren()) {
			return null;
		}
		Vector grp = new Vector();
		Enumeration en;
		EntityInstance e;
		
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			if (e.intersectsLayout(lyt)) {
				e.setGroupFlag(); 
				grp.addElement(e);
			}
		}

		if (grp.isEmpty()) {
			return null;
		}
		return grp;
	}

	public void getGroup(Vector grp) 
	{
		Enumeration en;
		EntityInstance e;
		
		if (getGroupFlag()) {
			grp.addElement(this);
		}

		for (en = getChildren(); en.hasMoreElements();) {
			e = (EntityInstance) en.nextElement(); 
			e.getGroup(grp);
	}	}

	protected void setGroupFlag() 
	{
		if (!isMarked(GROUP_MARK)) {
			orMark(GROUP_MARK);
			repaint(); 
	}	}

	protected void clearGroupFlag() 
	{
		if (isMarked(GROUP_MARK|GROUPKEY_MARK)) {
			nandMark(GROUP_MARK|GROUPKEY_MARK);
			repaint();
	}	}		

	public boolean getGroupFlag() 
	{
		return isMarked(GROUP_MARK);
	}

	protected void setGroupKeyFlag() 
	{
		if (!isMarked(GROUPKEY_MARK)) {
			orMark(GROUPKEY_MARK);
			repaint();
	}	}

	protected void clearGroupKeyFlag() 
	{
		if (isMarked(GROUPKEY_MARK)) {
			nandMark(GROUPKEY_MARK);
			repaint();
	}	}

	public boolean getGroupKeyFlag() 
	{
		return isMarked(GROUPKEY_MARK);
	}

	public void getRedBoxGroup(Vector grp) 
	{
		Enumeration		en;
		EntityInstance	e;

		if (isMarked(REDBOX_MARK)) {
			grp.addElement(this);
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			e.getRedBoxGroup(grp);
	}	}

	public void setRedBoxFlag() 
	{
		if (!isMarked(REDBOX_MARK)) {
			orMark(REDBOX_MARK);
			repaint();
	}	}

	public void clearRedBoxFlag() 
	{
		if (isMarked(REDBOX_MARK)) {
			nandMark(REDBOX_MARK);
			repaint();
	}	}

	public void clearAllFlags() 
	{
		Enumeration en;
		RelationInstance ri;
		EntityInstance e;

		clearGroupFlag();
		clearGroupKeyFlag();
		clearRedBoxFlag();
		openStatusUnknown();

		for (en = m_srcRelList.elements(); en.hasMoreElements();) {
			ri = (RelationInstance) en.nextElement();
			ri.clearHighlightFlag();
			ri.clearGroupFlag();
		}
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			e.clearAllFlags();
		}
	}

	// Remove redbox and highlight flags at and under me

	public void clearQueryFlags() 
	{
		Enumeration en;
		RelationInstance ri;
		EntityInstance e;

		clearRedBoxFlag();

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.clearHighlightFlag();
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e    = (EntityInstance) en.nextElement(); 
			e.clearQueryFlags();
	}	}

	public void clearGroupFlags() 
	{
		Enumeration en;
		EntityInstance e;

		clearGroupFlag();
		clearGroupKeyFlag();

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			e.clearGroupFlags();
		}
	}

	public boolean isClippedLabel() 
	{
		if (getWidth() < MIN_WIDTH || getHeight() < MIN_HEIGHT) {
			return(true);
		}
		return(false);
	}

	// Internal attributes of different entities

	public boolean isClickable() 
	{
		return true;
	}

	public void orMark(int val) 
	{
/*
		if ((m_mark & REDBOX_MARK) == 0) {
			if ((val & REDBOX_MARK) != 0) {
				System.out.println("EntityInstance.orMark(REDBOX_MARK) " + this);
		}	}
*/
		m_mark |= val;
	}

	public void andMark(int val)
	{
/*
		if ((m_mark & REDBOX_MARK) != 0) {
			if ((val & REDBOX_MARK) == 0) {
				System.out.println("EntityInstance.andMark(~REDBOX_MARK) " + this);
		}	}
*/	
		m_mark &= (val | PERMANENT_MARKS);
	}

	public void nandMark(int val) 
	{
/*
		if ((m_mark & REDBOX_MARK) != 0) {
			if ((val & REDBOX_MARK) != 0) {
				System.out.println("EntityInstance.nandMark(REDBOX_MARK) " + this);
		}	}	
*/
		m_mark &= (~val | PERMANENT_MARKS);
	}
	
	public boolean isMarked(int val)
	{
		return((m_mark & val) != 0);
	}

	public int getMark()
	{
		return m_mark;
	}

	public boolean isClient()
	{
		return(isMarked(CLIENT_MARK));
	}

	public boolean isSupplier()
	{
		return(isMarked(SUPPLIER_MARK));
	}

	public boolean isClientOrSupplier()
	{
		return(isMarked(CLIENT_MARK|SUPPLIER_MARK));
	}

	public void markDeleted()
	{
		m_mark |= DELETED_MARK;
	}

	public void clearDeleted()
	{
		m_mark &= ~DELETED_MARK;
	}

	public void clearAllDeleted()
	{
		Enumeration		en;
		EntityInstance	e;

		clearDeleted();

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.clearAllDeleted();
	}	}

	public double parentsWidthLocal()
	{
		EntityInstance parent;

		parent = getContainedBy();
		if (parent == null) {
			return(getDiagram().getWidth());
		} 
		return(parent.parentsWidthLocal() * parent.widthRelLocal());
	}

	public double parentsHeightLocal()
	{
		EntityInstance parent;

		parent = getContainedBy();
		if (parent == null) {
			return(getDiagram().getHeight());
		} 
		return(parent.parentsHeightLocal() * parent.heightRelLocal());
	}

	public double parentsWidth()
	{
		EntityInstance parent;

		parent = getContainedBy();
		if (parent == null) {
			return(getDiagram().getWidth());
		} 
		return(parent.getWidth());
	}

	public double parentsHeight()
	{
		EntityInstance parent;

		parent = getContainedBy();
		if (parent == null) {
			return(getDiagram().getHeight());
		} 
		return(parent.getHeight());
	}

	/* Relative local coordinate system
     *
     * 0 same offset as top/left hand edge of parent
     * 1 same offset as bottom/right hand edge of parent
     */

	public double xRelLocal()  
	{
		return(m_xrelLocal);
	}

	public void setXRelLocal(double xRelLocal) 
	{
		m_xrelLocal = xRelLocal;
	}

	public double yRelLocal() 
	{
		return(m_yrelLocal);
	}

	public void setYRelLocal(double yRelLocal) 
	{
		m_yrelLocal = yRelLocal;
	}

	public double widthRelLocal() 
	{
		return(m_widthrelLocal);
	}

	public void setWidthRelLocal(double widthRelLocal) 
	{
		m_widthrelLocal = widthRelLocal;
	}

	public double heightRelLocal() 
	{
		return(m_heightrelLocal);
	}

	public void setHeightRelLocal(double heightRelLocal) 
	{
/*
		if (getEntityLabel().equals("SupplierSet")) {
			System.out.println("Changing SupplierSet rel height " + m_heightrelLocal + "->" + heightRelLocal);
		}
 */
		m_heightrelLocal = heightRelLocal;
	}

	public void setXRelLocalBounded(double xRelLocal)  
	{
		if (xRelLocal < 0) {
			xRelLocal = 0.0;
		}
		setXRelLocal(xRelLocal);
	}

	public void updatexRelLocal(double value)
	{
		if (value < 0) {
			value = 0;
		} 
		if (value != m_xrelLocal) {
			new UpdateXRelLocal(value);
	}	}

	public void setYRelLocalBounded(double yRelLocal) 
	{
		if (yRelLocal < 0) {
			yRelLocal = 0.0;
		}
		setYRelLocal(yRelLocal);
	}	

	public void updateyRelLocal(double value)
	{
		if (value < 0) {
			value = 0;
		}
		if (value != m_yrelLocal) {
			new UpdateYRelLocal(value);
	}	}

	public void setWidthRelLocalBounded(double widthRelLocal) 
	{
		if (widthRelLocal > 1.0) {
			widthRelLocal = 1.0;
		}
		if ((m_xrelLocal + widthRelLocal) > 1.0) {
			setXRelLocal(1.0 - widthRelLocal);
		}
		setWidthRelLocal(widthRelLocal);
	}

	public void updatewidthRelLocal(double value)
	{
		if (value > 1.0) {
			value = 1.0;
		}
		if ((m_xrelLocal + value) > 1.0) {
			updatexRelLocal(1.0 - value);
		}

		if (value != m_widthrelLocal) {
			new UpdateWidthRelLocal(value);
	}	}

	public void setHeightRelLocalBounded(double heightRelLocal) 
	{
		if (heightRelLocal > 1.0) {
			heightRelLocal = 1.0;
		}
		if (m_yrelLocal + heightRelLocal > 1.0) {
			setYRelLocal(1.0 - heightRelLocal);
		}
		setHeightRelLocal(heightRelLocal);
	}

	public void updateheightRelLocal(double value)
	{
		if (value > 1.0) {
			value = 1.0;
		}
		if (m_yrelLocal + value > 1.0) {
			updateyRelLocal(1.0 - value);
		}
		if (value != m_heightrelLocal) {
			new UpdateHeightRelLocal(value);
	}	}

	public void setRelLocal(double x, double y, double width, double height)
	{
		setXRelLocal(x);
		setYRelLocal(y);
		setWidthRelLocal(width);
		setHeightRelLocal(height);
	}

	// Not currently used

	public void setRelLocalBounded(double x, double y, double width, double height)
	{
		if (x < 0) {
			x = 0;
		} 
		if (y < 0) {
			y = 0;
		}
		if (width > 1.0) {
			width = 1.0;
		}
		if (height > 1.0) {
			height = 1.0;
		}
		if ((x + width) > 1.0) {
			x = 1.0 - width;
		}
		if ((y + height) > 1.0) {
			y = 1.0 - height;
		}
		setRelLocal(x,y,width, height);
	}

	public void updateRelLocal(double x, double y, double width, double height)
	{
		if (x < 0) {
			x = 0;
		} 
		if (y < 0) {
			y = 0;
		}
		if (width > 1.0) {
			width = 1.0;
		}
		if (height > 1.0) {
			height = 1.0;
		}
		if ((x + width) > 1.0) {
			x = 1.0 - width;
		}
		if ((y + height) > 1.0) {
			y = 1.0 - height;
		}
		if (x != m_xrelLocal || y != m_yrelLocal || width != m_widthrelLocal || height != m_heightrelLocal) {
			new UpdateRelLocal(x, y, width, height);
	}	}

	/* Local coordinate system (obsoleted because of numeric underflow)
	 *
	 * 0 - Same as top/left edge of parent
	 * n - As position n while parent at position m.
     */

	/* This is only called if we are using legacy coordinate system..
	 * It is called after loading coordinates
	 * and converts the old local coordinates temporarily stored into relative ones
	 */

	public void computeRelCoordinates(double xParent, double yParent, double widthParent, double heightParent)
	{
		double			xLocal, yLocal, widthLocal, heightLocal;
		Enumeration		en;
		EntityInstance	e;

		xLocal      = m_xrelLocal;
		yLocal      = m_yrelLocal;
		widthLocal  = m_widthrelLocal;
		heightLocal = m_heightrelLocal;

		if (widthParent == 0.0) {
			setXRelLocal(0.0);
			setWidthRelLocal(0.0);
		} else {
			setXRelLocal(xLocal/widthParent);
			setWidthRelLocal(widthLocal/widthParent);
		}
		if (heightParent == 0.0) {
			setYRelLocal(0.0);
			setHeightRelLocal(0.0);
		} else {
			setYRelLocal(yLocal/heightParent);
			setHeightRelLocal(heightLocal/heightParent);
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.computeRelCoordinates(xLocal, yLocal, widthLocal, heightLocal);
		}
//		System.out.println("EntityInstance:computeRelCoordinates(" + xParent + ", " + yParent + ", " + widthParent + ", " + heightParent + ") = {" + m_xrelLocal + ", " + m_yrelLocal + ", " + m_widthrelLocal + ", " + m_heightrelLocal + "}");
	}

	/* Store absolute coordinates as relative ones and later fix up */

	public void setxLocal(double xLocal)  
	{
		getDiagram().m_uses_local_coordinates = true;
		setXRelLocal(xLocal);
	}


	public void setyLocal(double yLocal) 
	{
		getDiagram().m_uses_local_coordinates = true;
		setYRelLocal(yLocal);
	}

	public void setwidthLocal(double widthLocal) 
	{
		getDiagram().m_uses_local_coordinates = true;
		setWidthRelLocal(widthLocal);
	}

	public void setheightLocal(double heightLocal) 
	{
		getDiagram().m_uses_local_coordinates = true;
		setHeightRelLocal(heightLocal);
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes
 
	public int getPrimaryAttributeCount()
	{
		return(13);
	}

	public String getLsAttributeNameAt(int index)
	{
		String	name;

		switch (index) {
		case 0:
			name  = "id";
			break;
		case 1:
			name  = "class";
			break;
		case 2:
			name  = LABEL_ID;
			break;
		case 3:
			name  = TITLE_ID;
			break;
		case 4:
			name  = DESC_ID;
			break;	
		case 5:
			name  = COLOUR_ID;
			break;
		case 6:
			name  = LABEL_COLOUR_ID;
			break;
		case 7:
			name  = OPEN_COLOUR_ID;
			break;
		case 8:
			name  = XRELPOSITION_ID;
			break;
		case 9:
			name  = YRELPOSITION_ID;
			break;
		case 10:
			name  = WIDTHREL_ID;
			break;
		case 11:
			name  = HEIGHTREL_ID;
			break;
		case 12:
			name  = FONTDELTA_ID;
			break;
		default:
			name  = super.getLsAttributeNameAt(index);
		}
		return(name);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Object				 value;

		switch (index) {
		case 0:
			value = getId();
			break;
		case 1:
		{
			LandscapeClassObject parentClass = getParentClass();

			if (parentClass == null) {
				value = null;
			} else {
				value = parentClass.getId();
			}
			break;
		}
		case 2:
			value = getLabel();
			break;
		case 3:
			value = getTitle();
			break;
		case 4:
			value = getDescription();
			break;
		case 5:
			if (hasObjectColor()) {
				value = getObjectColor();
			} else {
				value = null;
			}
			break;
		case 6:
			if (hasLabelColor()) {
				value = getLabelColor();
			} else {
				value = null;
			}
			break;
		case 7:
			if (hasColorWhenOpen()) {
				value = getColorWhenOpen();
			} else {
				value = null;
			}
			break;
		case 8:
			value = new Double(xRelLocal());
			break;
		case 9:
			value = new Double(yRelLocal());
			break;
		case 10:
			value = new Double(widthRelLocal());
			break;
		case 11:
			value = new Double(heightRelLocal());
			break;
		case 12:
			value = new Integer(m_fontDelta);
			break;
		default:
			value = super.getLsAttributeValueAt(index);
		}
		return(value);
	}

	public void setAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case 0:
			setId((String) value);
			break;
		case 1:
		{
			if (value != null) {
				LandscapeClassObject parentClass = getParentClass();
				String newId = (String) value;
				if (parentClass == null || !parentClass.getId().equals(newId)) {
					Enumeration	en;
					EntityClass	ec;

					for (en = getDiagram().enumEntityClasses(); en.hasMoreElements(); ) {
						ec = (EntityClass) en.nextElement();
						if (ec.getId().equals(newId)) {
							updateParentClass(ec);
							break;
			}	}	}	}
			break;
		}
		case 2:
			updateLabel((String) value);
			break;
		case 3:
			updateTitle((String) value);
			break;
		case 4:
			updateDescription((String) value);
			break;
		case 5:
			updateObjectColor((Color) value);
			break;
		case 6:
			updateLabelColor((Color) value);
			break;
		case 7:
			updateColorWhenOpen((Color) value);
			break;
		case 8:
			updatexRelLocal(((Double) value).doubleValue());
			break;
		case 9:
			updateyRelLocal(((Double) value).doubleValue());
			break;
		case 10:
			updatewidthRelLocal(((Double) value).doubleValue());
			break;
		case 11:
			updateheightRelLocal(((Double) value).doubleValue());
			break;
		case 12:
			updateFontDelta(((Integer) value).intValue());
			break;
		default:
			super.setAttributeValueAt(index, value);
	}	}


	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getLsAttributeTypeAt(int index)
	{
		int		ret;
		
		switch (index) {
		case 0:
		case 2:
		case 3:
			ret = Attribute.STRING_TYPE;
			break;
		case 1:
			ret = Attribute.ENTITY_CLASS_TYPE;
			break;
		case 4:
			ret = Attribute.TEXT_TYPE;
			break;
		case 5:
		case 6:
		case 7:
			ret = Attribute.COLOR_OR_NULL_TYPE;
			break;
		case 8:
		case 9:
		case 10:
		case 11:
			ret = Attribute.DOUBLE_TYPE;
			break;
		case 12:
			ret = Attribute.INT_TYPE;
			break;
		default:
			ret = super.getLsAttributeTypeAt(index);
		}
		return(ret);
	}

	public boolean containsDiagramPoint(int x, int y)
	{
		if (x < getDiagramX()) {
			return(false);
		}
		if (x > getDiagramX() + getWidth()) {
			return(false);
		}
		if (y < getDiagramY()) {
			return(false);
		}
		if (y > getDiagramY() + getHeight()) {
			return(false);
		}
		return(true);
	}

	public void dump(int indent)
	{
		Enumeration		en;
		EntityInstance	e;
		int				i;

		for (i = 0; i < indent; ++i) {
			System.out.print(" ");
		}
		System.out.println(this);

		// Handle children

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.dump(indent+2);
		}
	}

	// Postorder - Preorder == number of nodes below me

	public int prepostorder(int value)
	{
		Enumeration		en;
		EntityInstance	e;

		m_preorder = value;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			value = e.prepostorder(value+1);
		}
		m_postorder = value;
		return(value);
	}

	public int	getPreorderNumber()
	{
		return m_preorder;
	}

	public int	nodesInSubtree()
	{
		return m_postorder - m_preorder + 1;
	}

	public void clearAllMarks(int preserve_entity_marks, int preserve_relation_marks) 
	{
		Enumeration			en;
		EntityInstance		e;
		RelationInstance	ri;

		andMark(preserve_entity_marks);
		
//		System.out.println("EntityInstance.clearAllMarks(" + preserve_entity_marks + ", " + preserve_relation_marks + ") " + getEntityLabel() + " srcLifted empty" );
		m_srcLiftedList.removeAllElements();
		m_dstLiftedList.removeAllElements();
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.clearAllMarks(preserve_entity_marks, preserve_relation_marks);
		}

		// Doing all the source points clears all edges since all edges have a source

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.clearMark(preserve_relation_marks);
	}	}

	/* It is cheaper to visit each node outside of the draw root and not above it
	 * and see once if it has anything into the drawing, than to examine the edges
	 * inside the diagram to see where they go
	 *
	 * Adds to the vector set all those top most nodes outside of the draw root but
	 * not above it which have edges into the drawing
	 */

	public void addClients(Vector set, EntityInstance drawRoot, boolean visibleEdges, boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;
		EntityClass			ec;

		if (this != drawRoot) {
			// Don't descend beneath the drawroot
			if (!hasDescendant(drawRoot)) {
				for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
					ri  = (RelationInstance) en.nextElement();
					if (visibleEdges) {
						RelationClass rc = ri.getRelationClass();
						if (!rc.isClassVisible()) {
							continue;
					}	}

					e   = ri.getDst();
					if (drawRoot.hasDescendant(e)) {
						ec = e.getEntityClass();
						if (!ec.isShown()) {
							return;
						}
						if (!liftEdges) {
							do {
								e = e.getContainedBy();
								if (e == drawRoot) {
									orMark(CLIENT_MARK);
									set.addElement(this);
									return;
								}
							} while (e.isOpen());
						} else {
							orMark(CLIENT_MARK);
							set.addElement(this);
							return;
			}	}	}	}	
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.addClients(set, drawRoot, visibleEdges, liftEdges);
	}	}	}

	/* It is cheaper to visit each node outside of the draw root and not above it
	 * and see once if it has anything into the drawing, than to examine the edges
	 * inside the diagram to see where they go
	 *
	 * Adds to the vector set all those top most nodes outside of the draw root but
	 * not above it which have edges from the drawing
	 */

	public void addSuppliers(Vector set, EntityInstance drawRoot, boolean visibleEdges, boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;
		EntityClass			ec;

		if (this != drawRoot) {
			// Don't descend beneath the drawroot
			if (!hasDescendant(drawRoot)) {
				for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
					ri  = (RelationInstance) en.nextElement();
					if (visibleEdges) {
						RelationClass rc = ri.getRelationClass();
						if (!rc.isClassVisible()) {
							continue;
					}	}
					e   = ri.getSrc();
					if (drawRoot.hasDescendant(e)) {
						ec = e.getEntityClass();
						if (!ec.isShown()) {
							return;
						}
						if (!liftEdges) {
							do {
								e = e.getContainedBy();
								if (e == drawRoot) {
									orMark(SUPPLIER_MARK);
									set.addElement(this);
									return;
								}
							} while (e.isOpen());
						} else {
//							System.out.println("EntityInstance.addSuppliers " + this);
							orMark(SUPPLIER_MARK);
							set.addElement(this);
							return;
			}	}	}	}
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.addSuppliers(set, drawRoot, visibleEdges, liftEdges);
	}	}	}

	protected void liftSrc(RelationInstance ri)
	{
		LandscapeClassObject	relationClass = ri.getParentClass();
		Enumeration				en;
		RelationInstance		other;

		if (!ri.isMarked(RelationInstance.PRESENTATION_MARKS)) {
			for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
				other = (RelationInstance) en.nextElement();
				if (ri.m_drawSrc == other.m_drawSrc && ri.m_drawDst == other.m_drawDst && relationClass == other.getParentClass()) {
					return;
		}	}	} 

//		System.out.println("EntityInstance.liftSrc into " + getEntityLabel() + " " + ri);
		m_srcLiftedList.add(ri);	// Add this relation to the vector of relations that have draw source in this entity
	}

	protected void liftDst(RelationInstance ri)
	{
		LandscapeClassObject	relationClass = ri.getParentClass();
		Enumeration				en;
		RelationInstance		other;

		if (!ri.isMarked(RelationInstance.PRESENTATION_MARKS)) {
			for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
				other = (RelationInstance) en.nextElement();
				if (ri.m_drawSrc == other.m_drawSrc && ri.m_drawDst == other.m_drawDst && relationClass == other.getParentClass()) {
					return;
		}	}	} 
//		System.out.println("EntityInstance.liftDst into " + getEntityLabel() + " " + ri);
		m_dstLiftedList.add(ri);	// Add this relation to the vector of relations that have draw destination to this entity
	}

	// Mark any source relation whose destination is under 'under'

	public void orSrcRelationsDstUnder(EntityInstance under)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		dst;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			dst = ri.getDst();
			if (under.hasDescendantOrSelf(dst)) {
				ri.orMark(RelationInstance.ADD_RESULTS_MARK);
	}	}	}

	public void orDstRelationsSrcUnder(EntityInstance under)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.getSrc();
			if (under.hasDescendantOrSelf(src)) {
				ri.orMark(RelationInstance.ADD_RESULTS_MARK);
	}	}	}

	public void orAllContainedSrcRelationsDstUnder(EntityInstance under)
	{
		Enumeration			en;
		EntityInstance		e;

		orSrcRelationsDstUnder(under);
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.orAllContainedSrcRelationsDstUnder(under);
	}	}

	public void addSrcRelations(int value, ResultBox resultBox)
	{
		Enumeration			en;
		RelationInstance	ri;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			if (ri.isMarked(value)) {
				resultBox.addRelation(ri);
				ri.orMark(RelationInstance.HIGHLIGHT_FLAG_MARK);
				ri.nandMark(value);
	}	}	}

	public void addDstRelations(int value, ResultBox resultBox)
	{
		Enumeration			en;
		RelationInstance	ri;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			if (ri.isMarked(value)) {
				resultBox.addRelation(ri);
				ri.orMark(RelationInstance.HIGHLIGHT_FLAG_MARK);
				ri.nandMark(value);
	}	}	}

	public void addSrcDstRelations(int value, ResultBox resultBox)
	{
		Enumeration			en;
		EntityInstance		e;

		addSrcRelations(value, resultBox);
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.addSrcDstRelations(value, resultBox);
	}	}

	/* Compute all the diagram edges before lifting them so that we can later when lifting them detect duplicate draw edges
	   and eliminate them.  That is we will set none null values for ri.m_drawSrc/ri.m_drawDst but not actually add them into
	   the entity vectors yet.
	 */

	public void computeAllDiagramEdges(EntityInstance drawRoot, Vector clients, Vector suppliers, EntityInstance closedEntity, boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src, dst, e;
		EntityClass			ec;

		ec = getEntityClass();
		if (!ec.isShown()) {
			return;
		}

//		System.out.println("EntityInstance.computeAllDiagramEdges for " + this);

		// For every edge that comes to us (something in or beneath entities in the diagram)
		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.m_src;

			if (clients != null || suppliers != null) {
				// N.B. Clients may actually be classified as suppliers if one and the same
				if (!drawRoot.isPathBetween(src)) {
					ri.m_drawSrc = src.clientServer();
			}	}
			// The destination of ri comes to our entity

			if (closedEntity != null) {
				if (!closedEntity.hasDescendant(src)) {
					// Ignore internal loops beneath a closed entity
					ri.m_drawDst = closedEntity;
//					System.out.println("EntityInstance.computeAllDiagramEdges " + ri + " -> closed " + closedEntity + " not " + this);
				}
			} else {
				// The draw destination of ri is its actual destination
//				System.out.println("EntityInstance.computeAllDiagramEdges " + ri + " -> open " + this);
				ri.m_drawDst = this;
			}
//			System.out.println(" -> " + ri);
		}

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			dst = ri.m_dst;

			if (suppliers != null && !drawRoot.isPathBetween(dst)) {
				ri.m_drawDst = dst.clientServer();
			}

			// The source of ri comes from our entity

			if (closedEntity != null) {
				if (!closedEntity.hasDescendant(dst)) {
					// Ignore internal loops beneath a close entity
					ri.m_drawSrc = closedEntity;
				}
			} else {
				// The source destination of ri is its actual destination
				ri.m_drawSrc = this;
			}
//			System.out.println(" <- " + ri);
		}

		if (closedEntity == null) {
			orMark(DIAGRAM_MARK);
//			System.out.println("EntityInstance.computeAllDiagramEdges " + this + " width=" + getWidth() + " height=" + getHeight());
			if (!isOpen()) {
				closedEntity = this;
				if (!liftEdges) {
					return;
			}	}
		} else {
			setSwingObject(null);	// Release this EntityComponent -- its not visible
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.computeAllDiagramEdges(drawRoot, clients, suppliers, closedEntity, liftEdges);
	}	}
	
	public void liftAllDiagramEdges(boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e, src, dst;

//		System.out.println("EntityInstance.liftAllDiagramEdges " + this);

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
//			System.out.println("==>" + ri);
			if (!ri.isMarked(LIFTED_MARK)) {
				ri.orMark(LIFTED_MARK);
				src = ri.m_drawSrc;
				if (src != null) {
					dst = ri.m_drawDst;
					if (dst != null) {
						src.liftSrc(ri);
						dst.liftDst(ri);
//						System.out.println("EntityInstance.liftAllDiagramEdgees <-" + ri);
					}
		}	}	}
		
		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
//			System.out.println("<==" + ri);
			if (!ri.isMarked(LIFTED_MARK)) {
				ri.orMark(LIFTED_MARK);
				src = ri.m_drawSrc;
				if (src != null) {
					dst = ri.m_drawDst;
					if (dst != null) {
						src.liftSrc(ri);
						dst.liftDst(ri);
//						System.out.println("EntityInstance.liftAllDiagramEdgees ->" + ri);
		}	}	}	}
		
		if (!liftEdges && !isOpen()) {
			return;
		}
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.liftAllDiagramEdges(liftEdges);
	}	}

	public void validateEdges()
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.validate();
		}

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.validate();
		}

		if (!isMarked(CLOSED_MARK)) {
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.validateEdges();
	}	}	}

	public boolean intersectsLayout(Rectangle rect)
	{
		// Return true if the intersection of passed layout and 
		// entities layout is non-null

		// It overlaps if any corner of layout is contained in
		// entity, or vice versa.

		Rectangle box = new Rectangle(getX(), getY(), getWidth(), getHeight());
		return box.intersects(rect);
	}

 	public boolean containsRectangle(Rectangle rect) 
	{
		int x = getDiagramX();
		int y = getDiagramY();

		return (x < rect.x && rect.x+rect.width < x+getWidth() && y < rect.y && rect.y+rect.height < y+getHeight()); 
	}

	public int getParentDiagramX()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			DiagramCoordinates above;
			Container          parentComponent = entityComponent.getParent();

			if (parentComponent instanceof EntityComponent) {
				above = (DiagramCoordinates) ((EntityComponent) parentComponent).getEntityInstance();
			} else {
				above = (DiagramCoordinates) parentComponent;
			}
			if (above != null) {
				return(above.getDiagramX());
		}	}
		return(0);
	}

	public int getParentDiagramY()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			DiagramCoordinates above;
			Container          parentComponent = entityComponent.getParent();

			if (parentComponent instanceof EntityComponent) {
				above = (DiagramCoordinates) ((EntityComponent) parentComponent).getEntityInstance();
			} else {
				above = (DiagramCoordinates) parentComponent;
			}
			if (above != null) {
				return(above.getDiagramY());
		}	}
		return(0);
	}

	// Diagram Coordinates
	
	public int getDiagramX()
	{
		return(m_diagramX);
	}

	public int getDiagramY()
	{
		return(m_diagramY);
	}

	/* Compute the average position on the x axis of all drawn edges in/out of me */

	public void computeAvgX() 
	{
		EntityComponent ec = neededComponent();

		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src, dst;
		int					edgeMode;
		double				f, avg;
		double				x = 0.0;
		int					n = 0;

		edgeMode = getDiagram().getEdgeMode();
		if (edgeMode == Do.DIRECT_EDGE_STATE) {
			// For every edge coming out of us consider the destination
			for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				dst = ri.m_drawDst;
				x  += (dst.getDiagramX() + dst.getWidth()/2);
				++n;
			}
			// For every edge coming into us consider the source
			for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				src = ri.m_drawSrc;
				x  += (src.getDiagramX() + src.getWidth()/2);
				++n;
			}
		} else {
			for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				dst = ri.m_drawDst;
				f   = ri.getRelationClass().getIOfactor();
				x  += (dst.getDiagramX() + dst.getWidth()*f);
				++n;
			}
			for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				src = ri.m_drawSrc;
				f   = ri.getRelationClass().getIOfactor();
				x  += (src.getDiagramX() + src.getWidth()*f);
				++n;
		}	}
		if (n > 0) {
			avg = x/((double) n);
		} else {
			avg = -1.0;
		}
		ec.setAvgX(avg);
	}

	public double getAvgX()
	{
		EntityComponent ec = neededComponent();

		return ec.getAvgX();
	}

	public void addUnder(JComponent under)
	{
		EntityComponent entityComponent = neededComponent();

//		System.out.println("EntityInstance:addUnder " + this + " " + isOpen() + " " + numChildren());
		entityComponent.removeAll();
		orMark(DIAGRAM_MARK);

		if (isOpen()) {
			Enumeration		en;
			EntityInstance	e;
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.addUnderEntity(this); // Add all children of open parent to diagram
		}	}
		under.add(entityComponent);		// Add this entity to diagram
		// Adding causes call to validate
	}

	public void addUnderEntity(EntityInstance under)
	{
		EntityClass	ec = getEntityClass();

		if (ec.isShown()) {
			EntityComponent parentComponent = under.neededComponent();
			addUnder(parentComponent);
	}	}
	
	// Reset all cardinals associated with this entity and things it contains

	public void resetDstCardinals(int numRelations) 
	{
		Enumeration en;

		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent != null) {
			entityComponent.resetDstCardinals(numRelations);

			for (en = getChildren(); en.hasMoreElements(); ) {
				EntityInstance e = (EntityInstance) en.nextElement();
				e.resetDstCardinals(numRelations);
	}	}	}

	public void resetSrcCardinals(int numRelations) 
	{
		Enumeration en;

		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent != null) {
			entityComponent.resetSrcCardinals(numRelations);

			for (en = getChildren(); en.hasMoreElements(); ) {
				EntityInstance e = (EntityInstance) en.nextElement();
				e.resetSrcCardinals(numRelations);
	}	}	}

	// Calculate the number of edges into me

	public void calcDstEdgeCardinals(boolean hOnly)
	{
		Enumeration			en;
		RelationInstance	ri;
		RelationClass		rc;
		EntityInstance		src, dst, target;
		EntityInstance		e;
		int					ind;
		Cardinal[]			cardinals;
		Cardinal			cardinal;
		EntityClass			ec;

//		System.out.println("EntityInstance.calcEdgeCardinals for " + this);

		EntityComponent entityComponent = (EntityComponent) getSwingObject();

		if (entityComponent != null) {
			cardinals = entityComponent.getDstCardinals();
			// For every edge that comes to us (something in or beneath entities in the diagram)
			for (en = m_dstLiftedList.elements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
			
				if (!hOnly || ri.getHighlightFlag()) {
					rc  = ri.getRelationClass();

					if (rc.isContainsClass()) {
						continue;
					}
					ind = rc.getNid();

					cardinal = cardinals[ind];
					if (cardinal == null) {
						cardinal            = new Cardinal();
						cardinals[ind] = cardinal;
					}
					cardinal.inc();
				}
			}

			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.calcDstEdgeCardinals(hOnly);
	}	}	}

	// Calculate the number of edges into me

	public void calcSrcEdgeCardinals(boolean hOnly)
	{
		Enumeration			en;
		RelationInstance	ri;
		RelationClass		rc;
		EntityInstance		src, dst, target;
		EntityInstance		e;
		int					ind;
		Cardinal[]			cardinals;
		Cardinal			cardinal;
		EntityClass			ec;

		EntityComponent entityComponent = (EntityComponent) getSwingObject();

//		System.out.println("EntityInstance.calcEdgeCardinals for " + this);

		if (entityComponent != null) {
			cardinals = entityComponent.getSrcCardinals();

			// For every edge that comes to us (something in or beneath entities in the diagram)
			for (en = m_srcLiftedList.elements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
			
				if (!hOnly || ri.getHighlightFlag()) {
					rc  = ri.getRelationClass();
					if (rc.isContainsClass()) {
						continue;
					}
					ind = rc.getNid();

					cardinal = cardinals[ind];
					if (cardinal == null) {
						cardinal       = new SrcCardinal();
						cardinals[ind] = cardinal;
					}
					cardinal.inc();
				}
			}

			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.calcSrcEdgeCardinals(hOnly);
	}	}	}
	
	public void showDstCardinals()
	{
		Enumeration		en;
		EntityInstance	e;
		int				width, height;
		EntityClass		ec;

//		System.out.println("EntityInstance.showCardinals " + this);

		width    = getWidth();
		height   = getHeight();

		if (width > 0 && height > 0) {

			EntityComponent entityComponent = (EntityComponent) getSwingObject();
			if (entityComponent != null) {
				
				Cardinal[]	cardinals;

				cardinals = entityComponent.getDstCardinals();

				if (cardinals != null) {
					ec = getEntityClass();
					if (ec.isShown()) {
						int				cnt;

						Diagram		diagram = getDiagram();
						Cardinal	cardinal;
						int			i, diagramX, diagramY, w1;
						RelationClass rc;
						double		f;

						diagramX = getDiagramX();
						diagramY = getDiagramY();

						for (i = cardinals.length; i > 0; ) {
							cardinal = cardinals[--i];
							if (cardinal != null) {
								cnt      = cardinal.getCnt();
								if (cnt > 0) {
									rc = diagram.numToRelationClass(i);
									f  = rc.getIOfactor();
									cardinal.setBackground(rc.getObjectColor());
									cardinal.setCenterTop(diagramX, diagramY, width, height, f);
									diagram.add(cardinal /* JLayeredPane.PALETTE_LAYER */);		// Add this cardinal to the diagram
				}	}	}	}	}

				for (en = getChildren(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();
					e.showDstCardinals();
	}	}	}	}

	public void showSrcCardinals()
	{
		Enumeration		en;
		EntityInstance	e;
		int				width, height;
		EntityClass		ec;

//		System.out.println("EntityInstance.showSrcCardinals " + this);

		width    = getWidth();
		height   = getHeight();

		if (width > 0 && height > 0) {

			EntityComponent entityComponent = (EntityComponent) getSwingObject();
			if (entityComponent != null) {
				Cardinal[]	cardinals;

				cardinals = entityComponent.getSrcCardinals();
				if (cardinals != null) {
					ec = getEntityClass();
					if (ec.isShown()) {
						int				cnt;

						Diagram		diagram = getDiagram();
						Cardinal	cardinal;
						int			i, diagramX, diagramY, w1;
						RelationClass rc;
						double		f;

						diagramX = getDiagramX();
						diagramY = getDiagramY();

						for (i = cardinals.length; i > 0; ) {
							cardinal = cardinals[--i];
							if (cardinal != null) {
								cnt      = cardinal.getCnt();
								if (cnt > 0) {
									rc = diagram.numToRelationClass(i);
									f  = rc.getIOfactor();
									cardinal.setBackground(rc.getObjectColor());
									cardinal.setCenterTop(diagramX, diagramY, width, height, f);
									diagram.add(cardinal /* JLayeredPane.PALETTE_LAYER */);		// Add this cardinal to the diagram
				}	}	}	}	}

				for (en = getChildren(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();
					e.showSrcCardinals();
	}	}	}	}

	public void moveCardinals()
	{
		Enumeration		en;
		EntityInstance	e;
		int				width, height;

		// Move cardinals in sync with entity

		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		Cardinal[]		cardinals;

		if (entityComponent != null) {
			width  = getWidth();
			height = getHeight();

			if (width > 0 && height > 0) {
				Diagram			diagram = getDiagram();
				int				i, diagramX, diagramY;

				diagramX = getDiagramX();
				diagramY = getDiagramY();

				cardinals = entityComponent.getDstCardinals();
				if (cardinals != null) {	
					Cardinal		cardinal;
					RelationClass	rc;
					double			f;

					for (i = cardinals.length; i > 0; ) {
						cardinal = cardinals[--i];
						if (cardinal != null) {
							rc       = diagram.numToRelationClass(i);
							f        = rc.getIOfactor();
							cardinal.setCenterTop(diagramX, diagramY, width, height, f);
							cardinal.revalidate();
				}	}	}

				cardinals = entityComponent.getSrcCardinals();
				if (cardinals != null) {	
					Cardinal		cardinal;
					RelationClass	rc;
					double			f;

					for (i = cardinals.length; i > 0; ) {
						cardinal = cardinals[--i];
						if (cardinal != null) {
							rc       = diagram.numToRelationClass(i);
							f        = rc.getIOfactor();
							cardinal.setCenterTop(diagramX, diagramY, width, height, f);
							cardinal.revalidate();
				}	}	}
	}	}	}

	public boolean isTransparent() 
	{
		switch (getStyle()) {
		case EntityClass.ENTITY_STYLE_LABELLED_GROUP:
			return true;
		}
		return false;
	}

	public boolean isCloseable() 	
	{
		switch (getStyle()) {
		case EntityClass.ENTITY_STYLE_LABELLED_GROUP:
			return false;
		}
		return true;
	}	

	public boolean isEnterable() 	
	{
		switch (getStyle()) {
		case EntityClass.ENTITY_STYLE_LABELLED_GROUP:
			return false;
		}
		return true;
	}

	// Assuming p1 is in this object and p2 is outside,
	// return the point that is the intersection between this object 
	// and the line segment p1->p2.

	public RealPoint calculateIntercept(RealPoint p1, RealPoint p2) 
	{
		double x = 0.0;
		double y = 0.0;

		double t, b, l, r;	// Top, bottom, left, and right
		double x1, y1, x2, y2;

		t = getY() -1;
		b = getY() + getHeight() + 1;
		l = getX() - 1;
		r = getX() + getWidth() + 1;

		boolean found = true;

		x1 = p1.getX();
		y1 = p1.getY();
		
		if (x1 < l || x1 > r || y1 < t || y1 > b) {
			MsgOut.println("calculateIntercept: p1 is not in box");
			return new RealPoint(x, y);
		}

		x2 = p2.getX();
		y2 = p2.getY();
		
		if (x1 == x2 && y1 == y2) {
			MsgOut.println("calculateIntercept: p1 == p2");
			return new RealPoint(x, y);
		}

		if (r <= x2) {
			x = r;
		} else if (x2 < l) {
			x = l;
		} else {
			found = false;
		}

		if (found) {
			// y = mx + b
			y = y1 + (x - x1) * ( (y2 - y1) / (x2 - x1) );
			found = ( t <= y && y <= b );
		}

		if (!found) {
			found = true;

			if (y2 <= t) {
				y = t;
			} else if (y2 >= b) {
				y = b;
			} else {
				found = false;
			}

			if (found) {
				x = x1 + (y - y1) * ( (x2 - x1) / (y2 - y1) );
				found = (l <= x && x <= r);
			}

		}

		if (!found) {
			MsgOut.println("calculateIntercept failed: " + x1 + " " + y1 + " " + x2 + " " + y2); 
		}
		return new RealPoint(x, y);
	}

	public int overResizeTab(int x1, int y1) 
	{
		int xLeft, xMid, xRight;
		int	yTop,  yMid, yBottom;
		int	pos;

		xLeft  = getDiagramX();

		if (x1 < xLeft) {
			// Outside object
			return RSZ_NONE;
		}
		if (x1 <= xLeft + 6) {
			pos = 0;
		} else {
			xRight = xLeft + getWidth();
			if (x1 > xRight) {
				// Outside object
				return RSZ_NONE;
			}
			if (x1 >= xRight - 6) {
				pos = 2;
			} else {
				xMid   = (xLeft + xRight)  / 2;
				if (x1 < xMid - 3 || x1 > xMid + 3) {
					return RSZ_NONE;
				}
				pos = 1;
		}	}

		yTop = getDiagramY();
		if (y1 < yTop) {
			// Outside object
			return RSZ_NONE;
		}
		if (y1 > yTop + 6) {
			yBottom = (int) (yTop + getHeight());
			if (y1 > yBottom) {
				// Outside object
				return RSZ_NONE;
			}
			if (y1 >= yBottom - 6) {
				pos += 6;
			} else {
				yMid = (yTop  + yBottom) / 2;
				if (y1 < yMid - 3 || y1 > yMid + 3) {
					return RSZ_NONE;
				}
				pos += 3;
		}	}

		switch (pos) {
		case 0:
			return RSZ_NW;
		case 1:
			return RSZ_N;
		case 2:
			return RSZ_NE;
		case 3:
			return RSZ_W;
		case 5:
			return RSZ_E;
		case 6:
			return RSZ_SW;
		case 7:
			return RSZ_S;
		case 8:
			return RSZ_SE;
		}
		return RSZ_NONE;
	}

	public boolean isPointOverIO(EdgePoint pt, int x, int y) 
	{
		int	x1, y1;

		x1 = (int) (pt.getX() + 0.5);	// round
		y1 = (int) (pt.getY() + 0.5);	// round	

		return ((x1 - RelationInstance.NEAR_PIXEL_SIZE/2) < x && x < (x1 + RelationInstance.NEAR_PIXEL_SIZE/2) && (y1 - RelationInstance.NEAR_PIXEL_SIZE/2) < y && y < (y1 + RelationInstance.NEAR_PIXEL_SIZE/2));
	}

	public boolean isHighlight()
	{
		return isMarked(HIGHLIGHT_EDGE_MARK);
	}

	public void drawHighlight() 
	{
		if (!isMarked(HIGHLIGHT_EDGE_MARK)) {
			orMark(HIGHLIGHT_EDGE_MARK);
			repaint();
	}	}

	public void undrawHighlight() 
	{
		if (isMarked(HIGHLIGHT_EDGE_MARK)) {
			nandMark(HIGHLIGHT_EDGE_MARK);
			repaint();
	}	}

	private EdgePoint getPoint(EdgePoint[] pts, RelationClass rc, int side) 
	{
		int		  nid;
		EdgePoint cached;

		nid	   = rc.getNid();
		cached = pts[nid];

		// Cache calculated points

		if (cached == null || cached.getRc() != rc) {

			double f  = rc.getIOfactor();
			double wf = 0.0;
			double hf = 0.0;

			switch(side) {
			case EdgePoint.TOP:
				wf = f;					// Put at entity x + width * f at top
				break;
			case EdgePoint.BOTTOM:
				wf = f;
				hf = 1.0;				// But at bottom
				break;
			case EdgePoint.LEFT:
				hf = f;
				break;
			default:
				wf = 1.0;				// Put at right
				hf = f;
				break;
			}
			if (cached == null) {
				pts[nid] = cached = new EdgePoint(this, rc, wf, hf);
			} else {
				cached.setRc(rc);
			}
			cached.isDefault = true;
			cached.side		 = side;
			cached.rescale();	// Compute actual point given current position of e
		}
/*
		if (side == EdgePoint.TOP && getEntityLabel().equals("code")) {
			System.out.println("EntityInstance.getPoint " + cached);
		}
*/  
		return cached;
	}

	public EdgePoint getPoint(RelationClass rc, int side) 
	{
		EdgePoint[] cache;

		switch(side) {
		case EdgePoint.TOP:
			cache = topPoints;
			if (cache == null) {
				topPoints = cache = new EdgePoint[numRelationClasses()];
			}
			break;
		case EdgePoint.BOTTOM:
			cache = bottomPoints;
			if (cache == null) {
				bottomPoints = cache = new EdgePoint[numRelationClasses()];
			}
			break;
		case EdgePoint.LEFT:
			cache = leftPoints;
			if (cache == null) {
				leftPoints = cache = new EdgePoint[numRelationClasses()];
			}
			break;
		default:
			cache = rightPoints;
			if (cache == null) {
				rightPoints = cache = new EdgePoint[numRelationClasses()];
		}	 }
		return getPoint(cache, rc, side);
	}


	// At what point does the ri relation hit this, given that it goes from the box specified by srcLyt to dstLyt
	// N.B. Most of the time anyway it appears that srcLyt is the srcLyt of this.

	public EdgePoint getOutPoint(RelationInstance ri, int edge_mode, Rectangle srcLyt, Rectangle dstLyt) 
	{
		RelationClass rc = ri.getRelationClass();

		if (edge_mode == Do.TB_EDGE_STATE) {
			// Only allow edges to be from top or bottom
			EntityInstance src = (EntityInstance) ri.getSrc();
			if (this == src || src.hasAncestor(this)) {
				return getPoint(rc, EdgePoint.BOTTOM);
			}
			return getPoint(rc, EdgePoint.TOP);
		}
		if ((dstLyt.y - (srcLyt.y+srcLyt.height)) > SEP_THRESHOLD) {

			// dstLyt strictly below srcLyt
			return getPoint(rc, EdgePoint.BOTTOM);
		}

		if ((srcLyt.y - (dstLyt.y+dstLyt.height)) > SEP_THRESHOLD) {
			// srcLyt strictly below dstLyt
			return getPoint(rc, EdgePoint.TOP);
		}

		if ((dstLyt.x - (srcLyt.x+srcLyt.width)) > SEP_THRESHOLD) {
			return getPoint(rc, EdgePoint.RIGHT);
		}

		if ((srcLyt.x - (dstLyt.x+dstLyt.width)) > SEP_THRESHOLD) {
			return getPoint(rc, EdgePoint.LEFT);
		}

		if (dstLyt.y > (srcLyt.y+srcLyt.height)) {
			return getPoint(rc, EdgePoint.BOTTOM);
		}
		return getPoint(rc, EdgePoint.TOP);
	}

	public EdgePoint getLeftOutPoint(RelationInstance ri) 
	{
		RelationClass rc = ri.getRelationClass();

		return getPoint(rc, EdgePoint.LEFT);
	}

	public EdgePoint getRightOutPoint(RelationInstance ri) 
	{
		RelationClass rc = ri.getRelationClass();

		return getPoint(rc, EdgePoint.RIGHT);
	}

	public EdgePoint getTopOutPoint(RelationInstance ri) 
	{
		RelationClass rc = ri.getRelationClass();

		return getPoint(rc, EdgePoint.TOP);
	}

	public EdgePoint getBottomOutPoint(RelationInstance ri) 
	{
		RelationClass rc = ri.getRelationClass();

		return getPoint(rc, EdgePoint.BOTTOM);
	}

	protected EdgePoint testMouseOverIO(EdgePoint[] pts, int x, int y) 
	{
		if (pts == null) {
			return null;
		}

		for (int i = 0; i < pts.length; i++) {
			EdgePoint pt = pts[i];

			if (pt != null) {
				if (isPointOverIO(pt, x, y)) {
					return pt;
				}
			}
		}
		return null;
	}

	public EdgePoint getMouseOverIO(int x, int y) 
	{
		EdgePoint pt = testMouseOverIO(topPoints, x, y);
		if (pt != null) {
			return pt;
		}

		pt = testMouseOverIO(bottomPoints, x, y);
		if (pt != null) {
			return pt;
		}

		pt = testMouseOverIO(leftPoints, x, y);
		if (pt != null) {
			return pt;
		}
		return testMouseOverIO(rightPoints, x, y);
	}

	// Icon interface (used to paint legends)

	public int getIconWidth()
	{
		return(getWidth());
	}

	public int getIconHeight()
	{
		return(getHeight());
	}

	public void paintIcon(Component c, Graphics g, int x, int y)
	{
		EntityComponent entityComponent = neededComponent();

		entityComponent.paintIcon(c, g, x, y);	
	}

	// MouseListener interface

	public void mouseClicked(MouseEvent e)
	{
	}

	public void mouseEntered(MouseEvent e)
	{
	/*
	 	if (m_label.equals("code")) {
			System.out.println("EntityInstance.mouseEntered code " + getDiagramBounds());
			repaint();
		}
	*/
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
		Diagram	diagram;
		int		x, y;

//		System.out.println("EntityInstance.mousePressed " + this);

		diagram = getDiagram();
		x       = ev.getX();
		y       = ev.getY();

		if (x       <= EntityComponent.CONTENTS_FLAG_X_RESERVE && 
		    y       <= EntityComponent.CONTENTS_FLAG_Y_RESERVE &&
		    x       >= EntityComponent.CONTENTS_FLAG_X &&
			y       >= EntityComponent.CONTENTS_FLAG_Y &&
			m_width  > EntityComponent.CONTENTS_FLAG_X_RESERVE &&
			m_height > EntityComponent.CONTENTS_FLAG_Y_RESERVE &&
			close_with_children_under_drawroot()) {
			LandscapeEditorCore	ls      = diagram.getLs();
			ls.processKey(Do.SHOW_CONTENTS, 0, this);
			return;
		}
		diagram.entityPressed(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}

	public void mouseReleased(MouseEvent ev)
	{
		getDiagram().entityReleased(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}

	// MouseMotionListener interface

	public void mouseDragged(MouseEvent ev)
	{
		getDiagram().entityDragged(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}

	public void mouseMoved(MouseEvent ev)
	{
		Diagram				diagram = getDiagram();

		if (this != m_infoShown) {
			LandscapeEditorCore	ls      = diagram.getLs();
			m_infoShown = this;

			String str = getEntityLabel();
			EntityInstance pe = getEnterableParent();

			if (pe != null) {
				str = pe.getEntityLabel() + " . " + str /* + " " + getDiagramX() + "x" + getDiagramY() + " " + getX() + "X" + getY() */;
			} 
			ls.showInfo(str);

			if (m_currentDescEntity != this && !isOpen() && getEntityClass() != null) {
				String label = getEntityLabel();
				String title = getTitle(); 
				String desc  = getDescription();

				if (desc == null) {
					desc = "The " + label + " " + getClassLabel() + ".";
				}

				String topline = " (" + getClassLabel() + (hasChildren() ? " - " + numChildren() + " items)" : ")" );

				if (title != null) {
					topline = title + topline;
				} else {
					topline = label + topline;
				}
				ls.setRightTextBox(topline, desc);
				m_currentDescEntity = this;
		}	}
		diagram.movedOverThing(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}
}
