package lsedit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Pattern;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;



public class FindBox extends JDialog implements ActionListener, ItemListener
{
	public static final int FIND = 0;
	public static final int CANCEL = 1;

	public static boolean substrings = false;
	public static boolean casesens = true;

	protected JButton findButton, canButton;
	protected JLabel label;
	protected JTextField text;
	protected JCheckBox cb_case;

	protected static String searchStr = "";

	public FindBox(JFrame f, String title)
	{
		super(f, title, true);

		Container	contentPane = getContentPane();
		Font		font, bold;

		font         = FontCache.getDialogFont();
		bold         = font.deriveFont(Font.BOLD);

		// Create a dialog 

		contentPane.setLayout(new BorderLayout());

		setFont(font);

		JLabel l = new JLabel("");

		contentPane.add("West", l);

		l = new JLabel("");

		contentPane.add("East", l);

		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());

		label = new JLabel("Any java.util.regex.Pattern:");
		label.setFont(font);
		p.add("North", label);

		// Create input component and add it to the window

		text = new JTextField(searchStr, 30);
		text.setFont(font);
		p.add("Center", text);
		text.addActionListener(this);

		cb_case = new JCheckBox("Case sensitive");
		cb_case.setFont(bold);
		cb_case.setSelected(casesens);
		p.add("South", cb_case);
		cb_case.addItemListener(this);

		contentPane.add("Center", p);

		p = new JPanel();
		p.setLayout(new FlowLayout());

		findButton = new JButton("Find");
		findButton.setFont(bold);
		p.add(findButton);
		findButton.addActionListener(this);

		canButton = new JButton("Cancel");
		canButton.setFont(bold);
		p.add(canButton);
		canButton.addActionListener(this);

		contentPane.add("South", p);

		// Resize the window to the preferred size of its components

		this.pack();
	}

	public static Pattern Create(JFrame frame, String banner) 
	{
		FindBox mb      = new FindBox(frame, banner);
		Pattern pattern;
		int	flags;

		if (frame != null) {	// ie. not an applet
			mb.setLocation(frame.getX()+200, frame.getY()+300);
		}
		mb.setVisible(true);

		
		if (searchStr == null) {
			pattern = null;
		} else {
			try {
				if (searchStr.equals("*")) {
					searchStr = ".*";
				}
				if (casesens) {
					flags = 0;
				} else {
					flags = Pattern.CASE_INSENSITIVE;
				}
				flags |= Pattern.DOTALL;
				
				pattern = Pattern.compile(searchStr, flags);
			} catch (Exception e) {
				pattern = null;
		}	}
		mb.dispose();
		return(pattern);
	}

	// ActionListener interface

	public void actionPerformed(ActionEvent ev)
	{
		Object	source;

		// Pop down the window when the button is clicked.
		// System.out.println("event: " + ev);

		source = ev.getSource();

		if (source == findButton || source == text) {
			this.setVisible(false);
			this.dispose();
			searchStr = text.getText();
			return;
		}
		searchStr = null;
		if (source == canButton) {
			this.setVisible(false);
			this.dispose();
			return;
		}
	}

	// ItemListener interface

	public void itemStateChanged(ItemEvent ev)
	{
		casesens = cb_case.isSelected();
	}




}

