package lsedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;

/* This handler is responsible for moving things about on the screen
   when dragged.
 */

public class GroupModeHandler extends LandscapeModeHandler
{

	// A small JComponent so that the whole handler doesn't need to be one
	// This object just draws the outline of the thing(s) being moved

	protected class DrawOutline extends JComponent
	{
		public DrawOutline()
		{
			super();
			setForeground(Color.BLACK);
		}

		public void paintComponent(Graphics g)
		{
			Rectangle rect, shift;

			rect  = m_rect;
			shift = m_shift;

			if (rect != null) {
				g.drawRect(rect.x, rect.y, rect.width, rect.height);
			}
			if (shift != null) {

				Enumeration		en;
				EntityInstance	e;
				int				x, y, width, height;
				int				dx, dy;
				Rectangle		grpLayout;

				grpLayout = m_grpLayout;

				dx = shift.x - grpLayout.x;
				dy = shift.y - grpLayout.y; 

				for (en = m_groupList.elements(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement(); 
					g.drawRect(e.getDiagramX()+dx, e.getDiagramY()+dy, e.getWidth(), e.getHeight());
//					System.out.println("GroupModeHandler.DrawOutline dx=" + dx + " dy=" + dy);
	}	}	}	}

	protected static final int NONE				= 0;
	protected static final int GROUPING			= 1;
	protected static final int SINGLE_MOVE		= 2;

	protected DrawOutline		m_drawOutline;				// The outline drawn
	protected Vector			m_groupList = null;			// List of entities
	protected Rectangle			m_grpLayout;
	protected int				m_curX, m_curY;
	protected Rectangle			m_shift = null;

	protected EditModeHandler	m_parent;
	protected int				m_groupMode = NONE;

	protected double			m_dx, m_dy;
	private	  boolean			m_seen_motion;
	private	  Rectangle			m_rect;

	protected void setShift(int x, int y, int width, int height)
	{
		if (m_shift == null) {
			Diagram	diagram = m_ls.getDiagram();

			m_shift        = new Rectangle(x, y, width, height);

			m_drawOutline.setBounds(0, 0, diagram.getWidth(), diagram.getHeight());
			m_drawOutline.setVisible(true);
			diagram.add(m_drawOutline /* JLayeredPane.PALETTE_LAYER */ , 0);
		} else {
			m_shift.setBounds(x, y, width, height);
			m_drawOutline.repaint();
		}
	}

	// Group entities

	protected EntityInstance findOverlap(Rectangle lyt) 
	{
		Diagram	diagram = m_ls.getDiagram();

		double dx = lyt.x - m_grpLayout.x;
		double dy = lyt.y - m_grpLayout.y;

		EntityInstance e = diagram.getKeyEntity();

		Rectangle elyt = e.getDiagramBounds();

		elyt.x += dx;
		elyt.y += dy;

		EntityInstance oe = diagram.intersects(lyt);

		if (oe != null && !m_groupList.contains(oe)) {
			return oe;
		}

		Enumeration en = m_groupList.elements();

		while (en.hasMoreElements()) {
			e = (EntityInstance) en.nextElement();

			elyt = e.getDiagramBounds();

			elyt.x += dx;
			elyt.y += dy;

			oe = diagram.intersects(lyt);

			if (oe != null && !m_groupList.contains(oe)) {
				return oe;
			}
		}
		return null;
	}

	// This can only move things contained within an entity in the drawing

	protected void moveGroup(EntityInstance container, double dx, double dy, Diagram diagram) 
	{
		int	grid = diagram.getGrid();
		EntityInstance e       = (EntityInstance) m_groupList.firstElement();
		boolean changeParent   = (e.getContainedBy() != container);

		int width  = 0;
		int height = 0;

		Enumeration en;

		if (changeParent) {
			int num = container.numChildren();

			if (num == 0) {
				Rectangle plyt = e.getContainedBy().getDiagramBounds();
				Rectangle nplyt = container.getDiagramBounds();

				double xs = ((double) nplyt.width)/((double) plyt.width);
				double ys = ((double) nplyt.height)/((double) plyt.height);

				Rectangle lyt = e.getDiagramBounds();

				width  = (int) (lyt.width  * xs);
				height = (int) (lyt.height * ys);
//				System.out.println("moveGroup width=" + width + " height=" + height + " lyt=" + lyt + " xs=" + xs + " ys=" + ys);
			}
			else {
				for (en = container.getChildren(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();

					Rectangle elyt = e.getDiagramBounds();

					width  += elyt.width;
					height += elyt.height;
				} 
				width  /= num;
				height /= num;
			}
		}

		for (en = m_groupList.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();

			int	x = e.getX();
			int	y = e.getY();
			int x1 = x;
			int y1 = y;
			int width1, height1;


			if (grid <= 1) {
				x1 += dx;
				y1 += dy;
			} else {
				if (dx != 0) {
					x1 += dx;
					x1  = (x1/grid)*grid;
				}
				if (dy != 0) {
					y1 += dy;
					y1  = (y1/grid)*grid;
			}	}
//			System.out.println("GroupModeHandler: Moving " + e + " to " + x1 + "," + y1 + " under " + container + " at " + container.getDiagramX() + ", " + container.getDiagramY());

			if (changeParent) {
				e.moveEntityContainment(container);
				width1  = width;
				height1 = height;
			} else {
				width1  = e.getWidth();
				height1 = e.getHeight();
			}
			e.updateDiagramBounds(container.getDiagramX()+x1, container.getDiagramY()+y1, width1, height1);
//			System.out.println("MoveGroup " + e.m_label + " " + e.getBounds() + e.getParent());
		}

		if (changeParent) {
			diagram.prepostorder();
		}

		for (en = m_groupList.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.validateEdges();
		}
	}

	protected void moveGroup(EntityInstance container, Diagram diagram) 
	{
		double dx = m_shift.x - m_grpLayout.x;
		double dy = m_shift.y - m_grpLayout.y;

//		System.out.println("m_shift    =" + m_shift + "\nm_grpLayout=" + m_grpLayout + " dx=" + dx + " dy=" + dy);
		moveGroup(container, dx, dy, diagram);
	}

	protected void setAsKeyEntity(EntityInstance e) 
	{
		Diagram	diagram = m_ls.getDiagram();

		diagram.setKeyEntity(e);
	}

	protected void selectEntity(EntityInstance e) 
	{
		Diagram		  diagram = m_ls.getDiagram();

		diagram.setPreserveEntityMarks(EntityInstance.GROUP_MARK | EntityInstance.GROUPKEY_MARK);
		diagram.setPreserveRelationMarks(0);

		if (e.getGroupFlag()) {
			// Already a member of a group

			if (e != diagram.getKeyEntity()) {
				setAsKeyEntity(e);
			}
		} else {
			EntityInstance old_ke = diagram.getKeyEntity();

			if (old_ke != null) {
				boolean ret;

				ret = diagram.clearFlags();
				diagram.setKeyEntity(e);
				if (ret) {
					m_ls.repaintDg();
				}
			} else {
				setAsKeyEntity(e);
			}
		}
		m_ls.show_groupList();
	}

	protected void toggleMembership(EntityInstance e) 
	{
		Diagram		  diagram = m_ls.getDiagram();

		if (e.getGroupFlag()) {
			if (e == diagram.getKeyEntity()) {
				Vector grp = diagram.getGroup();

				if (grp.size() == 1) {
					diagram.clearFlags();
					e.repaint();
				} else {
					e.clearGroupFlag();
					grp = diagram.getGroup();

					EntityInstance nke = (EntityInstance) grp.firstElement();

					setAsKeyEntity(nke);
				}
			} else {
				e.clearGroupFlag();
				e.repaint();
			}
		} else {
			Vector grp = diagram.getGroup();

			if (grp != null) {
				// See if this is in same container as others

				EntityInstance fe = (EntityInstance) grp.firstElement();

				if (fe.getContainedBy() != e.getContainedBy()) {
					selectEntity(e);
					return;
				}
			}
			setAsKeyEntity(e);
		}

		m_ls.show_groupList();
	}

	protected boolean groupingStart(MouseEvent ev, int x, int y) 
	{
		m_curX = x;
		m_curY = y;
		cleanup();
		return true;
	}

	protected void groupingMotion(MouseEvent ev, Object thing, int x, int y) 
	{
		if (thing instanceof EntityInstance) {

			EntityInstance e = (EntityInstance) thing;

			int shiftX, shiftY, shiftWidth, shiftHeight;
			int	nx, ny;

			// Constrain it to container

			nx = x;
			ny = y;

			Rectangle lyt = e.getDiagramBounds();

//			System.out.println("GroupModeHandler.groupingMotion {" + x + "," + y + "}" + lyt);

			if (nx < lyt.x+LandscapeEditorCore.GAP) {
				nx = lyt.x+LandscapeEditorCore.GAP;
			} else if (nx > lyt.x+lyt.width-LandscapeEditorCore.GAP) {
				nx = lyt.x+lyt.width-LandscapeEditorCore.GAP;
			}

			if (ny < lyt.y+LandscapeEditorCore.GAP) {
				ny = lyt.y+LandscapeEditorCore.GAP;
			} else if (ny > lyt.y+lyt.height-LandscapeEditorCore.GAP) {
				ny = lyt.y+lyt.height-LandscapeEditorCore.GAP;
			}

			// Calculate new Rectangle rectangle

			if (nx > m_curX) {
				shiftX     = m_curX;
				shiftWidth = nx-m_curX;
			}
			else {
				shiftX     = nx;
				shiftWidth = m_curX-nx;
			}

			if (ny > m_curY) {
				shiftY      = m_curY;
				shiftHeight = y-m_curY;
			} else {
				shiftY      = y;
				shiftHeight = m_curY-y;
			}

			setShift(shiftX, shiftY, shiftWidth, shiftHeight);
			// Draw a box
			m_rect = m_shift;
			m_drawOutline.repaint();
	}	}

	protected void groupingEnd(MouseEvent ev) 
	{
		// Flag all entities intersecting group box as being part of a group

		Diagram	diagram = m_ls.getDiagram();
		Vector	gl		= diagram.setGroupRegion(m_shift);

		if (gl != null) {
			m_ls.show_groupList();
			diagram.setKeyEntity((EntityInstance) gl.firstElement());
			m_rect = null;
		} else {
			m_rect = m_shift;
		}
		m_drawOutline.repaint();
	}

	protected boolean moveGroupStart(MouseEvent ev, int x, int y) 
	{
		Diagram		  diagram = m_ls.getDiagram();
		m_groupList = diagram.getGroup();

		m_seen_motion = false;

		if (m_groupList == null) {
			return false;
		}

		EntityInstance pe = ((EntityInstance) m_groupList.firstElement()).getContainedBy();

		if (pe == null) {
			return false;
		}

		m_grpLayout = diagram.getGroupBoundingBox();
		setShift(m_grpLayout.x, m_grpLayout.y, m_grpLayout.width, m_grpLayout.height);
		m_dx	  = x - m_shift.x;
		m_dy	  = y - m_shift.y;

		if (m_groupList.size() == 1) {
			m_ls.doFeedback("Moving entity: (" + m_shift.x + ", " + m_shift.y + ")");
		}
		else {
			m_ls.doFeedback("Moving group (key): (" + m_shift.x + ", " + m_shift.y + ")");
		}
		return true;
	}

	protected void moveGroupMotion(MouseEvent ev, int x, int y) 
	{
		Diagram			diagram  = m_ls.getDiagram();
		EntityInstance	e        = (EntityInstance) m_groupList.firstElement();
		EntityInstance	pe       = e.getContainedBy();
		EntityInstance  drawRoot = diagram.getDrawRoot();

		// Make sure we don't moved out of the root

		if (!m_seen_motion) {
			m_seen_motion = true;
		}

		int grid      = diagram.getGrid();
		int	nx        = x - (int) m_dx;		// Convert from cursor coordinates to Diagram top left edge of entity coordinates
		int	ny        = y - (int) m_dy;
		int px        = pe.getDiagramX();
		int py        = pe.getDiagramY();


		
		nx -= px;			// Convert to coordinates of e relative to parent
		ny -= py;
		nx  = (nx/grid)*grid;
		ny  = (ny/grid)*grid;
		nx += px;
		ny += py;


		int drawRootX      = drawRoot.getDiagramX();
		int drawRootY      = drawRoot.getDiagramY();
		int drawRootWidth  = drawRoot.getWidth();
		int drawRootHeight = drawRoot.getHeight();
		int	bound;

		bound = drawRootX+LandscapeEditorCore.GAP;
		if (nx < bound) {
			nx = bound;
		}

		bound = drawRootY+LandscapeEditorCore.GAP;
		if (ny < bound) {
			ny = bound;
		}

		bound = drawRootX+drawRootWidth-2*LandscapeEditorCore.GAP-m_shift.width;
		if (nx > bound) {
			nx = bound;
		}
		bound = drawRootY+drawRootHeight-2*LandscapeEditorCore.GAP-m_shift.height;
		if (ny> bound) {
			ny = bound;
		}

		m_shift.x = nx;
		m_shift.y = ny;

		if (m_groupList.size() == 1) {
			m_ls.doFeedback("Moving entity: (" + m_shift.x + ", " + m_shift.y + ")");
		} else {
			m_ls.doFeedback("Moving group (key): (" + m_shift.x + ", " + m_shift.y + ")");
		}
		m_drawOutline.repaint();
	}

	protected void moveGroupEnd(MouseEvent ev) 
	{
		m_ls.clearFeedback();

		if (!m_seen_motion) {
			cleanup();
			return;
		}

		Diagram		   diagram = m_ls.getDiagram();
		EntityInstance ke      = diagram.getKeyEntity();
		
		double dx = m_shift.x - m_grpLayout.x;
		double dy = m_shift.y - m_grpLayout.y;

		Rectangle klyt = ke.getDiagramBounds();

		klyt.x += dx;
		klyt.y += dy;

		EntityInstance container = diagram.containing(klyt);

		if (container == null) {
			m_ls.error("Failed to find container");
			cleanup();
			return;
		}

		boolean changeParent = (container != ke.getContainedBy());
		
		if (m_groupList.contains(container)) {
			container = container.getContainedBy();
		}

		diagram.beginUndoRedo("Group Move");
		moveGroup(container, diagram);

		if (changeParent) {
			m_ls.doFeedback("Group move into: " + container.getEntityLabel());
		}
		diagram.endUndoRedo();
		cleanup();
	}

	//
	// Public methods
	//

	public GroupModeHandler(EditModeHandler parent) 
	{
		super(parent.m_ls);
		m_parent      = parent;
		m_drawOutline = new DrawOutline();
	}

	public void cleanup()
	{
		Diagram	diagram = m_ls.getDiagram();

		m_shift = null;
		m_rect  = null;
		m_drawOutline.setVisible(false);
		diagram.remove(m_drawOutline);
		m_ls.setCursor(Cursor.DEFAULT_CURSOR);
		
		m_groupMode = NONE;
	}

	public Vector getGroupList()
	{
		return(m_groupList);
	}

	public void moveGroup(int key) 
	{
		Diagram diagram = m_ls.getDiagram();
		int		grid    = diagram.getGrid();

		m_groupList = diagram.getGroup();

		if (m_groupList == null)
			return;

		EntityInstance pe = diagram.getKeyEntity().getContainedBy();

		double dx = 0;
		double dy = 0;

		switch(key) {
		case Do.MOVE_GROUP_UP:
			dy = -grid;
			break;

		case Do.MOVE_GROUP_DOWN:
			dy = grid;
			break;

		case Do.MOVE_GROUP_RIGHT:
			dx = grid;
			break;

		case Do.MOVE_GROUP_LEFT:
			dx = -grid;
			break;
		}

		moveGroup(pe, dx, dy, diagram);
	}

	public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) 
	{
		Diagram diagram = m_ls.getDiagram();

//		System.out.println("GroupModeHandler mousedown e=" + e + " x=" + x + " y=" + y);

		if (ev.isShiftDown()) {
			if (ev.isAltDown()) {
				m_groupMode = GROUPING;
				if (groupingStart(ev, x, y)) {
					m_parent.setSubHandler(this);
				}
				return;
			} 
			if (e != diagram.getDrawRoot()) {
				if (ev.isMetaDown()) {
					setAsKeyEntity(e);
				} else {
					toggleMembership(e);
			}	}
		} else { 
			if (e != diagram.getDrawRoot() && !e.isClientOrSupplier()) {
				selectEntity(e);
				m_ls.setCursor(Cursor.MOVE_CURSOR);
				m_groupMode = SINGLE_MOVE;

				if (moveGroupStart(ev, x, y)) {
					m_parent.setSubHandler(this);
				}
				return;
			}

			// Otherwise it is a selection event

			selectEntity(e);
		}
		m_groupMode = NONE;
	}

	public void entityDragged(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("GroupModeHandler.entityDragged()" + ((m_groupMode == GROUPING) ? "GROUPING" : "SINGLE_MOVE") );
		switch(m_groupMode)	{
		case GROUPING:
			groupingMotion(ev, e, x, y);
			break;

		case SINGLE_MOVE:
			moveGroupMotion(ev, x, y);
			break;
		}
	}

	public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) 
	{
		switch(m_groupMode)
		{
		case GROUPING:
			groupingEnd(ev);
			break;

		case SINGLE_MOVE:
			moveGroupEnd(ev);
			break;

		default:
			return;
		}
		m_parent.cleanup();
	}

	public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y)
	{
		ri.setGroupAndHighlightFlag();
		m_parent.cleanup();
	}
}
