package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class LandscapeClassObject extends LandscapeObject3D /* extends LandscapeObject extends JComponent */ {

	protected Vector inherits = new Vector();							// Set of class's this class inherits from

	protected static final String CLASSLABEL_ID = "class_label";
	protected static final String CLASSSTYLE_ID = "class_style";
	protected static final String CLASSDESC_ID	= "class_description";

	private int					m_nid = -1;		// Used to output things in order entered
	private Diagram				m_dg;			// Diagram which contains it

	// -----------------
	// Protected methods
	// -----------------

	// Make passed object an instance of this class. Instances obtain copies
	// of the attributes defined for the class. 

	protected void makeInstanceOfUs(LandscapeObject lo) {

		// We employ a clone on write strategy.
		//
		// We can keep references to the parent classes attributes
		// until such time as an override occurs. At that time, 
		// a clone of the attribute object occurs.
		//
		// Since we have an inheritance among TA relation classes
		// we first add the attributes of the TA superclasses which this 
		// inherits from, since child TA classes can override parent values.

		Enumeration en;
		
		for (en = getParentElements(); en.hasMoreElements(); ) {
			LandscapeClassObject lco = (LandscapeClassObject) en.nextElement();

			if (lco == null) {
				System.out.println("Internal error: Null inheritance");
				break;
			}
			lco.makeInstanceOfUs(lo);
		}

		// And now this class' attributes

		en = getLsAttributesEnum();
		if (en != null) { 
			for (; en.hasMoreElements();) {
				Attribute attr = (Attribute) en.nextElement();
				if (!attr.id.startsWith("class")) {
					lo.addAttribute(attr);
		}	}	}
	}

	protected String addParentClass(LandscapeClassObject lco, String baseId) 
	{
		if (lco == null) {
			return ("Can't inherit from null class");
		}

		if (!inherits.contains(lco)) {
			// We should make sure we're
			// not being asked to inherit from an ancestor of something
			// we already inherit from.
			inherits.addElement(lco);
			return null;
		}

		return ("Already inherits from " + lco.getId());	   
	}

	protected boolean processClassAttributes(Attribute attr) 
	{
		if (attr.avi != null) {

			if (attr.id.equals(CLASSLABEL_ID)) {
				setLabel(attr.avi.value);
				return true;
			}
			if (attr.id.equals(CLASSSTYLE_ID)) {
				setStyle(Util.parseInt(attr.avi.value));
				return true;
			}
			if (attr.id.equals(CLASSDESC_ID)) {
				setDescription(attr.avi.value);
				return true;
			} 
			return false;
		}
		return false;
	}



	// --------------

	// Public methods

	// --------------

	public Diagram getDiagram()
	{
		return m_dg;
	}

	public void setLandscapeObjectDiagram(Diagram dg)
	{
		m_dg = dg;
	}

 	public int getNid() 
	{
		return m_nid;
	}

	public void setNid(int nid) 
	{
		this.m_nid = nid;
	}

	public LandscapeClassObject derivedFrom(int i)
	{
		return((i < inherits.size()) ? (LandscapeClassObject) inherits.elementAt(i) : null);
	}

	// If a new attribute, add it to the attribute database,
	// otherwise merely update the value.

	public void addAttribute(Attribute attr) {

		if (attr.avi != null && attr.id.startsWith("class_")) {
			if (processClassAttributes(attr)) {
				return;
		}	}

		if (processFirstOrder(attr)) {
			return;
		}

		Attribute curAttr = getLsAttribute(attr.id);

		if (curAttr == null) {
			// New attribute
			putLsAttribute(attr);
			attr.m_cloneOnAssign = true;
		} else if (attr.avi != null) {
			// Simply change the value if value present
			curAttr.avi = attr.avi; 
		}
	}

	// Return the attribute with the associated id
	/* This logic is flawed -- it won't find the attribute in the
	 * nearest ancestor -- only the ancestor in the nearest leftmost ancestor
	 * IJD
	 */

	public Attribute getLsAttribute(String id) 
	{
		Attribute attr = (Attribute) super.getLsAttribute(id);

		if (attr != null) {
			return attr;
		}

		Enumeration			 en;
		LandscapeClassObject lco;

		for (en = getParentElements(); en.hasMoreElements(); ) {
			lco = (LandscapeClassObject) en.nextElement();
			attr = lco.getLsAttribute(id);
			if (attr != null) {
				return attr;
		}	}
		return null;
	}

	public void writeAttributes(PrintStream ps) throws IOException {

		super.writeAttributes(ps, null, true);
	
		String label = getLabel();

		if (!getId().equals(label)) {
			ps.print(Attribute.indent + CLASSLABEL_ID + " = " + qt(label) + "\n");
		}
		ps.print(Attribute.indent + CLASSSTYLE_ID + " = " + getStyle() + "\n");

		String description = getDescription();

		if (description != null) {
			ps.print(Attribute.indent + CLASSDESC_ID + " = " + AttributeValueItem.qt(description) + "\n");
		}
	}

	public void setColor(Color c) {

		Attribute attr = getLsAttribute(EntityInstance.COLOUR_ID);

		double r = ((double) c.getRed())/255;
		double g = ((double) c.getGreen())/255;
		double b = ((double) c.getBlue())/255;

		attr.avi.value			 = "" + r;
		attr.avi.next.value		 = "" + g;
		attr.avi.next.next.value = "" + b;
	}



	public boolean inheritsFrom(LandscapeClassObject lco) {
		return inherits.contains(lco);
	}

	public Enumeration getParentElements() {
		return inherits.elements();
	}
}

