package lsedit;

import java.util.Enumeration;
import java.util.Vector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.JLabel;

class MatrixConfigure extends JDialog implements ActionListener {

	class LayoutImage extends JComponent implements MouseListener
	{
		Rectangle[] m_boxs;
		int			m_rows = 2;
		boolean		m_validated;


		public LayoutImage()
		{
			super();

			Dimension	dimension = new Dimension(400,240);
			int			i;

			setLayout(null);
			setPreferredSize(dimension);
			setMinimumSize(dimension);
			setMaximumSize(dimension);
			setSize(dimension);

			m_boxs      = new Rectangle[25];
			m_validated = false;
			addMouseListener(this);
			setVisible(true);
		}
		
		public void validate()
		{
			Rectangle[]	boxs      = m_boxs;
			int			cnt       = boxs.length;
			int			dimension = m_rows;;				
			int			width     = getWidth();
			int			height    = getHeight();

			int			x, y, w, h, gapw, gaph, w1, h1, row, col, i, gaps;
			double		dgaps;
			Rectangle	rectangle;

			x      = (int) (((double) width)  * m_new_border / 2.0);
			y      = (int) (((double) height) * m_new_border / 2.0);
			w      = width  - 2 * x;
			h      = height - 2 * y;

			m_validated = false;

			if (w < 1 || h < 1) {
				return;
			}

			gaps      = dimension - 1;
			dgaps     = (double) gaps;
			gapw      = (int) ((m_new_xgap * ((double) w))/dgaps); // Size of the gaps
			gaph      = (int) ((m_new_ygap * ((double) h))/dgaps);
			w1        = (w - (gapw * gaps)) / dimension;
			h1        = (h - (gaph * gaps)) / dimension;
				
			if (w1 < 1 || h1 < 1) {
				return;
			}

			row = col = 0;
			cnt = dimension * dimension;
			for (i = 0; i < cnt; ++i) {
				rectangle = (Rectangle) boxs[i];
				if (rectangle == null) {
					boxs[i] = rectangle = new Rectangle();
				}
				rectangle.x = x;
				if (col != 0) {
					rectangle.x += col*(w1 + gapw);
				}
				rectangle.y = y;
				if (row != 0) {
					rectangle.y += row*(h1 + gaph);
				}
				rectangle.width  = w1;
				rectangle.height = h1;
				if (++col == dimension) {
					++row;
					col = 0;
			}	}

			m_validated = true;
		}

		
		public void paintComponent(Graphics g)
		{
			int	dimension, w, h, row, col, cnt;
			boolean	triangular = (m_layout instanceof SugiyamaLayout);

			w = getWidth();
			h = getHeight();

			g.setColor(Color.black);
			g.drawRect(0, 0, w-1, h-1);

			if (m_validated) {
				Rectangle[]	boxs = m_boxs;
				Rectangle	rectangle;
				int			i;

				g.setColor(Color.blue);
				dimension = m_rows;
				row = col = 0;
				cnt = dimension * dimension;
				for (i = 0; i < cnt; ++i) {
					if (!triangular || (row >= col)) {
						rectangle = boxs[i];
						g.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height); 
					}
					if (++col == dimension) {
						++row;
						col = 0;
				}	}
				if (dimension == 2) {
					String		s     = "Click to change dimensions";
					FontMetrics fm    = g.getFontMetrics();
					int			width = fm.stringWidth(s);

					g.setColor(Color.black);
					g.drawString(s, (w - width)/2, h/2);
			}	}
		}

		// MouseListener interface

		public void mouseClicked(MouseEvent ev)
		{
		}

		public void mouseEntered(MouseEvent ev)
		{
		}

		public void mouseExited(MouseEvent ev)
		{
		}

		public void mousePressed(MouseEvent ev)
		{
			if (ev.isMetaDown()) {
				--m_rows;
				if (m_rows < 2) {
					m_rows = 5;
				}
			} else {
				++m_rows;
				if (m_rows > 5) {
					m_rows = 2;
			}	}
			validate();
			repaint();
		}

		public void mouseReleased(MouseEvent ev)
		{
		}
	}

	MatrixLayout m_layout;

	protected JTextField		m_border_textField;				
	protected JTextField		m_xgap_textField;				// specify horizontal gap between nodes
	protected JTextField		m_ygap_textField;				// specify vertical   gap between nodes

	protected LayoutImage		m_layoutImage;

	protected double			m_default_border;
	protected double			m_default_xgap;
	protected double			m_default_ygap;

	protected double			m_new_border;
	protected double			m_new_xgap;
	protected double			m_new_ygap;

	protected JLabel			m_message;

	protected JButton			m_ok;
	protected JButton			m_default;
	protected JButton			m_cancel;
	
	protected boolean newBorder()
	{
		String	string;
		double	border;

		string = m_border_textField.getText();
		try {
			border = Double.parseDouble(string);
			if (border < 0 || border > 1.0) {
				m_message.setText("Border must be a fraction between 0 and 1");
				return false;
			}
		} catch (Throwable exception) {
			m_message.setText("Border not a double precision string value");
			return false;
		}
		m_new_border = border;
		return true;
	}

	protected boolean newXGap()
	{
		String	string;
		double	xgap;

		string = m_xgap_textField.getText();
		try {
			xgap = Double.parseDouble(string);
			if (xgap < 0 || xgap > 1.0) {
				m_message.setText("Horizontal gap must be a fraction between 0 and 1");
				return false;
			}
		} catch (Throwable exception) {
			m_message.setText("Horizontal gap not a double precision value");
			return false;
		}
		m_new_xgap = xgap;
		return true;
	}

	protected boolean newYGap()
	{
		String	string;
		double	ygap;

		string = m_ygap_textField.getText();
		try {
			ygap = Double.parseDouble(string);
			if (ygap < 0 || ygap > 1.0) {
				m_message.setText("Vertical gap must be a fraction between 0 and 1");
				return false;
			}
		} catch (Throwable exception) {
			m_message.setText("Vertical gap not a double precision string value");
			return false;
		}
		m_new_ygap = ygap;
		return true;
	}

	public MatrixConfigure(MatrixLayout layout, double defaultBorder, double defaultXGap, double defaultYGap, double border, double xgap, double ygap)
	{
		super(layout.getLs().getFrame(), layout.getName() + " Whitespace", true);

		Container			contentPane;
		Font				font, bold;
		JLabel				label;

		m_layout = layout;
		m_default_border = defaultBorder;
		m_default_xgap   = defaultXGap;
		m_default_ygap   = defaultYGap;

		m_new_border     = border;
		m_new_xgap       = xgap;
		m_new_ygap       = ygap;

		font   = FontCache.getDialogFont();
		bold   = font.deriveFont(Font.BOLD);

		setForeground(ColorCache.get(0,0,0));
		setBackground(ColorCache.get(192,192,192));
		setFont(font);

		JPanel topPanel    = new JPanel();
		JPanel labelPanel  = new JPanel();
		JPanel valuePanel  = new JPanel();

		GridLayout gridLayout;

		topPanel.setLayout( new BorderLayout() );
		gridLayout = new GridLayout(3, 1, 0, 10);
		labelPanel.setLayout(gridLayout);

		gridLayout = new GridLayout(3,1, 0, 10);
		valuePanel.setLayout(gridLayout);

		label = new JLabel("Border fraction of total:", JLabel.RIGHT);
		label.setFont(bold);
		labelPanel.add(label);

		m_border_textField = new JTextField("" + m_new_border, 10);
		m_border_textField.setFont(font);
		m_border_textField.addActionListener(this);

		valuePanel.add(m_border_textField);

		label = new JLabel("Horizontal whitespace fraction of grid:", JLabel.RIGHT);
		label.setFont(bold);
		labelPanel.add(label);

		m_xgap_textField = new JTextField("" + m_new_xgap, 10);
		m_xgap_textField.setFont(font);
		m_xgap_textField.addActionListener(this);
		valuePanel.add(m_xgap_textField);

		label = new JLabel("Vertical whitespace fraction of grid:", JLabel.RIGHT);
		label.setFont(bold);
		labelPanel.add(label);

		m_ygap_textField = new JTextField("" + m_new_ygap, 10);
		m_ygap_textField.setFont(font);
		m_ygap_textField.addActionListener(this);
		valuePanel.add(m_ygap_textField);

		topPanel.add( BorderLayout.WEST,   labelPanel);
		topPanel.add( BorderLayout.EAST,   valuePanel);

		contentPane = getContentPane();
		
		contentPane.add( BorderLayout.NORTH, topPanel );

		JPanel centerPanel = new JPanel();
		centerPanel.setLayout( new BorderLayout() );


		m_layoutImage = new LayoutImage();
		centerPanel.add( BorderLayout.NORTH, m_layoutImage);
		m_layoutImage.validate();

		m_message = new JLabel(" ", JLabel.CENTER);
		m_message.setFont(font);
		m_message.setForeground(Color.RED);
		m_message.setSize(400,50);
		m_message.setPreferredSize(new Dimension(400,50));
		centerPanel.add( BorderLayout.SOUTH, m_message);

		contentPane.add( BorderLayout.CENTER, centerPanel);

		// --------------
		// Use a FlowLayout to center the button and give it margins.

		JPanel bottomPanel = new JPanel();

		bottomPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));

		m_ok = new JButton("Ok");
		m_ok.setFont(bold);
		bottomPanel.add(m_ok);
		m_ok.addActionListener(this);

		m_default = new JButton("Default");
		m_default.setFont(bold);
		bottomPanel.add(m_default);
		m_default.addActionListener(this);

		m_cancel = new JButton("Cancel");
		m_cancel.setFont(bold);
		bottomPanel.add(m_cancel);
		m_cancel.addActionListener(this);

		contentPane.add( BorderLayout.SOUTH, bottomPanel);

		// Resize the window to the preferred size of its components
		pack();
		show();
	}

	// ActionListener interface

	public void actionPerformed(ActionEvent ev)
	{
		Object			source;

		source = ev.getSource();

		if (source == m_default) {
			m_border_textField.setText("" + m_default_border);
			m_xgap_textField.setText("" + m_default_xgap);
			m_ygap_textField.setText("" + m_default_ygap);
			newBorder();
			newXGap();
			newYGap();
			m_layoutImage.validate();
			m_layoutImage.repaint();
			return;
		}

		if (source != m_cancel && source != m_ok) {
			if (!newBorder()) {
				return;
			}
			if (!newXGap()) {
				return;
			}
			if (!newYGap()) {
				return;
			}
			m_layoutImage.validate();
			m_layoutImage.repaint();
			return;
		}

		if (source == m_ok) {
			if (!newBorder()) {
				return;
			}
			if (!newXGap()) {
				return;
			}
			if (!newYGap()) {
				return;
			}

			m_layout.setBorder(m_new_border);
			m_layout.setXGap(m_new_xgap);
			m_layout.setYGap(m_new_ygap);
		}
		setVisible(false);
		return;
	}
}

