package lsedit;

import java.util.Enumeration;
import java.util.Vector;

import java.awt.Cursor;
import java.awt.Graphics;

public class MatrixLayout extends LandscapeLayouter  implements ToolBarEventHandler {

	public final static double BORDER = 0.0333;	// 1/30 of graph all round
	public final static double XGAP   = 0.2;		// Make gap 1/5 of space
	public final static double YGAP   = 0.2;		// Make gap 1/5 of space

	protected static double m_border  = BORDER;
	protected static double m_xgap    = XGAP;
	protected static double m_ygap    = YGAP;

	public MatrixLayout(LandscapeEditorCore ls) 
	{
		super(ls);
	}

	public String getName()
	{
		return "Matrix";
	}

	public String getMenuLabel() 
	{
		return "Layout in a matrix";
	} 

	public static double getBorder()
	{
		return m_border;
	}

	public void setBorder(double value)
	{
		m_border = value;
	}

	public static double getXGap()
	{
		return m_xgap;
	}

	public void setXGap(double value)
	{
		m_xgap = value;
	}

	public static double getYGap()
	{
		return m_ygap;
	}

	public void setYGap(double value)
	{
		m_ygap = value;
	}

	public boolean isConfigurable()
	{
		return true;
	}

	public void configure(LandscapeEditorCore ls)
	{
		MatrixConfigure configure = new MatrixConfigure(this, BORDER, XGAP, YGAP, m_border, m_xgap, m_ygap);

		configure.dispose();
	}

	// The doLayout method executes the Matrix algorithm
	// Assumption: All boxes selected are in the same container.

	public void doLayout1(Vector selectedBoxes, EntityInstance container, boolean update) 
	{
		int				size = selectedBoxes.size();
		int				rows, columns, row, col, i, gaps, actualWidth, minWidth;
		EntityInstance	e, parent, parent1;
		double			xmarginrel, ymarginrel, xrel, yrel, widthrel, heightrel, dval, gapw, gaph, last, parentWidth;
		Graphics		graphics;

		if (m_border < 0 || m_xgap < 0 || m_ygap < 0) {
			m_ls.error("MatrixLayout: some parameters -ve");
			return;
		}

		if ((m_xgap + m_border) >= 1.0) {
			m_ls.error("MatrixLayout: no space to layout horizontally");
			return;
		}

		if ((m_ygap + m_border) >= 1.0) {
			m_ls.error("MatrixLayout: no space to layout vertically");
			return;
		}

		xmarginrel = m_border / 2.0;
		ymarginrel = m_border / 2.0;

		switch (size) {
		case 0:
			return;
		case 1:
			rows      = 1;
			break;
		default:
			rows      = (int) (Math.ceil(Math.sqrt(size)));
		}

		columns = rows;

		parent = null;
		for (i = 0; i < size; ++i) {
			e = (EntityInstance) selectedBoxes.elementAt(i);
			parent1 = e.getContainedBy();
			if (parent1 == null) {
				System.out.println("MatrixLayout: Entity " + e + " has no parent");
			} else if (parent == null) {
				parent = parent1;
			} else if (parent != parent1) {
				System.out.println("MatrixLayout: Entity " + e + " has different parent from other entities being laid out");
		}	}
		if (parent == null) {
			return;
		}

		parentWidth = (double) parent.getWidth();
		graphics    = m_ls.getGraphics();
				 
		for (; ; ) {

			if (rows == 1) {
				gaph      = 0;
				heightrel = 1.0 - m_border;
			} else {
				gaps      = rows - 1;
				dval      = (double) gaps;
				gaph      = m_ygap / dval;		// Size of the gaps	ie -- share gap space equally
				heightrel = (1.0 - m_ygap - m_border) / (dval + 1.0);
			}

			if (columns == 1) {
				gapw      = 0;
				widthrel  = 1.0 - m_border;
				break;
			} 
			gaps      = columns - 1;
			dval      = (double) gaps;
			gapw      = m_xgap / dval;		// Size of the gaps	ie -- share gap space equally
			widthrel  = (1.0 - m_xgap - m_border) / (dval + 1.0);

			if (parentWidth <= 0) {
				// Layout square
				break;
			}

			for (i = 0; i < size; ++i) {
				e = (EntityInstance) selectedBoxes.elementAt(i);
				minWidth    = e.getMinFitWidth(graphics);
				actualWidth = (int) (widthrel * parentWidth);
				if (actualWidth < minWidth) {
					break;
			}	}
			if (i == size) {
				break;
			}
			--columns;
			while (rows * columns < size) {
				++rows;
		}	}

		SortVector.byString(selectedBoxes, true /* ascending */);
			
		last = 0.0;
		row = col = 0;
		for (i = 0; i < size; ++i) {
			e = (EntityInstance) selectedBoxes.elementAt(i);
			xrel = xmarginrel;
			if (col != 0) {
				xrel += ((double) col) * (widthrel + gapw);
			}
			last = xrel;
			yrel = ymarginrel;
			if (row != 0) {
				yrel += ((double) row)*(heightrel + gaph);
			}
			if (update) {
				e.updateRelLocal(xrel, yrel, widthrel, heightrel);
			} else {
				e.setRelLocal(xrel, yrel, widthrel, heightrel);
			}
			if (++col == columns) {
				++row;
				col = 0;
		}	}

//		System.out.println("Matrix done");

	} // doLayout


  // The doLayout method executes the Coffman-Graham Layer Assignment
  // algorithm and the Sugiyama algorithm on the boxes selected.
  // Assumption: All boxes selected are in the same container.

	public String doLayout(Diagram dg) 
	{
		EntityInstance parent;

		// get user's selection of boxes to be laid out

		m_ls.setLayouter(this);
		m_ls.setCursor(Cursor.WAIT_CURSOR);

		Vector selectedBoxes = dg.getGroup();
		if (selectedBoxes == null) {
			  beep();
			  return "No group selected";
		}

		parent = parentOfSet(selectedBoxes);
		if (parent == null) {
			return	"Matrix layouter requires that all things laid out share same parent";
		}
		dg.beginUndoRedo("Matrix layout");
		doLayout1(selectedBoxes, parent, true /* Updating */);
		dg.endUndoRedo();

		m_ls.setCursor(Cursor.DEFAULT_CURSOR);

		return "Graph redrawn using Matrix Layout";
	} // doLayout

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram	dg;
		String	rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			m_ls.doFeedback(rmsg);
			dg.rescaleDiagram();
			m_ls.repaintDg();
	}	}
} 





