package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RelationClass extends LandscapeClassObject /* extends LandscapeObject3D extends LandscapeObject */ {

	protected static final String FACTOR_ID      = "class_iofactor";
	protected static final String HIERARCHY_ID   = "class_hierarchy";
	protected static final String ACTIVE_ID      = "class_active";
	protected static final String VISIBLE_ID     = "class_visible";
	protected static final String ISCONTAINS_ID  = "class_iscontains";

	protected static final String RELATION_BASE_CLASS_ID = "$RELATION";

	protected boolean m_active   = true;	// True if class active in queries
	protected boolean m_visible  = true;	// True if relations of this class should be visible
	protected boolean m_contains = false;	// True if this is the currently active contains class

	protected double  m_iofactor = -1;		// Where the relation should intersect entities as a percentage
	protected int	  m_cIndex   = -1;		// What is the offset of EntityShape[] for entity shape using this relation as contains

	// Permitted relations

	// This is the list of Entity class pairs that can participate in relations of this relation class
	// It can be presumed to be quite small.

	private Vector	m_relationList = new Vector();
		 
	protected int	m_ordinal;

	// --------------
	// Public methods
	// --------------

	public RelationClass(String id, int nid, RelationClass prc, Diagram dg)
	{
		setId(id);						// The string name of this relation class
		setNid(nid);					// The numeric id
		setLabel(id);					// The label of this relation
		setLandscapeObjectDiagram(dg);	// Backreference to diagram

		setStyle(Util.LINE_STYLE_NORMAL);

		addParentClass(prc);			// Parent class
		setObjectColor(Color.black);
	}

	public int getCIndex()
	{
		return m_cIndex;
	}

	public void setCIndex(int value)
	{
		m_cIndex = value;
	}

	public String getStyleName(int style) 
	{
		return Util.getLineStyleName(style);
	}

	public void setContainsClass(boolean contains)
	{
		m_contains = contains;
	}

	// Is this the contains relation

	public boolean isContainsClass() 
	{
		return m_contains;
	}

	protected boolean processClassAttributes(Attribute attr) 
	{
		if (attr.id.equals(HIERARCHY_ID)) {
			m_cIndex = Integer.parseInt(attr.avi.value);
			return true;
		}
		if (attr.id.equals(FACTOR_ID)) {
			m_iofactor = Double.parseDouble(attr.avi.value);
			return true;
		}
		if (attr.id.equals(ACTIVE_ID)) {
			m_active = Util.parseBoolean(attr.avi.value);
			return true;
		}
		if (attr.id.equals(VISIBLE_ID)) {
			m_visible = Util.parseBoolean(attr.avi.value);
			return true;
		}
		if (attr.id.equals(ISCONTAINS_ID)) {
			m_contains = Util.parseBoolean(attr.avi.value);
			return true;
		}
		return super.processClassAttributes(attr);
	}

	// If new, add an edge to the ERD (permitted relation)

	public void addRelation(EntityClass ec1, EntityClass ec2) {

		// Should check to see if relation is already present  
		EntityClassPair p = new EntityClassPair(ec1, ec2);
		if (m_relationList == null) {
			m_relationList = new Vector();
		}
		m_relationList.addElement(p);

	}

	// Return RelationInstance based on our RelationClass

	public RelationInstance newRelation(EntityInstance e1, EntityInstance e2) 
	{
		RelationInstance ri = new RelationInstance(this, e1, e2);
		makeInstanceOfUs(ri);
		return ri;
	}

	public void writeRelations(PrintStream ps) throws IOException 
	{
		Enumeration en;
		EntityClassPair ep;

		for (en = m_relationList.elements(); en.hasMoreElements(); ) {
			ep = (EntityClassPair) en.nextElement();
			ps.print(qt(getId()) + " " + qt(ep.entityClass1.getId()) + " " + qt(ep.entityClass2.getId()) + "\n");
		}
	}

	public void writeAttributes(PrintStream ps) throws IOException 
	{
		if (getNid() >= 2) {
			ps.print("(" + qt(getId()) + ") {\n");

			if (m_cIndex >= 0) {
				ps.print(HIERARCHY_ID + " = " + m_cIndex + " ");
			}
			if (m_iofactor >= 0) {
				ps.print(FACTOR_ID + " = " + m_iofactor + " ");
			}
			if (!m_active) {
				ps.print(ACTIVE_ID + " = false ");
			}
			if (!m_visible) {
				ps.print(VISIBLE_ID + " = false ");
			}
			if (m_contains) {
				ps.print(ISCONTAINS_ID + " = true ");
			}
			super.writeAttributes(ps);
			ps.print("}\n\n");
		}
	}

	// Accessor functions

	public boolean isClassVisible() 
	{
		return m_visible && !m_contains;
	}

	public void setClassVisible(boolean state) 
	{
		m_visible = state; 
	}

	public boolean isActive() 
	{
		return m_active;
	}

	public void setActiveState(boolean state) 
	{
		m_active = state; 
	}

	public String addParentClass(RelationClass inherits) 
	{
		return addParentClass(inherits, RELATION_BASE_CLASS_ID);
	}

	public void setOrdinal(int ord) 
	{
		m_ordinal = ord;
	}

	public double getIOfactor() 
	{
		if (m_iofactor >= 0) {
			return m_iofactor;
		}
		
		Diagram diagram = getDiagram();

		if (diagram.allowElision()) {
			double num = diagram.numVisibleRelationClasses();
			return (m_ordinal+1)/(num+1);
		}
		double num = diagram.numRelationClasses();
		return ((num > 2) ? (getNid()-1)/(num-1) : 0.5);
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes

	public int getPrimaryAttributeCount()
	{
		return(7);
	}

	public String getLsAttributeNameAt(int index)
	{
		String	name;

		switch (index) {
		case 0:
			name  = "id";
			break;
		case 1:
			name  = CLASSLABEL_ID;
			break;
		case 2:
			name  = CLASSDESC_ID;
			break;
		case 3:
			name  = CLASSSTYLE_ID;
			break;	
		case 4:
			name  = COLOUR_ID;
			break;
		case 5:
			name  = LABEL_COLOUR_ID;
			break;
		case 6:
			name  = FACTOR_ID;
			break;
		default:
			name  = super.getLsAttributeNameAt(index);
		}
		return(name);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Object	value;

		switch (index) {
		case 0:
			value = getId();
			break;
		case 1:
			value = getLabel();
			break;
		case 2:
			value = getDescription();
			break;
		case 3:
			value = new Integer(getStyle());
			break;
		case 4:
			value = getObjectColor();
			break;
		case 5:
			value = getLabelColor();
			break;
		case 6:
			value = new Double(m_iofactor);
			break;
		default:
			value = super.getLsAttributeValueAt(index);
		}
		return(value);
	}

	public void setAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case 0:
			setId((String) value);
			break;
		case 1:
			updateLabel((String) value);
			break;
		case 2:
			updateDescription((String) value);
			break;
		case 3:
			updateStyle(((Integer) value).intValue());
			break;
		case 4:
			updateObjectColor((Color) value);
			break;
		case 5:
			updateLabelColor((Color) value);
			break;
		case 6:
			m_iofactor = ((Double) value).doubleValue();
			break;
		default:
			super.setAttributeValueAt(index, value);
	}	}

	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getLsAttributeTypeAt(int index)
	{
		int		ret;
		
		switch (index) {
		case 0:
		case 1:
			ret = Attribute.STRING_TYPE;
			break;
		case 2:
			ret = Attribute.TEXT_TYPE;
			break;
		case 3:
			ret = Attribute.REL_STYLE_TYPE;
			break;
		case 4:
			ret = Attribute.COLOR_OR_NULL_TYPE;
			break;
		case 5:
			ret = Attribute.COLOR_TYPE;
			break;
		case 6:
			ret = Attribute.DOUBLE_TYPE;
			break;
		default:
			ret = super.getLsAttributeTypeAt(index);
		}
		return(ret);
	}
}

