package lsedit;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

// Used by query and legend box

class RelnChkBox extends JComponent
{
	protected static final int GAP    = 5; 
	protected static final int WIDTH  = 45;
	protected static final int HEIGHT = 20;

	protected   JCheckBox			m_checkbox;
	protected	RelationClass		m_rc;
	protected	int					m_index;

	public RelnChkBox(RelationClass rc, int index, boolean value, Font font) 
	{
		FlowLayout	flowLayout;
		Color		color;
		JCheckBox	checkbox;
		Arrow		arrow;
		JLabel		label;
		String		labelText;

		flowLayout = new FlowLayout(FlowLayout.LEFT);
		flowLayout.setHgap(GAP);
		setLayout(new FlowLayout(FlowLayout.LEFT));

		m_rc    = rc;
		m_index = index;

		color       = rc.getObjectColor();

		m_checkbox = checkbox = new JCheckBox();
//		checkbox.setBackground(Color.WHITE);
		checkbox.setBorderPaintedFlat(false);
		if (m_index < 0) {
			checkbox.setSelected(false);
			checkbox.setEnabled(false);
			checkbox.setVisible(false);
		} else {
			checkbox.setSelected(value);
			checkbox.setEnabled(true);
			checkbox.setVisible(true);
		}
		add(checkbox);

		arrow = new Arrow(WIDTH, HEIGHT);
		arrow.setBackground(color);
		add(arrow);

		color       = rc.getLabelColor();
		labelText   = rc.getLabel();
		if (index >= 0) {
			labelText += " (" + index + ")";
		}
		label = new JLabel(labelText);
		label.setForeground(color);
		label.setFont(font);
		add(label);

		setToolTipText(rc.getDescription());
	}

	public void addItemListener(ItemListener listener)
	{
		m_checkbox.addItemListener(listener);
	}

	public boolean isSelected()
	{
		return(m_checkbox.isSelected());
	}

	public void doClick()
	{
		if (m_index >= 0) {
			m_checkbox.doClick();
	}	}

	public int getIndex()
	{
		return(m_index);
	}

	public boolean isContainsClass()
	{
		return m_rc.isContainsClass();
	}
}
