package lsedit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import java.util.zip.ZipInputStream;
import java.util.zip.GZIPInputStream;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class Ta extends JPanel
{
	public final static String INSTANCE_ID				= "$INSTANCE";	
	public final static String INHERIT_RELN				= "$INHERIT";

	public final static String CONTAIN_ID				= "contain"; 

	public final static String EDGEMODE_ID				= "edgemode"; 
	public final static String TOPCLIENTS_ID			= "topclients"; 
	public final static String WANTCLIENTS_ID			= "wantclients"; 
	public final static String WANTSUPPLIERS_ID			= "wantsuppliers"; 
	public final static String WANTCARDINALS_ID			= "wantcardinals"; 
	public final static String SCALE_ID					= "scale";
	public final static String RELN_HIDDEN_ID			= "reln_hidden";
	public final static String NAVLINK_ID				= "navlink";

	public final static int	UPDATE_FREQ = 250; 

	public    final static String ROOT_ID = "$ROOT";
	private   final static String BG_STR = "0.75";			// String value of BG

	// Non-first order attributes of $ROOT

	private final static String g_optionsAttributes[] =
		{ SCALE_ID, 
		  RELN_HIDDEN_ID, 
		  EDGEMODE_ID, 
		  NAVLINK_ID, 
		  TOPCLIENTS_ID,
		  WANTCLIENTS_ID,
		  WANTSUPPLIERS_ID,
		  WANTCARDINALS_ID
		};

	// Values

	protected LandscapeEditorCore	m_ls;
	private   Diagram				m_diagram;					// The actual diagram instance else null

	protected EntityInstance		m_rootInstance;				// The root instance of the diagram
	protected RelationClass			m_containsClass;			// The class that defines containment.
	protected int					m_cIndex;					// The index of the contains class that non-cached position information is for
	
	private   Hashtable m_entityClasses	  = new Hashtable(10);

	// The set of relationClasses
	protected Hashtable m_relationClasses = new Hashtable(5);

	private   Vector	m_numToRel		  = new Vector(10);

	public    RelationClass		m_relationBaseClass; 
	public    EntityClass		m_entityBaseClass;

	protected RelationClass		m_defaultRelationClass = null;
	protected int				m_numRelationClasses = 0;

	protected EntityClass		m_defaultEntityClass = null;
	private   int				m_numEntityClasses = 0; 

	private   boolean			m_universalScheme = false;

	private   Object			m_context;
	private	  String			m_zipEntry;

	/* Must detect use of legacy coordinates and convert after diagram loaded
	 * since attributes may not be in tree order so won't know parent dimensions
	 * necessarily when doing conversion from legacy coordinates to relative ones
	 */

	boolean						m_uses_local_coordinates;

	/* Used in writing raw */

	private boolean				m_schemeSetup = false;
	protected String			m_resString = null;

	protected int				m_progressCount;
	protected boolean			m_changedFlag = false;
	
	protected int				m_numberRelations;
	// -----------------
	// Protected methods
	// -----------------

	// Overloaded by Diagram to return the actual diagram pointer
	protected Diagram getDiagram()
	{
		return(null);
	}

	public boolean getChangedFlag()
	{
		return m_changedFlag;
	}

	public void updateProgress() 
	{
		int cnt = ++m_progressCount;

		StringBuffer sb = new StringBuffer("Loading: ");
		for (int i=0; i<cnt; ++i) {
			sb.append('*');
		}
		m_ls.doFeedback(new String(sb));
	}

	public EntityClass getEntityClass(String id)
	{
		return (EntityClass) m_entityClasses.get(id); 
	}

	// After this method has been called however many times
	// need to fillLegendBox again

	private EntityClass addEntityClass(String id) 
	{
		EntityClass ec = getEntityClass(id); 

		if (ec == null) {
			ec = new EntityClass(id, m_numEntityClasses++, m_entityBaseClass /* parent class */, m_diagram);
			m_entityClasses.put(id, ec);
			if (m_defaultEntityClass == null) {
				m_defaultEntityClass = ec;
			}
		}
		return ec;
	}

	public EntityInstance getRootInstance()
	{
		return m_rootInstance;
	}

	public RelationClass getRelationClass(String id)
	{
		return (RelationClass) m_relationClasses.get(id);
	}

	// After this method has been called however many times
	// need to fillLegendBox again

	private RelationClass addRelationClass(String id) 
	{
		RelationClass rc = getRelationClass(id);		// Lookup in the hash table

		if (rc == null) {
			rc = new RelationClass(id, m_numRelationClasses, m_relationBaseClass, m_diagram);
			m_relationClasses.put(id, rc);
			m_numToRel.addElement(rc);
			m_numRelationClasses++;
			if (m_defaultRelationClass == null)
				m_defaultRelationClass = rc;
		}
		return rc;
	}

	public void addEdge(EntityInstance src, EntityInstance dst, RelationClass rc)
	{
		RelationInstance ri = rc.newRelation(src, dst);

		// Should check to see if relation is already present
		src.addSrcRelation(ri); 
		dst.addDstRelation(ri); 
	}

	private int getMaxCIndex()
	{
		Enumeration		en;
		RelationClass	rc;
		int				cindex, cindex1;

		cindex = -1;
		for (en = enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			cindex1 = rc.getCIndex();
			if (cindex1 > cindex) {
				cindex = cindex1;
		}	}
		return cindex;
	}

	private int getCIndex(RelationClass containsClass)
	{
		int cindex = containsClass.getCIndex();
		
		if (cindex < 0) {
			cindex = getMaxCIndex();
			containsClass.setCIndex(++cindex);
		} 
		return cindex;
	}

	// Setup for universal scheme
	// This is employed if there are no SCHEME TUPLES

	public boolean isUniversalScheme()
	{
		return m_universalScheme;
	}

	private void setupUniversalScheme() 
	{
		m_relationBaseClass.addRelation(m_entityBaseClass, m_entityBaseClass);
		m_universalScheme = true;
	}

	// Section processing methods

	private void 
	processSchemeTuples(LandscapeTokenStream ts) throws IOException 
	{
		RelationClass	rc;
		String			verb, object;
		EntityClass		ec1, ec2;
		String			msg;

		while (ts.nextTriple()) {

			verb    = ts.m_verb;
			object  = ts.m_object;

			ec1     = addEntityClass(object); 
			ec2     = addEntityClass(ts.m_subject);

			if (verb.equals(INHERIT_RELN)) {							// $INHERIT
				if (object.equals(EntityClass.ENTITY_BASE_CLASS_ID)) {	// $ENTITY
					ts.errorNS("Improper use of $ENTITY with $INHERIT");
					return;
				}
				msg = ec1.addParentClass(ec2);
				if (msg != null) {
					ts.errorNS(msg);
				}
			} else { 
				rc = addRelationClass(verb);
				rc.addRelation(ec1, ec2);		// If not already present
			}
		}
	}

	private void processFactTuples(LandscapeTokenStream ts) throws IOException 
	{
		String			verb, object, subject;
		EntityInstance	e;
		int				ne = 0;
		int				nr = 0;

		MsgOut.vprint("\nFACT TUPLE : ");

		while (ts.nextTriple()) {

			verb    = ts.m_verb;
			object  = ts.m_object;
			subject = ts.m_subject;

			if (verb.equals(INSTANCE_ID)) {

				// 
				// $INSTANCE instanceId classId
				//

				ne++;
		
				if ((ne % UPDATE_FREQ) == 0) {
					MsgOut.vprint(".");
					updateProgress();
					m_ls.showInfo("Entities: " + ne);
				}		


				e = EntityCache.get(object);

				if (e == null) {

					// New $INSTANCE

					EntityClass ec = getEntityClass(subject);


					if (ec == null && isUniversalScheme()) {
						ec = m_entityBaseClass;
					}	

					if (ec != null) {
						e = ec.newEntity(object);
						EntityCache.put(e);
					}  else {
						ts.errorNS("EntityClass '" + subject + "' has not been declared");
					}
				} else {

					EntityClass ec = e.getEntityClass();

					if (ec.hasId(subject)) {
						ts.warning("Redeclaration of " + e.toString());
					} else {

						ts.errorNS("Attempt to declare " + e.getId() + " as instanceof " + subject + ". Currently declared as instanceof " + ec.getId());
					}
				}
			} else {

				// Relation tuple definition
				//
				// relationClass entityInstance entityInstance
				//

				nr++;

				if ((nr % UPDATE_FREQ) == 0) {

					MsgOut.vprint(".");
					updateProgress();
					m_ls.showInfo("Relations: " + nr);
				}		

				RelationClass rc  = getRelationClass(verb);
				EntityInstance e1 = EntityCache.get(object);
				EntityInstance e2 = EntityCache.get(subject);

				if (m_universalScheme) {

					// Implicit declaration upon use

					if (rc == null) {
						rc = m_relationBaseClass;
					}

					if (e1 == null) {
						e1 = m_entityBaseClass.newEntity(object);
						EntityCache.put(e1);
					}

					if (e2 == null) {
						e2 = m_entityBaseClass.newEntity(subject);
						EntityCache.put(e2);
					}
				}

				if (rc == null) {
					ts.errorNS("Can't process: " + "(" + verb + " " + object + " " + subject + ") - Missing '" + verb + "'");
				} else if (e1 == null) {
					ts.errorNS("Can't process: " + "(" + verb + " " + object + " " + subject + ") - Missing '" + object + "'");
				} else if (e2 == null) {
					ts.errorNS("Can't process: " + "(" + verb + " " + object + " " + subject + ") - Missing '" + subject + "'");
				} else {
					addEdge(e1, e2, rc);
				}
			}
		}
		m_numberRelations = nr;
	}

	// *** And now for output ***

	private void writeSchemeTuples(PrintStream ps) throws IOException 
	{
		Enumeration en0, en;
		EntityClass	ec, parent;


		ps.print("// Landscape TA file\n\n");
		ps.print("SCHEME TUPLE :\n\n// The ERD\n\n"); 

		for (en0 = enumEntityClassesInOrder(); en0.hasMoreElements(); ) {
			ec = (EntityClass) en0.nextElement();
			if (ec != m_entityBaseClass) {
				for (en = ec.getParentElements(); en.hasMoreElements(); ) {
					parent = (EntityClass) en.nextElement();
					if (parent != m_entityBaseClass) {
						ps.print(INHERIT_RELN + " " + ec.getId() + " " + parent.getId() + "\n");
					}
				}
			}
		}
		ps.print("\n");
		for (en = enumRelationClassesInOrder(); en.hasMoreElements(); ) {	// Output in same order as input
			RelationClass rc = (RelationClass) en.nextElement();
			rc.writeRelations(ps); 
		}
	}

	private void writeSchemeAttributes(PrintStream ps) throws IOException 
	{
		Enumeration en;

		ps.print("\n\nSCHEME ATTRIBUTE :\n\n");
		ps.print("// EntityClass attributes\n\n");
		// Write attributes for entity classes 

		for (en = m_entityClasses.elements(); en.hasMoreElements(); ) {
			EntityClass ec = (EntityClass) en.nextElement(); 
			ec.writeAttributes(ps);
		}

		// Write attributes for relation classes 

		for (en = m_relationClasses.elements(); en.hasMoreElements(); ) {
			RelationClass rc = (RelationClass) en.nextElement();
			rc.writeAttributes(ps);
		}
	}

	private void writeFactAttributes(PrintStream ps) throws IOException
	{
		Enumeration		en;
		EntityInstance	child;

		ps.print("\n\nFACT ATTRIBUTE :\n\n"); 
		m_rootInstance.writeOptionsAttributes(ps); 

		for (en = m_rootInstance.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			child.writeAttributes(ps, m_cIndex);
	}	}

	private void writeFactTuples(PrintStream ps) throws IOException 
	{
		Enumeration		 en; 
		EntityInstance	 e;
		
		ps.print("\n\nFACT TUPLE :\n\n"); 
		ps.print("// Instances of entity classes\n\n");

		for (en = m_rootInstance.getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.writeInstances(ps);
		}

		// Avoid writing m_rootInstance relations

		for (en = m_rootInstance.getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.writeRelations(ps);
		}
	}

	public RelationClass getContainsClass()
	{
		return m_containsClass;
	}

	public String getContainsId()
	{
		return m_containsClass.getLabel();
	}

	public void setContainsClass(RelationClass containsClass)
	{
		Enumeration		en;
		RelationClass	rc;

		for (en = enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			rc.setContainsClass(rc == containsClass);
		}
		m_containsClass = containsClass;
	}

	protected RelationInstance newEdge(EntityInstance from, RelationClass rc, EntityInstance to)
	{
		RelationInstance ri = new RelationInstance(rc, from, to);

		from.addSrcRelation(ri);
		to.addDstRelation(ri);

		return ri;
	}

	public boolean entityExists(String name) 
	{
		return (EntityCache.get(name) != null);
	}

	protected boolean establishRootInstance(RelationClass containsClass)
	{
		RelationClass	oldContainsClass = m_containsClass;

		JFrame			frame = m_ls.getFrame();
		Attribute		attr;
		EntityInstance	root, parent, nextroot;
		int				i, size;
		String			containsLabel;
		Vector			forest;
		boolean			ok;

		setContainsClass(containsClass);
		containsLabel = containsClass.getLabel();

		EntityCache.remove(m_rootInstance);		// Dont want to see this while searching for forests
		nextroot= null;
		ok      = false;
		forest  = new Vector();
		size    = EntityCache.size();
		for (root = EntityCache.someEntity();; root = nextroot) {
			if (root == null) {
				break;
			}
			for (i = 0; i < size; ++i) {
				if (i > size) {
					// Must be a loop can't be a tree
					JOptionPane.showMessageDialog(frame, containsClass.getLabel() + " relation class forms cycle ascending from " + root, "Unable to build visualisation tree", JOptionPane.ERROR_MESSAGE | JOptionPane.OK_OPTION);
					break;
				}
				parent = root.getContainedBy();
				if (parent == null || parent == m_rootInstance) {
					break;
				}
				root = parent;
			}
			if (root == null) {
				break;
			}
			i = root.cntNodesInSubtree(containsLabel);
			if (i < 0) {
				break;
			}
			forest.addElement(root);
			size -= i;

			if (size == 0) {
				ok = true;
				break;
			} 

			for (nextroot = EntityCache.getFirst(); nextroot != null; nextroot = EntityCache.getNext()) {
				if (!nextroot.isMarked(EntityInstance.IN_TREE_MARK)) {
					break;
			}	}
		}
		EntityCache.put(m_rootInstance);	

		if (ok) {
			size = forest.size();

			m_rootInstance.deleteAllEdges();

			for (i = 0; i < size; ++i) {
				root = (EntityInstance) forest.elementAt(i);
				newEdge(m_rootInstance, containsClass, root);
			}	

			// This will assign it a contain index if not having one
			int cindex = getCIndex(containsClass);

			if (cindex != m_cIndex) {
				int	lth    = getMaxCIndex() + 1;
				
				m_rootInstance.exchangePositioning(m_cIndex, cindex, lth);
				m_cIndex = cindex;
			}
			containsClass.setActiveState(false);
		} else {
			setContainsClass(oldContainsClass);
		}
		m_rootInstance.clearTreeMark();

		return ok;
	}

	private void computeRelCoordinates()
	{
		m_rootInstance.computeRelCoordinates(m_rootInstance.xRelLocal(), m_rootInstance.yRelLocal(), m_rootInstance.widthRelLocal(), m_rootInstance.heightRelLocal() );
	}

	public void emptyDiagram() 
	{
		EntityInstance	e;

		m_uses_local_coordinates = false;
		m_schemeSetup = true;
		setupUniversalScheme();

		m_defaultEntityClass   = m_entityBaseClass;
		m_defaultRelationClass = m_relationBaseClass;
		e = m_entityBaseClass.newEntity("BLANK");
		EntityCache.put(e);
		m_rootInstance = e;
	} 

	private void parseStream(InputStream is, String src, URL context) 
	{

		MsgOut.vprintln("Parse TA file: " + src);

		m_uses_local_coordinates = false;
		m_cIndex                 = 0;	// It is the contains that get loaded into the active positioning info

		try {
			BufferedInputStream bis = new BufferedInputStream(is);

			LandscapeTokenStream ts = new LandscapeTokenStream(bis, src);

			for (;;) {
				int sec = ts.nextSection();

				if (sec == LandscapeTokenStream.EOF) {
					MsgOut.vprintln("");
					break;
				}
				try { 
					switch(sec) {

					case LandscapeTokenStream.SCHEME_TUPLE:

						// regSrcInfo(src, sec);

						m_schemeSetup = true;
						m_universalScheme = false;

						processSchemeTuples(ts);
						updateProgress();
						break;



					case LandscapeTokenStream.SCHEME_ATTRIBUTE:

						// regSrcInfo(src, sec);

						if (!m_schemeSetup) {
							m_schemeSetup = true;
							setupUniversalScheme();
						}
						ts.processSchemeAttributes(this);
						updateProgress();
						break;



					case LandscapeTokenStream.FACT_TUPLE:

						// regSrcInfo(src, sec);

						if (!m_schemeSetup) {
							m_schemeSetup = true;
							setupUniversalScheme();
						}

						processFactTuples(ts);
						break;



					case LandscapeTokenStream.FACT_ATTRIBUTE:

						// int srcIndex = regSrcInfo(src, sec);

						ts.processFactAttributes(this);
						break;


					case LandscapeTokenStream.INCLUDE_FILE:

						if (m_context == null) {
							parseFile(ts.getIncludeFile(), null);
						} else {
							parseURL(ts.getIncludeFile(), context);
						}
						MsgOut.vprintln("Back to TA file: " + src);
						break; 
					}

				} catch (IOException e) {
					MsgOut.println("IO error reading landscape"); 
					m_resString = e.toString();
					break; 
				}
			}
			StringCache.clear();
			bis.close(); 
			is.close();

			Attribute		attr;
			Enumeration		en;
			RelationClass	containsClass, rc;
			String			containsLabel;

			containsClass = null;
			for (en = m_relationClasses.elements(); en.hasMoreElements(); ) {
				rc = (RelationClass) en.nextElement();
				if (rc.isContainsClass()) {
					if (containsClass != null) {
						containsClass.setContainsClass(false);
					}
					containsClass = rc;
			}	}	
			if (containsClass == null) {
				containsClass = getRelationClass(CONTAIN_ID);
			}
			if (containsClass  == null) {
				JOptionPane.showMessageDialog(m_ls.getFrame(), 	"No containing relation class defined", "Unable to build visualisation tree", JOptionPane.ERROR_MESSAGE | JOptionPane.OK_OPTION);
				return;
			}

			if (!establishRootInstance(containsClass)) {
				return;
			}

			if (m_uses_local_coordinates) {
				computeRelCoordinates();
			}
		}

		catch (Exception e) {
			m_resString = e.toString();
			System.out.println("Parse error: " + m_resString);
		}

	} // end parseStream() 

	private InputStream decompress(InputStream is, String source, String subfile)
	{
		InputStream ret      = is;
		int			lth      = source.length();

		if (lth > 4) {
			String ends = source.substring(lth - 4);
			if (ends.equalsIgnoreCase(".zip")) {
				ZipInputStream	zipInputStream;
				ZipEntry		zipEntry;

				try {
					zipInputStream = new ZipInputStream(is);
					for (;;) {
						zipEntry = zipInputStream.getNextEntry();
						if (subfile == null || subfile.equalsIgnoreCase(zipEntry.getName())) {
							break;
						}
						zipInputStream.closeEntry();
					}
				} catch (Exception e) {
					System.out.println("Attempt to open " + source + ((subfile == null) ? "" : "#" + subfile) + " as zip file failed");
					m_resString    = e.toString();
					zipInputStream = null;
				}
				return zipInputStream;
			}
			if (ends.equalsIgnoreCase(".jar")) {
				JarInputStream	jarInputStream;
				ZipEntry		zipEntry;

				try {
					jarInputStream = new JarInputStream(is);
					for (;;) {
						zipEntry = jarInputStream.getNextEntry();
						if (subfile == null || subfile.equalsIgnoreCase(zipEntry.getName())) {
							break;
						}
						jarInputStream.closeEntry();
					}
				} catch (Exception e) {
					System.out.println("Attempt to open " + source + ((subfile == null) ? "" : "#" + subfile) + " as jar file failed");
					m_resString    = e.toString();
					jarInputStream = null;
				}
				return jarInputStream;
			}

			if (lth > 5) {
				ends = source.substring(lth - 5);
				if (ends.equalsIgnoreCase(".gzip")) {
					GZIPInputStream	gzipInputStream;

					try {
						gzipInputStream = new GZIPInputStream(is);
					} catch (Exception e) {
						System.out.println("Attempt to open " + source + " as gzip file failed");
						m_resString     = e.toString();
						gzipInputStream = null;
					}
					return gzipInputStream;
		}	}	}
		return is;
	}

	private URL parseURL(String taPath, URL context) 
	{
		int		lth   = taPath.length();
		char	lc	  = taPath.charAt(lth-1);
		String	entry = null;

		if (lth > 2 &&  lc == ']') {
			int	i = taPath.lastIndexOf('['); 

			if (i > 0 && i < lth - 2) {
				entry  = taPath.substring(i+1, lth-1);
				taPath = taPath.substring(0, i);
				if (m_zipEntry == null) {
					m_zipEntry = entry;
				}
				lth    = i;
				lc     = taPath.charAt(lth-1);
		}	}

		if (lc == File.separatorChar) {
			taPath = taPath.substring(0, lth-1);
		}

		m_progressCount = 0;

		updateProgress();

		try {

			URL		lsURL;

			if (context == null) {
				lsURL = new URL(taPath);
			} else {
				lsURL = new URL(context, taPath);
			}

			MsgOut.dprintln("Opening URL: " + taPath);
			InputStream is = lsURL.openStream();

			is = decompress(is, taPath, entry);
			if (is == null) {
				return null;
			}
			MsgOut.dprintln("opened");

			parseStream(is, taPath, lsURL);
			return lsURL; 
		}
		catch(Exception e) {
			m_resString = e.toString();
			return null;
		}
	}


	// Called from diagram.loadDiagram to parse a file or an include within a file

	private File parseFile(String taPath, File context) 
	{
		int		lth   = taPath.length();
		char	lc	  = taPath.charAt(lth-1);
		String	entry = null;

		if (lth > 2 &&  lc == ']') {
			int	i = taPath.lastIndexOf('['); 

			if (i > 0 && i < lth - 2) {
				entry  = taPath.substring(i+1, lth-1);
				if (m_zipEntry == null) {
					m_zipEntry = entry;
				}
				taPath = taPath.substring(0, i);
				lth    = i;
				lc     = taPath.charAt(lth-1);
		}	}

		if (lc == File.separatorChar) {
			taPath = taPath.substring(0, lth-1);
		}	
		
		m_progressCount = 0;

		updateProgress();

		try {
			File file;

			if (context == null)
				file = new File(taPath);
			else {
				String dir = getDir(context);

				file = new File(dir, taPath);
			}

			InputStream is = new FileInputStream(file);

			is = decompress(is, taPath, entry);
			if (is == null) {
				return null;
			}

			parseStream(is, taPath, null);
			return file;

		} catch (Exception e) {
			m_resString = e.toString();
			return null;
		}
	}

	// --------------
	// Public methods
	// --------------

	public Ta(LandscapeEditorCore ls) 
	{
		m_ls      = ls;
		m_diagram = getDiagram();

		// Must create this before create $ROOT
		// Need a navlink attribute on rootInstance

		m_entityBaseClass = new EntityClass(EntityClass.ENTITY_BASE_CLASS_ID, m_numEntityClasses++, null, m_diagram);							// $ENTITY
		m_entityClasses.put(EntityClass.ENTITY_BASE_CLASS_ID, m_entityBaseClass);

		// Create root entity

		m_rootInstance = new EntityInstance(m_entityBaseClass, ROOT_ID); 	// $ROOT
		m_rootInstance.setRelLocal(0.0, 0.0, 1.0, 1.0);
		EntityCache.put(m_rootInstance);
		
		for (int i = 0; i < g_optionsAttributes.length; i++) {
			m_rootInstance.addAttribute( new Attribute(g_optionsAttributes[i], null));
		}

		AttributeValueItem av = new AttributeValueItem(BG_STR);																			// 0.75

		av.next = new AttributeValueItem(BG_STR);
		av.next.next = new AttributeValueItem(BG_STR);
		m_rootInstance.addAttribute(new Attribute("color", av));																			// $ROOT (0.75 0.75 0.75)


		m_relationBaseClass =	 new RelationClass(RelationClass.RELATION_BASE_CLASS_ID, m_numRelationClasses++, null /* parent */, m_diagram);	// $RELATION
		m_relationClasses.put(RelationClass.RELATION_BASE_CLASS_ID, m_relationBaseClass);													// Add to hash table
		m_numToRel.addElement(m_relationBaseClass);

		RelationClass rc = new RelationClass(CONTAIN_ID, m_numRelationClasses++, m_relationBaseClass, m_diagram);								// contain
		rc.setCIndex(0);
		m_relationClasses.put(CONTAIN_ID, rc);																							// Add to hash table
		m_numToRel.addElement(rc);
	}

	public LandscapeEditorCore getLs() 
	{
		return m_ls;
	}

	public Enumeration enumRelationClasses() 
	{
		return m_relationClasses.elements(); 
	}

	public Enumeration enumRelationClassesInOrder() 
	{
		return OrderedHashTableEnumeration.elements(m_relationClasses); 
	}

	public int numRelationClasses() 
	{
		return m_numRelationClasses;
	}

	public Enumeration enumEntityClasses() 
	{
		return m_entityClasses.elements(); 
	}

	public Enumeration enumEntityClassesInOrder() 
	{
		return OrderedHashTableEnumeration.elements(m_entityClasses); 
	}

	public int numEntityClasses() 
	{
		return m_numEntityClasses;
	}

	public Object getContext() 
	{
		return m_context;
	}

	public void setContext(Object context) 
	{
		m_context = context;
	}

	public String getContextName() 
	{
		String ret;

		if (m_context instanceof File) {
			ret = Util.nameFromPath(((File) m_context).getPath());
		} else { 
			ret = m_rootInstance.getEntityLabel();
		}
		if (m_zipEntry != null) {
			ret += "[" + m_zipEntry + "]";
		}
		return ret;
	}

	public String getDir(File file) 
	{
		if (file.isAbsolute()) {
			return file.getParent();
		}
		return (new File(file.getAbsolutePath())).getParent();
	}

	public String getDir() 
	{
		return getDir((File) m_context);
	}

	public String getAbsolutePath() 
	{
		if (m_context != null) {
			if (m_context instanceof File) {
				return ((File) m_context).getAbsolutePath();
			}
//			return ((URL) m_context).toExternalForm();
		}
		return null;
	}

	public RelationClass numToRelationClass(int n) 
	{
		return (RelationClass) m_numToRel.elementAt(n);
	}

	// Save the landscape in the output stream

	public void saveDiagram(OutputStream os, boolean markEnd) throws IOException
	{
		BufferedOutputStream bos = new BufferedOutputStream(os);
		PrintStream ps = new PrintStream(bos);

		writeSchemeTuples(ps);
		writeSchemeAttributes(ps);
		writeFactTuples(ps);
		writeFactAttributes(ps);

		if (markEnd) {
			ps.print("END\n");
		}
		ps.flush();
		ps.close();
		m_changedFlag = false;
	}

	public String loadTA(String taPath, Object context) {

		Attribute	attr;
		boolean		option;

		m_containsClass = null;
		m_resString     = null;
		m_zipEntry      = null;
		if (taPath == null) {
			emptyDiagram();
		} else {
			int		lth   = taPath.length();

			if (lth == 0) {
				emptyDiagram();
			} else {
				if (context instanceof URL || Util.isHTTP(taPath)) {
					MsgOut.dprintln("Parse a URL");
					setContext(parseURL(taPath, (URL) context));
				} else {
					MsgOut.dprintln("Parse a file");
					setContext(parseFile(taPath, (File) context));
		}	}	}
	
		if (m_defaultEntityClass == null) {
			m_defaultEntityClass = m_entityBaseClass;
		}
		if (m_defaultRelationClass == null) {
			m_defaultRelationClass = m_relationBaseClass;
		}
			
		if (m_context == null) {
			return m_resString;
		}
		return null;
	}
	
	public int getNumberEntitiesLoaded()
	{
		return EntityCache.size();
	}

	public int getNumberRelationsLoaded()
	{
		return m_numberRelations;
	}
}

