package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JFrame;

public class Util
{
	public static final double ARROW_L_DEFAULT  = 10.0;
	public static final double ARROW_TH_DEFAULT = 0.40;
	public static final int	   LINE_W_DEFAULT   = 1;

	public static double ARROW_L  = ARROW_L_DEFAULT;
	public static double ARROW_TH = ARROW_TH_DEFAULT; 
	public static int	 LINE_W   = LINE_W_DEFAULT;

	public static final int LINE_STYLE_NORMAL			= 0;
	public static final int LINE_STYLE_DASHED			= 1;
	public static final int LINE_STYLE_DOTTED			= 2;
	public static final int LINE_STYLE_INSCRIBED		= 3;

	public static final String[] lineStyleName =
		{ 
				"Normal", 
				"Dashed", 
				"Dotted", 
				"Inscribed"
		};

	protected static final int DASH_LEN			= 4;
	protected static final int DASH_GAP			= 3;

	protected static final int DOT_LEN			= 0;
	protected static final int DOT_GAP			= 4;

	protected static boolean reverseZflag = false;

	protected static final int GAP		  = 5;
	protected static final int INSET	  = 12;
	protected static final int OUTSET	  = 5;

	public static String formatFraction(double val)
	{
		if (val >= 1.0) {
			if (val == 1.0) {
				return("1");
			}
			return "" + val;
		}
		if (val <= 0) {
			if (val == 0) {
				return("0");
			}
			return "" + val;
		}
		int	e1, e2;

		e1 = (int) (val*10);
		e2 = ((int) (val*100)) - (e1*10);
		if (e2 == 0) {
			return "0." + e1;
		}
		return ("0." + e1) + e2;
	}

	public static boolean isBlank(String s)
	{
		for (int i = s.length(); i > 0; ) {
			if (s.charAt(--i) != ' ') {
				return false;
		}	}
		return true;
	}

	public static String getLineStyleName(int style)
	{
		if (style < 0 || style >= lineStyleName.length) {
			return "";
		}
		return lineStyleName[style];
	}

	public static boolean drawStringClipped(Graphics g, String str,	double x, double y, double width, double height, boolean centered, boolean underlined)
	{
		FontMetrics fm = g.getFontMetrics();


		int len = str.length();
		int pos = len-1;

		if (fm.stringWidth(str) > width) {
			while(pos >= 0 && fm.stringWidth(str.substring(0, pos) + "...") > width) {
				pos--;
			}
		}

		if (pos < 0) {
			return false;
		}


		String dstr;
		double xpos;

		if (pos == len-1) {
			dstr = str;

			double sw = (double) fm.stringWidth(str);

			xpos = (centered ? x+width/2-sw/2 : x); 
		} else {
			dstr = str.substring(0, pos) + "...";

			xpos = x;
		}

		ScreenPoint pt;	 

		if (centered) {
			pt = new ScreenPoint(xpos, y + height/2 + fm.getHeight()/2);
		} else {
			pt = new ScreenPoint(xpos, y + fm.getHeight());
		}

		g.drawString(dstr, pt.x, pt.y);

		if (underlined) {
			int sw = fm.stringWidth(dstr);

			g.drawLine(pt.x, pt.y, pt.x+sw, pt.y);
		}

		return (pos == len-1);
	}

	public static boolean drawStringClipped(Graphics g, String str,	double x, double y, double width, double height)
	{
		return drawStringClipped(g, str, x, y, width, height, false, false);
	}

	public static boolean drawUnderlinedStringClipped(Graphics g, String str, double x, double y, double width, double height)
	{
		return drawStringClipped(g, str, x, y, width, height, false, true);
	}

	protected static int longestSubStr(String str, FontMetrics fm, int width) 
	{
		int lpos, pos = str.indexOf('\n');

		if (pos > 0) {
			// Consider only the next line of text
			str = str.substring(0, pos);
		}
		if (fm.stringWidth(str) <= width) {
			return str.length();
		}

		for (lpos = -1;; lpos = pos) {
			pos = str.indexOf(' ', lpos+1);
			if (pos < 0) {
				break;
			}
			if (fm.stringWidth(str.substring(0, pos)) > width) {
				break;
		}	}
		if (lpos == -1) {
			return str.length();
		}
		return lpos;
	}

	public static boolean drawStringWrapped(Graphics g, String str,	double x, double y, double width, double height, boolean centered, boolean underlined)
	{
		FontMetrics fm = g.getFontMetrics();
		Vector		strs = new Vector();


		if (str.indexOf(' ') < 0 && str.indexOf('\n') < 0) {
			return drawStringClipped(g, str, x, y, width, height, centered, underlined);
		}

		String		dstr;
		double		xpos;
		int			pos;

		for (;;) {
			pos = longestSubStr(str, fm, (int) width); 
			strs.addElement(str.substring(0, pos));
			if (pos == str.length()) {
				break;
			}
			str = str.substring(pos + 1);
		}

		int fh = (fm.getHeight() * 3)/4;
		int ht = strs.size() * fh;

		Enumeration en = strs.elements();

		double ypos = (centered ? y + (height - ht)/2 + fh : y + fh);

		while(en.hasMoreElements()) {
			str     = (String) en.nextElement();
			int len = str.length();
			pos     = len-1;

			while(pos >= 0 && fm.stringWidth(str.substring(0, pos)) > width) {
				pos--;
			}

			if (pos >= 0) {
				

				if (pos == len-1) {
					dstr = str;

					double sw = (double) fm.stringWidth(str);
					xpos = (centered ? x+width/2-sw/2 : x); 
				} else {
					dstr = str.substring(0, pos);

					xpos = x;
				}

				ScreenPoint pt = new ScreenPoint(xpos, ypos);

				g.drawString(dstr, pt.x, pt.y);
				if (underlined) {
					int sw = fm.stringWidth(dstr);
					g.drawLine(pt.x, pt.y, pt.x+sw, pt.y);
				}
				ypos += fh;
		}	}
		return true;
	}

	public static boolean isHTTP(String path) 
	{
		return path.length() > 7 && (path.substring(0,7).equals("http://") || path.substring(0,7).equals("HTTP://"));
	}

	public static String prefixOf(String name) 
	{
		int ind = name.lastIndexOf('.');


		if (ind >= 0) {
			return name.substring(0, ind);
		}
		return name;
	}



	public static void drawFrame(Graphics gc, Rectangle r) {

		gc.setColor(Diagram.boxColour);



		gc.draw3DRect(0, 0, r.width-1, r.height-1, true);

		gc.draw3DRect(1, 1, r.width-3, r.height-3, true);

	}

	public static double parseReal(String str) 
	{
		return (new Double(str)).doubleValue();
	}

	public static int parseInt(String str) 
	{
		return (new Integer(str)).intValue();
	}

	public static boolean parseBoolean(String str) 
	{
		return str.equals("true");
	}

	protected static String qt(String str) 
	{
		if (str.indexOf(' ') >= 0) {
			return "\"" + str + "\"";
		}
		return str;
	}

	protected static String doExpand(String src, String id, LandscapeEditorCore ls) 
	{
		String link = "";

		int pos = 0;
		int len = src.length();
		boolean found;

		MsgOut.dprintln("Expand: " + src);

		do {
			int ind = src.indexOf('$', pos);
			found = (ind == 0 || (ind > 0 && src.charAt(ind-1) != '\\')) &&	(ind+1 < len);
			if (found) {
				int endInd = src.indexOf('$', ind+1);
				if (endInd < ind) {
					MsgOut.println("Missing delimitting '$'" + " in expansion variable");
					return null;
				}
				link += src.substring(pos, ind);
				String var = src.substring(ind+1, endInd);

				if (var.equals("ID")) {
					link += qt(id);
				} else if (var.equals("IDPREFIX")) {
					int dind = id.lastIndexOf('.');
					if (dind >= 0) {
						link += qt(id.substring(0, dind));
					} else {
						link += qt(id);
					}
				} else if (var.equals("IDSUFFIX")) {
					int dind = id.lastIndexOf('.');
					if (dind >= 0) {
						link += id.substring(dind+1);
					}
				} else if (var.equals("DGDIR")) {
					String path = ls.getDiagram().getAbsolutePath();
					String dir = dirFromPath(path);
					link += dir;
				} else if (var.equals("DGSUFFIX")) {
					String path = ls.getDiagram().getAbsolutePath();
					String name = nameFromPath(path);
					int dind = name.indexOf('.');

					if (dind >=0)  {
						link += name.substring(dind+1);
					}

				} else {
					// Assume it's a PARAM name
					String value = ls.getParameter(var);
					if (value != null) {
						link += qt(value); 
					} else {
						MsgOut.println("Parameter not found: "	+ "'" + var + "'");
						return "";
					}
				}
				pos = endInd+1;
			}

		} while (found && pos < len);



		if (pos < len) {
			link += src.substring(pos);
		}
		MsgOut.dprintln("Result: " + link);
		return link;
	}



	public static String expand(String src, String id, LandscapeEditorCore ls)
	{
		String nstr1, nstr2;

		nstr2 = doExpand(src, id, ls);
		do {
			nstr1 = nstr2;
			nstr2 = doExpand(nstr1, id, ls);
		} while (!nstr1.equals(nstr2));
		return nstr1;
	}



	public static String expand(String src, LandscapeEditorCore ls) 
	{
		return expand(src, "", ls);
	}

	public static JFrame getFrame(Component c) 
	{
		for (; c != null; c = c.getParent()) {
			if (c instanceof JFrame) {
				return (JFrame) c;
		}	}
		return null;
	}

	public static String dirFromPath(String path) 
	{
		int ind1 = path.lastIndexOf('/');
		int ind2 = path.lastIndexOf('\\');

		if (ind1 > ind2) {
			return path.substring(0, ind1);
		} else if (ind2 > ind1) {
			return path.substring(0, ind2);
		}
		return "";
	}



	public static String nameFromPath(String path) 
	{
		int ind1 = path.lastIndexOf('/');
		int ind2 = path.lastIndexOf('\\');

		if (ind1 > ind2) {
			return path.substring(ind1+1);
		}

		if (ind2 > ind1) {
			return path.substring(ind2+1);
		}
		return path;
	}



	public static boolean isBlack(Color c) 
	{
		if (c == Color.black) {
			return true;
		}

		if (c.getRed() != 0) {
			return false;
		}
		if (c.getGreen() != 0) {
			return false;
		}
		return(c.getBlue() == 0);
	}

	public static String quoted(String str) 
	{
		if (str.indexOf(' ') >= 0) {
			return "\"" + str + "\"";
		}
		return str;
	}

	protected static void drawLine(Graphics g, LineWalker lw) 
	{
		ScreenPoint p1 = new ScreenPoint(0, 0);
		ScreenPoint p2 = new ScreenPoint(0, 0);

		while(lw.morePoints()) {
			 lw.nextPoints(p1, p2);
			 g.drawLine(p1.x, p1.y, p2.x, p2.y);
		}
	}

	protected static void 
	drawInscribedLine(Graphics g, int x1, int y1, int x2, int y2) 
	{
		Color cc = g.getColor();

		g.setColor(Color.gray);
		g.drawLine(x1, y1, x2, y2);
		g.setColor(Color.white);

		if (x1 == x2) {
			g.drawLine(x1+1, y1, x2+1, y2);
		} else {
			g.drawLine(x1, y1+1, x2, y2+1);
		}
		g.setColor(cc);
	}

	public static void drawTailPoint(Graphics g, int x, int y) 
	{
		int hb = RelationInstance.NEAR_PIXEL_SIZE/2;
		g.fillOval(x-hb, y-hb, hb*2, hb*2);
	}

	public static void drawOutlineBox(Graphics g, int x, int y, int width, int height, boolean has3Dlook)
	{
		g.setColor(Color.gray);

		if (!has3Dlook) {
			g.drawRect(x, y, width, height);
			return;
		}

		g.drawLine(x, y, x + width, y);
		g.drawLine(x + width -1, y+1, x+ width -1, y+ height -1);
		g.drawLine(x + width -1, y+height-1, x+1, y+height-1);
		g.drawLine(x, y+height, x, y);
		g.setColor(Color.white);

		g.drawLine(x+1, y+1, x+width, y+1);
		g.drawLine(x+width, y+1, x+width, y+height);
		g.drawLine(x+width, y+height, x+1, y+height);
		g.drawLine(x+1, y+height, x+1, y+1);
	}


	public static void drawOutlineBox(Graphics g, Rectangle rect, boolean has3Dlook)
	{
		drawOutlineBox(g, rect.x, rect.y, rect.width, rect.height, has3Dlook);
	}

	public static void drawGroupBox(Graphics g, int x, int y, int w, int h, String label, boolean has3Dlook)
	{
		FontMetrics fm;
		int			len, ht, inset, x2;

		g.setFont(EntityInstance.getSmallFont());

		fm    = g.getFontMetrics();
		len   = fm.stringWidth(label);
		ht	  = fm.getHeight();
		inset = Math.min(INSET, w/12);

		if (w < inset + OUTSET) {
			drawOutlineBox(g, x, y, w, h, has3Dlook);
		} else {
			if (len+GAP*2 > w-inset-OUTSET) {
				x2 = x + w - OUTSET;
			} else {
				x2 = x + inset + len + GAP*2;
			}

			g.setColor(Color.gray);

			if (has3Dlook) {
				g.drawLine(x, y+h, x, y);
				g.drawLine(x, y, x+inset, y);
				g.drawLine(x2, y, x+w, y);
				g.drawLine(x+w-1, y+1, x+w-1, y+h-1);
				g.drawLine(x+w-1, y+h-1, x+1, y+h-1);
				g.setColor(Color.white);
				g.drawLine(x+1, y+h, x+1, y+1);
				g.drawLine(x+1, y+1, x+inset, y+1);
				g.drawLine(x2, y+1, x+w, y+1);
				g.drawLine(x+w, y+1, x+w, y+h);
				g.drawLine(x+w, y+h, x+1, y+h);
			} else {
				g.drawLine(x, y+h, x, y);
				g.drawLine(x, y, x+inset, y);
				g.drawLine(x2, y, x+w, y);
				g.drawLine(x+w, y, x+w, y+h);
				g.drawLine(x+w, y+h, x, y+h);
		}	}
	}

	public static void drawGroupBoxLabel(Graphics g, int x, int y, int w, String label)
	{
		FontMetrics fm;
		int			len, ht, inset, x2;

		g.setFont(EntityInstance.getSmallFont());

		fm    = g.getFontMetrics();
		len   = fm.stringWidth(label);
		ht	  = fm.getHeight();
		inset = Math.min(INSET, w/12);

		if (w >= inset + OUTSET) {
			if (len+GAP*2 > w-inset-OUTSET) {
				x2 = x + w - OUTSET;
			} else {
				x2 = x + inset + len + GAP*2;
			}
			drawStringClipped(g, label, x+inset+GAP, y - (ht*2)/3, x2-x-GAP*2, 100);
	}	}

	public static String mungeName(String name) {
		String tmp = name.replace(' ', '_');

		tmp = tmp.replace('/', '-');
		tmp = tmp.replace(',', '_');
		return tmp.replace('\\', '-');
	}

	public static String hashEdge(RelationClass rc, EntityInstance src, EntityInstance dst)
	{
		return src.getId() + rc.getId() + dst.getId();
	}

	public static int round(double val) {
		return (int) (val + 0.5);
	}

	// Line drawing stuff

	protected static final int DOT_LEN_REG		= 0;
	protected static final int DOT_LEN_PRNT		= 1;

	protected static int getDotLen(Graphics g) 
	{
		return DOT_LEN_REG;
	}

	// --------------
	// Public methods
	// --------------


	public static void drawSegment(Graphics g, int style, int x1, int y1, int x2, int y2)
	{
		int	x, y, xshift, yshift, i;

		x      = 0;
		y      = 0;
		xshift = 0;
		yshift = 0;

		for (i = 0; i < LINE_W; ++i) {
			switch(style) {
				case Util.LINE_STYLE_NORMAL:
				{
//					System.out.println("Util.drawSegment line (" + x1 + ", " + y1 + ")->(" + x2 + ", " + y2 + ")" );
					g.drawLine(x1+x, y1+y, x2+x, y2+y);
					break;
				}
				case Util.LINE_STYLE_DOTTED:
				{
//					System.out.println("Util.drawSegment dotted (" + x1 + ", " + y1 + ")->(" + x2 + ", " + y2 + ")" );
					LineWalker lw = new LineWalker(x1+x, y1+y, x2+x, y2+y, getDotLen(g), DOT_GAP);
					drawLine(g, lw);
					break;
				}
				case Util.LINE_STYLE_DASHED:
				{
//					System.out.println("Util.drawSegment dashed (" + x1 + ", " + y1 + ")->(" + x2 + ", " + y2 + ")" );
					LineWalker lw = new LineWalker(x1+x, y1+y, x2+x, y2+y, DASH_LEN, DASH_GAP);
					drawLine(g, lw);
					break;
				}
				case Util.LINE_STYLE_INSCRIBED:
				{
					drawInscribedLine(g, x1, y1, x2, y2);
			}	}

			x = -x;
			y = -y;

			if ((i & 1) == 0) {
				if (i == 0) {
					int w, h;

					w = x2 - x1;
					h = y2 - y1;

					if (w <= 0 && h <= 0) {
						w = -w;
						h = -h;
					}
					if (w >= 0 && h >= 0) {
						if (2*h >= w) {
							xshift = 1;
						} 
						if (2*w >= h) {
							yshift = -1;
						}
					} else {
						if (w < 0) {
							w = -w;
						}
						if (h < 0) {
							h = -h;
						}
						if (2*h >= w) {
							xshift = 1;
						} 
						if (2*w >= h) {
							yshift = 1;
					}	}
//					System.out.println("xshift=" + xshift + " yshift=" + yshift);
				} 
				x += xshift;
				y += yshift;
	}	}	}

	// Returns the ratio of the arrow length to the length

	public static double getArrow(int srcX, int srcY, int dstX, int dstY, int[] x, int[] y)
	{
		double	len;

		int dx   = srcX - dstX;
		int dy   = srcY - dstY;

		if (dx == 0 && dy == 0) {
			len = 0;
		} else {
			double theta = Math.atan2(dy, dx);
			       len   = Math.sqrt(dx*dx + dy*dy);
			double len1   = Math.min(ARROW_L, len);

			double ax    = dstX + len1*Math.cos(theta-ARROW_TH);
			double ay    = dstY + len1*Math.sin(theta-ARROW_TH);
			double bx    = dstX + len1*Math.cos(theta+ARROW_TH);
			double by    = dstY + len1*Math.sin(theta+ARROW_TH);

			x[0] = dstX;
			y[0] = dstY;
			x[1] = (int) Math.round(ax);
			y[1] = (int) Math.round(ay);
			x[2] = (int) Math.round(bx);
			y[2] = (int) Math.round(by);

			len = len1/len;
		}
		return(len);
	}

	public static double drawArrowHead(Graphics g, int x1, int y1, int x2, int y2) 
	{
		int[] x = new int[3];
		int[] y = new int[3];
		double	  len = getArrow(x1, y1, x2, y2, x, y);
		if (len != 0) {
			if (LandscapeEditorCore.isFillArrowhead()) {
				g.fillPolygon(x, y, 3);
			} else {
				g.drawPolygon(x, y, 3);
		}	}
		return len;
	}

	public static void drawArrow(Graphics g, int style, int x1, int y1, int x2, int y2)
	{
		if (Do.isCenterArrowhead()) {
			int	x3 = x2;
			int y3 = y2;
			
			x2 = (x1 + x2) / 2;
			y2 = (y1 + y2) / 2;
			drawSegment(g, style, x2, y2, x3, y3);
		} 
		double	fraction = drawArrowHead(g, x1, y1, x2, y2);
		int		shift;
		x2 -= (int) (((double) (x2-x1)) * fraction);
		y2 -= (int) (((double) (y2-y1)) * fraction);
		drawSegment(g, style, x1, y1, x2, y2);
	}	
}

