/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import lsedit.AttributeValueItem;
import lsedit.ColorCache;
import lsedit.LandscapeObject;
import lsedit.MsgOut;
import lsedit.Util;

public class Attribute {
    public static final Integer NULL = new Integer(0);
    public static final Integer INT = new Integer(1);
    public static final Integer DOUBLE = new Integer(2);
    public static final Integer STRING = new Integer(3);
    public static final Integer INT_LIST = new Integer(4);
    public static final Integer DOUBLE_LIST = new Integer(5);
    public static final Integer STRING_LIST = new Integer(6);
    public static final int NULL_TYPE = 0;
    public static final int INT_TYPE = 1;
    public static final int DOUBLE_TYPE = 2;
    public static final int STRING_TYPE = 3;
    public static final int INT_LIST_TYPE = 4;
    public static final int DOUBLE_LIST_TYPE = 5;
    public static final int STRING_LIST_TYPE = 6;
    public static final int COLOR_TYPE = 7;
    public static final int COLOR_OR_NULL_TYPE = 8;
    public static final int POINT_TYPE = 9;
    public static final int ELISION_TYPE = 10;
    public static final int AVI_TYPE = 11;
    public static final int TEXT_TYPE = 12;
    public static final int ENTITY_STYLE_TYPE = 13;
    public static final int REL_STYLE_TYPE = 14;
    public static final int ENTITY_CLASS_TYPE = 15;
    public static final int RELATION_CLASS_TYPE = 16;
    public static final String indent = " ";
    public String id;
    public AttributeValueItem avi;
    public boolean m_cloneOnAssign;
    public Attribute next;
    protected double cachedReal = Double.POSITIVE_INFINITY;
    protected Color cachedColor = null;

    public Attribute(String string, AttributeValueItem attributeValueItem) {
        this.id = string;
        this.avi = attributeValueItem;
    }

    public boolean hasId(String string) {
        return this.id.equals(string);
    }

    public String toString() {
        String string = this.id;
        if (this.avi != null) {
            string = string + "=";
        }
        AttributeValueItem attributeValueItem = this.avi;
        while (attributeValueItem != null) {
            if (attributeValueItem != this.avi) {
                string = string + ",";
            }
            string = string + attributeValueItem;
            attributeValueItem = attributeValueItem.nextList;
        }
        return string;
    }

    public Object clone() {
        AttributeValueItem attributeValueItem = this.avi == null ? null : (AttributeValueItem)this.avi.clone();
        return new Attribute(this.id, attributeValueItem);
    }

    public String parseString() {
        return this.avi.value;
    }

    public double parseReal() {
        if (this.avi.value == null) {
            return 0.0;
        }
        if (this.cachedReal == Double.POSITIVE_INFINITY) {
            this.cachedReal = Util.parseReal(this.avi.value);
        }
        return this.cachedReal;
    }

    public int parseInt() {
        if (this.avi.value == null) {
            return 0;
        }
        return Util.parseInt(this.avi.value);
    }

    public boolean parseBoolean() {
        if (this.avi.value == null) {
            return false;
        }
        return Util.parseBoolean(this.avi.value);
    }

    public Color parseColour() {
        if (this.cachedColor != null) {
            return this.cachedColor;
        }
        AttributeValueItem attributeValueItem = this.avi;
        if (attributeValueItem.value == null) {
            MsgOut.println("parseColor: missing values");
            return Color.black;
        }
        float f = new Float(attributeValueItem.value).floatValue();
        attributeValueItem = attributeValueItem.next;
        if (attributeValueItem == null) {
            MsgOut.println("parseColor: missing green and blue values");
            return Color.black;
        }
        float f2 = new Float(attributeValueItem.value).floatValue();
        attributeValueItem = attributeValueItem.next;
        if (attributeValueItem == null) {
            MsgOut.println("parseColor: missing blue value");
            return Color.black;
        }
        float f3 = new Float(attributeValueItem.value).floatValue();
        this.cachedColor = ColorCache.get(f, f2, f3);
        return this.cachedColor;
    }

    public Color parseColor() {
        return this.parseColour();
    }

    public void addToList(String string) {
        AttributeValueItem attributeValueItem = new AttributeValueItem(string);
        attributeValueItem.next = this.avi;
        this.avi = attributeValueItem;
    }

    public void removeFromList(String string) {
        AttributeValueItem attributeValueItem = null;
        AttributeValueItem attributeValueItem2 = this.avi;
        while (attributeValueItem2 != null) {
            if (attributeValueItem2.value.equals(string)) {
                if (attributeValueItem != null) {
                    attributeValueItem.next = attributeValueItem2.next;
                } else {
                    this.avi = attributeValueItem2.next;
                }
                return;
            }
            attributeValueItem = attributeValueItem2;
            attributeValueItem2 = attributeValueItem2.next;
        }
    }

    public void writeAttribute(PrintStream printStream, LandscapeObject landscapeObject, boolean bl) throws IOException {
        if (this.avi == null) {
            if (bl) {
                printStream.print(indent + this.id + "\n");
            }
        } else if (!(!bl && this.m_cloneOnAssign || landscapeObject != null && landscapeObject.defaultValue(this.id, this.avi))) {
            printStream.print(indent + this.id + " = ");
            this.avi.writeAttribute(printStream);
        }
    }
}

