/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import lsedit.ColorCache;
import lsedit.FontCache;

class Cardinal
extends JComponent {
    protected static final int MARGIN = 5;
    protected int m_cnt;
    protected int m_w;
    public static final String DEFAULT_CARDINAL_FONT_NAME = "Helvetica";
    public static final int DEFAULT_CARDINAL_FONT_STYLE = 0;
    public static final int DEFAULT_CARDINAL_FONT_SIZE = 9;
    public static Font m_font = FontCache.get("Helvetica", 0, 9);
    public static FontMetrics m_fm = null;
    public static int m_h;

    public Cardinal() {
        this.setFont(m_font);
    }

    public static void setDefaultFont(Font font) {
        m_font = font;
        m_fm = null;
    }

    public void reset() {
        this.m_cnt = 0;
    }

    public void inc() {
        ++this.m_cnt;
    }

    public void known() {
        this.setToolTipText("" + this.m_cnt);
    }

    public int getCnt() {
        return this.m_cnt;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.setForeground(ColorCache.getInverse(color.getRGB()));
    }

    public void setCenterTop(int n, int n2, int n3, int n4, double d) {
        this.setFont(m_font);
        if (m_fm == null) {
            m_fm = this.getFontMetrics(this.getFont());
            m_h = m_fm.getAscent();
        }
        n = (int)((double)n + (double)n3 * d);
        this.m_w = m_fm.stringWidth("" + this.m_cnt);
        this.setBounds(n - this.m_w / 2 - 2, n2 += n4 + 5, this.m_w + 4, m_h + 4);
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setFont(m_font);
        graphics.setColor(this.getBackground());
        graphics.fillOval(0, 0, n, n2);
        graphics.setColor(Color.black);
        graphics.drawOval(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.getForeground());
        graphics.drawString("" + this.m_cnt, 2, m_h - 2);
    }

    public void removeNotify() {
        super.removeNotify();
        this.setSize(0, 0);
    }

    public String toString() {
        return "Cardinal " + this.m_cnt;
    }
}

