/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;

public class ColorCache {
    private static final int m_initialCapacity = 200;
    private static final float m_loadFactor = 0.75f;
    private static Entry[] m_table = null;
    private static int m_count = 0;
    private static int m_threshold = 150;

    public static int size() {
        return m_count;
    }

    public static boolean isEmpty() {
        return m_count == 0;
    }

    public static void clear() {
        Entry[] entryArray = m_table;
        if (entryArray != null) {
            int n = entryArray.length;
            while (--n >= 0) {
                entryArray[n] = null;
            }
        }
        m_count = 0;
    }

    protected static void rehash() {
        Entry[] entryArray = m_table;
        int n = entryArray.length;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        m_threshold = (int)((float)n2 * 0.75f);
        m_table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.m_next;
                int n4 = (entry2.m_value.getRGB() & Integer.MAX_VALUE) % n2;
                entry2.m_next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    protected static void put(Color color, int n) {
        Entry[] entryArray = m_table;
        if (m_count >= m_threshold) {
            ColorCache.rehash();
            entryArray = m_table;
            n = (color.getRGB() & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n] = new Entry(color, entryArray[n]);
        ++m_count;
    }

    public static Color get(int n) {
        Color color;
        int n2;
        Entry[] entryArray = m_table;
        if (entryArray == null) {
            m_table = new Entry[200];
            n2 = (n & Integer.MAX_VALUE) % m_table.length;
        } else {
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                color = entry.m_value;
                if (color.getRGB() == n) {
                    return color;
                }
                entry = entry.m_next;
            }
        }
        color = new Color(n, true);
        ColorCache.put(color, n2);
        return color;
    }

    public static Color get(int n, int n2, int n3, int n4) {
        int n5 = (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
        return ColorCache.get(n5);
    }

    public static Color get(int n, int n2, int n3) {
        int n4 = 0xFF000000 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
        return ColorCache.get(n4);
    }

    public static Color get(float f, float f2, float f3) {
        return ColorCache.get((int)((double)(f * 255.0f) + 0.5), (int)((double)(f2 * 255.0f) + 0.5), (int)((double)(f3 * 255.0f) + 0.5));
    }

    public static Color getInverse(int n) {
        return ColorCache.get(n ^ 0xFFFFFF);
    }

    static class Entry {
        public Color m_value;
        public Entry m_next;

        protected Entry(Color color, Entry entry) {
            this.m_value = color;
            this.m_next = entry;
        }
    }
}

