/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.GroupModeHandler;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeModeHandler;
import lsedit.MoveModeHandler;
import lsedit.MyMenuItem;
import lsedit.NewEdgeModeHandler;
import lsedit.RelationInstance;
import lsedit.ResizeModeHandler;

public class EditModeHandler
extends LandscapeModeHandler {
    protected MoveModeHandler m_moveHandler = new MoveModeHandler(this);
    protected ResizeModeHandler m_resizeHandler = new ResizeModeHandler(this);
    protected GroupModeHandler m_groupingHandler = new GroupModeHandler(this);
    protected NewEdgeModeHandler m_newEdgeModeHandler;
    private LandscapeModeHandler m_handler = null;
    private long m_lastUp;
    private boolean m_mouseIsDown = false;
    protected JPopupMenu m_rootEntityPopup;
    protected JPopupMenu m_entityPopup;
    protected JPopupMenu m_relationPopup;

    protected JPopupMenu buildEntityPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu("Entity options");
        Do.entityPopupMenuItem(jPopupMenu, this.m_ls);
        return jPopupMenu;
    }

    protected JPopupMenu buildRelationPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu("Edge options");
        Do.edgePopupMenuItem(jPopupMenu, this.m_ls);
        return jPopupMenu;
    }

    public EditModeHandler(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public boolean mouseIsDown() {
        return this.m_mouseIsDown;
    }

    public LandscapeModeHandler getSubHandler() {
        return this.m_handler;
    }

    public void setSubHandler(LandscapeModeHandler landscapeModeHandler) {
        if (this.m_handler != null) {
            this.m_handler.cleanup();
        }
        this.m_handler = landscapeModeHandler;
    }

    public void cleanup() {
        this.setSubHandler(null);
    }

    protected static void usesObject(Object object, Object object2) {
        if (object instanceof MyMenuItem) {
            ((MyMenuItem)object).setObject(object2);
            return;
        }
        if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            int n = jMenu.getItemCount();
            while (n > 0) {
                JMenuItem jMenuItem;
                if ((jMenuItem = jMenu.getItem(--n)) == null) continue;
                EditModeHandler.usesObject(jMenuItem, object2);
            }
            return;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            int n = container.getComponentCount();
            while (n > 0) {
                EditModeHandler.usesObject(container.getComponent(--n), object2);
            }
            return;
        }
    }

    public void moveGroup(int n) {
        this.m_groupingHandler.moveGroup(n);
    }

    public void newEdge(Object object) {
        if (this.m_newEdgeModeHandler == null) {
            this.m_newEdgeModeHandler = new NewEdgeModeHandler(this);
        }
        this.m_newEdgeModeHandler.activate(object);
    }

    public void rightClickEntity(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        Diagram diagram = this.m_ls.getDiagram();
        JPopupMenu jPopupMenu = this.m_entityPopup;
        if (jPopupMenu == null) {
            this.m_entityPopup = jPopupMenu = this.buildEntityPopup();
        }
        EditModeHandler.usesObject(jPopupMenu, entityInstance);
        FontCache.setMenuTreeFont(jPopupMenu);
        this.m_ls.add(jPopupMenu);
        jPopupMenu.show(this.m_ls.getContentPane(), this.m_ls.getDiagramX() + n, this.m_ls.getDiagramY() + n2);
    }

    public void rightClickRelation(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        JPopupMenu jPopupMenu = this.m_relationPopup;
        if (jPopupMenu == null) {
            this.m_relationPopup = jPopupMenu = this.buildRelationPopup();
        }
        EditModeHandler.usesObject(jPopupMenu, relationInstance);
        FontCache.setMenuTreeFont(jPopupMenu);
        this.m_ls.add(jPopupMenu);
        jPopupMenu.show(this.m_ls.getContentPane(), this.m_ls.getDiagramX() + n, this.m_ls.getDiagramY() + n2);
    }

    public void entityPressed(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        if (mouseEvent.isMetaDown()) {
            this.rightClickEntity(mouseEvent, entityInstance, n, n2);
            return;
        }
        this.m_mouseIsDown = true;
        if (this.m_handler != null) {
            this.m_handler.entityPressed(mouseEvent, entityInstance, n, n2);
            return;
        }
        Diagram diagram = this.m_ls.getDiagram();
        if (entityInstance == diagram.getDrawRoot() && diagram.clearFlags()) {
            diagram.redrawDiagram();
        }
        if (mouseEvent.isShiftDown()) {
            this.m_groupingHandler.entityPressed(mouseEvent, entityInstance, n, n2);
            return;
        }
        this.m_resizeHandler.entityPressed(mouseEvent, entityInstance, n, n2);
        if (this.m_handler != null) {
            return;
        }
        this.m_moveHandler.entityPressed(mouseEvent, entityInstance, n, n2);
        if (this.m_handler != null) {
            return;
        }
        this.m_groupingHandler.entityPressed(mouseEvent, entityInstance, n, n2);
    }

    public void entityReleased(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        if (this.m_mouseIsDown) {
            long l = mouseEvent.getWhen();
            if (l - this.m_lastUp < 300L) {
                this.m_ls.setCursor(0);
                this.mouseDoubleClick(mouseEvent, entityInstance);
                this.m_lastUp = 0L;
            } else if (this.m_handler != null) {
                this.m_handler.entityReleased(mouseEvent, entityInstance, n, n2);
            }
            this.m_lastUp = l;
            this.m_mouseIsDown = false;
        }
    }

    public void relationPressed(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        if (mouseEvent.isMetaDown()) {
            this.rightClickRelation(mouseEvent, relationInstance, n, n2);
            return;
        }
        Diagram diagram = this.m_ls.getDiagram();
        this.m_mouseIsDown = true;
        if (this.m_handler != null) {
            this.m_handler.relationPressed(mouseEvent, relationInstance, n, n2);
            return;
        }
        if (!mouseEvent.isControlDown()) {
            if (mouseEvent.isShiftDown()) {
                this.m_groupingHandler.relationPressed(mouseEvent, relationInstance, n, n2);
                return;
            }
            diagram.clearFlags();
            this.m_moveHandler.relationPressed(mouseEvent, relationInstance, n, n2);
            if (this.m_handler == null) {
                this.m_groupingHandler.relationPressed(mouseEvent, relationInstance, n, n2);
            }
        }
    }

    public void relationReleased(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        if (this.m_mouseIsDown) {
            long l = mouseEvent.getWhen();
            if (l - this.m_lastUp < 300L) {
                this.m_ls.setCursor(0);
                this.mouseDoubleClick(mouseEvent, relationInstance);
                this.m_lastUp = 0L;
            } else {
                this.m_lastUp = l;
                if (this.m_handler != null) {
                    this.m_handler.relationReleased(mouseEvent, relationInstance, n, n2);
                }
            }
        }
        this.m_mouseIsDown = false;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent, Object object) {
        this.m_ls.processKey(10, mouseEvent.getModifiers() & 0xF, object);
    }

    public void movedOverThing(MouseEvent mouseEvent, Object object, int n, int n2) {
        if (this.m_handler != null) {
            this.m_handler.movedOverThing(mouseEvent, object, n, n2);
            return;
        }
        this.m_resizeHandler.movedOverThing(mouseEvent, object, n, n2);
        if (this.m_handler == null) {
            this.m_moveHandler.movedOverThing(mouseEvent, object, n, n2);
        }
    }

    public void entityDragged(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        if (this.m_handler != null) {
            this.m_handler.entityDragged(mouseEvent, entityInstance, n, n2);
        }
    }

    public void relationDragged(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        if (this.m_handler != null) {
            this.m_handler.relationDragged(mouseEvent, relationInstance, n, n2);
        }
    }
}

