/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.EntityInstance;

public class EntityCache {
    private static Entry[] m_table = null;
    private static int m_last_index = 0;
    private static int m_next = 0;
    private static Entry m_current = null;
    private static int m_count = 0;

    public static int size() {
        return m_count;
    }

    public static void clear() {
        m_table = null;
        m_count = 0;
    }

    public static void put(EntityInstance entityInstance) {
        int n;
        Entry[] entryArray = m_table;
        if (entryArray == null) {
            m_table = entryArray = new Entry[262144];
        }
        m_last_index = n = entityInstance.getId().hashCode() & 0x3FFFF;
        Entry entry = entryArray[n];
        while (entry != null) {
            EntityInstance entityInstance2 = entry.m_value;
            if (entityInstance2.getId().equals(entityInstance.getId()) && entityInstance == entityInstance2) {
                return;
            }
            entry = entry.m_next;
        }
        entryArray[n] = new Entry(entityInstance, entryArray[n]);
        ++m_count;
    }

    public static void remove(EntityInstance entityInstance) {
        Entry[] entryArray = m_table;
        if (entryArray != null) {
            int n = entityInstance.getId().hashCode() & 0x3FFFF;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entityInstance == entry.m_value) {
                    if (entry2 != null) {
                        entry2.m_next = entry.m_next;
                    } else {
                        entryArray[n] = entry.m_next;
                    }
                    entry.m_value = null;
                    --m_count;
                    return;
                }
                entry2 = entry;
                entry = entry.m_next;
            }
        }
        System.out.println("EntityCache: can't remove " + entityInstance);
    }

    public static EntityInstance get(String string) {
        Entry[] entryArray = m_table;
        if (entryArray != null) {
            Entry entry = entryArray[string.hashCode() & 0x3FFFF];
            while (entry != null) {
                EntityInstance entityInstance = entry.m_value;
                if (string.equals(entityInstance.getId())) {
                    return entityInstance;
                }
                entry = entry.m_next;
            }
        }
        return null;
    }

    public static EntityInstance someEntity() {
        if (m_count != 0) {
            Entry[] entryArray = m_table;
            Entry entry2 = entryArray[m_last_index];
            if (entry2 != null) {
                return entry2.m_value;
            }
            for (Entry entry2 : entryArray) {
                if (entry2 == null) continue;
                return entry2.m_value;
            }
        }
        return null;
    }

    protected static EntityInstance getFirst(int n) {
        int n2 = m_table.length;
        for (int i = n; i < n2; ++i) {
            Entry entry = m_table[i];
            if (entry == null) continue;
            m_current = entry.m_next;
            m_next = ++i;
            return entry.m_value;
        }
        return null;
    }

    public static EntityInstance getNext() {
        if (m_current != null) {
            EntityInstance entityInstance = EntityCache.m_current.m_value;
            m_current = EntityCache.m_current.m_next;
            return entityInstance;
        }
        return EntityCache.getFirst(m_next);
    }

    public static EntityInstance getFirst() {
        return EntityCache.getFirst(0);
    }

    public static void show() {
        Entry[] entryArray = m_table;
        if (entryArray == null) {
            System.out.println("Null Entity Cache");
        }
        if (m_count == 0) {
            System.out.println("Empty Entity Cache");
        }
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry entry = entryArray[i];
            if (entry == null) continue;
            System.out.print(i + ": ");
            while (entry != null) {
                System.out.print(" " + entry.m_value);
                entry = entry.m_next;
            }
            System.out.println("");
        }
    }

    static class Entry {
        public EntityInstance m_value;
        public Entry m_next;

        protected Entry(EntityInstance entityInstance, Entry entry) {
            this.m_value = entityInstance;
            this.m_next = entry;
        }
    }
}

