/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.EntityInstance;

class EntityChkBox
extends JComponent {
    protected static final int GAP = 5;
    protected static final int WIDTH = 45;
    protected static final int HEIGHT = 20;
    protected JCheckBox m_checkbox;
    protected EntityClass m_ec;
    protected EntityInstance m_e;
    protected int m_index;
    protected JLabel m_label;

    public EntityChkBox(EntityClass entityClass, int n, int n2, boolean bl) {
        JLabel jLabel;
        JCheckBox jCheckBox;
        int n3 = n2 * 2;
        int n4 = n3 * 4 / 3;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setHgap(5);
        this.setLayout(new FlowLayout(0));
        this.m_ec = entityClass;
        this.m_index = n;
        Color color = entityClass.getObjectColor();
        this.m_checkbox = jCheckBox = new JCheckBox();
        jCheckBox.setBorderPaintedFlat(false);
        jCheckBox.setSelected(entityClass.isShown());
        jCheckBox.setEnabled(true);
        jCheckBox.setVisible(true);
        this.add(jCheckBox);
        this.m_e = entityClass.newEntity("");
        EntityComponent entityComponent = this.m_e.neededPlainComponent();
        this.m_e.setSize(n4, n3);
        this.m_e.setLocation(0, 0);
        entityComponent.setPreferredSize(new Dimension(n4, n3));
        this.add(entityComponent);
        this.m_label = jLabel = new JLabel(entityClass.getLabel());
        jLabel.setForeground(entityClass.getLabelColor());
        this.add(jLabel);
        this.setToolTipText(entityClass.getDescription());
    }

    public void setFont(Font font) {
        this.m_label.setFont(font);
    }

    public void addItemListener(ItemListener itemListener) {
        this.m_checkbox.addItemListener(itemListener);
    }

    public boolean isSelected() {
        return this.m_checkbox.isSelected();
    }

    public void doClick() {
        this.m_checkbox.doClick();
    }

    public int getIndex() {
        return this.m_index;
    }
}

