/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import lsedit.Cardinal;
import lsedit.ClientSupplierSet;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.SrcCardinal;
import lsedit.Util;

public class EntityComponent
extends JComponent
implements Icon {
    public static final int MARGIN = 5;
    public static final int MIN_FLAP_HT = 3;
    public static final int MAX_FLAP_HT = 8;
    public static final int FLAP_MARGIN = 4;
    public static final int TINY_FLAP_WD = 10;
    public static final int MIN_FLAP_WD = 75;
    public static final int CONTENTS_FLAG_X = 3;
    public static final int CONTENTS_FLAG_Y = 9;
    public static final int CONTENTS_FLAG_DIM = 8;
    public static final int CONTENTS_FLAG_X_RESERVE = 11;
    public static final int CONTENTS_FLAG_Y_RESERVE = 17;
    private EntityInstance m_entityInstance;
    private double m_avgX;
    private Cardinal[] m_dstCardinals;
    private SrcCardinal[] m_srcCardinals;

    public EntityComponent(EntityInstance entityInstance) {
        this.m_entityInstance = entityInstance;
        this.setLayout(null);
        entityInstance.setSwingObject(this);
        this.setBounds(entityInstance.getX(), entityInstance.getY(), entityInstance.getWidth(), entityInstance.getHeight());
    }

    public String toString() {
        return "EntityComponent: " + this.m_entityInstance.toString();
    }

    public EntityInstance getEntityInstance() {
        return this.m_entityInstance;
    }

    public void resetDstCardinals(int n) {
        if (this.m_dstCardinals == null) {
            if (n > 0) {
                this.m_dstCardinals = new Cardinal[n];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Cardinal cardinal = this.m_dstCardinals[i];
                if (cardinal == null) continue;
                cardinal.reset();
            }
        }
    }

    public Cardinal[] getDstCardinals() {
        return this.m_dstCardinals;
    }

    public void resetSrcCardinals(int n) {
        if (this.m_srcCardinals == null) {
            if (n > 0) {
                this.m_srcCardinals = new SrcCardinal[n];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                SrcCardinal srcCardinal = this.m_srcCardinals[i];
                if (srcCardinal == null) continue;
                srcCardinal.reset();
            }
        }
    }

    public Cardinal[] getSrcCardinals() {
        return this.m_srcCardinals;
    }

    public void setAvgX(double d) {
        this.m_avgX = d;
    }

    public double getAvgX() {
        return this.m_avgX;
    }

    protected void setGraphicsColor(Graphics graphics, Color color, EntityInstance entityInstance) {
        if (color != null) {
            graphics.setColor(color);
        } else if (entityInstance.red_closed()) {
            graphics.setColor(Color.red.darker());
        } else {
            graphics.setColor(entityInstance.getCurrentObjectColor());
        }
    }

    public void paintShape(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Color color) {
        if (n3 > 0 && n4 > 0) {
            EntityInstance entityInstance = this.m_entityInstance;
            switch (entityInstance.getStyle()) {
                case 0: {
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fill3DRect(n + 1, n2 + 1, n3 - 1, n4 - 1, true);
                    }
                    this.setGraphicsColor(graphics, null, entityInstance);
                    graphics.draw3DRect(n, n2, n3, n4, true);
                    break;
                }
                case 1: {
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillRect(n, n2, n3, n4);
                    }
                    graphics.setColor(Color.black);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    break;
                }
                case 2: {
                    int n5 = Math.min(Math.min(n3, n4) / 2, 8);
                    int[] nArray = new int[6];
                    int[] nArray2 = new int[6];
                    nArray[0] = n;
                    nArray2[0] = n2;
                    nArray[1] = n + n3 - n5;
                    nArray2[1] = n2;
                    nArray[2] = n + n3 - 1;
                    nArray2[2] = n2 + n5;
                    nArray[3] = nArray[2];
                    nArray2[3] = n2 + n4 - 1;
                    nArray[4] = n;
                    nArray2[4] = nArray2[3];
                    nArray[5] = nArray[0];
                    nArray2[5] = nArray2[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray, nArray2, 6);
                    }
                    graphics.setColor(Color.darkGray);
                    graphics.drawPolygon(nArray, nArray2, 6);
                    nArray[0] = nArray[1];
                    nArray2[0] = nArray2[2];
                    nArray[3] = nArray[0];
                    nArray2[3] = nArray2[0];
                    graphics.drawPolygon(nArray, nArray2, 4);
                    break;
                }
                case 3: {
                    int n6 = Math.min(Math.min(n3, n4) / 2, 8);
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillRect(n, n2 + n6 / 2, n3, n4 - n6);
                        graphics.fillOval(n, n2, n3, n6);
                        graphics.fillOval(n, n2 + n4 - n6, n3, n6);
                    }
                    graphics.setColor(Color.black);
                    graphics.drawOval(n, n2, n3, n6);
                    graphics.drawArc(n, n2 + n4 - n6 - 1, n3, n6, 180, 180);
                    graphics.drawLine(n, n2 + n6 / 2, n, n2 + n4 - n6 / 2);
                    graphics.drawLine(n + n3 - 1, n2 + n6 / 2, n + n3 - 1, n2 + n4 - n6 / 2);
                    break;
                }
                case 4: {
                    int n7 = (int)((double)n3 * 0.4);
                    int n8 = Math.max(3, Math.min(8, (int)((double)n4 * 0.2)));
                    int n9 = 4;
                    if (n7 < 75) {
                        n7 += n7 / 2;
                    }
                    if (n7 < 10) {
                        n7 = Math.min(n7 + 4, n3 - n3 / 3);
                        n9 = 0;
                    }
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillRect(n, n2, n3 - 1, n4 - 1);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    int n10 = n;
                    int n11 = n2 + n8;
                    int n12 = n + n3 - 1;
                    int n13 = n11;
                    if (entityInstance.isOpen()) {
                        graphics.drawLine(n10, n11, n12, n13);
                        break;
                    }
                    int n14 = n + n9;
                    int n15 = n2 + n8;
                    graphics.drawLine(n10, n11, n14, n15);
                    int n16 = n14 + n8 / 2;
                    int n17 = n2;
                    graphics.drawLine(n14, n15, n16, n17);
                    int n18 = n + n7;
                    int n19 = n17;
                    graphics.drawLine(n16, n17, n18, n19);
                    int n20 = n18 + n8 / 2;
                    int n21 = n11;
                    graphics.drawLine(n18, n19, n20, n21);
                    graphics.drawLine(n20, n21, n12, n13);
                    break;
                }
                case 5: {
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillOval(n, n2, n3, n4);
                    }
                    graphics.setColor(this.m_entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawOval(n, n2, n3, n4);
                    break;
                }
                case 6: {
                    int n22 = n3 / 5;
                    int n23 = n4 / 5;
                    int n24 = Math.min(n22, n23);
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillRoundRect(n, n2, n3, n4, n24, n24);
                    }
                    graphics.setColor(Color.black);
                    graphics.drawRoundRect(n, n2, n3, n4, n24, n24);
                    break;
                }
                case 7: {
                    Util.drawOutlineBox(graphics, n, n2, n3, n4, true);
                    break;
                }
                case 8: {
                    Util.drawGroupBox(graphics, n, n2, n3, n4, entityInstance.getEntityLabel(), true);
                }
            }
        }
    }

    public void paintMap(Graphics graphics, int n, int n2, int n3, int n4, EntityInstance entityInstance, int n5) {
        if (n3 > 0 && n4 > 0) {
            EntityInstance entityInstance2 = this.m_entityInstance;
            Color color = entityInstance2 == entityInstance ? Color.green : entityInstance2.getObjectColor();
            this.paintShape(graphics, n, n2, n3, n4, !entityInstance2.hasChildren() || n5 == 1, color);
            if (n5 < 1) {
                Enumeration enumeration = entityInstance2.getChildren();
                while (enumeration.hasMoreElements()) {
                    EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
                    int n6 = n + (int)((double)n3 * entityInstance3.xRelLocal());
                    int n7 = n2 + (int)((double)n4 * entityInstance3.yRelLocal());
                    int n8 = (int)((double)n3 * entityInstance3.widthRelLocal());
                    int n9 = (int)((double)n4 * entityInstance3.heightRelLocal());
                    entityInstance3.paintMap(graphics, n6, n7, n8, n9, entityInstance, n5 + 1);
                }
            }
        }
    }

    protected void drawTopLeftLabel(Graphics graphics) {
        EntityInstance entityInstance = this.m_entityInstance;
        switch (entityInstance.getStyle()) {
            case 4: {
                graphics.setFont(EntityInstance.getSmallFont());
                int n = (int)((double)this.getWidth() * 0.4);
                int n2 = Math.max(3, Math.min(8, (int)((double)this.getHeight() * 0.2)));
                if (n < 75) {
                    n += n / 2;
                }
                if (n < 10) {
                    n = Math.min(n + 4, this.getWidth() - this.getWidth() / 3);
                }
                Util.drawStringClipped(graphics, entityInstance.getEntityLabel(), 4 + n2 / 2 + 2, 0.0, n, this.getHeight() - 10);
                break;
            }
            case 6: {
                graphics.setFont(EntityInstance.getOpenClassFont());
                Util.drawStringClipped(graphics, entityInstance.getEntityLabel(), 15.0, 5.0, this.getWidth() - 10, this.getHeight() - 10);
                break;
            }
            default: {
                graphics.setFont(EntityInstance.getSmallFont());
                Util.drawStringClipped(graphics, entityInstance.getEntityLabel(), 5.0, 5.0, this.getWidth() - 10, this.getHeight() - 10);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        EntityInstance entityInstance = this.m_entityInstance;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = 5;
        this.paintShape(graphics, 0, 0, n2, n3, true, null);
        Diagram diagram = entityInstance.getDiagram();
        LandscapeEditorCore landscapeEditorCore = diagram.getLs();
        if (landscapeEditorCore.isShowGrid() && entityInstance == diagram.getDrawRoot() && (n = diagram.getGrid()) > 1) {
            int n5;
            graphics.setColor(Color.WHITE);
            for (n5 = n; n5 < n3; n5 += n) {
                graphics.drawLine(0, n5, n2 - 1, n5);
            }
            for (n5 = n; n5 < n2; n5 += n) {
                graphics.drawLine(n5, 0, n5, n3 - 1);
            }
        }
        if (entityInstance.isMarked(4096)) {
            graphics.setColor(Color.white);
            graphics.drawRect(0, 0, n2, n3);
            graphics.drawRect(1, 1, n2 - 1, n3 - 1);
        }
        if (entityInstance.close_with_children_under_drawroot() && n2 > 11 && n3 > 17) {
            graphics.setColor(ColorCache.getInverse(entityInstance.getObjectColor().getRGB()));
            graphics.drawRect(3, 9, 8, 8);
            graphics.drawLine(4, 13, 10, 13);
            graphics.drawLine(7, 10, 7, 16);
            n4 += 11;
        }
        graphics.setColor(entityInstance.getCurrentLabelColor());
        switch (entityInstance.getStyle()) {
            case 8: {
                Util.drawGroupBoxLabel(graphics, 0, 0, n2, entityInstance.getEntityLabel());
                break;
            }
            default: {
                if (entityInstance.isOpen()) {
                    this.drawTopLeftLabel(graphics);
                    break;
                }
                String string = entityInstance.getEntityLabel();
                if (!entityInstance.isMarked(6)) {
                    graphics.setFont(entityInstance.getAdjustedClosedFont());
                } else {
                    graphics.setFont(ClientSupplierSet.getClientSupplierFont());
                    EntityInstance entityInstance2 = entityInstance.getEnterableParent();
                    if (entityInstance2 != null) {
                        string = entityInstance2.getEntityLabel() + " .\n" + string;
                    }
                }
                Util.drawStringWrapped(graphics, string, n4, 5.0, this.getWidth() - 5 - n4, this.getHeight() - 10, true, false);
            }
        }
        if (entityInstance.getGroupFlag()) {
            graphics.setColor(entityInstance.getLabelColor());
            int n6 = n = n3 < 20 ? 4 : 6;
            if (entityInstance.getGroupKeyFlag()) {
                graphics.fillRect(1, 1, n, n);
                graphics.fillRect(n2 / 2 - n / 2, 1, n, n);
                graphics.fillRect(n2 - n, 1, n, n);
                graphics.fillRect(1, n3 / 2 - n / 2, n, n);
                graphics.fillRect(n2 - n, n3 / 2 - n / 2, n, n);
                graphics.fillRect(1, n3 - n, n, n);
                graphics.fillRect(n2 / 2 - n / 2, n3 - n, n, n);
                graphics.fillRect(n2 - n, n3 - n, n, n);
            } else {
                graphics.drawRect(1, 1, n, n);
                graphics.drawRect(n2 / 2 - n / 2, 1, n, n);
                graphics.drawRect(n2 - n - 1, 1, n, n);
                graphics.drawRect(1, n3 / 2 - n / 2, n, n);
                graphics.drawRect(n2 - n - 1, n3 / 2 - n / 2, n, n);
                graphics.drawRect(1, n3 - n - 1, n, n);
                graphics.drawRect(n2 / 2 - n / 2, n3 - n - 1, n, n);
                graphics.drawRect(n2 - n - 1, n3 - n - 1, n, n);
            }
        }
    }

    public int getIconWidth() {
        return this.getWidth();
    }

    public int getIconHeight() {
        return this.getHeight();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.translate(n, n2);
        this.paintComponent(graphics);
    }
}

