/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.RelationInstance;

public class GroupModeHandler
extends LandscapeModeHandler {
    protected static final int NONE = 0;
    protected static final int GROUPING = 1;
    protected static final int SINGLE_MOVE = 2;
    protected DrawOutline m_drawOutline;
    protected Vector m_groupList = null;
    protected Rectangle m_grpLayout;
    protected int m_curX;
    protected int m_curY;
    protected Rectangle m_shift = null;
    protected EditModeHandler m_parent;
    protected int m_groupMode = 0;
    protected double m_dx;
    protected double m_dy;
    private boolean m_seen_motion;
    private Rectangle m_rect;

    protected void setShift(int n, int n2, int n3, int n4) {
        if (this.m_shift == null) {
            Diagram diagram = this.m_ls.getDiagram();
            this.m_shift = new Rectangle(n, n2, n3, n4);
            this.m_drawOutline.setBounds(0, 0, diagram.getWidth(), diagram.getHeight());
            this.m_drawOutline.setVisible(true);
            diagram.add((Component)this.m_drawOutline, 0);
        } else {
            this.m_shift.setBounds(n, n2, n3, n4);
            this.m_drawOutline.repaint();
        }
    }

    protected EntityInstance findOverlap(Rectangle rectangle) {
        Diagram diagram = this.m_ls.getDiagram();
        double d = rectangle.x - this.m_grpLayout.x;
        double d2 = rectangle.y - this.m_grpLayout.y;
        EntityInstance entityInstance = diagram.getKeyEntity();
        Rectangle rectangle2 = entityInstance.getDiagramBounds();
        rectangle2.x = (int)((double)rectangle2.x + d);
        rectangle2.y = (int)((double)rectangle2.y + d2);
        EntityInstance entityInstance2 = diagram.intersects(rectangle);
        if (entityInstance2 != null && !this.m_groupList.contains(entityInstance2)) {
            return entityInstance2;
        }
        Enumeration enumeration = this.m_groupList.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            rectangle2 = entityInstance.getDiagramBounds();
            rectangle2.x = (int)((double)rectangle2.x + d);
            rectangle2.y = (int)((double)rectangle2.y + d2);
            entityInstance2 = diagram.intersects(rectangle);
            if (entityInstance2 == null || this.m_groupList.contains(entityInstance2)) continue;
            return entityInstance2;
        }
        return null;
    }

    protected void moveGroup(EntityInstance entityInstance, double d, double d2, Diagram diagram) {
        Enumeration enumeration;
        int n;
        int n2 = diagram.getGrid();
        EntityInstance entityInstance2 = (EntityInstance)this.m_groupList.firstElement();
        boolean bl = entityInstance2.getContainedBy() != entityInstance;
        int n3 = 0;
        int n4 = 0;
        if (bl) {
            Rectangle rectangle;
            n = entityInstance.numChildren();
            if (n == 0) {
                rectangle = entityInstance2.getContainedBy().getDiagramBounds();
                Rectangle rectangle2 = entityInstance.getDiagramBounds();
                double d3 = (double)rectangle2.width / (double)rectangle.width;
                double d4 = (double)rectangle2.height / (double)rectangle.height;
                Rectangle rectangle3 = entityInstance2.getDiagramBounds();
                n3 = (int)((double)rectangle3.width * d3);
                n4 = (int)((double)rectangle3.height * d4);
            } else {
                enumeration = entityInstance.getChildren();
                while (enumeration.hasMoreElements()) {
                    entityInstance2 = (EntityInstance)enumeration.nextElement();
                    rectangle = entityInstance2.getDiagramBounds();
                    n3 += rectangle.width;
                    n4 += rectangle.height;
                }
                n3 /= n;
                n4 /= n;
            }
        }
        enumeration = this.m_groupList.elements();
        while (enumeration.hasMoreElements()) {
            int n5;
            int n6;
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            n = entityInstance2.getX();
            int n7 = entityInstance2.getY();
            int n8 = n;
            int n9 = n7;
            if (n2 <= 1) {
                n8 = (int)((double)n8 + d);
                n9 = (int)((double)n9 + d2);
            } else {
                if (d != 0.0) {
                    n8 = (int)((double)n8 + d);
                    n8 = n8 / n2 * n2;
                }
                if (d2 != 0.0) {
                    n9 = (int)((double)n9 + d2);
                    n9 = n9 / n2 * n2;
                }
            }
            if (bl) {
                entityInstance2.moveEntityContainment(entityInstance);
                n6 = n3;
                n5 = n4;
            } else {
                n6 = entityInstance2.getWidth();
                n5 = entityInstance2.getHeight();
            }
            entityInstance2.updateDiagramBounds(entityInstance.getDiagramX() + n8, entityInstance.getDiagramY() + n9, n6, n5);
        }
        if (bl) {
            diagram.prepostorder();
        }
        enumeration = this.m_groupList.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            entityInstance2.validateEdges();
        }
    }

    protected void moveGroup(EntityInstance entityInstance, Diagram diagram) {
        double d = this.m_shift.x - this.m_grpLayout.x;
        double d2 = this.m_shift.y - this.m_grpLayout.y;
        this.moveGroup(entityInstance, d, d2, diagram);
    }

    protected void setAsKeyEntity(EntityInstance entityInstance) {
        Diagram diagram = this.m_ls.getDiagram();
        diagram.setKeyEntity(entityInstance);
    }

    protected void selectEntity(EntityInstance entityInstance) {
        Diagram diagram = this.m_ls.getDiagram();
        diagram.setPreserveEntityMarks(196608);
        diagram.setPreserveRelationMarks(0);
        if (entityInstance.getGroupFlag()) {
            if (entityInstance != diagram.getKeyEntity()) {
                this.setAsKeyEntity(entityInstance);
            }
        } else {
            EntityInstance entityInstance2 = diagram.getKeyEntity();
            if (entityInstance2 != null) {
                boolean bl = diagram.clearFlags();
                diagram.setKeyEntity(entityInstance);
                if (bl) {
                    this.m_ls.repaintDg();
                }
            } else {
                this.setAsKeyEntity(entityInstance);
            }
        }
        this.m_ls.show_groupList();
    }

    protected void toggleMembership(EntityInstance entityInstance) {
        Diagram diagram = this.m_ls.getDiagram();
        if (entityInstance.getGroupFlag()) {
            if (entityInstance == diagram.getKeyEntity()) {
                Vector vector = diagram.getGroup();
                if (vector.size() == 1) {
                    diagram.clearFlags();
                    entityInstance.repaint();
                } else {
                    entityInstance.clearGroupFlag();
                    vector = diagram.getGroup();
                    EntityInstance entityInstance2 = (EntityInstance)vector.firstElement();
                    this.setAsKeyEntity(entityInstance2);
                }
            } else {
                entityInstance.clearGroupFlag();
                entityInstance.repaint();
            }
        } else {
            EntityInstance entityInstance3;
            Vector vector = diagram.getGroup();
            if (vector != null && (entityInstance3 = (EntityInstance)vector.firstElement()).getContainedBy() != entityInstance.getContainedBy()) {
                this.selectEntity(entityInstance);
                return;
            }
            this.setAsKeyEntity(entityInstance);
        }
        this.m_ls.show_groupList();
    }

    protected boolean groupingStart(MouseEvent mouseEvent, int n, int n2) {
        this.m_curX = n;
        this.m_curY = n2;
        this.cleanup();
        return true;
    }

    protected void groupingMotion(MouseEvent mouseEvent, Object object, int n, int n2) {
        if (object instanceof EntityInstance) {
            int n3;
            int n4;
            int n5;
            int n6;
            EntityInstance entityInstance = (EntityInstance)object;
            int n7 = n;
            int n8 = n2;
            Rectangle rectangle = entityInstance.getDiagramBounds();
            if (n7 < rectangle.x + 4) {
                n7 = rectangle.x + 4;
            } else if (n7 > rectangle.x + rectangle.width - 4) {
                n7 = rectangle.x + rectangle.width - 4;
            }
            if (n8 < rectangle.y + 4) {
                n8 = rectangle.y + 4;
            } else if (n8 > rectangle.y + rectangle.height - 4) {
                n8 = rectangle.y + rectangle.height - 4;
            }
            if (n7 > this.m_curX) {
                n6 = this.m_curX;
                n5 = n7 - this.m_curX;
            } else {
                n6 = n7;
                n5 = this.m_curX - n7;
            }
            if (n8 > this.m_curY) {
                n4 = this.m_curY;
                n3 = n2 - this.m_curY;
            } else {
                n4 = n2;
                n3 = this.m_curY - n2;
            }
            this.setShift(n6, n4, n5, n3);
            this.m_rect = this.m_shift;
            this.m_drawOutline.repaint();
        }
    }

    protected void groupingEnd(MouseEvent mouseEvent) {
        Diagram diagram = this.m_ls.getDiagram();
        Vector vector = diagram.setGroupRegion(this.m_shift);
        if (vector != null) {
            this.m_ls.show_groupList();
            diagram.setKeyEntity((EntityInstance)vector.firstElement());
            this.m_rect = null;
        } else {
            this.m_rect = this.m_shift;
        }
        this.m_drawOutline.repaint();
    }

    protected boolean moveGroupStart(MouseEvent mouseEvent, int n, int n2) {
        Diagram diagram = this.m_ls.getDiagram();
        this.m_groupList = diagram.getGroup();
        this.m_seen_motion = false;
        if (this.m_groupList == null) {
            return false;
        }
        EntityInstance entityInstance = ((EntityInstance)this.m_groupList.firstElement()).getContainedBy();
        if (entityInstance == null) {
            return false;
        }
        this.m_grpLayout = diagram.getGroupBoundingBox();
        this.setShift(this.m_grpLayout.x, this.m_grpLayout.y, this.m_grpLayout.width, this.m_grpLayout.height);
        this.m_dx = n - this.m_shift.x;
        this.m_dy = n2 - this.m_shift.y;
        if (this.m_groupList.size() == 1) {
            this.m_ls.doFeedback("Moving entity: (" + this.m_shift.x + ", " + this.m_shift.y + ")");
        } else {
            this.m_ls.doFeedback("Moving group (key): (" + this.m_shift.x + ", " + this.m_shift.y + ")");
        }
        return true;
    }

    protected void moveGroupMotion(MouseEvent mouseEvent, int n, int n2) {
        Diagram diagram = this.m_ls.getDiagram();
        EntityInstance entityInstance = (EntityInstance)this.m_groupList.firstElement();
        EntityInstance entityInstance2 = entityInstance.getContainedBy();
        EntityInstance entityInstance3 = diagram.getDrawRoot();
        if (!this.m_seen_motion) {
            this.m_seen_motion = true;
        }
        int n3 = diagram.getGrid();
        int n4 = n - (int)this.m_dx;
        int n5 = n2 - (int)this.m_dy;
        int n6 = entityInstance2.getDiagramX();
        int n7 = entityInstance2.getDiagramY();
        n4 -= n6;
        n5 -= n7;
        n4 = n4 / n3 * n3;
        n5 = n5 / n3 * n3;
        n4 += n6;
        n5 += n7;
        int n8 = entityInstance3.getDiagramX();
        int n9 = entityInstance3.getDiagramY();
        int n10 = entityInstance3.getWidth();
        int n11 = entityInstance3.getHeight();
        int n12 = n8 + 4;
        if (n4 < n12) {
            n4 = n12;
        }
        if (n5 < (n12 = n9 + 4)) {
            n5 = n12;
        }
        if (n4 > (n12 = n8 + n10 - 8 - this.m_shift.width)) {
            n4 = n12;
        }
        if (n5 > (n12 = n9 + n11 - 8 - this.m_shift.height)) {
            n5 = n12;
        }
        this.m_shift.x = n4;
        this.m_shift.y = n5;
        if (this.m_groupList.size() == 1) {
            this.m_ls.doFeedback("Moving entity: (" + this.m_shift.x + ", " + this.m_shift.y + ")");
        } else {
            this.m_ls.doFeedback("Moving group (key): (" + this.m_shift.x + ", " + this.m_shift.y + ")");
        }
        this.m_drawOutline.repaint();
    }

    protected void moveGroupEnd(MouseEvent mouseEvent) {
        boolean bl;
        this.m_ls.clearFeedback();
        if (!this.m_seen_motion) {
            this.cleanup();
            return;
        }
        Diagram diagram = this.m_ls.getDiagram();
        EntityInstance entityInstance = diagram.getKeyEntity();
        double d = this.m_shift.x - this.m_grpLayout.x;
        double d2 = this.m_shift.y - this.m_grpLayout.y;
        Rectangle rectangle = entityInstance.getDiagramBounds();
        rectangle.x = (int)((double)rectangle.x + d);
        rectangle.y = (int)((double)rectangle.y + d2);
        EntityInstance entityInstance2 = diagram.containing(rectangle);
        if (entityInstance2 == null) {
            this.m_ls.error("Failed to find container");
            this.cleanup();
            return;
        }
        boolean bl2 = bl = entityInstance2 != entityInstance.getContainedBy();
        if (this.m_groupList.contains(entityInstance2)) {
            entityInstance2 = entityInstance2.getContainedBy();
        }
        diagram.beginUndoRedo("Group Move");
        this.moveGroup(entityInstance2, diagram);
        if (bl) {
            this.m_ls.doFeedback("Group move into: " + entityInstance2.getEntityLabel());
        }
        diagram.endUndoRedo();
        this.cleanup();
    }

    public GroupModeHandler(EditModeHandler editModeHandler) {
        super(editModeHandler.m_ls);
        this.m_parent = editModeHandler;
        this.m_drawOutline = new DrawOutline();
    }

    public void cleanup() {
        Diagram diagram = this.m_ls.getDiagram();
        this.m_shift = null;
        this.m_rect = null;
        this.m_drawOutline.setVisible(false);
        diagram.remove(this.m_drawOutline);
        this.m_ls.setCursor(0);
        this.m_groupMode = 0;
    }

    public Vector getGroupList() {
        return this.m_groupList;
    }

    public void moveGroup(int n) {
        Diagram diagram = this.m_ls.getDiagram();
        int n2 = diagram.getGrid();
        this.m_groupList = diagram.getGroup();
        if (this.m_groupList == null) {
            return;
        }
        EntityInstance entityInstance = diagram.getKeyEntity().getContainedBy();
        double d = 0.0;
        double d2 = 0.0;
        switch (n) {
            case 38: {
                d2 = -n2;
                break;
            }
            case 40: {
                d2 = n2;
                break;
            }
            case 39: {
                d = n2;
                break;
            }
            case 37: {
                d = -n2;
            }
        }
        this.moveGroup(entityInstance, d, d2, diagram);
    }

    public void entityPressed(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        Diagram diagram = this.m_ls.getDiagram();
        if (mouseEvent.isShiftDown()) {
            if (mouseEvent.isAltDown()) {
                this.m_groupMode = 1;
                if (this.groupingStart(mouseEvent, n, n2)) {
                    this.m_parent.setSubHandler(this);
                }
                return;
            }
            if (entityInstance != diagram.getDrawRoot()) {
                if (mouseEvent.isMetaDown()) {
                    this.setAsKeyEntity(entityInstance);
                } else {
                    this.toggleMembership(entityInstance);
                }
            }
        } else {
            if (entityInstance != diagram.getDrawRoot() && !entityInstance.isClientOrSupplier()) {
                this.selectEntity(entityInstance);
                this.m_ls.setCursor(13);
                this.m_groupMode = 2;
                if (this.moveGroupStart(mouseEvent, n, n2)) {
                    this.m_parent.setSubHandler(this);
                }
                return;
            }
            this.selectEntity(entityInstance);
        }
        this.m_groupMode = 0;
    }

    public void entityDragged(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        switch (this.m_groupMode) {
            case 1: {
                this.groupingMotion(mouseEvent, entityInstance, n, n2);
                break;
            }
            case 2: {
                this.moveGroupMotion(mouseEvent, n, n2);
            }
        }
    }

    public void entityReleased(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        switch (this.m_groupMode) {
            case 1: {
                this.groupingEnd(mouseEvent);
                break;
            }
            case 2: {
                this.moveGroupEnd(mouseEvent);
                break;
            }
            default: {
                return;
            }
        }
        this.m_parent.cleanup();
    }

    public void relationPressed(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        relationInstance.setGroupAndHighlightFlag();
        this.m_parent.cleanup();
    }

    protected class DrawOutline
    extends JComponent {
        public DrawOutline() {
            this.setForeground(Color.BLACK);
        }

        public void paintComponent(Graphics graphics) {
            Rectangle rectangle = GroupModeHandler.this.m_rect;
            Rectangle rectangle2 = GroupModeHandler.this.m_shift;
            if (rectangle != null) {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (rectangle2 != null) {
                Rectangle rectangle3 = GroupModeHandler.this.m_grpLayout;
                int n = rectangle2.x - rectangle3.x;
                int n2 = rectangle2.y - rectangle3.y;
                Enumeration enumeration = GroupModeHandler.this.m_groupList.elements();
                while (enumeration.hasMoreElements()) {
                    EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                    graphics.drawRect(entityInstance.getDiagramX() + n, entityInstance.getDiagramY() + n2, entityInstance.getWidth(), entityInstance.getHeight());
                }
            }
        }
    }
}

