/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;
import lsedit.HiGraphLayout;
import lsedit.HiSimplex;

class HiGraphCoordinates {
    static final boolean debug = false;

    HiGraphCoordinates() {
    }

    private static void postorder(HiGraph hiGraph, int n) {
        int n2 = n;
        hiGraph.m_minbeneath = n;
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            HiGraphCoordinates.postorder(hiGraph2, n2);
            n2 = hiGraph2.m_postorder + 1;
        }
        hiGraph.m_postorder = n2;
    }

    private static HiGraph auxGraph(HiGraphLayout hiGraphLayout, HiGraph hiGraph) throws HiGraphException {
        HiGraph hiGraph2;
        int n;
        int n2;
        Vector vector;
        HiGraph hiGraph3;
        HiArc hiArc;
        int n3;
        int n4;
        int n5 = hiGraphLayout.outside_bias();
        int n6 = hiGraphLayout.weight_1dummy();
        int n7 = hiGraphLayout.weight_2dummy();
        boolean bl = hiGraphLayout.hasBends();
        int n8 = hiGraph.m_xGap;
        if (n8 < 0) {
            n8 = hiGraphLayout.xgap();
        }
        int n9 = n4 = hiGraph.m_horizontalArray ? 100 : 0;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        HiGraph hiGraph4 = new HiGraph(null, hiGraph.label(), 0, hiGraph.height());
        Vector vector2 = hiGraph.m_children;
        int n10 = vector2.size();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n3 = 0; n3 < n10; ++n3) {
            HiGraph hiGraph5;
            hiArc = (HiArc)vector2.elementAt(n3);
            hiGraph3 = hiArc.to();
            hiGraph3.m_duplicate = hiGraph5 = hiGraph4.newChild(hiGraph3.getReferencedObject(), hiGraph3.label(), hiGraph3.width(), hiGraph3.height());
            hiGraph5.m_duplicate = hiGraph3;
            if (hiGraph3.m_outside > 0) {
                bl2 = true;
                continue;
            }
            if (hiGraph3.m_outside >= 0) continue;
            bl3 = true;
        }
        for (n3 = 0; n3 < n10; ++n3) {
            hiArc = (HiArc)vector2.elementAt(n3);
            hiGraph3 = hiArc.to();
            vector = hiGraph3.m_duplicate.m_out;
            n2 = 0;
            block2: for (n = n3 + 1; n < n10; ++n) {
                hiArc = (HiArc)vector2.elementAt(n);
                hiGraph2 = hiArc.to();
                if (hiGraph3.m_rank < hiGraph2.m_rank ? hiGraph3.m_sink_rank <= hiGraph2.m_rank : hiGraph3.m_rank > hiGraph2.m_sink_rank || hiGraph3.m_rank == hiGraph2.m_sink_rank && hiGraph2.m_children.size() > 0) continue;
                for (int i = 0; i < n2; ++i) {
                    hiArc = (HiArc)vector.elementAt(i);
                    HiGraph hiGraph6 = hiArc.to().m_duplicate;
                    if (!(hiGraph6.m_rank < hiGraph2.m_rank ? hiGraph6.m_sink_rank <= hiGraph2.m_rank : hiGraph6.m_rank > hiGraph2.m_sink_rank || hiGraph6.m_rank == hiGraph2.m_sink_rank && hiGraph2.m_children.size() > 0)) continue block2;
                }
                bl4 = true;
                hiArc = hiGraph2.m_duplicate.newInputArc(hiGraph3.m_duplicate);
                int n11 = n8 + (hiGraph2.m_width + hiGraph3.m_width) / 2;
                if (!bl) {
                    if (hiGraph2.dummyNode() != 0 && hiGraph3.dummyNode() != 0) {
                        n11 = 0;
                    } else if (hiGraph2.dummyNode() != 0) {
                        n11 = n8 + hiGraph3.m_width / 2;
                    } else if (hiGraph3.dummyNode() != 0) {
                        n11 = hiGraph2.m_width / 2;
                    }
                }
                if (n11 < 0) {
                    throw new HiGraphException("Negative distance between nodes " + hiGraph3 + " and " + hiGraph2);
                }
                hiArc.minlength(n11);
                hiArc.weight(n4);
                ++n2;
            }
        }
        HiGraph hiGraph7 = null;
        HiGraph hiGraph8 = null;
        if (n5 != 0 && (bl3 || bl2) && bl4) {
            if (bl2) {
                hiGraph8 = hiGraph4.newChild(null, "right", 0, 0);
            }
            if (bl3) {
                hiGraph7 = hiGraph4.newChild(null, "left", 0, 0);
            }
        }
        for (n3 = 0; n3 < n10; ++n3) {
            HiGraph hiGraph9;
            int n12;
            hiArc = (HiArc)vector2.elementAt(n3);
            hiGraph3 = hiArc.to();
            if (hiGraph7 != null && hiGraph3.m_duplicate.m_in.size() == 0) {
                hiArc = hiGraph3.m_duplicate.newInputArc(hiGraph7);
                hiArc.minlength(0);
                hiArc.weight(0);
            }
            if (hiGraph8 != null && hiGraph3.m_duplicate.m_out.size() == 0) {
                hiArc = hiGraph8.newInputArc(hiGraph3.m_duplicate);
                hiArc.minlength(0);
                hiArc.weight(0);
            }
            if (hiGraph3.m_outside > 0) {
                hiGraph2 = hiGraph8;
                n12 = hiGraph3.m_outside;
            } else if (hiGraph3.m_outside < 0) {
                hiGraph2 = hiGraph7;
                n12 = 0 - hiGraph3.m_outside;
            } else {
                hiGraph2 = null;
                n12 = 0;
            }
            if (hiGraph2 != null) {
                hiGraph9 = hiGraph4.newChild(null, "fork1", 0, 0);
                hiArc = hiGraph3.m_duplicate.newInputArc(hiGraph9);
                hiArc.minlength(0);
                hiArc.weight(n12 *= n5);
                hiArc = hiGraph2.newInputArc(hiGraph9);
                hiArc.minlength(0);
                hiArc.weight(n12);
            }
            vector = hiGraph3.m_out;
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                hiArc = (HiArc)vector.elementAt(n);
                hiGraph2 = hiArc.to();
                if (hiGraph2.m_parent == null || hiGraph2.m_parent.from() != hiGraph) continue;
                hiGraph9 = hiGraph4.newChild(null, "fork2", 0, 0);
                n12 = hiGraph3.m_dummy_node != 0 && hiGraph2.m_dummy_node != 0 ? n7 : (hiGraph3.m_dummy_node == 0 && hiGraph2.m_dummy_node == 0 ? 1 : n6);
                hiArc = hiGraph3.m_duplicate.newInputArc(hiGraph9);
                hiArc.minlength(0);
                hiArc.weight(n12);
                hiArc = hiGraph2.m_duplicate.newInputArc(hiGraph9);
                hiArc.minlength(0);
                hiArc.weight(n12);
            }
        }
        return hiGraph4;
    }

    private static void balance(HiGraph hiGraph, HiGraph hiGraph2) {
        int n;
        HiGraph hiGraph3;
        HiArc hiArc;
        int n2;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        Vector vector = hiGraph2.m_in;
        int n5 = vector.size();
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            hiArc = (HiArc)vector.elementAt(n2);
            if (hiArc.weight() != 0 || (hiGraph3 = hiArc.to()) != hiGraph2) continue;
            hiGraph3 = hiArc.from();
            n = hiGraph3.m_rank + hiArc.minlength();
            if (n <= n3) continue;
            n3 = n;
        }
        vector = hiGraph2.m_out;
        n5 = vector.size();
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            hiArc = (HiArc)vector.elementAt(n2);
            if (hiArc.weight() != 0 || (hiGraph3 = hiArc.from()) != hiGraph2) continue;
            hiGraph3 = hiArc.to();
            n = hiGraph3.m_rank - hiArc.minlength();
            if (n >= n4) continue;
            n4 = n;
        }
        if (n4 <= n3) {
            return;
        }
        vector = hiGraph.m_in;
        n5 = vector.size();
        int n6 = 0;
        int n7 = 0;
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            hiArc = (HiArc)vector.elementAt(n2);
            hiGraph3 = hiArc.from();
            if (hiGraph3.m_duplicate == null) continue;
            n6 += hiGraph3.m_duplicate.m_rank;
            ++n7;
        }
        vector = hiGraph.m_out;
        n5 = vector.size();
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            hiArc = (HiArc)vector.elementAt(n2);
            hiGraph3 = hiArc.to();
            if (hiGraph3.m_duplicate == null) continue;
            n6 += hiGraph3.m_duplicate.m_rank;
            ++n7;
        }
        if (n7 != 0) {
            hiGraph2.m_rank = (n6 /= n7) < n3 ? n3 : (n6 > n4 ? n4 : n6);
        }
    }

    private static void local_xlayout(HiGraphLayout hiGraphLayout, HiGraph hiGraph, int n) throws HiGraphException {
        int n2;
        HiGraph hiGraph2;
        HiArc hiArc;
        int n3;
        int n4 = hiGraphLayout.xgap();
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        Vector vector = hiGraph.m_children;
        int n7 = vector.size();
        for (n3 = 0; n3 < n7; ++n3) {
            hiArc = (HiArc)vector.elementAt(n3);
            hiGraph2 = hiArc.to();
            HiGraphCoordinates.local_xlayout(hiGraphLayout, hiGraph2, n);
        }
        if (hiGraph.m_uniformWidth) {
            n2 = 0;
            for (n3 = 0; n3 < n7; ++n3) {
                hiArc = (HiArc)vector.elementAt(n3);
                hiGraph2 = hiArc.to();
                if (n2 >= hiGraph2.m_width) continue;
                n2 = hiGraph2.m_width;
            }
            for (n3 = 0; n3 < n7; ++n3) {
                hiArc = (HiArc)vector.elementAt(n3);
                hiGraph2 = hiArc.to();
                hiGraph2.m_width = n2;
            }
        }
        n2 = hiGraph.m_dummy_node != 0 ? 0 : hiGraph.width();
        n6 = 0;
        n5 = 0;
        if (n7 != 0) {
            HiGraph hiGraph3 = HiGraphCoordinates.auxGraph(hiGraphLayout, hiGraph);
            HiSimplex.simplex(hiGraph3, n);
            for (n3 = n7 - 1; n3 >= 0; --n3) {
                hiArc = (HiArc)vector.elementAt(n3);
                hiGraph2 = hiArc.to();
                HiGraph hiGraph4 = hiGraph2.m_duplicate;
                if (hiGraph2.m_in.size() == 0 || hiGraph2.m_out.size() == 0) {
                    HiGraphCoordinates.balance(hiGraph2, hiGraph4);
                }
                hiGraph2.m_x = hiGraph4.m_rank;
                int n8 = hiGraph2.m_x - hiGraph2.m_width / 2;
                if (n8 < n5) {
                    n5 = n8;
                }
                if ((n8 += hiGraph2.m_width) <= n6) continue;
                n6 = n8;
            }
            for (n3 = n7 - 1; n3 >= 0; --n3) {
                hiArc = (HiArc)vector.elementAt(n3);
                hiGraph2 = hiArc.to();
                hiGraph2.m_duplicate = null;
            }
            if ((n6 += n4) - (n5 -= n4) > n2) {
                n2 = n6 - n5;
            }
            hiGraph3.dispose();
        }
        hiGraph.m_x = 0;
        hiGraph.m_width = n2;
    }

    private static void global_xlayout(HiGraph hiGraph, int n) {
        HiGraph hiGraph2;
        HiArc hiArc;
        int n2;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        hiGraph.m_x += n;
        Vector vector = hiGraph.m_children;
        int n5 = vector.size();
        for (n2 = 0; n2 < n5; ++n2) {
            hiArc = (HiArc)vector.elementAt(n2);
            hiGraph2 = hiArc.to();
            int n6 = hiGraph2.m_x - hiGraph2.m_width / 2;
            if (n6 < n3) {
                n3 = n6;
            }
            if ((n6 += hiGraph2.m_width) <= n4) continue;
            n4 = n6;
        }
        n = hiGraph.m_x - (n4 + n3) / 2;
        for (n2 = 0; n2 < n5; ++n2) {
            hiArc = (HiArc)vector.elementAt(n2);
            hiGraph2 = hiArc.to();
            HiGraphCoordinates.global_xlayout(hiGraph2, n);
        }
    }

    private static void local_ylayout(HiGraphLayout hiGraphLayout, HiGraph hiGraph, int n) {
        HiGraph hiGraph2;
        HiArc hiArc;
        int n2 = hiGraph.height();
        int n3 = hiGraphLayout.ygap();
        int n4 = n2 + n3;
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            HiGraphCoordinates.local_ylayout(hiGraphLayout, hiGraph2, n);
        }
        if (hiGraph.m_dummy_node == 1) {
            int n5 = 0;
            hiGraph.m_height = 0;
            hiArc = (HiArc)hiGraph.m_out.elementAt(0);
            hiGraph2 = hiArc.to();
            hiArc = (HiArc)hiGraph.m_in.elementAt(0);
            HiGraph hiGraph3 = hiArc.from();
            if (hiGraph2.m_dummy_node == hiGraph3.m_dummy_node) {
                if (hiGraph2.m_dummy_node == 1) {
                    n5 = n2 / 2;
                } else {
                    hiGraph.width(0);
                    hiGraph.height(n4 - n3);
                    n5 = hiGraph.height() / 2;
                }
            } else if (hiGraph2.m_dummy_node != 1) {
                n5 = n2;
            }
            hiGraph.m_y = hiGraph.m_rank * n4 + n5;
        } else {
            int n6;
            int n7 = hiGraph.m_sink_rank - hiGraph.m_rank + 1;
            if (n7 < 0) {
                System.out.println("Caution: " + hiGraph + " has " + n7 + " ranks " + hiGraph.m_rank + "-" + hiGraph.m_sink_rank);
            }
            hiGraph.m_height = n7 * n4 - n3;
            if (n7 != 1) {
                hiGraph.m_height -= n2 + n3 / 2;
            }
            if ((n6 = hiGraph.height()) > hiGraph.m_height) {
                hiGraph.m_height = n6;
            }
            hiGraph.m_y = hiGraph.m_rank * n4;
        }
    }

    private static void global_ylayout(HiGraph hiGraph, int n) {
        HiGraph hiGraph2;
        HiArc hiArc;
        int n2;
        Vector vector = hiGraph.m_children;
        int n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            hiArc = (HiArc)vector.elementAt(n2);
            hiGraph2 = hiArc.to();
            HiGraphCoordinates.global_ylayout(hiGraph2, n);
        }
        hiGraph.m_y += n;
        if (hiGraph.uniformDepth()) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                int n5;
                HiGraph hiGraph3;
                int n6;
                hiArc = (HiArc)vector.elementAt(n2);
                hiGraph2 = hiArc.to();
                int n7 = hiGraph2.m_y - hiGraph2.m_height / 2;
                int n8 = hiGraph2.m_y + hiGraph2.m_height / 2;
                boolean bl = false;
                block8: for (n6 = n2 + 1; n6 < n3; ++n6) {
                    hiArc = (HiArc)vector.elementAt(n6);
                    hiGraph3 = hiArc.to();
                    n5 = hiGraph3.m_y - hiGraph3.m_height / 2;
                    n4 = hiGraph3.m_y + hiGraph3.m_height / 2;
                    switch (n7 - n5) {
                        case -1: 
                        case 0: 
                        case 1: {
                            if (n8 == n4) continue block8;
                            bl = true;
                            if (n8 >= n4) continue block8;
                            n8 = n4;
                        }
                    }
                }
                if (!bl) continue;
                block9: for (n6 = n2; n6 < n3; ++n6) {
                    hiArc = (HiArc)vector.elementAt(n6);
                    hiGraph3 = hiArc.to();
                    n5 = hiGraph3.m_y - hiGraph3.m_height / 2;
                    n4 = hiGraph3.m_y + hiGraph3.m_height / 2;
                    switch (n7 - n5) {
                        case -1: 
                        case 0: 
                        case 1: {
                            int n9;
                            int n10 = n8 - n7;
                            int n11 = n7 + n10 / 2;
                            for (n9 = 0; n9 < n3; ++n9) {
                                if (n9 == n6) continue;
                                hiArc = (HiArc)vector.elementAt(n9);
                                HiGraph hiGraph4 = hiArc.to();
                                int n12 = hiGraph4.m_y - n11;
                                if (n12 < 0) {
                                    n12 = 0 - n12;
                                }
                                if (n12 >= (n10 + hiGraph4.m_height) / 2) continue;
                                n12 = hiGraph4.m_x - hiGraph3.m_x;
                                if (n12 < 0) {
                                    n12 = 0 - n12;
                                }
                                if (n12 < (hiGraph3.m_width + hiGraph4.m_width) / 2) break;
                            }
                            if (n9 != n3) continue block9;
                            hiGraph3.m_height = n10;
                            hiGraph3.m_y = n11;
                        }
                    }
                }
            }
        }
    }

    private static int clip(int n, int n2) {
        if (n > n2) {
            return n2;
        }
        if (n < -n2) {
            return -n2;
        }
        return n;
    }

    static void arc_layout(HiArc hiArc) {
        int n;
        int n2;
        int n3;
        int n4;
        HiGraph hiGraph = hiArc.from();
        HiGraph hiGraph2 = hiArc.to();
        int n5 = hiGraph.m_width / 2;
        int n6 = hiGraph.m_height / 2;
        int n7 = hiGraph2.m_width / 2;
        int n8 = hiGraph2.m_height / 2;
        int n9 = hiGraph.m_x;
        int n10 = hiGraph.m_y;
        int n11 = hiGraph2.m_x;
        int n12 = hiGraph2.m_y;
        int n13 = n12 - n10;
        int n14 = n11 - n9;
        if (n14 < 2 && n14 > -2) {
            n4 = n10;
            n3 = n12;
            n = n2 = n11;
            if (n13 > 0) {
                n4 += n6;
                n3 -= n8;
            } else {
                n4 -= n6;
                n3 += n8;
            }
        } else if (n13 < 2 && n13 > -2) {
            n = n9;
            n2 = n11;
            n4 = n3 = n12;
            if (n14 > 0) {
                n += n5;
                n2 -= n7;
            } else {
                n -= n5;
                n2 += n7;
            }
        } else {
            double d = (double)n13 / (double)n14;
            n = (int)((double)n6 / d);
            n4 = (int)((double)n5 * d);
            n = HiGraphCoordinates.clip(n, n5);
            n4 = HiGraphCoordinates.clip(n4, n6);
            n2 = (int)((double)n8 / d);
            n3 = (int)((double)n7 * d);
            n2 = HiGraphCoordinates.clip(n2, n7);
            n3 = HiGraphCoordinates.clip(n3, n8);
            if (d < 0.0) {
                n4 = 0 - n4;
                n3 = 0 - n3;
            }
            int n15 = n11 + n2 - (n9 + n);
            int n16 = n12 + n3 - (n10 + n4);
            n15 = n11 - n2 - (n9 + n);
            n16 = n12 - n3 - (n10 + n4);
            int n17 = n15 * n15 + n16 * n16;
            int n18 = n15 * n15 + n16 * n16;
            if (n17 < n18) {
                n18 = n17;
                n2 = -n2;
                n3 = -n3;
            }
            if ((n17 = (n15 = n11 + n2 - (n9 - n)) * n15 + (n16 = n12 + n3 - (n10 - n4)) * n16) < n18) {
                n = -n;
                n4 = -n4;
            }
            n += n9;
            n4 += n10;
            n2 += n11;
            n3 += n12;
        }
        if (hiGraph.m_children.size() > 0) {
            int n19 = n - n9;
            if (n19 < 0) {
                n19 = 0 - n19;
            }
            if (n19 == n5) {
                n4 = hiGraph2.m_rank < hiGraph.m_sink_rank ? n10 - n6 + hiGraph.height() : n10 + n6 - hiGraph.height();
            }
        } else if (hiGraph.m_width == 0) {
            n4 = hiGraph.m_y + n6;
        }
        if (hiGraph2.m_children.size() > 0) {
            int n20 = n2 - n11;
            if (n20 < 0) {
                n20 = 0 - n20;
            }
            if (n20 == n7) {
                n3 = n12 - n8 + hiGraph2.height();
            }
        } else if (hiGraph2.m_width == 0) {
            n3 = hiGraph2.m_y - n8;
        }
        if (hiArc.reversed()) {
            int n21 = n;
            n = n2;
            n2 = n21;
            n21 = n4;
            n4 = n3;
            n3 = n21;
        }
        hiArc.m_fromX = n;
        hiArc.m_toX = n2;
        hiArc.m_fromY = n4;
        hiArc.m_toY = n3;
    }

    private static void arc_layout(HiGraph hiGraph, HiArc hiArc, int n) {
        hiArc.m_fromX = hiGraph.m_x;
        hiArc.m_fromY = hiGraph.m_y;
        hiArc.m_fromX = (n & 1) == 0 ? (hiArc.m_fromX += hiGraph.m_width / 2) : (hiArc.m_fromX -= hiGraph.m_width / 2);
        hiArc.m_fromY = (n >> 1 & 1) == 0 ? (hiArc.m_fromY -= hiGraph.m_height / 2) : (hiArc.m_fromY += hiGraph.m_height / 2);
        hiArc.m_toX = hiGraph.m_height < hiGraph.m_width ? hiGraph.m_height : hiGraph.m_width;
        hiArc.m_toX -= (n >> 2) * 4;
        if (hiArc.m_toX < 4) {
            hiArc.m_toX = 4;
        }
        int n2 = hiArc.m_toX >> 1;
        switch (n & 3) {
            case 1: {
                hiArc.m_fromX -= n2;
                hiArc.m_fromY -= n2;
                hiArc.m_toY = 0;
                break;
            }
            case 2: {
                hiArc.m_fromX -= n2;
                hiArc.m_fromY -= n2;
                hiArc.m_toY = 180;
                break;
            }
            case 3: {
                hiArc.m_fromX -= n2;
                hiArc.m_fromY -= n2;
                hiArc.m_toY = 90;
                break;
            }
            default: {
                hiArc.m_fromX -= n2;
                hiArc.m_fromY -= n2;
                hiArc.m_toY = 270;
            }
        }
    }

    private static void layout(HiGraph hiGraph, boolean bl, boolean bl2) {
        HiArc hiArc;
        Enumeration enumeration;
        if (bl) {
            enumeration = hiGraph.m_children.elements();
            while (enumeration.hasMoreElements()) {
                hiArc = (HiArc)enumeration.nextElement();
                HiGraph hiGraph2 = hiArc.to();
                HiGraphCoordinates.layout(hiGraph2, bl, bl2);
            }
        }
        if (bl2) {
            enumeration = hiGraph.m_in.elements();
            while (enumeration.hasMoreElements()) {
                hiArc = (HiArc)enumeration.nextElement();
                HiGraphCoordinates.arc_layout(hiArc);
            }
        }
        enumeration = hiGraph.m_out.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            HiGraphCoordinates.arc_layout(hiArc);
        }
        int n = 0;
        enumeration = hiGraph.m_self.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            HiGraphCoordinates.arc_layout(hiGraph, hiArc, n);
            ++n;
        }
    }

    static void layout(HiGraph hiGraph, boolean bl) {
        HiGraphCoordinates.layout(hiGraph, bl, true);
    }

    public static void coordinates(HiGraphLayout hiGraphLayout, HiGraph hiGraph) throws HiGraphException {
        int n = hiGraphLayout.simplex();
        HiGraphCoordinates.local_xlayout(hiGraphLayout, hiGraph, n);
        HiGraphCoordinates.local_ylayout(hiGraphLayout, hiGraph, n);
        HiGraphCoordinates.global_xlayout(hiGraph, hiGraphLayout.xmargin() - (hiGraph.m_x - hiGraph.m_width / 2));
        HiGraphCoordinates.global_ylayout(hiGraph, hiGraphLayout.ymargin() - (hiGraph.m_y - hiGraph.m_height / 2));
        HiGraphCoordinates.layout(hiGraph, true, false);
    }
}

