/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyMenuItem;
import lsedit.ToolBarEventHandler;

public class HistoryBox
extends JComponent
implements ToolBarEventHandler,
MouseListener,
MouseMotionListener {
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected static final int TY_CLEAR = 0;
    protected static final int TY_RAISED = 1;
    protected static final int TY_SUNK = 2;
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    public static Dimension m_preferredSize = new Dimension(0, 0);
    public static int m_disable_history = 0;
    public static final String m_helpStr = "This box shows the history of navigation within the current diagram.";
    public static final String DEFAULT_HISTORY_FONT_NAME = "Helvetica";
    public static final int DEFAULT_HISTORY_FONT_STYLE = 0;
    public static final int DEFAULT_HISTORY_FONT_SIZE = 11;
    protected static Font m_textFont = FontCache.get("Helvetica", 0, 11);
    protected static FontMetrics m_fm = null;
    protected static int m_fontheight;
    protected static int m_baseline;
    protected Vector m_history = new Vector(1000);
    protected int m_style;
    protected int m_over = -1;
    protected int m_at = -1;

    protected void navigateTo(EntityInstance entityInstance) {
        ++m_disable_history;
        this.m_ls.navigateTo(entityInstance);
        --m_disable_history;
        this.repaint();
    }

    public HistoryBox(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        this.setBackground(Diagram.boxColour);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab("History", null, this.m_scrollPane, m_helpStr);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void clear() {
        this.m_history.removeAllElements();
        this.m_at = -1;
        this.m_over = -1;
        this.m_ls.setHistoryButtons(this);
        this.fillHistoryBox();
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
        m_fm = null;
    }

    public void textFontChanged(Font font) {
        this.fillHistoryBox();
    }

    public void activate() {
        this.fillHistoryBox();
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component component = this.m_tabbedPane.getSelectedComponent();
        return component != null && this.m_scrollPane == component;
    }

    public void fillHistoryBox() {
        if (this.isActive()) {
            this.repaint();
        }
    }

    public void setNewPreferredSize() {
        this.setPreferredSize(m_preferredSize);
        this.setSize(m_preferredSize);
        this.m_scrollPane.revalidate();
    }

    public void addEntity(EntityInstance entityInstance) {
        Vector vector = this.m_history;
        if (m_disable_history == 0) {
            this.m_at = vector.size();
            vector.addElement(entityInstance);
            FontMetrics fontMetrics = m_fm;
            if (fontMetrics == null) {
                m_fm = fontMetrics = this.getFontMetrics(m_textFont);
                m_fontheight = fontMetrics.getHeight();
                m_baseline = m_fontheight - fontMetrics.getDescent();
            }
            int n = fontMetrics.stringWidth(entityInstance.getEntityLabel()) + 10;
            int n2 = vector.size() * m_fontheight + 15;
            if (n > HistoryBox.m_preferredSize.width || n2 > HistoryBox.m_preferredSize.height) {
                if (n > HistoryBox.m_preferredSize.width) {
                    HistoryBox.m_preferredSize.width = n;
                }
                if (n2 > HistoryBox.m_preferredSize.height) {
                    HistoryBox.m_preferredSize.height = n2;
                }
                this.setNewPreferredSize();
            }
            this.fillHistoryBox();
        }
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        Vector vector = this.m_history;
        if (vector != null) {
            int n = m_fontheight;
            int n2 = m_baseline;
            int n3 = n;
            int n4 = this.m_at;
            int n5 = this.m_over;
            graphics.setFont(m_textFont);
            int n6 = this.m_history.size();
            while (n6 > 0) {
                EntityInstance entityInstance;
                if ((entityInstance = (EntityInstance)this.m_history.elementAt(--n6)).isMarked(0x2000000)) {
                    graphics.setColor(Color.BLACK);
                } else {
                    if (n6 == n5 && this.m_style != 0) {
                        Color color = graphics.getColor();
                        graphics.setColor(Color.BLACK);
                        graphics.draw3DRect(0, n3, HistoryBox.m_preferredSize.width - 1, n - 2, this.m_style == 1);
                        graphics.setColor(color);
                    }
                    if (n6 == n4) {
                        graphics.setColor(Color.RED);
                    } else {
                        graphics.setColor(Color.BLUE);
                    }
                }
                String string = entityInstance.getEntityLabel();
                graphics.drawString(string, 5, n3 + n2);
                n3 += n;
            }
        }
    }

    public boolean hasPrevious() {
        if (this.m_history.size() > 1) {
            int n = this.m_at;
            if (n == -1) {
                n = this.m_history.size() - 1;
            }
            while (--n >= 0) {
                if (!(this.m_history.elementAt(n) instanceof EntityInstance)) continue;
                return true;
            }
        }
        return false;
    }

    public void navigatePrevious() {
        if (this.m_history.size() > 1) {
            int n = this.m_at;
            if (n == -1) {
                n = this.m_history.size() - 1;
            }
            while (--n >= 0) {
                Object e = this.m_history.elementAt(n);
                if (!(e instanceof EntityInstance)) continue;
                this.m_over = -1;
                this.m_at = n;
                this.navigateTo((EntityInstance)e);
                return;
            }
        }
    }

    public boolean hasNext() {
        int n = this.m_at;
        if (n >= 0) {
            while (++n < this.m_history.size()) {
                if (!(this.m_history.elementAt(n) instanceof EntityInstance)) continue;
                return true;
            }
        }
        return false;
    }

    public void navigateNext() {
        int n = this.m_at;
        if (n >= 0) {
            while (++n < this.m_history.size()) {
                Object e = this.m_history.elementAt(n);
                if (!(e instanceof EntityInstance)) continue;
                this.m_over = -1;
                this.m_at = n;
                this.navigateTo((EntityInstance)e);
                return;
            }
        }
    }

    protected void mouseAt(int n) {
        int n2 = this.m_history.size();
        if (n2 > 0) {
            int n3;
            int n4 = n2 - n / m_fontheight;
            if (n4 < 0) {
                n3 = 0;
                n4 = -1;
            } else if (n4 >= n2) {
                n3 = 0;
                n4 = n2;
            } else {
                n3 = 1;
            }
            if (n3 != this.m_style || n4 != this.m_over) {
                this.m_style = n3;
                this.m_over = n4;
                this.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseAt(mouseEvent.getY());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_style = 0;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.m_history.size();
        if (n > 0) {
            int n2;
            Vector vector = this.m_history;
            if (mouseEvent.isMetaDown()) {
                JPopupMenu jPopupMenu = new JPopupMenu("History options");
                new MyMenuItem(jPopupMenu, "Dispose", this, -1, 127);
                FontCache.setMenuTreeFont(jPopupMenu);
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            this.m_over = n2 = n - mouseEvent.getY() / m_fontheight;
            this.m_style = 2;
            if (n2 >= 0 && n2 < n) {
                EntityInstance entityInstance = (EntityInstance)vector.elementAt(n2);
                this.m_at = n2;
                if (!entityInstance.isMarked(0x2000000)) {
                    this.navigateTo(entityInstance);
                }
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_style = 0;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseAt(mouseEvent.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseAt(mouseEvent.getY());
    }

    public void processKeyEvent(int n, int n2, Object object) {
        switch (n) {
            case 127: {
                ShowReallyDelete showReallyDelete = new ShowReallyDelete(this.m_ls);
                showReallyDelete.dispose();
                break;
            }
        }
    }

    public void showInfo(String string) {
    }

    public class ShowReallyDelete
    extends JDialog
    implements ActionListener {
        protected LandscapeEditorCore m_ls;
        protected JButton m_ok;
        protected JButton m_cancel;

        public ShowReallyDelete(LandscapeEditorCore landscapeEditorCore) {
            super(landscapeEditorCore.getFrame(), "Delete History", true);
            this.m_ls = landscapeEditorCore;
            JFrame jFrame = landscapeEditorCore.getFrame();
            int n = HistoryBox.this.m_tabbedPane.getX() + 20;
            int n2 = HistoryBox.this.m_tabbedPane.getY() + 20;
            this.setLocation(n, n2);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(FontCache.get("Dialog", 0, 12));
            Container container = this.getContentPane();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 1));
            JLabel jLabel = new JLabel("Confirm deletion?");
            jPanel.add(jLabel);
            container.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            this.m_ok = new JButton("Ok");
            jPanel2.add(this.m_ok);
            this.m_ok.addActionListener(this);
            this.m_cancel = new JButton("Cancel");
            jPanel2.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            container.add((Component)jPanel2, "South");
            this.pack();
            this.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.m_ok || object == this.m_cancel) {
                if (object == this.m_ok) {
                    HistoryBox.this.clear();
                }
                this.setVisible(false);
                return;
            }
        }
    }
}

