/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Diagram;
import lsedit.LandscapeObject;
import lsedit.LandscapeObject3D;
import lsedit.Util;

public abstract class LandscapeClassObject
extends LandscapeObject3D {
    protected Vector inherits = new Vector();
    protected static final String CLASSLABEL_ID = "class_label";
    protected static final String CLASSSTYLE_ID = "class_style";
    protected static final String CLASSDESC_ID = "class_description";
    private int m_nid = -1;
    private Diagram m_dg;

    protected void makeInstanceOfUs(LandscapeObject landscapeObject) {
        Object object;
        Enumeration enumeration = this.getParentElements();
        while (enumeration.hasMoreElements()) {
            object = (LandscapeClassObject)enumeration.nextElement();
            if (object == null) {
                System.out.println("Internal error: Null inheritance");
                break;
            }
            ((LandscapeClassObject)object).makeInstanceOfUs(landscapeObject);
        }
        if ((enumeration = this.getLsAttributesEnum()) != null) {
            while (enumeration.hasMoreElements()) {
                object = (Attribute)enumeration.nextElement();
                if (((Attribute)object).id.startsWith("class")) continue;
                landscapeObject.addAttribute((Attribute)object);
            }
        }
    }

    protected String addParentClass(LandscapeClassObject landscapeClassObject, String string) {
        if (landscapeClassObject == null) {
            return "Can't inherit from null class";
        }
        if (!this.inherits.contains(landscapeClassObject)) {
            this.inherits.addElement(landscapeClassObject);
            return null;
        }
        return "Already inherits from " + landscapeClassObject.getId();
    }

    protected boolean processClassAttributes(Attribute attribute) {
        if (attribute.avi != null) {
            if (attribute.id.equals(CLASSLABEL_ID)) {
                this.setLabel(attribute.avi.value);
                return true;
            }
            if (attribute.id.equals(CLASSSTYLE_ID)) {
                this.setStyle(Util.parseInt(attribute.avi.value));
                return true;
            }
            if (attribute.id.equals(CLASSDESC_ID)) {
                this.setDescription(attribute.avi.value);
                return true;
            }
            return false;
        }
        return false;
    }

    public Diagram getDiagram() {
        return this.m_dg;
    }

    public void setLandscapeObjectDiagram(Diagram diagram) {
        this.m_dg = diagram;
    }

    public int getNid() {
        return this.m_nid;
    }

    public void setNid(int n) {
        this.m_nid = n;
    }

    public LandscapeClassObject derivedFrom(int n) {
        return n < this.inherits.size() ? (LandscapeClassObject)this.inherits.elementAt(n) : null;
    }

    public void addAttribute(Attribute attribute) {
        if (attribute.avi != null && attribute.id.startsWith("class_") && this.processClassAttributes(attribute)) {
            return;
        }
        if (this.processFirstOrder(attribute)) {
            return;
        }
        Attribute attribute2 = this.getLsAttribute(attribute.id);
        if (attribute2 == null) {
            this.putLsAttribute(attribute);
            attribute.m_cloneOnAssign = true;
        } else if (attribute.avi != null) {
            attribute2.avi = attribute.avi;
        }
    }

    public Attribute getLsAttribute(String string) {
        Attribute attribute = super.getLsAttribute(string);
        if (attribute != null) {
            return attribute;
        }
        Enumeration enumeration = this.getParentElements();
        while (enumeration.hasMoreElements()) {
            LandscapeClassObject landscapeClassObject = (LandscapeClassObject)enumeration.nextElement();
            attribute = landscapeClassObject.getLsAttribute(string);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        super.writeAttributes(printStream, null, true);
        String string = this.getLabel();
        if (!this.getId().equals(string)) {
            printStream.print(" class_label = " + this.qt(string) + "\n");
        }
        printStream.print(" class_style = " + this.getStyle() + "\n");
        String string2 = this.getDescription();
        if (string2 != null) {
            printStream.print(" class_description = " + AttributeValueItem.qt(string2) + "\n");
        }
    }

    public void setColor(Color color) {
        Attribute attribute = this.getLsAttribute("color");
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        attribute.avi.value = "" + d;
        attribute.avi.next.value = "" + d2;
        attribute.avi.next.next.value = "" + d3;
    }

    public boolean inheritsFrom(LandscapeClassObject landscapeClassObject) {
        return this.inherits.contains(landscapeClassObject);
    }

    public Enumeration getParentElements() {
        return this.inherits.elements();
    }
}

