/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoableEdit;
import lsedit.ArrowDimensions;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.BrowserLauncher;
import lsedit.Cardinal;
import lsedit.ClientSupplierSet;
import lsedit.DataInputStream;
import lsedit.DefaultBrowserButton;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EditAttribute;
import lsedit.EditModeHandler;
import lsedit.Elision_CS_Button;
import lsedit.Elision_CU_Button;
import lsedit.Elision_I_Button;
import lsedit.Elision_c_Button;
import lsedit.Elision_s_Button;
import lsedit.Elision_u_Button;
import lsedit.EntityCache;
import lsedit.EntityInstance;
import lsedit.Feedback;
import lsedit.Find;
import lsedit.FindBox;
import lsedit.FindNext_Button;
import lsedit.FindPrev_Button;
import lsedit.Find_Button;
import lsedit.FontBiggerButton;
import lsedit.FontCache;
import lsedit.FontChooser;
import lsedit.FontSmallerButton;
import lsedit.HistoryBox;
import lsedit.HistoryNext_Button;
import lsedit.HistoryPrev_Button;
import lsedit.LandscapeEditorFrame;
import lsedit.LandscapeObject;
import lsedit.LegendBox;
import lsedit.LsLink;
import lsedit.MapBox;
import lsedit.MsgOut;
import lsedit.MyHistoryMenuItem;
import lsedit.MySplitPane;
import lsedit.QueryBox;
import lsedit.Query_C_Button;
import lsedit.Query_Clear_Button;
import lsedit.Query_b_Button;
import lsedit.Query_f_Button;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.RightTabbedPane;
import lsedit.SortVector;
import lsedit.TextBox;
import lsedit.TextTree;
import lsedit.ToolBarButton;
import lsedit.ToolBarEventHandler;
import lsedit.UndoBox;
import lsedit.Util;
import lsedit.Version;
import lsedit.Vista;

public class LandscapeEditorCore
extends Do
implements ToolBarEventHandler,
ItemListener {
    protected static final int GRID_MAX = 100;
    protected static final int GAP = 4;
    protected static final String TITLE = "Software Landscape Editor";
    protected static final int FA_LOAD = 0;
    protected static final int FA_SAVE = 1;
    protected EditModeHandler m_editModeHandler;
    protected Vector m_diagrams = new Vector();
    protected Vector m_diagramNames = new Vector();
    protected JMenuBar m_menuBar;
    protected JMenu m_fileMenu;
    protected boolean m_lseditHistoryChanged = false;
    public String m_aboutURL = "http://swag.uwaterloo.ca";
    public String m_helpURL = "http://swag.uwaterloo.ca/lsedit";
    public String m_startEntity = null;
    public String m_lsPath = null;
    protected JFrame m_frame = null;
    protected JApplet m_applet = null;
    protected URL m_documentBase = null;
    protected AppletContext m_ac = null;
    protected static final String m_leftTextBoxHelp = "Displays the 'description' for the current landscape.";
    protected static final String m_rightTextBoxHelp = "Displays the 'description' for the closed (not a container) entity currently under the mouse cursor.";
    protected static final String m_feedbackHelp = "Displays feedback from the program. Examples include errors, warnings, and confirmations of action.";
    protected static final String m_nameBoxHelp = "Displays the landscape entity, edge, or application button/box currently under the mouse cursor.";
    protected static double m_mainSplitRatio = 0.8;
    protected static double m_secondSplitRatio = 0.1;
    protected static double m_thirdSplitRatio = 0.5;
    protected static String m_browser = null;
    protected static int m_openFrames = 1;
    protected Container m_contentPane;
    protected JToolBar m_toolBar = null;
    protected JComboBox m_lsDropDown = null;
    protected MySplitPane m_thirdSplitPane = null;
    protected JSplitPane m_secondSplitPane = null;
    protected JSplitPane m_mainSplitPane = null;
    protected JScrollPane m_scrollLeftTextBox = null;
    protected JPanel m_leftPanel = null;
    protected JPanel m_rightPanel = null;
    protected JLabel m_leftTextBoxTitle = null;
    protected TextBox m_leftTextBox = null;
    protected JScrollPane m_scrollRightTextBox = null;
    protected JLabel m_rightTextBoxTitle = null;
    protected TextBox m_rightTextBox = null;
    protected Feedback m_feedback = null;
    protected Feedback m_nameBox = null;
    public JScrollPane m_scrollDiagram = null;
    protected Diagram m_diagram = null;
    protected RightTabbedPane m_rightTabbedPane = null;
    protected LegendBox m_legendBox = null;
    protected MapBox m_mapBox = null;
    protected QueryBox m_queryBox = null;
    protected ResultBox m_resultBox = null;
    protected TextTree m_tocBox = null;
    protected UndoBox m_undoBox = null;
    protected HistoryBox m_historyBox = null;
    protected EntityInstance m_currentNameEntity = null;
    protected String lsSavePath;
    protected String lsSaveSuffix;
    protected String lsSaveCmd;
    protected int mode = 0;
    protected boolean modeHandlingActive = false;
    protected RelationInstance m_currentEdge = null;
    protected EntityInstance m_currentDescEntity = null;
    protected Find m_findResults = null;
    private int m_curCursor = 0;
    protected boolean m_fonts_changed = false;
    protected static int PREV_HISTORY_BUTTON = 13;
    protected static int NEXT_HISTORY_BUTTON = 14;
    protected static int PREV_FIND_BUTTON = 15;
    protected static int NEXT_FIND_BUTTON = 16;
    protected ToolBarButton[] toolButton = new ToolBarButton[]{new Find_Button(this), new Query_f_Button(this), new Query_b_Button(this), new Query_C_Button(this), new Query_Clear_Button(this), new Elision_c_Button(this), new Elision_I_Button(this), new Elision_u_Button(this), new Elision_CU_Button(this), new Elision_s_Button(this), new Elision_CS_Button(this), new FontSmallerButton(this), new FontBiggerButton(this), new HistoryPrev_Button(this), new HistoryNext_Button(this), new FindPrev_Button(this), new FindNext_Button(this)};
    protected static final String indAdd = "  ";

    protected void setApplet(JApplet jApplet) {
        this.m_applet = jApplet;
    }

    public boolean isApplet() {
        return this.m_applet != null;
    }

    public LandscapeEditorCore(JFrame jFrame) {
        this.m_frame = jFrame;
        this.m_contentPane = jFrame.getContentPane();
    }

    public LandscapeEditorCore(JApplet jApplet) {
        this.setApplet(jApplet);
        this.m_documentBase = jApplet.getDocumentBase();
        this.m_contentPane = jApplet.getContentPane();
    }

    public String getTitle() {
        return TITLE;
    }

    public EditModeHandler getModeHandler() {
        return this.m_editModeHandler;
    }

    protected void repaintTabs() {
        if (this.m_rightTabbedPane != null) {
            this.m_rightTabbedPane.revalidate();
        }
    }

    protected static String canonicalPath(String string) {
        String string2;
        try {
            File file = new File(string);
            string2 = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    protected void loadLseditHistory(JMenu jMenu) {
        if (this.isApplet()) {
            return;
        }
        String string = System.getProperty("user.home");
        try {
            String string2;
            FileReader fileReader = new FileReader(string + System.getProperty("file.separator") + ".lsedit");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("menu=")) {
                    new MyHistoryMenuItem(jMenu, string2.substring(5), this);
                    continue;
                }
                if (string2.startsWith("font=")) {
                    this.loadSavedFont(string2);
                    continue;
                }
                if (!string2.startsWith("browser=")) continue;
                m_browser = string2.substring(8);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("LandscapeEditorCore.loadLseditHistory " + exception);
        }
    }

    protected void addLseditHistory(String string) {
        String string2 = LandscapeEditorCore.canonicalPath(string);
        int n = this.m_fileMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = this.m_fileMenu.getItem(i);
            if (!(jMenuItem instanceof MyHistoryMenuItem) || !((MyHistoryMenuItem)jMenuItem).isPath(string2)) continue;
            return;
        }
        new MyHistoryMenuItem(this.m_fileMenu, string2, this);
        this.m_lseditHistoryChanged = true;
    }

    public void saveLseditHistory() {
        if (this.isApplet()) {
            return;
        }
        if (this.m_lseditHistoryChanged || this.m_fonts_changed) {
            try {
                String string = System.getProperty("user.home");
                if (string == null) {
                    System.out.println("Can't save history in .lsedit: don't know location of $HOME");
                } else {
                    String string2 = string + System.getProperty("file.separator") + ".lsedit";
                    System.out.println("Saving history in " + string2);
                    FileWriter fileWriter = new FileWriter(string2);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    int n = this.m_fileMenu.getItemCount();
                    for (int i = 0; i < n; ++i) {
                        JMenuItem jMenuItem = this.m_fileMenu.getItem(i);
                        if (!(jMenuItem instanceof MyHistoryMenuItem)) continue;
                        String string3 = ((MyHistoryMenuItem)jMenuItem).getPath();
                        bufferedWriter.write("menu=", 0, 5);
                        bufferedWriter.write(string3, 0, string3.length());
                        bufferedWriter.newLine();
                    }
                    this.saveFonts(bufferedWriter);
                    String string4 = m_browser;
                    if (string4 != null) {
                        bufferedWriter.write("browser=", 0, 8);
                        bufferedWriter.write(string4, 0, string4.length());
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception  " + exception + " caught when attempting to save history in $HOME/.lsedit");
            }
        }
    }

    public void removeHistoryMenu(MyHistoryMenuItem myHistoryMenuItem) {
        this.m_fileMenu.remove(myHistoryMenuItem);
        this.m_lseditHistoryChanged = true;
    }

    public void removeHistory() {
        int n;
        int n2 = n = this.m_fileMenu.getItemCount();
        while (n2 > 0) {
            JMenuItem jMenuItem;
            if (!((jMenuItem = this.m_fileMenu.getItem(--n2)) instanceof MyHistoryMenuItem)) continue;
            this.removeHistoryMenu((MyHistoryMenuItem)jMenuItem);
        }
    }

    protected void showDescription(RelationInstance relationInstance, boolean bl) {
        if (relationInstance != this.m_currentEdge) {
            this.m_currentEdge = relationInstance;
            this.m_currentNameEntity = null;
            EntityInstance entityInstance = relationInstance.m_drawSrc;
            EntityInstance entityInstance2 = relationInstance.m_drawDst;
            String string = entityInstance == null ? "??null??" : Util.quoted(entityInstance.getEntityLabel());
            string = string + " " + relationInstance.getClassLabel() + "";
            string = entityInstance2 == null ? string + "??null??" : string + Util.quoted(entityInstance2.getEntityLabel());
            this.showInfo(string);
        }
    }

    protected void showDescription(EntityInstance entityInstance, boolean bl) {
        String string;
        Object object;
        if (entityInstance != this.m_currentNameEntity) {
            this.m_currentNameEntity = entityInstance;
            this.m_currentEdge = null;
            string = entityInstance == null ? "" : ((object = entityInstance.getEnterableParent()) != null ? ((EntityInstance)object).getEntityLabel() + " . " + entityInstance.getEntityLabel() : entityInstance.getEntityLabel());
            this.showInfo(string);
        }
        if (entityInstance != null && this.m_currentDescEntity != entityInstance && (!entityInstance.isOpen() || bl) && entityInstance.getEntityClass() != null) {
            string = entityInstance.getEntityLabel();
            object = entityInstance.getTitle();
            String string2 = entityInstance.getDescription();
            if (string2 == null) {
                string2 = "The " + string + " " + entityInstance.getClassLabel() + ".";
            }
            String string3 = " (" + entityInstance.getClassLabel() + (entityInstance.hasChildren() ? " - " + entityInstance.numChildren() + " items)" : ")");
            string3 = object != null ? (String)object + string3 : string + string3;
            this.m_rightTextBoxTitle.setText(string3);
            this.m_rightTextBox.set(string2);
            this.m_currentDescEntity = entityInstance;
        }
    }

    public JMenuBar genMenu() {
        JMenu jMenu;
        JMenuBar jMenuBar;
        this.m_menuBar = jMenuBar = new JMenuBar();
        this.m_fileMenu = jMenu = new JMenu("File");
        LandscapeEditorCore.fileMenuItem(jMenu, this);
        if (!this.isApplet()) {
            Do.fileCloseMenuItem(jMenu, this);
        }
        jMenu.addSeparator();
        this.loadLseditHistory(jMenu);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Edit");
        this.editMenuItem(jMenu, this);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Layout");
        this.layoutMenuItem(jMenu, this);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Explore");
        LandscapeEditorCore.exploreMenuItem(jMenu, this);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Options");
        this.optionsMenuItem(jMenu, this);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Help");
        LandscapeEditorCore.helpMenuItem(jMenu, this, "Editor");
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    protected void setMenuFont(Font font) {
        FontCache.setMenuFont(font);
        FontCache.setMenuFont(this.m_menuBar, font);
    }

    protected void genDropDowns() {
        Dimension dimension = new Dimension(100, 24);
        this.m_lsDropDown = new JComboBox();
        this.m_lsDropDown.setMaximumSize(dimension);
        this.m_lsDropDown.setMinimumSize(dimension);
        this.m_lsDropDown.setPreferredSize(dimension);
        this.m_lsDropDown.setSize(dimension);
        this.m_lsDropDown.addItemListener(this);
    }

    protected void genMainGUI(int n, int n2) {
        int n3 = this.m_contentPane.getWidth();
        int n4 = this.m_contentPane.getHeight();
        Dimension dimension = new Dimension(100, 50);
        if (n > 0 && n2 > 0) {
            m_secondSplitRatio = 1.0 - (double)n2 / 100.0;
            m_mainSplitRatio = (double)n / 100.0;
        }
        this.m_contentPane.setVisible(false);
        this.m_toolBar = new JToolBar();
        this.m_toolBar.setRollover(true);
        if (this.m_lsDropDown != null) {
            this.m_toolBar.add(this.m_lsDropDown);
        }
        this.toolButton[NEXT_FIND_BUTTON].setEnabled(false);
        this.toolButton[PREV_FIND_BUTTON].setEnabled(false);
        this.toolButton[NEXT_HISTORY_BUTTON].setEnabled(false);
        this.toolButton[PREV_HISTORY_BUTTON].setEnabled(false);
        for (int i = 0; i < this.toolButton.length; ++i) {
            this.m_toolBar.add(this.toolButton[i]);
        }
        this.m_toolBar.setFloatable(false);
        this.m_toolBar.setSize(n3 - 8, 24);
        this.m_contentPane.add((Component)this.m_toolBar, "North");
        int n5 = (int)((double)n3 * m_mainSplitRatio / 2.0);
        int n6 = (int)((double)n4 * m_secondSplitRatio);
        Dimension dimension2 = new Dimension(n5, n6);
        this.m_leftPanel = new JPanel(new BorderLayout());
        this.m_leftPanel.setPreferredSize(dimension2);
        this.m_leftPanel.setVisible(true);
        this.m_leftTextBoxTitle = new JLabel();
        this.m_leftTextBoxTitle.setBackground(Diagram.boxColour);
        this.m_leftTextBoxTitle.setForeground(TextBox.titleColor);
        this.m_leftTextBoxTitle.setFont(TextBox.m_titleFont);
        this.m_leftTextBoxTitle.setSize(n5, 20);
        this.m_leftPanel.add((Component)this.m_leftTextBoxTitle, "North");
        this.m_scrollLeftTextBox = new JScrollPane();
        this.m_leftTextBox = new TextBox(this.m_scrollLeftTextBox, m_leftTextBoxHelp);
        this.m_leftTextBox.setSize(n5, n6 - 40);
        this.m_scrollLeftTextBox.setSize(n5, n6 - 40);
        this.m_leftPanel.add((Component)this.m_scrollLeftTextBox, "Center");
        this.m_feedback = new Feedback(m_feedbackHelp);
        this.m_feedback.setSize(n5, 20);
        this.m_leftPanel.add((Component)this.m_feedback, "South");
        this.m_rightPanel = new JPanel(new BorderLayout());
        this.m_rightPanel.setPreferredSize(dimension2);
        this.m_rightPanel.setVisible(true);
        this.m_rightTextBoxTitle = new JLabel();
        this.m_rightTextBoxTitle.setBackground(Diagram.boxColour);
        this.m_rightTextBoxTitle.setForeground(TextBox.titleColor);
        this.m_rightTextBoxTitle.setFont(TextBox.m_titleFont);
        this.m_rightTextBoxTitle.setSize(n5, 20);
        this.m_rightPanel.add((Component)this.m_rightTextBoxTitle, "North");
        this.m_scrollRightTextBox = new JScrollPane();
        this.m_rightTextBox = new TextBox(this.m_scrollRightTextBox, m_rightTextBoxHelp);
        this.m_rightTextBox.setSize(n5, n6 - 40);
        this.m_scrollRightTextBox.setSize(n5, n6 - 40);
        this.m_rightPanel.add((Component)this.m_scrollRightTextBox, "Center");
        this.m_nameBox = new Feedback(m_nameBoxHelp);
        this.m_nameBox.setSize(n5, 20);
        this.m_rightPanel.add((Component)this.m_nameBox, "South");
        this.computeMinInfoHeight();
        this.m_thirdSplitPane = new MySplitPane(1, this.m_leftPanel, this.m_rightPanel);
        this.m_thirdSplitPane.setOneTouchExpandable(true);
        this.m_thirdSplitPane.setDividerLocation(m_thirdSplitRatio);
        n6 = n4 - n6 - 24;
        n5 = (int)((double)n3 * m_mainSplitRatio);
        this.m_scrollDiagram = new JScrollPane();
        this.m_scrollDiagram.setSize(n5, n6);
        this.m_secondSplitPane = new JSplitPane(0, this.m_thirdSplitPane, this.m_scrollDiagram);
        this.m_secondSplitPane.setOneTouchExpandable(true);
        this.m_secondSplitPane.setDividerLocation(m_secondSplitRatio);
        n5 = (int)((double)n3 - (double)n3 * m_mainSplitRatio);
        n6 = n4 - 24;
        this.m_rightTabbedPane = new RightTabbedPane(this);
        this.m_legendBox = new LegendBox(this, this.m_rightTabbedPane);
        this.m_mapBox = new MapBox(this, this.m_rightTabbedPane);
        this.m_queryBox = new QueryBox(this, this.m_rightTabbedPane);
        this.m_resultBox = new ResultBox(this, this.m_rightTabbedPane);
        this.m_tocBox = new TextTree(this, this.m_rightTabbedPane);
        this.m_undoBox = new UndoBox(this, this.m_rightTabbedPane);
        this.m_historyBox = new HistoryBox(this, this.m_rightTabbedPane);
        dimension2 = new Dimension(n5, n6);
        this.m_legendBox.setSize(dimension2);
        this.m_mapBox.setSize(dimension2);
        this.m_queryBox.setSize(dimension2);
        this.m_resultBox.setSize(dimension2);
        this.m_tocBox.setSize(dimension2);
        this.m_rightTabbedPane.setSize(dimension2);
        this.m_undoBox.setSize(dimension2);
        this.m_historyBox.setSize(dimension2);
        this.m_legendBox.setPreferredSize(dimension2);
        this.m_mapBox.setPreferredSize(dimension2);
        this.m_queryBox.setPreferredSize(dimension2);
        this.m_resultBox.setPreferredSize(dimension2);
        this.m_tocBox.setPreferredSize(dimension2);
        this.m_rightTabbedPane.setPreferredSize(dimension2);
        this.m_undoBox.setPreferredSize(dimension2);
        this.m_historyBox.setPreferredSize(dimension2);
        this.m_legendBox.activate();
        this.m_secondSplitPane.setMinimumSize(dimension);
        this.m_rightTabbedPane.setMinimumSize(dimension);
        this.m_mainSplitPane = new JSplitPane(1, this.m_secondSplitPane, this.m_rightTabbedPane);
        this.m_mainSplitPane.setOneTouchExpandable(true);
        this.m_mainSplitPane.setSize(n3, n4 - 24);
        this.m_mainSplitPane.setDividerLocation(m_mainSplitRatio);
        this.m_contentPane.add((Component)this.m_mainSplitPane, "Center");
        this.m_contentPane.setVisible(true);
    }

    protected void genModeHandlers() {
        this.m_editModeHandler = new EditModeHandler(this);
    }

    protected void computeMinInfoHeight() {
        Dimension dimension;
        int n = 0;
        int n2 = 0;
        if (this.m_leftTextBoxTitle != null && this.m_leftTextBoxTitle.isVisible()) {
            dimension = this.m_leftTextBoxTitle.getMinimumSize();
            n += dimension.height;
        }
        if (this.m_scrollLeftTextBox != null && this.m_scrollLeftTextBox.isVisible()) {
            dimension = this.m_scrollLeftTextBox.getMinimumSize();
            n += dimension.height;
        }
        if (this.m_feedback != null && this.m_feedback.isVisible()) {
            dimension = this.m_feedback.getMinimumSize();
            n += dimension.height;
        }
        dimension = new Dimension(100, n);
        this.m_leftPanel.setMinimumSize(dimension);
        if (this.m_rightTextBoxTitle != null && this.m_rightTextBoxTitle.isVisible()) {
            dimension = this.m_rightTextBoxTitle.getMinimumSize();
            n2 += dimension.height;
        }
        if (this.m_scrollRightTextBox != null && this.m_scrollRightTextBox.isVisible()) {
            dimension = this.m_scrollRightTextBox.getMinimumSize();
            n2 += dimension.height;
        }
        if (this.m_nameBox != null && this.m_nameBox.isVisible()) {
            dimension = this.m_nameBox.getMinimumSize();
            n2 += dimension.height;
        }
        dimension = new Dimension(100, n2);
        this.m_rightPanel.setMinimumSize(dimension);
    }

    protected void registerLsName(String string) {
        if (this.m_lsDropDown != null) {
            int n = this.m_lsDropDown.getItemCount();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)this.m_lsDropDown.getItemAt(i);
                if (!string.equals(string2)) continue;
                return;
            }
            this.m_lsDropDown.addItem(string);
            if (this.m_lsDropDown.getItemCount() > 1) {
                this.m_lsDropDown.enable();
            }
        }
    }

    protected void setLeftBox() {
        EntityInstance entityInstance;
        if (this.m_diagram != null && (entityInstance = this.m_diagram.getDrawRoot()) != null) {
            String string = entityInstance.getEntityLabel();
            String string2 = entityInstance.getTitle();
            String string3 = entityInstance.getDescription();
            if (string3 == null) {
                string3 = entityInstance.getContainedBy() == null ? "The " + string + " landscape." : "The " + string + " " + entityInstance.getClassLabel();
            }
            String string4 = string2 != null ? string2 + " (" + string + ")" : string;
            this.m_leftTextBoxTitle.setText(string4);
            this.m_leftTextBox.set(string3);
        }
    }

    protected void setDiagram(Diagram diagram) {
        this.m_editModeHandler.cleanup();
        if (this.m_historyBox != null) {
            this.m_historyBox.clear();
        }
        if (this.m_findResults != null) {
            this.m_findResults.clear();
        }
        this.m_diagram = diagram;
        if (diagram != null) {
            diagram.setVisible(true);
        }
        if (this.m_tocBox != null) {
            if (!this.isTocHidden()) {
                this.setTocHidden(true);
                this.m_tocBox.firstTime();
            }
            this.setTocHidden(this.TOC_HIDDEN_DEFAULT);
            if (this.m_tocBox.isVisible()) {
                this.m_tocBox.repaint();
            }
        }
        if (this.m_legendBox != null) {
            this.m_legendBox.fillLegendBox();
        }
        if (this.m_queryBox != null) {
            this.m_queryBox.fillQueryBox();
        }
        if (this.m_rightTabbedPane != null) {
            this.m_rightTabbedPane.validate();
        }
        if (this.m_undoBox != null) {
            this.m_undoBox.fillUndoBox();
        }
        this.m_scrollDiagram.setViewportView(diagram);
        if (this.m_diagram != null) {
            String string = this.m_diagram.getContextName();
            if (string != null) {
                for (int i = 0; i < this.m_lsDropDown.getItemCount(); ++i) {
                    String string2 = (String)this.m_lsDropDown.getItemAt(i);
                    if (!string.equals(string2)) continue;
                    this.m_lsDropDown.setSelectedIndex(i);
                    break;
                }
            }
            this.doFeedback("Set to: " + string);
        }
        this.setLeftBox();
    }

    protected void setDiagram(int n) {
        Diagram diagram = this.m_diagram;
        Diagram diagram2 = (Diagram)this.m_diagrams.elementAt(n);
        if (diagram2 != diagram) {
            if (diagram != null) {
                diagram.removeEntitiesFromCache();
            }
            diagram2.addEntitiesToCache();
            this.setDiagram(diagram2);
        }
    }

    protected void rememberDiagram(Diagram diagram, String string) {
        this.m_diagrams.addElement(diagram);
        if (string != null) {
            this.addLseditHistory(this.m_lsPath);
            this.m_diagramNames.addElement(string);
            this.registerLsName(diagram.getContextName());
        } else {
            this.m_diagramNames.addElement("");
            this.registerLsName("unnamed");
        }
    }

    protected void addDiagram(Diagram diagram, String string) {
        this.rememberDiagram(diagram, string);
        this.setDiagram(diagram);
        diagram.setToViewport();
    }

    protected void attach(String string) {
        int n = this.m_diagramNames.indexOf(string);
        Diagram diagram = this.m_diagram;
        if (diagram != null) {
            diagram.removeEntitiesFromCache();
        }
        if (n < 0) {
            Diagram diagram2 = new Diagram(this, true);
            String string2 = diagram2.loadDiagram(string, this.m_documentBase);
            if (string2 != null) {
                this.error("Attach failed: " + string2);
                diagram.addEntitiesToCache();
                return;
            }
            this.addDiagram(diagram2, string);
        } else {
            this.setDiagram(n);
        }
    }

    public String getParameter(String string) {
        if (this.isApplet()) {
            return this.m_applet.getParameter(string);
        }
        return System.getProperty(string);
    }

    public void repaintDg() {
        this.m_diagram.revalidate();
        if (this.m_mapBox.isActive()) {
            this.m_mapBox.revalidate();
        }
    }

    public void redrawDg() {
        this.m_diagram.redrawDiagram();
    }

    protected String filePrompt(String string, String string2, int n, FileFilter[] fileFilterArray) {
        String string3;
        if (this.isApplet()) {
            string3 = JOptionPane.showInputDialog("Which file do you wish to upload from the server");
        } else {
            int n2;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(0);
            if (string2 != null) {
                jFileChooser.setSelectedFile(new File(string2));
            }
            if (fileFilterArray != null) {
                for (int i = 0; i < fileFilterArray.length; ++i) {
                    jFileChooser.addChoosableFileFilter(fileFilterArray[i]);
                }
            }
            if ((n2 = n == 0 ? jFileChooser.showOpenDialog(this.m_contentPane) : jFileChooser.showSaveDialog(this.m_contentPane)) == 0) {
                File file = jFileChooser.getSelectedFile();
                string3 = file.getAbsolutePath();
            } else {
                string3 = null;
            }
        }
        return string3;
    }

    protected void getBrowser() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        String string = Version.Detail("os.name");
        String string2 = null;
        String string3 = null;
        if (string != null && string.startsWith("Windows")) {
            string2 = "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";
        }
        File file = string2 != null ? new File(string2) : null;
        jFileChooser.setDialogTitle("Identify internet browser");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setApproveButtonText("Select");
        File file2 = m_browser == null ? file : new File(m_browser);
        if (file2 != null) {
            jFileChooser.setSelectedFile(file2);
        }
        if (file != null) {
            jFileChooser.setAccessory(new DefaultBrowserButton(jFileChooser, string, file));
        }
        if ((n = jFileChooser.showOpenDialog(this.m_contentPane)) == 0) {
            File file3 = jFileChooser.getSelectedFile();
            string3 = file3.getAbsolutePath();
            if (string3.equals(m_browser)) {
                return;
            }
            this.m_lseditHistoryChanged = true;
            m_browser = string3;
        }
    }

    protected void showURL(String string, int n) {
        block16: {
            MsgOut.vprintln("URL: " + string + " - target: " + n);
            try {
                if (!this.isApplet()) {
                    try {
                        BrowserLauncher.openURL(string);
                    }
                    catch (Exception exception) {
                        System.out.println("Unable to execute BrowserLauncher " + exception);
                        String[] stringArray = new String[2];
                        String string2 = m_browser;
                        if (string2 == null) {
                            this.getBrowser();
                            string2 = m_browser;
                            if (string2 == null) {
                                return;
                            }
                        }
                        stringArray[0] = string2;
                        stringArray[1] = string;
                        try {
                            Runtime runtime = Runtime.getRuntime();
                            runtime.exec(stringArray);
                            break block16;
                        }
                        catch (Exception exception2) {
                            JOptionPane.showMessageDialog(this.m_frame, "Unable to execute " + stringArray[0] + " " + exception2, "Browser error", 0);
                        }
                    }
                    break block16;
                }
                URL uRL = new URL(this.m_documentBase, string);
                if (this.m_ac == null) {
                    this.m_ac = this.m_applet.getAppletContext();
                }
                switch (n) {
                    case 0: {
                        this.m_ac.showDocument(uRL, "_top");
                        break;
                    }
                    case 5: {
                        this.m_ac.showDocument(uRL, "_blank");
                        break;
                    }
                    case 2: {
                        this.m_ac.showDocument(uRL, "Map");
                        break;
                    }
                    case 4: {
                        this.m_ac.showDocument(uRL, "List");
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                MsgOut.println("Malformed URL: " + string + " " + malformedURLException);
            }
        }
    }

    protected void about() {
        if (this.m_aboutURL != null) {
            this.showURL(this.m_aboutURL, 5);
        }
    }

    protected void help() {
        if (this.m_helpURL != null) {
            this.showURL(this.m_helpURL, 5);
        }
    }

    protected void setVisibility(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            jComponent.setVisible(bl);
        }
    }

    protected void readyMsg() {
        this.doFeedback(this.getTitle() + " " + 7 + "." + 0 + " (build " + 44 + ") Started.");
    }

    protected void followURL(String string, int n) {
        switch (n) {
            case 6: {
                this.attach(string);
                break;
            }
            case 1: {
                if (this.m_frame != null) {
                    LandscapeEditorFrame landscapeEditorFrame = LandscapeEditorFrame.create();
                    landscapeEditorFrame.setLsPath(string);
                    landscapeEditorFrame.launch();
                    ++m_openFrames;
                    break;
                }
            }
            default: {
                this.showURL(string, n);
            }
        }
    }

    public void doFeedback(String string) {
        if (this.m_feedback != null) {
            this.m_feedback.set(string);
        }
    }

    public void showInfo(String string) {
        if (this.m_nameBox != null) {
            this.m_nameBox.set(string);
        }
    }

    public void error(String string) {
        this.doFeedback(string);
        System.out.print("\u0007");
        System.out.flush();
    }

    public void clearFeedback() {
        this.m_feedback.set("");
    }

    protected void loadLs(String string) {
        Diagram diagram = this.m_diagram;
        if (diagram != null) {
            diagram.removeEntitiesFromCache();
        }
        Diagram diagram2 = new Diagram(this, true);
        if (string == null || string.length() < 1) {
            this.doFeedback("New Diagram");
            diagram2.emptyDiagram();
        } else {
            this.m_lsPath = string;
            this.doFeedback("Reading: " + this.m_lsPath);
            String string2 = diagram2.loadDiagram(this.m_lsPath, this.m_documentBase);
            if (string2 != null) {
                this.error("Failed to load (" + string2 + ")");
                diagram.addEntitiesToCache();
                return;
            }
        }
        this.addDiagram(diagram2, this.m_lsPath);
        this.requestFocus();
        this.repaint();
    }

    protected void fitToLabel() {
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Dimension dimension = entityInstance.getLabelDim(this.getGraphics(), 1);
            Rectangle rectangle = entityInstance.getDiagramBounds();
            rectangle.width = dimension.width + 10;
            rectangle.height = dimension.height + 10;
            if (entityInstance.hasChildren()) {
                rectangle.width += 11;
                if (rectangle.height < 17) {
                    rectangle.height = 17;
                }
            }
            entityInstance.updateDiagramBounds(rectangle);
        }
        this.m_diagram.rescaleDiagram();
        this.redrawDg();
    }

    protected Vector startGroupOp() {
        Vector vector = this.m_diagram.getGroup();
        if (vector == null) {
            this.error("Group not selected");
            return null;
        }
        return vector;
    }

    protected void alignTop() {
        EntityInstance entityInstance;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance2 = this.m_diagram.getKeyEntity();
        double d = entityInstance2.yRelLocal();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (!(d + entityInstance.heightRelLocal() > 1.0)) continue;
            d = 1.0 - entityInstance.heightRelLocal();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.updateyRelLocal(d);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void alignHorizontal() {
        EntityInstance entityInstance;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance2 = this.m_diagram.getKeyEntity();
        double d = entityInstance2.yRelLocal() + entityInstance2.heightRelLocal() / 2.0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (!(d + entityInstance.heightRelLocal() / 2.0 > 1.0)) continue;
            d = 1.0 - entityInstance.heightRelLocal() / 2.0;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (!(d - entityInstance.heightRelLocal() / 2.0 < 0.0)) continue;
            d = entityInstance.heightRelLocal() / 2.0;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.updateyRelLocal(d - entityInstance.heightRelLocal() / 2.0);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void alignBottom() {
        EntityInstance entityInstance;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance2 = this.m_diagram.getKeyEntity();
        double d = entityInstance2.yRelLocal() + entityInstance2.heightRelLocal();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (!(d - entityInstance.heightRelLocal() < 0.0)) continue;
            d = entityInstance.heightRelLocal();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.updateyRelLocal(d - entityInstance.heightRelLocal());
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void alignLeft() {
        EntityInstance entityInstance;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance2 = this.m_diagram.getKeyEntity();
        double d = entityInstance2.xRelLocal();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (!(d + entityInstance.widthRelLocal() > 1.0)) continue;
            d = 1.0 - entityInstance.widthRelLocal();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.updatexRelLocal(d);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void alignVertical() {
        EntityInstance entityInstance;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance2 = this.m_diagram.getKeyEntity();
        double d = entityInstance2.xRelLocal() + entityInstance2.widthRelLocal() / 2.0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (!(d + entityInstance.widthRelLocal() / 2.0 > 1.0)) continue;
            d = 1.0 - entityInstance.widthRelLocal() / 2.0;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (!(d - entityInstance.widthRelLocal() / 2.0 < 0.0)) continue;
            d = entityInstance.widthRelLocal() / 2.0;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.updatexRelLocal(d - entityInstance.widthRelLocal() / 2.0);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void alignRight() {
        EntityInstance entityInstance;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance2 = this.m_diagram.getKeyEntity();
        double d = entityInstance2.xRelLocal() + entityInstance2.widthRelLocal();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (!(d - entityInstance.widthRelLocal() < 0.0)) continue;
            d = entityInstance.widthRelLocal();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.updatexRelLocal(d - entityInstance.widthRelLocal());
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void sameWidth() {
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance = this.m_diagram.getKeyEntity();
        Rectangle rectangle = entityInstance.getDiagramBounds();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (entityInstance2 == entityInstance) continue;
            Rectangle rectangle2 = (Rectangle)entityInstance2.getDiagramBounds().clone();
            rectangle2.width = rectangle.width;
            entityInstance2.updateDiagramBounds(rectangle2);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void sameHeight() {
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance = this.m_diagram.getKeyEntity();
        Rectangle rectangle = entityInstance.getDiagramBounds();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (entityInstance2 == entityInstance) continue;
            Rectangle rectangle2 = (Rectangle)entityInstance2.getDiagramBounds().clone();
            rectangle2.height = rectangle.height;
            entityInstance2.updateDiagramBounds(rectangle2);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void sameSize() {
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance = this.m_diagram.getKeyEntity();
        Rectangle rectangle = entityInstance.getDiagramBounds();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (entityInstance2 == entityInstance) continue;
            Rectangle rectangle2 = (Rectangle)entityInstance2.getDiagramBounds().clone();
            rectangle2.width = rectangle.width;
            rectangle2.height = rectangle.height;
            entityInstance2.updateDiagramBounds(rectangle2);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void equalSpacing(int n) {
        Rectangle rectangle;
        EntityInstance entityInstance;
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        if (vector.size() < 3) {
            this.error("Minimum group of three required");
            return;
        }
        Rectangle rectangle2 = this.m_diagram.getGroupBoundingBox();
        if (rectangle2 == null) {
            this.error("Group not selected");
            return;
        }
        switch (n) {
            case 87: {
                SortVector.byDiagramX(vector);
                break;
            }
            case 72: {
                SortVector.byDiagramY(vector);
            }
        }
        double d = 0.0;
        Enumeration enumeration = vector.elements();
        double d2 = 0.0;
        double d3 = 0.0;
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            rectangle = entityInstance.getDiagramBounds();
            d3 += (double)rectangle.width;
            d2 += (double)rectangle.height;
        }
        d = n == 87 ? ((double)rectangle2.width - d3) / (double)(vector.size() - 1) : ((double)rectangle2.height - d2) / (double)(vector.size() - 1);
        entityInstance = (EntityInstance)vector.elementAt(0);
        rectangle = entityInstance.getDiagramBounds();
        for (int i = 1; i < vector.size() - 1; ++i) {
            EntityInstance entityInstance2 = (EntityInstance)vector.elementAt(i);
            Rectangle rectangle3 = entityInstance2.getDiagramBounds();
            if (n == 87) {
                rectangle3.x = (int)((double)(rectangle.x + rectangle.width) + d);
            } else {
                rectangle3.y = (int)((double)(rectangle.y + rectangle.height) + d);
            }
            rectangle = (Rectangle)rectangle3.clone();
            entityInstance2.updateDiagramBounds(rectangle3);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void createContainedGroup() {
        Vector vector = this.startGroupOp();
        if (vector == null) {
            return;
        }
        EntityInstance entityInstance = ((EntityInstance)vector.firstElement()).getContainedBy();
        Rectangle rectangle = this.m_diagram.getGroupBoundingBox();
        rectangle.y -= 21;
        rectangle.x -= 5;
        rectangle.width += 10;
        rectangle.height += 26;
        EntityInstance entityInstance2 = this.newEntity(entityInstance, rectangle);
        if (entityInstance2 != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
                Rectangle rectangle2 = entityInstance3.getDiagramBounds();
                this.moveEntityContainment(entityInstance2, entityInstance3);
                entityInstance3.updateDiagramBounds(rectangle2);
            }
            this.m_diagram.rescaleDiagram();
            this.repaintDg();
        }
    }

    protected void saveStatus(String string) {
        this.doFeedback("Save status: " + string);
    }

    protected String doSaveByURL(String string) {
        OutputStream outputStream;
        URLConnection uRLConnection;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return "Malformed URL on write";
        }
        try {
            uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(false);
            uRLConnection.setDoOutput(true);
            uRLConnection.setAllowUserInteraction(false);
        }
        catch (IOException iOException) {
            return "Couldn't open connection";
        }
        try {
            outputStream = uRLConnection.getOutputStream();
        }
        catch (IOException iOException) {
            return "Couldn't openStream";
        }
        try {
            this.m_diagram.saveDiagram(outputStream, false);
        }
        catch (IOException iOException) {
            return "IOException on write";
        }
        return null;
    }

    protected void saveByURL(String string) {
        InputStream inputStream;
        URL uRL;
        MsgOut.dprintln("Save by URL");
        String string2 = this.doSaveByURL(this.lsSavePath);
        if (string2 != null) {
            this.saveStatus(string2);
            return;
        }
        if (this.lsSaveCmd == null) {
            this.saveStatus("Success");
            return;
        }
        try {
            uRL = new URL(this.lsSaveCmd);
        }
        catch (MalformedURLException malformedURLException) {
            this.saveStatus("Malformed URL on write");
            return;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            this.saveStatus("Couldn't openStream for store");
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            string2 = dataInputStream.readLine();
            inputStream.close();
            this.saveStatus(string2);
        }
        catch (IOException iOException) {
            this.saveStatus("IOexception on store");
        }
    }

    protected String saveByFile(String string) {
        try {
            Object object;
            File file = (File)this.m_diagram.getContext();
            if (string == null) {
                object = file.getPath();
                file.renameTo(new File((String)object + ".old"));
            } else {
                file = new File(string);
                this.m_diagram.setContext(file);
            }
            object = new FileOutputStream(file);
            this.m_diagram.saveDiagram((OutputStream)object, false);
            return null;
        }
        catch (IOException iOException) {
            return "IOException on file open";
        }
    }

    protected String saveWithCmd(String string, String string2) {
        String string3;
        Object object;
        File file = (File)this.m_diagram.getContext();
        String string4 = file.getPath() + string;
        File file2 = new File(string4);
        try {
            object = new FileOutputStream(file2);
            this.m_diagram.saveDiagram((OutputStream)object, true);
        }
        catch (IOException iOException) {
            return "IOException on file save";
        }
        object = Util.expand(string2, file.getName(), this);
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec((String)object);
            DataInputStream dataInputStream = new DataInputStream(process.getErrorStream());
            string3 = dataInputStream.readLine();
            if (string3.equals("Done")) {
                string3 = "Save succeeded";
            }
            process.destroy();
        }
        catch (Exception exception) {
            string3 = "Exec failed for: " + (String)object;
        }
        return string3;
    }

    protected void doSaveLs(String string) {
        this.doFeedback("Saving landscape...");
        if (this.m_diagram.getContext() instanceof URL) {
            this.saveByURL(string);
        } else {
            String string2;
            if (string == null && this.lsSaveCmd != null) {
                MsgOut.dprintln("Save by app");
                string2 = this.saveWithCmd(this.lsSaveSuffix, this.lsSaveCmd);
            } else {
                MsgOut.dprintln("Save by file");
                string2 = this.saveByFile(string);
            }
            if (string2 == null) {
                string2 = "Success";
            }
            this.saveStatus(string2);
        }
    }

    protected void saveLs() {
        Object object = this.m_diagram.getContext();
        String string = null;
        if (object == null && (string = this.filePrompt("Save Landscape", this.m_diagram.getAbsolutePath(), 1, null)).length() == 0) {
            return;
        }
        this.doSaveLs(string);
    }

    public void init_core(int n, int n2) {
        this.m_contentPane.setBackground(Color.lightGray);
        this.genModeHandlers();
        this.genDropDowns();
        this.genMainGUI(n, n2);
        this.m_diagram = new Diagram(this, true);
        this.initialLoad();
        this.showInfo("");
    }

    protected void initialLoad() {
        this.setDirectEdge();
        if (this.m_lsPath == null) {
            MsgOut.dprintln("Empty landscape");
            if (this.m_leftTextBox != null) {
                this.m_leftTextBoxTitle.setText("Empty Landscape");
                this.m_leftTextBox.set("Select 'Open landscape' from 'File' menu to load a new landscape.");
            }
            this.readyMsg();
        } else if (this.m_diagram != null) {
            MsgOut.dprintln("Load: " + this.m_lsPath);
            String string = this.m_diagram.loadDiagram(this.m_lsPath, this.m_documentBase);
            if (string != null) {
                this.error("Load failed (" + string + ") for: " + this.m_lsPath);
                System.out.println("Load failed (" + string + ") for: " + this.m_lsPath);
            } else {
                this.setDiagram(this.m_diagram);
                if (this.m_startEntity == null) {
                    this.m_diagram.navigateTo();
                } else {
                    EntityInstance entityInstance = EntityCache.get(this.m_startEntity);
                    if (entityInstance == null) {
                        this.error("Entity not found: '" + this.m_startEntity + "'");
                    } else {
                        this.m_diagram.setPreserveEntityMarks(0);
                        this.m_diagram.setPreserveRelationMarks(0);
                        this.m_diagram.navigateTo(entityInstance);
                    }
                }
                this.setLeftBox();
                this.readyMsg();
            }
        }
        if (this.m_rightTabbedPane != null && this.m_rightTabbedPane.isVisible()) {
            this.m_legendBox.activate();
        }
        this.requestFocus();
        this.rememberDiagram(this.m_diagram, this.m_lsPath);
    }

    public void hasNewContainsClass() {
        if (this.m_legendBox != null) {
            this.m_legendBox.hasNewContainsClass();
        }
        if (this.m_queryBox != null) {
            this.m_queryBox.hasNewContainsClass();
        }
    }

    protected void goTo(Vector vector) {
        this.doFeedback("");
        this.m_diagram.clearFlags();
        EntityInstance entityInstance = (EntityInstance)vector.elementAt(0);
        EntityInstance entityInstance2 = entityInstance.getContainedBy();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.setRedBoxFlag();
        }
        this.m_diagram.setPreserveEntityMarks(32768);
        this.m_diagram.setPreserveRelationMarks(0);
        if (entityInstance2 != this.m_diagram.getDrawRoot()) {
            this.m_diagram.navigateTo(entityInstance2);
        }
        SortVector.byString(vector);
        this.m_resultBox.showResults("FIND RESULTS:", vector, "-- End of find --");
        this.setLeftBox();
        this.m_rightTextBoxTitle.setText("");
        this.m_rightTextBox.set("");
        this.redrawDg();
    }

    protected void findNext() {
        if (this.m_findResults == null) {
            this.error("No search has occured.");
        } else if (this.m_findResults.isEmpty()) {
            this.error("No entities found which match search pattern.");
        } else {
            boolean bl;
            ToolBarButton toolBarButton = this.toolButton[PREV_FIND_BUTTON];
            boolean bl2 = false;
            boolean bl3 = bl = !this.m_findResults.atBeginning();
            if (toolBarButton.isEnabled() != bl) {
                toolBarButton.setEnabled(bl);
                bl2 = true;
            }
            Vector vector = this.m_findResults.nextResult();
            bl = !this.m_findResults.atEnd();
            toolBarButton = this.toolButton[NEXT_FIND_BUTTON];
            if (toolBarButton.isEnabled() != bl) {
                toolBarButton.setEnabled(bl);
                bl2 = true;
            }
            if (bl2) {
                this.m_toolBar.revalidate();
            }
            if (vector == null) {
                this.error("No more results available.");
            } else {
                this.goTo(vector);
            }
        }
    }

    protected void find() {
        Pattern pattern = FindBox.Create(this.m_frame, "Find Landscape Entities");
        if (pattern != null) {
            this.m_findResults = new Find(pattern, this.m_diagram.getRootInstance());
            if (this.m_findResults.isEmpty()) {
                this.error("No entities found which match search pattern.");
            } else {
                this.m_findResults.reset();
                this.findNext();
                if (!this.m_findResults.atEnd()) {
                    this.m_rightTextBox.set("Use F3 to step forward through layers found and F2 to step back");
                }
            }
        }
    }

    protected void findPrev() {
        if (this.m_findResults == null) {
            this.error("No search has occured.");
        } else if (this.m_findResults.isEmpty()) {
            this.error("No search results.");
        } else if (!this.m_findResults.regress()) {
            this.error("At first result.");
        } else {
            this.findNext();
        }
    }

    public void setPreferredSizeUndo(Vector vector, UndoableEdit undoableEdit) {
        if (this.m_undoBox != null) {
            this.m_undoBox.setNewPreferredSize(vector, undoableEdit);
        }
    }

    public void fillUndoBox() {
        if (this.m_undoBox != null && this.m_undoBox.isActive()) {
            this.m_undoBox.fillUndoBox();
        }
    }

    public void setTocHidden(boolean bl) {
        if (this.isTocHidden() != bl) {
            super.setTocHidden(bl);
            if (this.m_tocBox != null) {
                this.m_tocBox.fillTOC();
            }
        }
    }

    public RelationInstance newEdge(EntityInstance entityInstance, EntityInstance entityInstance2) {
        return this.m_diagram.newEdge(entityInstance, entityInstance2);
    }

    public EntityInstance newEntity(EntityInstance entityInstance, Rectangle rectangle) {
        return this.m_diagram.newEntity(entityInstance, rectangle);
    }

    public void moveEntityContainment(EntityInstance entityInstance, EntityInstance entityInstance2) {
        EntityInstance entityInstance3 = entityInstance2.getContainedBy();
        if (entityInstance3 != entityInstance) {
            entityInstance2.moveEntityContainment(entityInstance);
        }
    }

    protected boolean deleteContainer(EntityInstance entityInstance) {
        if (entityInstance == this.m_diagram.getRootInstance()) {
            this.error("Can't delete root instance");
            return false;
        }
        entityInstance.deleteContainer();
        this.doFeedback("Container " + entityInstance.getEntityLabel() + " has been deleted.");
        return true;
    }

    protected boolean testForClose(boolean bl) {
        if (this.m_frame == null) {
            return false;
        }
        if (this.m_diagram.getChangedFlag()) {
            System.out.print("\u0007");
            int n = bl ? 0 : 1;
            int n2 = JOptionPane.showConfirmDialog(this.m_frame, "Landscape has been changed.\nShould it be saved?", "Landscape Changed", n);
            switch (n2) {
                case 0: {
                    this.saveLs();
                }
                case 1: {
                    break;
                }
                default: {
                    if (bl) break;
                    return false;
                }
            }
        }
        this.saveLseditHistory();
        return true;
    }

    protected void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void navigateTo(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = this.m_diagram.getDrawRoot();
        this.m_diagram.setPreserveEntityMarks(0);
        this.m_diagram.setPreserveRelationMarks(0);
        this.m_diagram.navigateTo(entityInstance);
        this.setLeftBox();
        this.m_diagram.clearFlags();
        this.m_rightTextBoxTitle.setText("");
        this.m_rightTextBox.set("");
        this.doFeedback("Now showing: " + entityInstance.getEntityLabel());
        this.validate();
    }

    public void followLink(EntityInstance entityInstance, boolean bl) {
        Attribute attribute = entityInstance.getLsAttribute("navlink");
        this.m_editModeHandler.cleanup();
        this.m_diagram.setPreserveEntityMarks(0);
        this.m_diagram.setPreserveRelationMarks(0);
        if (attribute == null) {
            this.navigateTo(entityInstance);
            return;
        }
        AttributeValueItem attributeValueItem = attribute.avi;
        if (attributeValueItem == null) {
            this.navigateTo(entityInstance);
            return;
        }
        while (attributeValueItem != null) {
            String string = LsLink.expand(attributeValueItem.value, entityInstance, this);
            if (string != null) {
                if (bl) {
                    this.followURL(string, 1);
                } else if (attribute.avi.next != null) {
                    String string2 = Util.expand(attributeValueItem.next.value, this);
                    int n = LsLink.convertTarget(string2);
                    if (n == 6) {
                        this.navigateTo(entityInstance);
                    } else {
                        this.followURL(string, n);
                    }
                } else {
                    this.error("No target: " + attribute.avi.value);
                }
            }
            attributeValueItem = attributeValueItem.nextList;
        }
    }

    protected void moveRedBoxes(Object object) {
        Vector vector = this.m_diagram.getRedBoxGroup();
        if (vector == null) {
            this.error("No query result active.");
            return;
        }
        EntityInstance entityInstance = this.m_diagram.targetEntity(object);
        if (entityInstance == null) {
            return;
        }
        if (entityInstance == this.m_diagram.getRootInstance()) {
            this.error("Can't add objects into the root");
            return;
        }
        this.beginUndoRedo("Move Redboxes");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (entityInstance2.hasDescendantOrSelf(entityInstance)) {
                this.error("Entity " + entityInstance2.getEntityLabel() + " can't be moved into " + entityInstance.getEntityLabel() + " because it contains the entity");
                continue;
            }
            this.moveEntityContainment(entityInstance, entityInstance2);
        }
        this.endUndoRedo();
        this.m_diagram.rescaleDiagram();
    }

    protected void deltaFont(int n) {
        String string;
        Vector vector = this.m_diagram.getGroup();
        if (vector != null && !vector.isEmpty()) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.deltaFont(n);
            }
            string = "Selected entities font changed";
        } else {
            EntityInstance entityInstance = this.m_diagram.getDrawRoot();
            if (entityInstance == null) {
                string = "No entities exist";
            } else {
                entityInstance.deltaFont(n);
                string = "Outer entities font changed";
            }
        }
        this.doFeedback(string);
    }

    public void show_groupList() {
        String string;
        Diagram diagram = this.m_diagram;
        if (diagram != null && (string = diagram.show_groupList(this.m_resultBox)) != null) {
            this.doFeedback(string);
        }
    }

    public void groupAll() {
        String string;
        Diagram diagram = this.m_diagram;
        if (diagram != null && (string = diagram.groupAll(this.m_resultBox)) != null) {
            this.doFeedback(string);
        }
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public JPanel getContentPane() {
        return (JPanel)this.m_contentPane;
    }

    public Feedback getFeedbackBox() {
        return this.m_feedback;
    }

    public Feedback getNameBox() {
        return this.m_nameBox;
    }

    public Diagram getDiagram() {
        return this.m_diagram;
    }

    public TextTree getTocBox() {
        return this.m_tocBox;
    }

    public UndoBox getUndoBox() {
        return this.m_undoBox;
    }

    public LegendBox getLegendBox() {
        return this.m_legendBox;
    }

    public MapBox getMapBox() {
        return this.m_mapBox;
    }

    public QueryBox getQueryBox() {
        return this.m_queryBox;
    }

    public ResultBox getResultBox() {
        return this.m_resultBox;
    }

    public void add(JComponent jComponent) {
        this.m_contentPane.add(jComponent);
    }

    public void repaint() {
        this.m_contentPane.repaint();
    }

    public void validate() {
        this.m_contentPane.validate();
    }

    public void requestFocus() {
        this.m_contentPane.requestFocus();
    }

    public Graphics getGraphics() {
        return this.m_contentPane.getGraphics();
    }

    public int getHeight() {
        return this.m_contentPane.getHeight();
    }

    public int getCursor() {
        return this.m_curCursor;
    }

    public int setCursor(int n) {
        int n2 = this.m_curCursor;
        if (n2 != n) {
            Cursor cursor = Cursor.getPredefinedCursor(n);
            this.m_curCursor = n;
            if (this.m_frame != null) {
                this.m_frame.setCursor(cursor);
            } else {
                this.m_applet.setCursor(cursor);
            }
        }
        return n2;
    }

    protected boolean getGroupQueryFlag() {
        return this.m_queryBox.getGroupingFlag();
    }

    public void setRightTextBox(String string, String string2) {
        this.m_rightTextBoxTitle.setText(string);
        this.m_rightTextBox.set(string2);
    }

    public Enumeration enumEntityClasses() {
        return this.m_diagram.enumEntityClasses();
    }

    public Enumeration enumEntityClassesInOrder() {
        return this.m_diagram.enumEntityClassesInOrder();
    }

    public Enumeration enumRelationClassesInOrder() {
        return this.m_diagram.enumRelationClassesInOrder();
    }

    public void beginUndoRedo(String string) {
        if (this.m_diagram != null) {
            this.m_diagram.beginUndoRedo(string);
        }
    }

    public void endUndoRedo() {
        if (this.m_diagram != null) {
            this.m_diagram.endUndoRedo();
        }
    }

    public void classChanges() {
        if (this.m_legendBox != null) {
            this.m_legendBox.fillLegendBox();
        }
        if (this.m_queryBox != null) {
            this.m_queryBox.fillQueryBox();
        }
    }

    public Vector getEdits() {
        if (this.m_diagram != null) {
            return this.m_diagram.getEdits();
        }
        return null;
    }

    public UndoableEdit getEditToBeRedone() {
        return this.m_diagram.getEditToBeRedone();
    }

    public int countEdits() {
        return this.m_diagram.countEdits();
    }

    public void massChange(UndoableEdit undoableEdit, boolean bl) {
        if (this.m_diagram != null) {
            this.m_diagram.massChange(undoableEdit, bl);
            this.redrawDg();
            this.doFeedback("Changes " + (bl ? "redone" : "undone"));
        }
    }

    public void discardAllEdits() {
        if (this.m_diagram != null) {
            this.m_diagram.discardAllEdits();
        }
    }

    public void deleteTOC(EntityInstance entityInstance) {
        if (!this.isTocHidden()) {
            this.m_tocBox.deleteTOC(entityInstance);
        }
    }

    public void insertTOC(EntityInstance entityInstance) {
        if (!this.isTocHidden()) {
            this.m_tocBox.insertTOC(entityInstance);
        }
    }

    public void entityCut(EntityInstance entityInstance) {
        if (this.m_resultBox != null) {
            this.m_resultBox.repaint();
        }
        if (this.m_findResults != null && this.m_findResults.entityCut()) {
            boolean bl;
            ToolBarButton toolBarButton = this.toolButton[PREV_FIND_BUTTON];
            boolean bl2 = false;
            boolean bl3 = bl = !this.m_findResults.atBeginning();
            if (toolBarButton.isEnabled() != bl) {
                toolBarButton.setEnabled(bl);
                bl2 = true;
            }
            toolBarButton = this.toolButton[NEXT_FIND_BUTTON];
            boolean bl4 = bl = !this.m_findResults.atEnd();
            if (toolBarButton.isEnabled() != bl) {
                toolBarButton.setEnabled(bl);
                bl2 = true;
            }
            if (bl2) {
                this.m_toolBar.revalidate();
            }
        }
        this.deleteTOC(entityInstance);
        if (this.m_historyBox != null) {
            this.m_historyBox.repaint();
        }
    }

    public void entityPasted(EntityInstance entityInstance) {
        if (this.m_resultBox != null) {
            this.m_resultBox.repaint();
        }
        this.insertTOC(entityInstance);
        if (this.m_historyBox != null) {
            this.m_historyBox.repaint();
        }
    }

    public void containerCut(EntityInstance entityInstance) {
        if (this.m_resultBox != null) {
            this.m_resultBox.repaint();
        }
        if (!this.isTocHidden()) {
            this.m_tocBox.containerCut(entityInstance);
        }
        if (this.m_historyBox != null) {
            this.m_historyBox.repaint();
        }
    }

    public void containerUncut(EntityInstance entityInstance) {
        if (this.m_resultBox != null) {
            this.m_resultBox.repaint();
        }
        if (!this.isTocHidden()) {
            this.m_tocBox.containerUncut(entityInstance);
        }
        if (this.m_historyBox != null) {
            this.m_historyBox.repaint();
        }
    }

    int getDiagramX() {
        return this.m_scrollDiagram.getX();
    }

    int getDiagramY() {
        return this.m_scrollDiagram.getY();
    }

    protected void edgeNavigateSrc(Object object) {
        Diagram diagram = this.getDiagram();
        RelationInstance relationInstance = diagram.targetRelation(object);
        if (relationInstance == null) {
            return;
        }
        this.followLink(relationInstance.getSrc(), false);
    }

    protected void edgeNavigateDst(Object object) {
        Diagram diagram = this.getDiagram();
        RelationInstance relationInstance = diagram.targetRelation(object);
        if (relationInstance == null) {
            return;
        }
        this.followLink(relationInstance.getDst(), false);
    }

    public void setHistoryButtons(HistoryBox historyBox) {
        ToolBarButton toolBarButton = this.toolButton[PREV_HISTORY_BUTTON];
        boolean bl = false;
        boolean bl2 = historyBox.hasPrevious();
        if (toolBarButton.isEnabled() != bl2) {
            toolBarButton.setEnabled(bl2);
            bl = true;
        }
        bl2 = historyBox.hasNext();
        toolBarButton = this.toolButton[NEXT_HISTORY_BUTTON];
        if (toolBarButton.isEnabled() != bl2) {
            toolBarButton.setEnabled(bl2);
            bl = true;
        }
        if (bl) {
            this.m_toolBar.revalidate();
        }
    }

    public void addHistoryEntity(EntityInstance entityInstance) {
        HistoryBox historyBox = this.m_historyBox;
        if (historyBox != null) {
            historyBox.addEntity(entityInstance);
            this.setHistoryButtons(historyBox);
        }
    }

    public void setContainsRelation(RelationClass relationClass) {
        if (this.m_diagram.setContainsRelation(relationClass)) {
            if (this.m_legendBox != null) {
                this.m_legendBox.fillLegendBox();
            }
            if (this.m_mapBox != null) {
                this.m_mapBox.fill(this.m_diagram.getDrawRoot());
            }
            if (this.m_queryBox != null) {
                this.m_queryBox.fillQueryBox();
            }
        }
    }

    public void processKey(int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            switch (n) {
                case 97: {
                    this.groupAll();
                    this.redrawDg();
                    break;
                }
                case 113: {
                    if (this.testForClose(false)) {
                        System.exit(0);
                    }
                    return;
                }
                case 119: {
                    if (!this.testForClose(false)) {
                        return;
                    }
                }
                case 110: {
                    this.loadLs(null);
                    return;
                }
                case 114: {
                    this.redrawDg();
                    return;
                }
                case 102: {
                    this.find();
                    return;
                }
                case 116: {
                    if (this.m_tocBox != null) {
                        this.m_tocBox.switch_TOC();
                    }
                    return;
                }
                case 100: {
                    if (this.m_diagram.set_to_viewport()) {
                        this.doFeedback("Diagram set to viewport");
                    }
                    return;
                }
                case 111: {
                    Object object2 = this.m_diagram.getContext();
                    String string = object2 != null ? this.filePrompt("Load Landscape", this.m_diagram.getAbsolutePath(), 0, null) : this.filePrompt("Load Landscape", "", 0, null);
                    if (string != null) {
                        this.loadLs(string);
                    }
                    return;
                }
                case 98: {
                    this.getBrowser();
                    return;
                }
                case 112: {
                    Vista vista = new Vista(this);
                    return;
                }
                case 83: {
                    Object object3 = this.m_diagram.getContext();
                    String string = object3 != null ? this.filePrompt("Save Landscape As", this.m_diagram.getAbsolutePath(), 1, null) : this.filePrompt("Save Landscape As", "", 1, null);
                    if (string == null || string.length() == 0) {
                        return;
                    }
                    this.doSaveLs(string);
                    return;
                }
                case 115: {
                    this.saveLs();
                    return;
                }
                case 118: {
                    this.m_diagram.pasteGroup(object);
                    return;
                }
                case 120: {
                    this.m_diagram.cutGroup(object, false);
                    return;
                }
                case 88: {
                    this.m_diagram.cutGroup(object, true);
                    return;
                }
                case 122: {
                    if (this.m_diagram != null) {
                        this.m_diagram.undo();
                    }
                    return;
                }
                case 121: {
                    if (this.m_diagram != null) {
                        this.m_diagram.redo();
                    }
                    return;
                }
            }
        } else if ((n2 & 8) != 0) {
            switch (n) {
                case 67: 
                case 73: 
                case 79: 
                case 99: 
                case 105: 
                case 111: {
                    if (this.m_diagram != null && this.m_diagram.handleEdgeExpansion(n, object, this.getResultBox())) {
                        this.redrawDg();
                    }
                    return;
                }
                case 78: {
                    this.edgeNavigateSrc(object);
                    return;
                }
                case 110: {
                    this.edgeNavigateDst(object);
                    return;
                }
                case 85: {
                    if (this.m_historyBox == null) break;
                    this.m_historyBox.navigateNext();
                    break;
                }
                case 117: {
                    if (this.m_historyBox == null) break;
                    this.m_historyBox.navigatePrevious();
                    break;
                }
                case 65: {
                    if (this.m_diagram == null) break;
                    this.m_diagram.queryContents(n, this.getResultBox(), this.getGroupQueryFlag());
                    this.redrawDg();
                    break;
                }
                case 81: {
                    boolean bl = !this.isQueryPersist();
                    this.setQueryPersist(bl);
                    this.doFeedback("Query persistence set to: " + (bl ? "On" : "Off"));
                    return;
                }
                case 69: {
                    this.m_diagram.setEdgeMode(0);
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    this.doFeedback("Edge mode set to: best edge.");
                    return;
                }
                case 97: {
                    this.m_diagram.setEdgeMode(1);
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    this.doFeedback("Edge mode set to: top/bottom.");
                    return;
                }
                case 101: {
                    this.m_diagram.setEdgeMode(2);
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    this.doFeedback("Edge mode set to: direct.");
                    return;
                }
                case 71: {
                    this.m_diagram.setEdgeMode(3);
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    this.doFeedback("Edge mode set to: direct+side.");
                    return;
                }
                case 68: {
                    boolean bl = !this.isShowDesc();
                    this.setShowDesc(bl);
                    this.setVisibility(this.m_leftTextBoxTitle, bl);
                    this.setVisibility(this.m_scrollLeftTextBox, bl);
                    this.setVisibility(this.m_rightTextBoxTitle, bl);
                    this.setVisibility(this.m_scrollRightTextBox, bl);
                    this.computeMinInfoHeight();
                    this.m_secondSplitPane.revalidate();
                    return;
                }
                case 66: {
                    boolean bl = !this.isShowFeedback();
                    this.setShowFeedback(bl);
                    this.setVisibility(this.m_feedback, bl);
                    this.setVisibility(this.m_nameBox, bl);
                    this.computeMinInfoHeight();
                    this.m_secondSplitPane.revalidate();
                    return;
                }
                case 83: {
                    boolean bl = !this.isShowClients();
                    this.setShowClients(bl);
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    return;
                }
                case 115: {
                    boolean bl = !this.isShowSuppliers();
                    this.setShowSuppliers(bl);
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    return;
                }
                case 116: {
                    this.setTopClients(!this.isTopClients());
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    return;
                }
                case 107: {
                    boolean bl = !this.isShowDstCardinals();
                    this.setShowDstCardinals(bl);
                    this.m_diagram.redrawDiagram();
                    return;
                }
                case 75: {
                    boolean bl = !this.isShowSrcCardinals();
                    this.setShowSrcCardinals(bl);
                    this.m_diagram.redrawDiagram();
                    return;
                }
                case 80: {
                    boolean bl = !this.isUseCompaction();
                    this.setUseCompaction(bl);
                    this.m_diagram.redrawDiagram();
                    return;
                }
                case 122: {
                    boolean bl = !this.isFixScrollBars();
                    this.setFixScrollBars(bl);
                    if (bl) {
                        this.m_scrollDiagram.setVerticalScrollBarPolicy(22);
                        this.m_scrollDiagram.setHorizontalScrollBarPolicy(32);
                        this.doFeedback("Diagram scroll bars permanently enabled");
                    } else {
                        this.m_scrollDiagram.setVerticalScrollBarPolicy(20);
                        this.m_scrollDiagram.setHorizontalScrollBarPolicy(30);
                        this.doFeedback("Diagram scroll bars will appear as needed");
                    }
                    return;
                }
                case 76: {
                    JComponent jComponent;
                    JComponent jComponent2;
                    boolean bl = !this.isLeftTabbox();
                    this.setLeftTabbox(bl);
                    this.m_mainSplitPane.setLeftComponent(null);
                    this.m_mainSplitPane.setRightComponent(null);
                    if (bl) {
                        jComponent2 = this.m_rightTabbedPane;
                        jComponent = this.m_secondSplitPane;
                    } else {
                        jComponent2 = this.m_secondSplitPane;
                        jComponent = this.m_rightTabbedPane;
                    }
                    int n3 = jComponent2.getWidth();
                    Dimension dimension = new Dimension(100, 50);
                    jComponent2.setMinimumSize(dimension);
                    jComponent.setMinimumSize(dimension);
                    this.m_mainSplitPane.setLeftComponent(jComponent2);
                    this.m_mainSplitPane.setRightComponent(jComponent);
                    this.m_mainSplitPane.setDividerLocation(n3);
                    return;
                }
                case 86: {
                    boolean bl = !this.isTabsScroll();
                    this.setTabsScroll(bl);
                    this.m_rightTabbedPane.setTabsScroll(bl);
                    break;
                }
                case 108: {
                    boolean bl = !this.isVisibleEdges();
                    this.setVisibleEdges(bl);
                    this.redrawDg();
                }
                case 118: {
                    boolean bl = !this.isTocHidden();
                    this.setTocHidden(bl);
                    return;
                }
                case 112: {
                    if (this.m_tocBox != null) {
                        this.m_tocBox.toc_path();
                    }
                    return;
                }
                case 38: {
                    this.beginUndoRedo("Align top");
                    this.alignTop();
                    this.endUndoRedo();
                    return;
                }
                case 88: {
                    this.beginUndoRedo("Align horizontal center");
                    this.alignHorizontal();
                    this.endUndoRedo();
                    return;
                }
                case 40: {
                    this.beginUndoRedo("Align bottom");
                    this.alignBottom();
                    this.endUndoRedo();
                    return;
                }
                case 37: {
                    this.beginUndoRedo("Align vertical left");
                    this.alignLeft();
                    this.endUndoRedo();
                    return;
                }
                case 39: {
                    this.beginUndoRedo("Align vertical right");
                    this.alignRight();
                    this.endUndoRedo();
                    return;
                }
                case 89: {
                    this.beginUndoRedo("Align vertical center");
                    this.alignVertical();
                    this.endUndoRedo();
                    return;
                }
                case 102: {
                    this.beginUndoRedo("Fit label");
                    this.fitToLabel();
                    this.endUndoRedo();
                    return;
                }
                case 103: {
                    this.createContainedGroup();
                    return;
                }
                case 119: {
                    this.beginUndoRedo("Same width");
                    this.sameWidth();
                    this.endUndoRedo();
                    return;
                }
                case 104: {
                    this.beginUndoRedo("Same height");
                    this.sameHeight();
                    this.endUndoRedo();
                    return;
                }
                case 120: {
                    this.beginUndoRedo("Same size");
                    this.sameSize();
                    this.endUndoRedo();
                    return;
                }
                case 87: {
                    this.beginUndoRedo("Space horizontally");
                    this.equalSpacing(n);
                    this.endUndoRedo();
                    return;
                }
                case 72: {
                    this.beginUndoRedo("Space vertically");
                    this.equalSpacing(n);
                    this.endUndoRedo();
                    return;
                }
                case 106: {
                    String string = this.m_diagram.relayoutAll();
                    if (string != null) {
                        this.doFeedback(string);
                    }
                    this.repaintDg();
                    return;
                }
                case 114: {
                    String string = this.m_diagram.closeAll();
                    if (string != null) {
                        this.doFeedback(string);
                    }
                    this.repaintDg();
                    return;
                }
                case 82: {
                    String string = this.m_diagram.openAll();
                    if (string != null) {
                        this.doFeedback(string);
                    }
                    this.repaintDg();
                    return;
                }
                case 70: {
                    FontChooser fontChooser = new FontChooser(this.m_frame, this);
                    fontChooser.dispose();
                    return;
                }
                case 77: 
                case 109: {
                    if (this.m_diagram == null) break;
                    this.beginUndoRedo("Magnify");
                    String string = this.m_diagram.scaleEntity(n, !this.m_editModeHandler.mouseIsDown());
                    this.endUndoRedo();
                    if (string != null) {
                        this.doFeedback(string);
                    }
                    this.redrawDg();
                    break;
                }
                case 100: {
                    ArrowDimensions.create(this);
                    this.repaint();
                    return;
                }
            }
        } else if (n2 == 1) {
            switch (n) {
                case 10: {
                    Diagram diagram = this.m_diagram;
                    if (diagram == null) break;
                    diagram.navigateToDrawRootParent();
                    this.redrawDg();
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.m_queryBox.activate();
                    this.m_queryBox.toggleRelationActivity(n - 48);
                    this.repaintDg();
                    this.requestFocus();
                    return;
                }
            }
        } else if (n2 == 0) {
            switch (n) {
                case 27: {
                    this.m_diagram.clearFlags();
                    this.doFeedback("Query/selection cleared");
                    this.m_diagram.setPreserveEntityMarks(0);
                    this.m_diagram.setPreserveRelationMarks(0);
                    this.redrawDg();
                    this.m_resultBox.clear();
                    this.m_editModeHandler.cleanup();
                    return;
                }
                case 67: {
                    if (this.m_diagram == null) break;
                    this.m_diagram.queryContents(n, this.getResultBox(), this.getGroupQueryFlag());
                    this.redrawDg();
                    break;
                }
                case 66: 
                case 70: 
                case 98: 
                case 102: {
                    if (this.m_diagram == null) break;
                    this.m_diagram.queryEntity(n, object, this.getResultBox(), this.getGroupQueryFlag());
                    this.redrawDg();
                    break;
                }
                case 73: 
                case 83: 
                case 85: 
                case 99: 
                case 115: 
                case 117: {
                    if (this.m_diagram == null) break;
                    String string = this.m_diagram.handleElision(n, object);
                    if (string != null) {
                        this.doFeedback(string);
                    }
                    this.redrawDg();
                    break;
                }
                case 88: 
                case 89: 
                case 90: 
                case 120: 
                case 121: 
                case 122: {
                    if (this.m_diagram == null) break;
                    this.beginUndoRedo("Scale");
                    String string = this.m_diagram.scaleEntity(n, !this.m_editModeHandler.mouseIsDown());
                    this.endUndoRedo();
                    if (string != null) {
                        this.doFeedback(string);
                    }
                    this.redrawDg();
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    this.beginUndoRedo("Move");
                    this.m_editModeHandler.moveGroup(n);
                    this.endUndoRedo();
                    this.redrawDg();
                    break;
                }
                case 10: {
                    Diagram diagram = this.getDiagram();
                    if (diagram == null) break;
                    EntityInstance entityInstance = diagram.targetEntity(object);
                    if (entityInstance == null) {
                        return;
                    }
                    EntityInstance entityInstance2 = diagram.getDrawRoot();
                    if (entityInstance == entityInstance2) {
                        this.error("Already in: " + entityInstance.getEntityLabel());
                    } else if (entityInstance == entityInstance2.getContainedBy()) {
                        this.followLink(entityInstance, false);
                    } else if (entityInstance.isClientOrSupplier()) {
                        if (entityInstance.hasChildren()) {
                            this.followLink(entityInstance, false);
                        } else {
                            this.followLink(entityInstance.getEnterableParent(), false);
                        }
                    } else {
                        while (entityInstance.getContainedBy() != entityInstance2 && !entityInstance.getContainedBy().isEnterable()) {
                            entityInstance = entityInstance.getContainedBy();
                        }
                        if (entityInstance.isEnterable()) {
                            this.followLink(entityInstance, false);
                        } else {
                            this.error("Can't navigate into: " + entityInstance.getEntityLabel());
                        }
                    }
                    this.redrawDg();
                    break;
                }
                case 127: {
                    this.m_diagram.doDelete(object);
                    return;
                }
                case 84: {
                    this.beginUndoRedo("Increase Font");
                    this.deltaFont(1);
                    this.endUndoRedo();
                    this.redrawDg();
                    break;
                }
                case 116: {
                    this.beginUndoRedo("Decrease Font");
                    this.deltaFont(-1);
                    this.endUndoRedo();
                    this.redrawDg();
                    break;
                }
                case 69: {
                    this.m_editModeHandler.newEdge(object);
                    return;
                }
                case 101: {
                    Diagram diagram = this.getDiagram();
                    if (diagram == null) break;
                    EntityInstance entityInstance = diagram.targetEntity(object);
                    if (entityInstance == null) {
                        return;
                    }
                    this.newEntity(entityInstance, null);
                    this.redrawDg();
                    break;
                }
                case 65: {
                    Diagram diagram = this.getDiagram();
                    if (diagram == null) {
                        return;
                    }
                    LandscapeObject landscapeObject = diagram.targetEntityRelation(object);
                    if (landscapeObject == null) {
                        return;
                    }
                    if (landscapeObject instanceof EntityInstance) {
                        EntityInstance entityInstance = (EntityInstance)landscapeObject;
                        EditAttribute.Create(this, entityInstance.getEntityClass());
                    } else {
                        RelationInstance relationInstance = (RelationInstance)landscapeObject;
                        EditAttribute.Create(this, relationInstance.getRelationClass());
                    }
                    this.redrawDg();
                    break;
                }
                case 97: {
                    Diagram diagram = this.getDiagram();
                    if (diagram == null) {
                        return;
                    }
                    LandscapeObject landscapeObject = diagram.targetEntityRelation(object);
                    if (landscapeObject == null) {
                        return;
                    }
                    if (landscapeObject instanceof EntityInstance) {
                        EntityInstance entityInstance = (EntityInstance)landscapeObject;
                        EditAttribute.Create(this, entityInstance);
                    } else {
                        RelationInstance relationInstance = (RelationInstance)landscapeObject;
                        EditAttribute.Create(this, relationInstance);
                    }
                    this.redrawDg();
                    break;
                }
                case 107: {
                    Diagram diagram = this.getDiagram();
                    if (diagram == null) {
                        return;
                    }
                    EntityInstance entityInstance = diagram.targetEntity(object);
                    if (entityInstance == null) {
                        return;
                    }
                    if (!this.deleteContainer(entityInstance)) break;
                    this.redrawDg();
                    break;
                }
                case 77: {
                    this.moveRedBoxes(object);
                    this.redrawDg();
                    break;
                }
                case 81: {
                    this.m_queryBox.toggleGroupingFlag();
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.m_legendBox.activate();
                    this.m_legendBox.toggleRelationVisibility(n - 48);
                    this.redrawDg();
                    this.requestFocus();
                    return;
                }
                case 1137: {
                    this.findPrev();
                    return;
                }
                case 1138: {
                    this.findNext();
                    return;
                }
                case 76: {
                    boolean bl = !this.isLiftEdges();
                    this.setLiftEdges(bl);
                    this.m_diagram.revalidate();
                    return;
                }
                case 71: {
                    int n4 = this.m_diagram.setNewGridValue();
                    if (n4 >= 0) {
                        this.doFeedback("Grid set to " + n4 + " pixels");
                    }
                    return;
                }
                case 103: {
                    boolean bl = !this.isShowGrid();
                    this.setShowGrid(bl);
                    this.m_diagram.repaint();
                    return;
                }
                case 1136: {
                    JOptionPane.showMessageDialog(this.m_frame, this.getTitle() + " " + Version.Details(this.getDiagram()), "About " + this.getTitle(), 0);
                    return;
                }
                case 1146: {
                    this.about();
                    return;
                }
                case 1147: {
                    this.help();
                    return;
                }
            }
        }
    }

    public Font getFont() {
        if (this.m_frame != null) {
            return this.m_frame.getFont();
        }
        return this.m_applet.getFont();
    }

    public String getDefaultFontName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "Helvetica";
                break;
            }
            case 3: {
                string = "Helvetica";
                break;
            }
            case 1: {
                string = "Helvetica";
                break;
            }
            case 2: {
                string = "Helvetica";
                break;
            }
            case 5: {
                string = "Helvetica";
                break;
            }
            case 4: {
                string = "Helvetica";
                break;
            }
            case 6: {
                string = "Helvetica";
                break;
            }
            case 7: {
                string = "Helvetica";
                break;
            }
            case 8: {
                string = "Helvetica";
                break;
            }
            case 9: {
                string = "Helvetica";
                break;
            }
            case 10: {
                string = "Helvetica";
                break;
            }
            case 11: {
                string = "Helvetica";
                break;
            }
            case 12: {
                string = "Helvetica";
                break;
            }
            case 13: {
                string = "Helvetica";
                break;
            }
            case 14: {
                string = "Helvetica";
                break;
            }
            case 15: {
                string = "Helvetica";
                break;
            }
            case 16: {
                string = "Helvetica";
                break;
            }
            case 17: {
                string = "Helvetica";
                break;
            }
            case 18: {
                string = "Helvetica";
                break;
            }
            case 19: {
                string = "Dialog";
                break;
            }
            case 20: {
                string = "Dialog";
                break;
            }
            default: {
                System.out.println("LandscapeEditorCore.getDefaultFontName() Illegal target " + n);
                string = "Helvetica";
            }
        }
        return string;
    }

    public int getDefaultFontStyle(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 5: {
                n2 = 0;
                break;
            }
            case 4: {
                n2 = 0;
                break;
            }
            case 6: {
                n2 = 1;
                break;
            }
            case 7: {
                n2 = 0;
                break;
            }
            case 8: {
                n2 = 1;
                break;
            }
            case 9: {
                n2 = 0;
                break;
            }
            case 10: {
                n2 = 1;
                break;
            }
            case 11: {
                n2 = 0;
                break;
            }
            case 12: {
                n2 = 0;
                break;
            }
            case 13: {
                n2 = 0;
                break;
            }
            case 14: {
                n2 = 0;
                break;
            }
            case 15: {
                n2 = 0;
                break;
            }
            case 16: {
                n2 = 1;
                break;
            }
            case 17: {
                n2 = 0;
                break;
            }
            case 18: {
                n2 = 0;
                break;
            }
            case 19: {
                n2 = 1;
                break;
            }
            case 20: {
                n2 = 0;
                break;
            }
            default: {
                System.out.println("LandscapeEditorCore.getDefaultFontStyle() Illegal target " + n);
                n2 = 0;
            }
        }
        return n2;
    }

    public int getDefaultFontSize(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 12;
                break;
            }
            case 1: {
                n2 = 12;
                break;
            }
            case 2: {
                n2 = 10;
                break;
            }
            case 5: {
                n2 = 9;
                break;
            }
            case 4: {
                n2 = 10;
                break;
            }
            case 6: {
                n2 = 14;
                break;
            }
            case 7: {
                n2 = 11;
                break;
            }
            case 8: {
                n2 = 12;
                break;
            }
            case 9: {
                n2 = 11;
                break;
            }
            case 10: {
                n2 = 12;
                break;
            }
            case 11: {
                n2 = 11;
                break;
            }
            case 12: {
                n2 = 11;
                break;
            }
            case 13: {
                n2 = 11;
                break;
            }
            case 14: {
                n2 = 11;
                break;
            }
            case 15: {
                n2 = 10;
                break;
            }
            case 16: {
                n2 = 14;
                break;
            }
            case 17: {
                n2 = 11;
                break;
            }
            case 18: {
                n2 = 11;
                break;
            }
            case 19: {
                n2 = 12;
                break;
            }
            case 20: {
                n2 = 12;
                break;
            }
            default: {
                System.out.println("LandscapeEditorCore.getDefaultFontSize() Illegal target " + n);
                n2 = 12;
            }
        }
        return n2;
    }

    public Font getTargetFont(int n) {
        Font font;
        switch (n) {
            case 0: {
                font = FontCache.get("Helvetica", 0, 12);
                break;
            }
            case 3: {
                font = EntityInstance.getOpenClassFont();
                break;
            }
            case 1: {
                font = EntityInstance.getClosedFont();
                break;
            }
            case 2: {
                font = EntityInstance.getSmallFont();
                break;
            }
            case 5: {
                font = Cardinal.m_font;
                break;
            }
            case 4: {
                font = ClientSupplierSet.getClientSupplierFont();
                break;
            }
            case 6: {
                font = ResultBox.getTitleFont();
                break;
            }
            case 7: {
                font = ResultBox.getTextFont();
                break;
            }
            case 8: {
                font = LegendBox.getTitleFont();
                break;
            }
            case 9: {
                font = LegendBox.getTextFont();
                break;
            }
            case 10: {
                font = QueryBox.getTitleFont();
                break;
            }
            case 11: {
                font = QueryBox.getTextFont();
                break;
            }
            case 12: {
                font = TextTree.getTextFont();
                break;
            }
            case 13: {
                font = UndoBox.getTextFont();
                break;
            }
            case 14: {
                font = HistoryBox.getTextFont();
                break;
            }
            case 15: {
                font = MapBox.getTextFont();
                break;
            }
            case 16: {
                font = TextBox.getTitleFont();
                break;
            }
            case 17: {
                font = TextBox.getTextFont();
                break;
            }
            case 18: {
                font = Feedback.getTextFont();
                break;
            }
            case 19: {
                font = FontCache.getMenuFont();
                break;
            }
            case 20: {
                font = FontCache.getDialogFont();
                break;
            }
            default: {
                System.out.println("LandscapeEditorCore.getTargetFont() Illegal target " + n);
                font = null;
            }
        }
        return font;
    }

    public void setTargetFont(int n, Font font) {
        switch (n) {
            case 0: {
                break;
            }
            case 3: {
                EntityInstance.setOpenClassFont(font);
                break;
            }
            case 1: {
                EntityInstance.setClosedFont(font);
                break;
            }
            case 2: {
                EntityInstance.setSmallFont(font);
                break;
            }
            case 5: {
                Cardinal.setDefaultFont(font);
                break;
            }
            case 4: {
                ClientSupplierSet.setClientSupplierFont(font);
                break;
            }
            case 8: {
                LegendBox.setTitleFont(font);
                if (this.m_legendBox == null) break;
                this.m_legendBox.titleFontChanged(font);
                break;
            }
            case 9: {
                LegendBox.setTextFont(font);
                if (this.m_legendBox == null) break;
                this.m_legendBox.textFontChanged(font);
                break;
            }
            case 6: {
                ResultBox.setTitleFont(font);
                break;
            }
            case 7: {
                ResultBox.setTextFont(font);
                break;
            }
            case 10: {
                QueryBox.setTitleFont(font);
                if (this.m_queryBox == null) break;
                this.m_queryBox.titleFontChanged(font);
                break;
            }
            case 11: {
                QueryBox.setTextFont(font);
                if (this.m_queryBox == null) break;
                this.m_queryBox.textFontChanged(font);
                break;
            }
            case 12: {
                TextTree.setTextFont(font);
                if (this.m_tocBox == null) break;
                this.m_tocBox.textFontChanged(font);
                break;
            }
            case 13: {
                UndoBox.setTextFont(font);
                if (this.m_undoBox == null) break;
                this.m_undoBox.textFontChanged(font);
                break;
            }
            case 14: {
                HistoryBox.setTextFont(font);
                if (this.m_historyBox == null) break;
                this.m_historyBox.textFontChanged(font);
                break;
            }
            case 15: {
                MapBox.setTextFont(font);
                if (this.m_mapBox == null) break;
                this.m_mapBox.textFontChanged(font);
                break;
            }
            case 16: {
                TextBox.setTitleFont(font);
                if (this.m_leftTextBoxTitle != null) {
                    this.m_leftTextBoxTitle.setFont(font);
                }
                if (this.m_rightTextBoxTitle == null) break;
                this.m_rightTextBoxTitle.setFont(font);
                break;
            }
            case 17: {
                TextBox.setTextFont(font);
                if (this.m_leftTextBox != null) {
                    this.m_leftTextBox.textFontChanged(font);
                }
                if (this.m_rightTextBox == null) break;
                this.m_rightTextBox.textFontChanged(font);
                break;
            }
            case 18: {
                Feedback.setTextFont(font);
                if (this.m_feedback != null) {
                    this.m_feedback.textFontChanged(font);
                }
                if (this.m_nameBox == null) break;
                this.m_nameBox.textFontChanged(font);
                break;
            }
            case 19: {
                this.setMenuFont(font);
                break;
            }
            case 20: {
                FontCache.setDialogFont(font);
            }
        }
    }

    public void setTargetFont(int n, Font font, boolean bl, boolean bl2, boolean bl3) {
        this.m_fonts_changed = true;
        if (n == 0) {
            for (int i = 0; i <= 20; ++i) {
                if (i == n) continue;
                if (bl || bl2 || bl3) {
                    String string = bl ? this.getDefaultFontName(i) : font.getName();
                    int n2 = bl2 ? this.getDefaultFontStyle(i) : font.getStyle();
                    int n3 = bl3 ? this.getDefaultFontSize(i) : font.getSize();
                    this.setTargetFont(i, FontCache.get(string, n2, n3));
                    continue;
                }
                this.setTargetFont(i, font);
            }
        } else {
            this.setTargetFont(n, font);
            this.redrawDg();
        }
    }

    public void handicapped(int n) {
        Font font = FontCache.get("Dialog", 1, n);
        this.setTargetFont(0, font, true, true, false);
    }

    public int remapToFontChooserId(int n) {
        if (n < 0 || n > 20) {
            return -1;
        }
        return n;
    }

    private void saveFonts(BufferedWriter bufferedWriter) {
        try {
            for (int i = 0; i <= 20; ++i) {
                int n = this.remapToFontChooserId(i);
                if (n < 0 || n == 0) continue;
                Font font = this.getTargetFont(n);
                String string = font.getName();
                int n2 = font.getStyle();
                int n3 = font.getSize();
                String string2 = this.getDefaultFontName(n);
                int n4 = this.getDefaultFontStyle(n);
                int n5 = this.getDefaultFontSize(n);
                if (string.equals(string2) && n2 == n4 && n3 == n5) continue;
                String string3 = "font=" + i + "," + string + "," + n2 + "," + n3;
                bufferedWriter.write(string3, 0, string3.length());
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception  " + exception + " caught when attempting to save fonts in $HOME/.lsedit");
        }
    }

    private void loadSavedFont(String string) {
        int n = 0;
        try {
            char c;
            int n2 = 5;
            while (true) {
                if (n2 >= string.length()) {
                    return;
                }
                c = string.charAt(n2);
                if (c == ',') break;
                if (c < '0' || c > '9') {
                    return;
                }
                n = n * 10 + (c - 48);
                ++n2;
            }
            if ((n = this.remapToFontChooserId(n)) < 0 || n == 0) {
                return;
            }
            int n3 = ++n2;
            while (true) {
                if (n3 >= string.length()) {
                    return;
                }
                c = string.charAt(n3);
                if (c == ',') break;
                ++n3;
            }
            if (n3 <= n2) {
                return;
            }
            String string2 = string.substring(n2, n3);
            int n4 = 0;
            n2 = ++n3;
            while (true) {
                if (n2 >= string.length()) {
                    return;
                }
                c = string.charAt(n2);
                if (c == ',') break;
                if (c < '0' || c > '9') {
                    return;
                }
                n4 += n4 * 10 + (c - 48);
                ++n2;
            }
            int n5 = 0;
            ++n2;
            while (n2 < string.length() && (c = string.charAt(n2)) != '\n' && c != ' ') {
                if (c < '0' || c > '9') {
                    return;
                }
                n5 += n5 * 10 + (c - 48);
                ++n2;
            }
            Font font = FontCache.get(string2, n4, n5);
            this.setTargetFont(n, font);
        }
        catch (Exception exception) {
            System.out.println("LandscapeEditorCore.loadSavedFont=" + n + " " + exception);
        }
    }

    public void processKeyEvent(int n, int n2, Object object) {
        if (n <= 90) {
            if (n >= 65) {
                if ((n2 & 1) != 0) {
                    n2 &= 0xFFFFFFFE;
                } else {
                    n += 32;
                }
            }
        } else if (n >= 112 && n <= 123 && (n2 & 0xA) == 0) {
            n += 1024;
        }
        this.processKey(n, n2, object);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.m_lsDropDown.getSelectedIndex();
        this.setDiagram(n);
        this.requestFocus();
    }
}

