/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.MyPaintableUndoableEdit;
import lsedit.MyUndoableEdit;

public abstract class LandscapeObject3D
extends LandscapeObject {
    private String m_id;
    private String m_description;
    private String m_label;
    private Color m_labelColor = null;
    private Color m_colorWhenOpen;

    public String toString() {
        return this.m_id;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String string) {
        this.m_id = string;
    }

    public boolean hasId(String string) {
        return this.m_id.equals(string);
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.m_description = string;
    }

    public void updateDescription(String string) {
        if (string == null ? this.m_description == null : string.equals(this.m_description)) {
            return;
        }
        new UpdateDescription(this, string);
    }

    protected void setLabel(String string) {
        JComponent jComponent = this.getSwingObject();
        this.m_label = string;
        if (jComponent != null) {
            jComponent.setToolTipText(string);
        }
    }

    public void updateLabel(String string) {
        if (string == null ? this.m_label == null : string.equals(this.m_label)) {
            return;
        }
        new UpdateLabel(this, string);
    }

    protected String getLabel() {
        return this.m_label;
    }

    public boolean hasLabelColor() {
        return this.m_labelColor != null;
    }

    public Color getLabelColor() {
        Color color = this.m_labelColor;
        if (color == null) {
            LandscapeClassObject landscapeClassObject;
            int n = 0;
            while ((landscapeClassObject = this.derivedFrom(n)) != null && (color = landscapeClassObject.getLabelColor()) == null) {
                ++n;
            }
        }
        return color;
    }

    public void setLabelColor(Color color) {
        this.m_labelColor = color;
    }

    public void updateLabelColor(Color color) {
        if (color == null ? this.m_labelColor == null : color.equals(this.m_labelColor)) {
            return;
        }
        new UpdateLabelColor(this, color);
    }

    public boolean hasColorWhenOpen() {
        return this.m_colorWhenOpen != null;
    }

    public Color getColorWhenOpen() {
        Color color = this.m_colorWhenOpen;
        if (color == null) {
            LandscapeClassObject landscapeClassObject;
            int n = 0;
            while ((landscapeClassObject = this.derivedFrom(n)) != null && (color = landscapeClassObject.getColorWhenOpen()) == null) {
                ++n;
            }
        }
        return color;
    }

    public void setColorWhenOpen(Color color) {
        this.m_colorWhenOpen = color;
    }

    public void updateColorWhenOpen(Color color) {
        if (color == null ? this.m_colorWhenOpen == null : color.equals(this.m_colorWhenOpen)) {
            return;
        }
        new UpdateColorWhenOpen(this, color);
    }

    public boolean canEditAttribute(int n) {
        if (n == 0) {
            return false;
        }
        return super.canEditAttribute(n);
    }

    class UpdateColorWhenOpen
    extends MyPaintableUndoableEdit
    implements UndoableEdit {
        LandscapeObject3D m_o;
        Color m_old;
        Color m_new;

        UpdateColorWhenOpen(LandscapeObject3D landscapeObject3D2, Color color) {
            this.m_o = landscapeObject3D2;
            this.m_old = landscapeObject3D2.m_colorWhenOpen;
            this.m_new = color;
            if (LandscapeObject3D.this.logEdit(this)) {
                landscapeObject3D2.m_colorWhenOpen = color;
            }
        }

        public String getPresentationName() {
            return this.m_o + " ColorWhenOpen ";
        }

        public void undo() {
            this.m_o.m_colorWhenOpen = this.m_old;
        }

        public void redo() {
            this.m_o.m_colorWhenOpen = this.m_new;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponentColor(graphics, n, n2, this.m_new);
        }

        public int getPreferredWidth() {
            return this.getPreferredWidthColor(this.m_o);
        }
    }

    class UpdateLabelColor
    extends MyPaintableUndoableEdit
    implements UndoableEdit {
        LandscapeObject3D m_o;
        Color m_old;
        Color m_new;

        UpdateLabelColor(LandscapeObject3D landscapeObject3D2, Color color) {
            this.m_o = landscapeObject3D2;
            this.m_old = landscapeObject3D2.m_labelColor;
            this.m_new = color;
            if (LandscapeObject3D.this.logEdit(this)) {
                landscapeObject3D2.m_labelColor = color;
            }
        }

        public String getPresentationName() {
            return this.m_o + " LabelColor ";
        }

        public void undo() {
            this.m_o.m_labelColor = this.m_old;
        }

        public void redo() {
            this.m_o.m_labelColor = this.m_new;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponentColor(graphics, n, n2, this.m_new);
        }

        public int getPreferredWidth() {
            return this.getPreferredWidthColor(this.m_o);
        }
    }

    class UpdateLabel
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject3D m_o;
        String m_old;
        String m_new;

        UpdateLabel(LandscapeObject3D landscapeObject3D2, String string) {
            this.m_o = landscapeObject3D2;
            this.m_old = landscapeObject3D2.m_label;
            this.m_new = string;
            if (LandscapeObject3D.this.logEdit(this)) {
                this.redo();
            }
        }

        public String getPresentationName() {
            return this.m_o + " Label " + this.m_new;
        }

        public void undo() {
            this.m_o.setLabel(this.m_old);
        }

        public void redo() {
            this.m_o.setLabel(this.m_new);
        }
    }

    class UpdateDescription
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject3D m_o;
        String m_old;
        String m_new;

        UpdateDescription(LandscapeObject3D landscapeObject3D2, String string) {
            this.m_o = landscapeObject3D2;
            this.m_old = landscapeObject3D2.m_description;
            this.m_new = string;
            if (LandscapeObject3D.this.logEdit(this)) {
                landscapeObject3D2.m_description = string;
            }
        }

        public String getPresentationName() {
            return this.m_o + " Description";
        }

        public void undo() {
            this.m_o.m_description = this.m_old;
        }

        public void redo() {
            this.m_o.m_description = this.m_new;
        }
    }
}

