/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.FontCache;
import lsedit.MatrixLayout;
import lsedit.SugiyamaLayout;

class MatrixConfigure
extends JDialog
implements ActionListener {
    MatrixLayout m_layout;
    protected JTextField m_border_textField;
    protected JTextField m_xgap_textField;
    protected JTextField m_ygap_textField;
    protected LayoutImage m_layoutImage;
    protected double m_default_border;
    protected double m_default_xgap;
    protected double m_default_ygap;
    protected double m_new_border;
    protected double m_new_xgap;
    protected double m_new_ygap;
    protected JLabel m_message;
    protected JButton m_ok;
    protected JButton m_default;
    protected JButton m_cancel;

    protected boolean newBorder() {
        double d;
        String string = this.m_border_textField.getText();
        try {
            d = Double.parseDouble(string);
            if (d < 0.0 || d > 1.0) {
                this.m_message.setText("Border must be a fraction between 0 and 1");
                return false;
            }
        }
        catch (Throwable throwable) {
            this.m_message.setText("Border not a double precision string value");
            return false;
        }
        this.m_new_border = d;
        return true;
    }

    protected boolean newXGap() {
        double d;
        String string = this.m_xgap_textField.getText();
        try {
            d = Double.parseDouble(string);
            if (d < 0.0 || d > 1.0) {
                this.m_message.setText("Horizontal gap must be a fraction between 0 and 1");
                return false;
            }
        }
        catch (Throwable throwable) {
            this.m_message.setText("Horizontal gap not a double precision value");
            return false;
        }
        this.m_new_xgap = d;
        return true;
    }

    protected boolean newYGap() {
        double d;
        String string = this.m_ygap_textField.getText();
        try {
            d = Double.parseDouble(string);
            if (d < 0.0 || d > 1.0) {
                this.m_message.setText("Vertical gap must be a fraction between 0 and 1");
                return false;
            }
        }
        catch (Throwable throwable) {
            this.m_message.setText("Vertical gap not a double precision string value");
            return false;
        }
        this.m_new_ygap = d;
        return true;
    }

    public MatrixConfigure(MatrixLayout matrixLayout, double d, double d2, double d3, double d4, double d5, double d6) {
        super(matrixLayout.getLs().getFrame(), matrixLayout.getName() + " Whitespace", true);
        this.m_layout = matrixLayout;
        this.m_default_border = d;
        this.m_default_xgap = d2;
        this.m_default_ygap = d3;
        this.m_new_border = d4;
        this.m_new_xgap = d5;
        this.m_new_ygap = d6;
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GridLayout gridLayout = new GridLayout(3, 1, 0, 10);
        jPanel2.setLayout(gridLayout);
        gridLayout = new GridLayout(3, 1, 0, 10);
        jPanel3.setLayout(gridLayout);
        JLabel jLabel = new JLabel("Border fraction of total:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_border_textField = new JTextField("" + this.m_new_border, 10);
        this.m_border_textField.setFont(font);
        this.m_border_textField.addActionListener(this);
        jPanel3.add(this.m_border_textField);
        jLabel = new JLabel("Horizontal whitespace fraction of grid:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_xgap_textField = new JTextField("" + this.m_new_xgap, 10);
        this.m_xgap_textField.setFont(font);
        this.m_xgap_textField.addActionListener(this);
        jPanel3.add(this.m_xgap_textField);
        jLabel = new JLabel("Vertical whitespace fraction of grid:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_ygap_textField = new JTextField("" + this.m_new_ygap, 10);
        this.m_ygap_textField.setFont(font);
        this.m_ygap_textField.addActionListener(this);
        jPanel3.add(this.m_ygap_textField);
        jPanel.add("West", jPanel2);
        jPanel.add("East", jPanel3);
        Container container = this.getContentPane();
        container.add("North", jPanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        this.m_layoutImage = new LayoutImage();
        jPanel4.add("North", this.m_layoutImage);
        this.m_layoutImage.validate();
        this.m_message = new JLabel(" ", 0);
        this.m_message.setFont(font);
        this.m_message.setForeground(Color.RED);
        this.m_message.setSize(400, 50);
        this.m_message.setPreferredSize(new Dimension(400, 50));
        jPanel4.add("South", this.m_message);
        container.add("Center", jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 15, 15));
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(font2);
        jPanel5.add(this.m_ok);
        this.m_ok.addActionListener(this);
        this.m_default = new JButton("Default");
        this.m_default.setFont(font2);
        jPanel5.add(this.m_default);
        this.m_default.addActionListener(this);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(font2);
        jPanel5.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        container.add("South", jPanel5);
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_default) {
            this.m_border_textField.setText("" + this.m_default_border);
            this.m_xgap_textField.setText("" + this.m_default_xgap);
            this.m_ygap_textField.setText("" + this.m_default_ygap);
            this.newBorder();
            this.newXGap();
            this.newYGap();
            this.m_layoutImage.validate();
            this.m_layoutImage.repaint();
            return;
        }
        if (object != this.m_cancel && object != this.m_ok) {
            if (!this.newBorder()) {
                return;
            }
            if (!this.newXGap()) {
                return;
            }
            if (!this.newYGap()) {
                return;
            }
            this.m_layoutImage.validate();
            this.m_layoutImage.repaint();
            return;
        }
        if (object == this.m_ok) {
            if (!this.newBorder()) {
                return;
            }
            if (!this.newXGap()) {
                return;
            }
            if (!this.newYGap()) {
                return;
            }
            this.m_layout.setBorder(this.m_new_border);
            this.m_layout.setXGap(this.m_new_xgap);
            this.m_layout.setYGap(this.m_new_ygap);
        }
        this.setVisible(false);
    }

    class LayoutImage
    extends JComponent
    implements MouseListener {
        Rectangle[] m_boxs;
        int m_rows = 2;
        boolean m_validated;

        public LayoutImage() {
            Dimension dimension = new Dimension(400, 240);
            this.setLayout(null);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setSize(dimension);
            this.m_boxs = new Rectangle[25];
            this.m_validated = false;
            this.addMouseListener(this);
            this.setVisible(true);
        }

        public void validate() {
            Rectangle[] rectangleArray = this.m_boxs;
            int n = rectangleArray.length;
            int n2 = this.m_rows;
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            int n5 = (int)((double)n3 * MatrixConfigure.this.m_new_border / 2.0);
            int n6 = (int)((double)n4 * MatrixConfigure.this.m_new_border / 2.0);
            int n7 = n3 - 2 * n5;
            int n8 = n4 - 2 * n6;
            this.m_validated = false;
            if (n7 < 1 || n8 < 1) {
                return;
            }
            int n9 = n2 - 1;
            double d = n9;
            int n10 = (int)(MatrixConfigure.this.m_new_xgap * (double)n7 / d);
            int n11 = (int)(MatrixConfigure.this.m_new_ygap * (double)n8 / d);
            int n12 = (n7 - n10 * n9) / n2;
            int n13 = (n8 - n11 * n9) / n2;
            if (n12 < 1 || n13 < 1) {
                return;
            }
            int n14 = 0;
            int n15 = 0;
            n = n2 * n2;
            for (int i = 0; i < n; ++i) {
                Rectangle rectangle = rectangleArray[i];
                if (rectangle == null) {
                    rectangleArray[i] = rectangle = new Rectangle();
                }
                rectangle.x = n5;
                if (n14 != 0) {
                    rectangle.x += n14 * (n12 + n10);
                }
                rectangle.y = n6;
                if (n15 != 0) {
                    rectangle.y += n15 * (n13 + n11);
                }
                rectangle.width = n12;
                rectangle.height = n13;
                if (++n14 != n2) continue;
                ++n15;
                n14 = 0;
            }
            this.m_validated = true;
        }

        public void paintComponent(Graphics graphics) {
            boolean bl = MatrixConfigure.this.m_layout instanceof SugiyamaLayout;
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
            if (this.m_validated) {
                Rectangle[] rectangleArray = this.m_boxs;
                graphics.setColor(Color.blue);
                int n3 = this.m_rows;
                int n4 = 0;
                int n5 = 0;
                int n6 = n3 * n3;
                for (int i = 0; i < n6; ++i) {
                    if (!bl || n5 >= n4) {
                        Rectangle rectangle = rectangleArray[i];
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    if (++n4 != n3) continue;
                    ++n5;
                    n4 = 0;
                }
                if (n3 == 2) {
                    String string = "Click to change dimensions";
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n7 = fontMetrics.stringWidth(string);
                    graphics.setColor(Color.black);
                    graphics.drawString(string, (n - n7) / 2, n2 / 2);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isMetaDown()) {
                --this.m_rows;
                if (this.m_rows < 2) {
                    this.m_rows = 5;
                }
            } else {
                ++this.m_rows;
                if (this.m_rows > 5) {
                    this.m_rows = 2;
                }
            }
            this.validate();
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

