/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.MsgOut;
import lsedit.MyUndoableEdit;
import lsedit.RelationClass;
import lsedit.RelationComponent;
import lsedit.Util;

public class RelationInstance
extends LandscapeObject {
    public static final int CLIENT_SUPPLIER_EL_LEN = 16;
    protected static final int NEAR_PIXEL_SIZE = 6;
    protected static final int LOOP_MARK = 1;
    protected static final int NORMAL_MARK = 2;
    protected static final int ELISION_MARK = 4;
    protected static final int OUT_ELIDED_MARK = 16;
    protected static final int IN_ELIDED_MARK = 32;
    protected static final int IN_DIAGRAM_MARK = 64;
    protected static final int VALID_MARK = 256;
    public static final int GROUP_FLAG_MARK = 512;
    public static final int HIGHLIGHT_FLAG_MARK = 1024;
    public static final int ADD_RESULTS_MARK = 2048;
    public static final int IN_OUT_ELIDED = 48;
    public static final int VARIOUS_TYPE_MARKS = 51;
    public static final int PRESENTATION_MARKS = 1536;
    protected EntityInstance m_src;
    protected EntityInstance m_dst;
    protected EntityInstance m_drawSrc;
    protected EntityInstance m_drawDst;
    protected int m_mark = 0;

    public RelationComponent neededComponent() {
        RelationComponent relationComponent = (RelationComponent)this.getSwingObject();
        if (relationComponent == null) {
            relationComponent = new RelationComponent(this);
        }
        return relationComponent;
    }

    public void repaint() {
        JComponent jComponent = this.getSwingObject();
        if (jComponent != null) {
            jComponent.repaint();
        }
    }

    public void validate() {
        JComponent jComponent = this.getSwingObject();
        if (jComponent != null) {
            jComponent.validate();
        }
    }

    public EdgePoint mouseOverEdgePoint(int n, int n2) {
        JComponent jComponent = this.getSwingObject();
        if (jComponent != null) {
            return ((RelationComponent)jComponent).mouseOverEdgePoint(n, n2);
        }
        return null;
    }

    protected boolean processFirstOrderAttributes(Attribute attribute) {
        boolean bl;
        boolean bl2 = bl = attribute.avi != null;
        if (attribute.id.equals("color")) {
            if (bl) {
                this.setObjectColor(attribute.parseColour());
            }
            return true;
        }
        if (attribute.id.equals("style")) {
            if (bl) {
                this.setStyle(attribute.parseInt());
            }
            return true;
        }
        return false;
    }

    public RelationInstance(RelationClass relationClass, EntityInstance entityInstance, EntityInstance entityInstance2) {
        this.setParentClass(relationClass);
        this.m_src = entityInstance;
        this.m_dst = entityInstance2;
        this.m_drawSrc = entityInstance;
        this.m_drawDst = entityInstance2;
    }

    public String getClassLabel() {
        return this.getRelationClass().getLabel();
    }

    public String getStyleName(int n) {
        return Util.getLineStyleName(n);
    }

    public void clearMark(int n) {
        RelationComponent relationComponent = (RelationComponent)this.getSwingObject();
        this.m_mark &= n;
        this.m_drawSrc = null;
        this.m_drawDst = null;
        this.setSwingObject(null);
    }

    public void orMark(int n) {
        this.m_mark |= n;
    }

    public void nandMark(int n) {
        this.m_mark &= ~n;
    }

    public boolean isMarked(int n) {
        return (this.m_mark & n) != 0;
    }

    public boolean isSrcVisible() {
        return this.m_src == this.m_drawSrc;
    }

    public boolean isDstVisible() {
        return this.m_dst == this.m_drawDst;
    }

    public void invalidateEdge() {
        this.nandMark(256);
    }

    public void setHighlightFlag() {
        if (!this.isMarked(1024)) {
            this.orMark(1024);
            this.repaint();
        }
    }

    public boolean getHighlightFlag() {
        return this.isMarked(1024);
    }

    public void clearHighlightFlag() {
        if (this.isMarked(1024)) {
            this.nandMark(1024);
            this.validate();
        }
    }

    public void setGroupAndHighlightFlag() {
        if ((this.m_mark & 0x600) != 1536) {
            this.orMark(1536);
            this.validate();
        }
    }

    public void drawHighlighted() {
        if (this.getHighlightFlag() && this.getRelationClass().isActive()) {
            this.draw(false);
        }
    }

    public void clearGroupFlag() {
        if (this.isMarked(512)) {
            this.nandMark(512);
            this.validate();
        }
    }

    public boolean getGroupFlag() {
        return this.isMarked(512);
    }

    public void draw(boolean bl) {
        Object object;
        if (this.isMarked(256)) {
            return;
        }
        RelationClass relationClass = this.getRelationClass();
        Diagram diagram = this.getDiagram();
        int n = 0;
        if (!bl || relationClass.isClassVisible()) {
            if (this.m_src == null || this.m_dst == null) {
                MsgOut.println("Landscape error: null src or dst");
                return;
            }
            object = this.m_drawSrc;
            EntityInstance entityInstance = this.m_drawDst;
            if (object == null) {
                System.out.println("draw() " + this + " has no draw src");
                return;
            }
            if (entityInstance == null) {
                System.out.println("draw() " + this + " has no draw dst");
                return;
            }
            EntityInstance entityInstance2 = diagram.getDrawRoot();
            if ((entityInstance2.hasDescendantOrSelf((EntityInstance)object) || entityInstance2.hasDescendantOrSelf(entityInstance)) && (object != entityInstance || object == this.m_src || entityInstance == this.m_dst)) {
                n = 2;
                if (bl) {
                    EntityInstance entityInstance3;
                    String string = relationClass.getId();
                    EntityInstance entityInstance4 = entityInstance.getContainedBy();
                    if (entityInstance3 != null && entityInstance3 == entityInstance4 && entityInstance3.isInternalRelationElided(string)) {
                        n = 0;
                    } else {
                        if (((EntityInstance)object).isSrcRelationElided(string)) {
                            n |= 0x10;
                        } else {
                            for (entityInstance3 = ((EntityInstance)object).getContainedBy(); entityInstance3 != null && !entityInstance3.hasDescendantOrSelf(entityInstance); entityInstance3 = entityInstance3.getContainedBy()) {
                                if (!entityInstance3.isExitingRelationElided(string)) continue;
                                n |= 0x10;
                                break;
                            }
                        }
                        if (entityInstance.isDstRelationElided(string)) {
                            n |= 0x20;
                        } else {
                            while (entityInstance4 != null && !entityInstance4.hasDescendantOrSelf((EntityInstance)object)) {
                                if (entityInstance4.isEnteringRelationElided(string)) {
                                    n |= 0x20;
                                    break;
                                }
                                entityInstance4 = entityInstance4.getContainedBy();
                            }
                        }
                    }
                }
                if (object == entityInstance && n == 2) {
                    n = 1;
                }
            }
        }
        if (n == 0) {
            if (this.isMarked(64)) {
                object = this.getSwingObject();
                if (object != null) {
                    diagram.remove((Component)object);
                    this.setSwingObject(null);
                }
                this.nandMark(64);
            }
        } else {
            n |= 0x100;
            if (bl) {
                n |= 4;
            }
            object = this.neededComponent();
            if (!this.isMarked(64)) {
                this.orMark(n |= 0x40);
                diagram.add((Component)object);
                ((JComponent)object).setVisible(true);
            } else {
                this.orMark(n);
            }
            ((Container)object).validate();
        }
    }

    public void addAttribute(Attribute attribute) {
        this.processFirstOrderAttributes(attribute);
    }

    public void assignAttributes(Attribute attribute) {
        while (attribute != null) {
            if (attribute.avi == null) {
                MsgOut.println("Null attribute assignment");
            } else if (!this.processFirstOrderAttributes(attribute)) {
                Attribute attribute2 = this.getLsAttribute(attribute.id);
                if (attribute2 == null) {
                    if (this.getDiagram().isUniversalScheme()) {
                        this.putLsAttribute(attribute);
                    } else {
                        MsgOut.println("Relation " + this + " missing attribute '" + attribute.toString() + "'");
                    }
                } else {
                    if (attribute2.m_cloneOnAssign) {
                        Attribute attribute3 = (Attribute)attribute2.clone();
                        this.replaceAttribute(attribute3);
                    }
                    attribute2.avi = attribute.avi;
                }
            }
            attribute = attribute.next;
        }
    }

    public void writeRelation(PrintStream printStream) throws IOException {
        printStream.print(this.qt(this.getParentClass().getId()) + " " + this.qt(this.m_src.getId()) + " " + this.qt(this.m_dst.getId()) + "\n");
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
        RelationClass relationClass = this.getRelationClass();
        int n = this.getStyle();
        if (n != -1 && (relationClass == null || relationClass.getStyle() != n)) {
            printStream2.print(" style = " + n + "\n");
        }
        super.writeAttributes(printStream2, relationClass, false);
        String string = byteArrayOutputStream.toString();
        if (string.length() != 0) {
            printStream.print("(" + this.qt(relationClass.getId()) + " " + this.qt(this.m_src.getId()) + " " + this.qt(this.m_dst.getId()) + ") {\n" + string + "}\n");
        }
    }

    public EntityInstance getSrc() {
        return this.m_src;
    }

    public void setSrc(EntityInstance entityInstance) {
        this.m_src = entityInstance;
    }

    public EntityInstance getDst() {
        return this.m_dst;
    }

    public EntityInstance getDrawSrc() {
        return this.m_drawSrc;
    }

    public EntityInstance getCurrentSrc() {
        if (this.m_drawSrc != null) {
            return this.m_drawSrc;
        }
        return this.m_src;
    }

    public EntityInstance getDrawDst() {
        return this.m_drawDst;
    }

    public EntityInstance getCurrentDst() {
        if (this.m_drawDst != null) {
            return this.m_drawDst;
        }
        return this.m_dst;
    }

    public RelationClass getRelationClass() {
        return (RelationClass)this.getParentClass();
    }

    public boolean matches(RelationInstance relationInstance) {
        return this.m_drawSrc == relationInstance.m_drawSrc && this.m_drawDst == relationInstance.m_drawDst;
    }

    protected void removeEdge() {
        this.getSrc().removeSrcRelation(this);
        this.getDst().removeDstRelation(this);
    }

    public void deleteEdge() {
        new DeleteEdge();
    }

    public String toString() {
        return this.m_drawSrc + (this.m_drawSrc == this.m_src ? "" : "{" + this.m_src + "}") + "->" + this.m_drawDst + (this.m_drawDst == this.m_dst ? "" : "{" + this.m_dst + "}");
    }

    public int getPrimaryAttributeCount() {
        return 3;
    }

    public String getLsAttributeNameAt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "class";
                break;
            }
            case 1: {
                string = "color";
                break;
            }
            case 2: {
                string = "style";
                break;
            }
            default: {
                string = super.getLsAttributeNameAt(n);
            }
        }
        return string;
    }

    public Object getLsAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                LandscapeClassObject landscapeClassObject = this.getParentClass();
                if (landscapeClassObject == null) {
                    object = null;
                    break;
                }
                object = landscapeClassObject.getId();
                break;
            }
            case 1: {
                if (this.hasObjectColor()) {
                    object = this.getObjectColor();
                    break;
                }
                object = null;
                break;
            }
            case 2: {
                object = new Integer(this.getStyle());
                break;
            }
            default: {
                object = super.getLsAttributeValueAt(n);
            }
        }
        return object;
    }

    public void setAttributeValueAt(int n, Object object) {
        block0 : switch (n) {
            case 0: {
                if (object == null) break;
                LandscapeClassObject landscapeClassObject = this.getParentClass();
                String string = (String)object;
                if (landscapeClassObject != null && landscapeClassObject.getId().equals(string)) break;
                Enumeration enumeration = this.getDiagram().enumRelationClasses();
                while (enumeration.hasMoreElements()) {
                    RelationClass relationClass = (RelationClass)enumeration.nextElement();
                    if (!relationClass.getId().equals(string)) continue;
                    this.updateParentClass(relationClass);
                    break block0;
                }
                break;
            }
            case 1: {
                this.updateObjectColor((Color)object);
                break;
            }
            case 2: {
                this.updateStyle((Integer)object);
                break;
            }
            default: {
                super.setAttributeValueAt(n, object);
            }
        }
    }

    public int getLsAttributeTypeAt(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 16;
                break;
            }
            case 1: {
                n2 = 8;
                break;
            }
            case 2: {
                n2 = 14;
                break;
            }
            default: {
                n2 = super.getLsAttributeTypeAt(n);
            }
        }
        return n2;
    }

    public void mouseEntered() {
        this.getDiagram().getLs().setCursor(12);
    }

    public void mouseExited() {
        this.getDiagram().getLs().setCursor(0);
    }

    public void mousePressed(MouseEvent mouseEvent, int n, int n2) {
        this.getDiagram().relationPressed(mouseEvent, this, n, n2);
    }

    public void mouseReleased(MouseEvent mouseEvent, int n, int n2) {
        this.getDiagram().relationReleased(mouseEvent, this, n, n2);
    }

    public void mouseDragged(MouseEvent mouseEvent, int n, int n2) {
        this.getDiagram().relationDragged(mouseEvent, this, n, n2);
    }

    public void mouseMoved(MouseEvent mouseEvent, int n, int n2) {
        Diagram diagram = this.getDiagram();
        if (this != m_infoShown) {
            m_infoShown = this;
            String string = this.m_src == this.m_drawSrc ? "" : Util.quoted(this.m_src.getEntityLabel()) + "->";
            string = string + Util.quoted(this.m_drawSrc.getEntityLabel()) + " " + this.getClassLabel() + " " + Util.quoted(this.m_drawDst.getEntityLabel());
            if (this.m_dst != this.m_drawDst) {
                string = string + "->" + Util.quoted(this.m_dst.getEntityLabel());
            }
            diagram.getLs().showInfo(string);
        }
        diagram.movedOverThing(mouseEvent, this, n, n2);
    }

    class DeleteEdge
    extends MyUndoableEdit
    implements UndoableEdit {
        DeleteEdge() {
            if (RelationInstance.this.logEdit(this)) {
                this.redo();
            }
        }

        public String getPresentationName() {
            return "Delete " + RelationInstance.this.toString();
        }

        public void undo() {
            Diagram diagram = RelationInstance.this.getDiagram();
            RelationInstance relationInstance = RelationInstance.this;
            relationInstance.getSrc().addSrcRelation(relationInstance);
            relationInstance.getDst().addDstRelation(relationInstance);
            diagram.redrawDiagram();
        }

        public void redo() {
            Diagram diagram = RelationInstance.this.getDiagram();
            RelationInstance relationInstance = RelationInstance.this;
            relationInstance.getSrc().removeSrcRelation(relationInstance);
            relationInstance.getDst().removeDstRelation(relationInstance);
            diagram.redrawDiagram();
        }
    }
}

