/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;
import lsedit.RelationInstance;

public class ResultBox
extends JComponent
implements Scrollable {
    protected static final Color m_titleColor = Color.red.darker();
    public static final String DEFAULT_RESULT_TITLE_FONT_NAME = "Helvetica";
    public static final int DEFAULT_RESULT_TITLE_FONT_STYLE = 1;
    public static final int DEFAULT_RESULT_TITLE_FONT_SIZE = 14;
    protected static Font m_titleFont = FontCache.get("Helvetica", 1, 14);
    public static final String DEFAULT_RESULT_TEXT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_RESULT_TEXT_FONT_STYLE = 0;
    public static final int DEFAULT_RESULT_TEXT_FONT_SIZE = 11;
    protected static Font m_textFont = FontCache.get("Helvetica", 0, 11);
    protected static final String m_indent = "    ";
    protected static final int horizontal_margin = 10;
    protected static final int vertical_indent = 10;
    public static final String m_helpStr = "This box shows the results of queries, and groupings";
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected BoxLayout m_boxLayout = new BoxLayout(this, 1);

    public ResultBox(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        this.setLayout(this.m_boxLayout);
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        this.setBackground(Diagram.boxColour);
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(0, 0, jTabbedPane.getWidth(), jTabbedPane.getHeight());
        Dimension dimension = this.m_scrollPane.getSize();
        this.setLocation(0, 0);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab("Results", null, this.m_scrollPane, m_helpStr);
    }

    public static Font getTitleFont() {
        return m_titleFont;
    }

    public static void setTitleFont(Font font) {
        m_titleFont = font;
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void clear() {
        this.removeAll();
        this.validate();
        this.repaint();
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (this.isVisible()) {
            Component component = this.m_tabbedPane.getSelectedComponent();
            return component != null && this.m_scrollPane == component;
        }
        return false;
    }

    public void setResultTitle(String string) {
        this.clear();
        if (string != null) {
            ResultLabel resultLabel = new ResultLabel();
            resultLabel.setText(string);
            resultLabel.setHorizontalAlignment(2);
            resultLabel.setFont(m_titleFont);
            resultLabel.setForeground(m_titleColor);
            this.add(resultLabel);
            this.add(Box.createVerticalStrut(5));
        }
    }

    public void addResultEntity(EntityInstance entityInstance) {
        this.add(new ResultEntity("", entityInstance, false));
    }

    public void addRelation(RelationInstance relationInstance) {
        this.add(new ResultRelation("", relationInstance, false));
    }

    public void addForwardRelation(EntityInstance entityInstance, RelationClass relationClass, Vector vector) {
        this.add(new ResultSet(entityInstance, relationClass, vector, true, false));
    }

    public void addBackRelation(EntityInstance entityInstance, RelationClass relationClass, Vector vector) {
        this.add(new ResultSet(entityInstance, relationClass, vector, false, false));
    }

    protected void addRelations(EntityInstance entityInstance, RelationClass relationClass, Vector vector, boolean bl) {
        this.add(new ResultSet(entityInstance, relationClass, vector, bl, true));
    }

    protected void addContents(EntityInstance entityInstance, Vector vector) {
        this.add(new ResultContents(entityInstance, vector));
    }

    public void addText(String string) {
        if (string != null) {
            ResultLabel resultLabel = new ResultLabel();
            resultLabel.setText(string);
            resultLabel.setHorizontalAlignment(2);
            resultLabel.setForeground(Color.black);
            this.add(resultLabel);
        }
    }

    public void done(String string) {
        if (string != null) {
            this.add(Box.createVerticalStrut(10));
            this.addText(string);
        }
        this.setPreferredSize(this.m_boxLayout.preferredLayoutSize(this));
        this.validate();
        this.m_scrollPane.revalidate();
    }

    public void showResults(String string, Vector vector, String string2) {
        this.setResultTitle(string);
        if (vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                this.addResultEntity(entityInstance);
            }
        } else {
            string2 = "No entities";
        }
        this.done(string2);
    }

    public String toString() {
        int n = this.getComponentCount();
        String string = "";
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            string = string + component.toString() + "\n---\n";
        }
        return string;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 50;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    class ResultContents
    extends VerticalResult {
        public ResultContents(EntityInstance entityInstance, Vector vector) {
            this.add(new ResultSetHeader(entityInstance, vector));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                ResultEntity resultEntity = new ResultEntity(ResultBox.m_indent, entityInstance2, true);
                this.add(resultEntity);
            }
        }
    }

    class ResultSet
    extends VerticalResult {
        public ResultSet(EntityInstance entityInstance, RelationClass relationClass, Vector vector, boolean bl, boolean bl2) {
            this.add(new ResultSetHeader(entityInstance, relationClass, bl, bl2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof EntityInstance) {
                    EntityInstance entityInstance2 = (EntityInstance)e;
                    ResultEntity resultEntity = new ResultEntity(ResultBox.m_indent, entityInstance2, false);
                    this.add(resultEntity);
                    continue;
                }
                RelationInstance relationInstance = (RelationInstance)e;
                ResultRelation resultRelation = new ResultRelation(ResultBox.m_indent, relationInstance, true);
                this.add(resultRelation);
            }
        }
    }

    class ResultSetHeader
    extends HorizontalResult {
        public ResultSetHeader(EntityInstance entityInstance, RelationClass relationClass, boolean bl, boolean bl2) {
            String string = bl2 ? "*" : "?";
            ResultLabel resultLabel = new ResultLabel();
            resultLabel.setText(" " + relationClass.getLabel());
            resultLabel.setHorizontalAlignment(0);
            ResultLabel resultLabel2 = new ResultLabel();
            if (bl) {
                ResultEntity resultEntity = new ResultEntity("", entityInstance, false);
                resultLabel2.setText(" " + string);
                resultLabel2.setHorizontalAlignment(2);
                this.add(resultEntity);
                this.add(resultLabel);
                this.add(resultLabel2);
            } else {
                resultLabel2 = new ResultLabel();
                resultLabel2.setText(string);
                resultLabel2.setHorizontalAlignment(2);
                ResultEntity resultEntity = new ResultEntity(" ", entityInstance, false);
                this.add(resultLabel2);
                this.add(resultLabel);
                this.add(resultEntity);
            }
        }

        public ResultSetHeader(EntityInstance entityInstance, Vector vector) {
            ResultEntity resultEntity = new ResultEntity("", entityInstance, false);
            ResultLabel resultLabel = new ResultLabel();
            resultLabel.setText(" contains (" + vector.size() + " items):");
            this.add(resultEntity);
            this.add(resultLabel);
        }
    }

    class ResultRelation
    extends HorizontalResult {
        protected RelationInstance m_relation;

        public ResultRelation(String string, RelationInstance relationInstance, boolean bl) {
            this.m_relation = relationInstance;
            ResultEntity resultEntity = new ResultEntity(string, relationInstance.getSrc(), false);
            this.add(resultEntity);
            if (!bl) {
                ResultLabel resultLabel = new ResultLabel();
                resultLabel.setText(" " + relationInstance.getClassLabel());
                resultLabel.setHorizontalAlignment(0);
                this.add(resultLabel);
            }
            resultEntity = new ResultEntity(" ", relationInstance.getDst(), false);
            this.add(resultEntity);
        }

        public boolean matches(RelationInstance relationInstance) {
            return this.m_relation.matches(relationInstance);
        }
    }

    class VerticalResult
    extends JComponent {
        public VerticalResult() {
            this.setLayout(new BoxLayout(this, 1));
        }

        public String toString() {
            int n = this.getComponentCount();
            String string = "";
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                string = string + component.toString() + "\n";
            }
            return string;
        }
    }

    class HorizontalResult
    extends JComponent {
        public HorizontalResult() {
            this.setAlignmentX(0.0f);
            this.setLayout(new BoxLayout(this, 0));
        }

        public String toString() {
            int n = this.getComponentCount();
            String string = "";
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                string = string + component.toString();
            }
            return string;
        }
    }

    class ResultEntity
    extends ResultLabel
    implements MouseListener {
        protected EntityInstance m_entity;

        public ResultEntity(String string, EntityInstance entityInstance, boolean bl) {
            this.m_entity = entityInstance;
            String string2 = string + entityInstance.getEntityLabel();
            if (bl) {
                string2 = string2 + " {" + entityInstance.getClassLabel() + "}";
            }
            this.setText(string2);
            this.setForeground(Color.blue);
            this.setToolTipText(entityInstance.getDescription());
            this.addMouseListener(this);
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.m_entity.isMarked(0x2000000) ? Color.black : Color.blue;
            this.setForeground(color);
            super.paintComponent(graphics);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.m_entity.isMarked(0x2000000)) {
                this.setForeground(Color.red);
                this.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.m_entity.isMarked(0x2000000)) {
                this.setForeground(Color.blue);
                this.repaint();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.m_entity.isMarked(0x2000000)) {
                this.setForeground(Color.blue);
                ResultBox.this.m_ls.followLink(this.m_entity, false);
            }
        }
    }

    class ResultLabel
    extends JLabel {
        public ResultLabel() {
            this.setHorizontalAlignment(2);
            this.setHorizontalTextPosition(2);
            this.setFont(m_textFont);
        }

        public String toString() {
            return this.getText();
        }
    }
}

