/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphLayout;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;

public class SimplexLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int BORDER = 30;

    public SimplexLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Simplex";
    }

    public String getMenuLabel() {
        return "Layout using Simplex algorithm";
    }

    protected static int edgesBetween(EntityInstance entityInstance, EntityInstance entityInstance2) {
        EntityInstance entityInstance3;
        int n = 0;
        Enumeration enumeration = entityInstance.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            RelationClass relationClass = relationInstance.getRelationClass();
            if (!relationClass.isClassVisible() || !entityInstance2.hasDescendantOrSelf(entityInstance3 = relationInstance.getDrawDst())) continue;
            ++n;
        }
        if (entityInstance.isOpen()) {
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance3 = (EntityInstance)enumeration.nextElement();
                n += SimplexLayout.edgesBetween(entityInstance3, entityInstance2);
            }
        }
        return n;
    }

    protected static int edgesFromClient(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        int n = 0;
        Enumeration enumeration = entityInstance.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getDrawSrc();
            if (!entityInstance2.isMarked(2)) continue;
            ++n;
        }
        if (entityInstance.isOpen()) {
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                n += SimplexLayout.edgesFromClient(entityInstance2);
            }
        }
        return n;
    }

    protected static int edgesToSupplier(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        int n = 0;
        Enumeration enumeration = entityInstance.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getDrawDst();
            if (!entityInstance2.isMarked(4)) continue;
            ++n;
        }
        if (entityInstance.isOpen()) {
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                n += SimplexLayout.edgesToSupplier(entityInstance2);
            }
        }
        return n;
    }

    public boolean isConfigurable() {
        return true;
    }

    public void configure(LandscapeEditorCore landscapeEditorCore) {
        HiGraphLayout.configure(landscapeEditorCore);
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        HiGraph hiGraph;
        int n;
        HiGraph hiGraph2;
        HiArc hiArc;
        EntityInstance entityInstance2;
        switch (vector.size()) {
            case 0: {
                return;
            }
            case 1: {
                EntityInstance entityInstance3 = (EntityInstance)vector.firstElement();
                double d5 = entityInstance3.widthRelLocal();
                double d6 = entityInstance3.heightRelLocal();
                double d7 = (1.0 - d5) / 2.0;
                double d8 = (1.0 - d6) / 2.0;
                if (bl) {
                    entityInstance3.updateRelLocal(d7, d8, d5, d6);
                } else {
                    entityInstance3.setXRelLocal(d7);
                    entityInstance3.setYRelLocal(d8);
                }
                return;
            }
        }
        HiGraphLayout hiGraphLayout = new HiGraphLayout();
        int n2 = entityInstance.getWidth();
        int n3 = entityInstance.getHeight();
        HiGraph hiGraph3 = new HiGraph(null, "root", 0, n3);
        double d9 = 0.0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            d9 += entityInstance2.heightRelLocal();
        }
        d9 /= (double)vector.size();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            hiGraph3.newChild(entityInstance2, entityInstance2.getEntityLabel(), (int)(entityInstance2.widthRelLocal() * (double)n2), (int)(d9 * (double)n3));
        }
        boolean bl2 = false;
        Vector vector2 = hiGraph3.children();
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            entityInstance2 = hiGraph2.getReferencedObject();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                EntityInstance entityInstance4;
                HiArc hiArc2 = (HiArc)enumeration2.nextElement();
                if (hiArc2 == hiArc || (n = SimplexLayout.edgesBetween(entityInstance2, entityInstance4 = (hiGraph = hiArc2.to()).getReferencedObject())) <= 0) continue;
                bl2 = true;
                hiArc = hiGraph.newInputArc(hiGraph2);
                hiArc.weight(n);
            }
        }
        HiGraph hiGraph4 = null;
        HiGraph hiGraph5 = null;
        if (bl2 && entityInstance != this.m_ls.getDiagram().getRootInstance()) {
            if (this.m_ls.isShowClients()) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    hiArc = (HiArc)enumeration.nextElement();
                    hiGraph = hiArc.to();
                    entityInstance2 = hiGraph.getReferencedObject();
                    if (entityInstance2 == null || (n = SimplexLayout.edgesFromClient(entityInstance2)) <= 0) continue;
                    if (hiGraph4 == null) {
                        hiGraph4 = hiGraph3.newChild(null, "client", 0, 0);
                    }
                    hiArc = this.m_ls.isTopClients() ? hiGraph.newInputArc(hiGraph4) : hiGraph4.newInputArc(hiGraph);
                    hiArc.weight(n);
                }
            }
            if (this.m_ls.isShowSuppliers()) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    hiArc = (HiArc)enumeration.nextElement();
                    hiGraph2 = hiArc.to();
                    entityInstance2 = hiGraph2.getReferencedObject();
                    if (entityInstance2 == null || (n = SimplexLayout.edgesToSupplier(entityInstance2)) <= 0) continue;
                    if (hiGraph5 == null) {
                        hiGraph5 = hiGraph3.newChild(null, "supplier", 0, 0);
                    }
                    hiArc = this.m_ls.isTopClients() ? hiGraph5.newInputArc(hiGraph2) : hiGraph2.newInputArc(hiGraph5);
                    hiArc.weight(n);
                }
            }
        }
        hiGraphLayout.layout(hiGraph3);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        bl2 = false;
        vector2 = hiGraph3.children();
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            entityInstance2 = hiGraph2.getReferencedObject();
            if (entityInstance2 == null) continue;
            int n8 = hiGraph2.x() - hiGraph2.width() / 2;
            int n9 = n8 + hiGraph2.width();
            int n10 = hiGraph2.y() - hiGraph2.height() / 2;
            int n11 = n10 + hiGraph2.height();
            if (!bl2) {
                n7 = n8;
                n6 = n9;
                n5 = n10;
                n4 = n11;
                bl2 = true;
                continue;
            }
            if (n8 < n7) {
                n7 = n8;
            }
            if (n9 > n6) {
                n6 = n9;
            }
            if (n10 < n5) {
                n5 = n10;
            }
            if (n11 <= n4) continue;
            n4 = n11;
        }
        int n12 = n6 - n7;
        n7 -= n12 / 30;
        n12 += 2 * n12 / 30;
        int n13 = n4 - n5;
        n5 -= n13 / 30;
        n13 += 2 * n13 / 30;
        if (n12 <= 0 || n13 <= 0) {
            return;
        }
        if (n12 > n2) {
            d3 = d4 = (double)n2 / (double)n12;
        } else {
            d4 = (double)n2 / (double)n12;
            d3 = 1.0;
        }
        if (n13 > n3) {
            d = d2 = (double)n3 / (double)n13;
        } else {
            d2 = (double)n3 / (double)n13;
            d = 1.0;
        }
        enumeration = hiGraph3.children().elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            entityInstance2 = hiGraph2.getReferencedObject();
            if (entityInstance2 == null) continue;
            double d10 = entityInstance2.widthRelLocal() * d3;
            double d11 = (double)(hiGraph2.x() - n7) * d4 / (double)n2 - d10 / 2.0;
            if (d11 + d10 > 1.0) {
                System.out.println("Simplex layout error: " + entityInstance2 + " xrel=" + d11 + " widthrel=" + d10 + " xrel+widthrel=" + (d11 + d10) + " > 1");
                d11 = 1.0 - d10;
            }
            double d12 = d9 * d;
            double d13 = (double)(hiGraph2.y() - n5) * d2 / (double)n3 - d12 / 2.0;
            if (d13 + d12 > 1.0) {
                System.out.println("Simplex layout error: yrel + heightrel > 1");
                d13 = 1.0 - d12;
            }
            if (bl) {
                entityInstance2.updateRelLocal(d11, d13, d10, d12);
                continue;
            }
            entityInstance2.setRelLocal(d11, d13, d10, d12);
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_ls.setLayouter(this);
        this.m_ls.setCursor(3);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            this.beep();
            return "No group selected";
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Simplex algorithm requires that all things laid out share same parent";
        }
        diagram.beginUndoRedo("Simplex layout");
        this.doLayout1(vector, entityInstance, true);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        return "Graph redrawn using Network Simplex algorithm";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }
}

