/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Diagram;
import lsedit.EntityCache;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeTokenStream;
import lsedit.MsgOut;
import lsedit.OrderedHashTableEnumeration;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.StringCache;
import lsedit.Util;

public class Ta
extends JPanel {
    public static final String INSTANCE_ID = "$INSTANCE";
    public static final String INHERIT_RELN = "$INHERIT";
    public static final String CONTAIN_ID = "contain";
    public static final String EDGEMODE_ID = "edgemode";
    public static final String TOPCLIENTS_ID = "topclients";
    public static final String WANTCLIENTS_ID = "wantclients";
    public static final String WANTSUPPLIERS_ID = "wantsuppliers";
    public static final String WANTCARDINALS_ID = "wantcardinals";
    public static final String SCALE_ID = "scale";
    public static final String RELN_HIDDEN_ID = "reln_hidden";
    public static final String NAVLINK_ID = "navlink";
    public static final int UPDATE_FREQ = 250;
    public static final String ROOT_ID = "$ROOT";
    private static final String BG_STR = "0.75";
    private static final String[] g_optionsAttributes = new String[]{"scale", "reln_hidden", "edgemode", "navlink", "topclients", "wantclients", "wantsuppliers", "wantcardinals"};
    protected LandscapeEditorCore m_ls;
    private Diagram m_diagram;
    protected EntityInstance m_rootInstance;
    protected RelationClass m_containsClass;
    protected int m_cIndex;
    private Hashtable m_entityClasses = new Hashtable(10);
    protected Hashtable m_relationClasses = new Hashtable(5);
    private Vector m_numToRel = new Vector(10);
    public RelationClass m_relationBaseClass;
    public EntityClass m_entityBaseClass;
    protected RelationClass m_defaultRelationClass = null;
    protected int m_numRelationClasses = 0;
    protected EntityClass m_defaultEntityClass = null;
    private int m_numEntityClasses = 0;
    private boolean m_universalScheme = false;
    private Object m_context;
    private String m_zipEntry;
    boolean m_uses_local_coordinates;
    private boolean m_schemeSetup = false;
    protected String m_resString = null;
    protected int m_progressCount;
    protected boolean m_changedFlag = false;
    protected int m_numberRelations;

    protected Diagram getDiagram() {
        return null;
    }

    public boolean getChangedFlag() {
        return this.m_changedFlag;
    }

    public void updateProgress() {
        int n = ++this.m_progressCount;
        StringBuffer stringBuffer = new StringBuffer("Loading: ");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('*');
        }
        this.m_ls.doFeedback(new String(stringBuffer));
    }

    public EntityClass getEntityClass(String string) {
        return (EntityClass)this.m_entityClasses.get(string);
    }

    private EntityClass addEntityClass(String string) {
        EntityClass entityClass = this.getEntityClass(string);
        if (entityClass == null) {
            entityClass = new EntityClass(string, this.m_numEntityClasses++, this.m_entityBaseClass, this.m_diagram);
            this.m_entityClasses.put(string, entityClass);
            if (this.m_defaultEntityClass == null) {
                this.m_defaultEntityClass = entityClass;
            }
        }
        return entityClass;
    }

    public EntityInstance getRootInstance() {
        return this.m_rootInstance;
    }

    public RelationClass getRelationClass(String string) {
        return (RelationClass)this.m_relationClasses.get(string);
    }

    private RelationClass addRelationClass(String string) {
        RelationClass relationClass = this.getRelationClass(string);
        if (relationClass == null) {
            relationClass = new RelationClass(string, this.m_numRelationClasses, this.m_relationBaseClass, this.m_diagram);
            this.m_relationClasses.put(string, relationClass);
            this.m_numToRel.addElement(relationClass);
            ++this.m_numRelationClasses;
            if (this.m_defaultRelationClass == null) {
                this.m_defaultRelationClass = relationClass;
            }
        }
        return relationClass;
    }

    public void addEdge(EntityInstance entityInstance, EntityInstance entityInstance2, RelationClass relationClass) {
        RelationInstance relationInstance = relationClass.newRelation(entityInstance, entityInstance2);
        entityInstance.addSrcRelation(relationInstance);
        entityInstance2.addDstRelation(relationInstance);
    }

    protected int getMaxCIndex() {
        int n = -1;
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            int n2 = relationClass.getCIndex();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected int getCIndex(RelationClass relationClass) {
        int n = relationClass.getCIndex();
        if (n < 0) {
            n = this.getMaxCIndex();
            relationClass.setCIndex(++n);
        }
        return n;
    }

    public boolean isUniversalScheme() {
        return this.m_universalScheme;
    }

    private void setupUniversalScheme() {
        this.m_relationBaseClass.addRelation(this.m_entityBaseClass, this.m_entityBaseClass);
        this.m_universalScheme = true;
    }

    private void processSchemeTuples(LandscapeTokenStream landscapeTokenStream) throws IOException {
        while (landscapeTokenStream.nextTriple()) {
            String string = landscapeTokenStream.m_verb;
            String string2 = landscapeTokenStream.m_object;
            EntityClass entityClass = this.addEntityClass(string2);
            EntityClass entityClass2 = this.addEntityClass(landscapeTokenStream.m_subject);
            if (string.equals(INHERIT_RELN)) {
                if (string2.equals("$ENTITY")) {
                    landscapeTokenStream.errorNS("Improper use of $ENTITY with $INHERIT");
                    return;
                }
                String string3 = entityClass.addParentClass(entityClass2);
                if (string3 == null) continue;
                landscapeTokenStream.errorNS(string3);
                continue;
            }
            RelationClass relationClass = this.addRelationClass(string);
            relationClass.addRelation(entityClass, entityClass2);
        }
    }

    private void processFactTuples(LandscapeTokenStream landscapeTokenStream) throws IOException {
        int n = 0;
        int n2 = 0;
        MsgOut.vprint("\nFACT TUPLE : ");
        while (landscapeTokenStream.nextTriple()) {
            LandscapeClassObject landscapeClassObject;
            String string = landscapeTokenStream.m_verb;
            String string2 = landscapeTokenStream.m_object;
            String string3 = landscapeTokenStream.m_subject;
            if (string.equals(INSTANCE_ID)) {
                EntityInstance entityInstance;
                if (++n % 250 == 0) {
                    MsgOut.vprint(".");
                    this.updateProgress();
                    this.m_ls.showInfo("Entities: " + n);
                }
                if ((entityInstance = EntityCache.get(string2)) == null) {
                    landscapeClassObject = this.getEntityClass(string3);
                    if (landscapeClassObject == null && this.isUniversalScheme()) {
                        landscapeClassObject = this.m_entityBaseClass;
                    }
                    if (landscapeClassObject != null) {
                        entityInstance = ((EntityClass)landscapeClassObject).newEntity(string2);
                        EntityCache.put(entityInstance);
                        continue;
                    }
                    landscapeTokenStream.errorNS("EntityClass '" + string3 + "' has not been declared");
                    continue;
                }
                landscapeClassObject = entityInstance.getEntityClass();
                if (landscapeClassObject.hasId(string3)) {
                    landscapeTokenStream.warning("Redeclaration of " + entityInstance.toString());
                    continue;
                }
                landscapeTokenStream.errorNS("Attempt to declare " + entityInstance.getId() + " as instanceof " + string3 + ". Currently declared as instanceof " + landscapeClassObject.getId());
                continue;
            }
            if (++n2 % 250 == 0) {
                MsgOut.vprint(".");
                this.updateProgress();
                this.m_ls.showInfo("Relations: " + n2);
            }
            landscapeClassObject = this.getRelationClass(string);
            EntityInstance entityInstance = EntityCache.get(string2);
            EntityInstance entityInstance2 = EntityCache.get(string3);
            if (this.m_universalScheme) {
                if (landscapeClassObject == null) {
                    landscapeClassObject = this.m_relationBaseClass;
                }
                if (entityInstance == null) {
                    entityInstance = this.m_entityBaseClass.newEntity(string2);
                    EntityCache.put(entityInstance);
                }
                if (entityInstance2 == null) {
                    entityInstance2 = this.m_entityBaseClass.newEntity(string3);
                    EntityCache.put(entityInstance2);
                }
            }
            if (landscapeClassObject == null) {
                landscapeTokenStream.errorNS("Can't process: (" + string + " " + string2 + " " + string3 + ") - Missing '" + string + "'");
                continue;
            }
            if (entityInstance == null) {
                landscapeTokenStream.errorNS("Can't process: (" + string + " " + string2 + " " + string3 + ") - Missing '" + string2 + "'");
                continue;
            }
            if (entityInstance2 == null) {
                landscapeTokenStream.errorNS("Can't process: (" + string + " " + string2 + " " + string3 + ") - Missing '" + string3 + "'");
                continue;
            }
            this.addEdge(entityInstance, entityInstance2, (RelationClass)landscapeClassObject);
        }
        this.m_numberRelations = n2;
    }

    private void writeSchemeTuples(PrintStream printStream) throws IOException {
        Enumeration enumeration;
        printStream.print("// Landscape TA file\n\n");
        printStream.print("SCHEME TUPLE :\n\n// The ERD\n\n");
        Enumeration enumeration2 = this.enumEntityClassesInOrder();
        while (enumeration2.hasMoreElements()) {
            EntityClass entityClass = (EntityClass)enumeration2.nextElement();
            if (entityClass == this.m_entityBaseClass) continue;
            enumeration = entityClass.getParentElements();
            while (enumeration.hasMoreElements()) {
                EntityClass entityClass2 = (EntityClass)enumeration.nextElement();
                if (entityClass2 == this.m_entityBaseClass) continue;
                printStream.print("$INHERIT " + entityClass.getId() + " " + entityClass2.getId() + "\n");
            }
        }
        printStream.print("\n");
        enumeration = this.enumRelationClassesInOrder();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            relationClass.writeRelations(printStream);
        }
    }

    private void writeSchemeAttributes(PrintStream printStream) throws IOException {
        LandscapeClassObject landscapeClassObject;
        printStream.print("\n\nSCHEME ATTRIBUTE :\n\n");
        printStream.print("// EntityClass attributes\n\n");
        Enumeration enumeration = this.m_entityClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (EntityClass)enumeration.nextElement();
            ((EntityClass)landscapeClassObject).writeAttributes(printStream);
        }
        enumeration = this.m_relationClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (RelationClass)enumeration.nextElement();
            ((RelationClass)landscapeClassObject).writeAttributes(printStream);
        }
    }

    private void writeFactAttributes(PrintStream printStream) throws IOException {
        printStream.print("\n\nFACT ATTRIBUTE :\n\n");
        this.m_rootInstance.writeOptionsAttributes(printStream);
        Enumeration enumeration = this.m_rootInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeAttributes(printStream, this.m_cIndex);
        }
    }

    private void writeFactTuples(PrintStream printStream) throws IOException {
        EntityInstance entityInstance;
        printStream.print("\n\nFACT TUPLE :\n\n");
        printStream.print("// Instances of entity classes\n\n");
        Enumeration enumeration = this.m_rootInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeInstances(printStream);
        }
        enumeration = this.m_rootInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeRelations(printStream);
        }
    }

    public RelationClass getContainsClass() {
        return this.m_containsClass;
    }

    public String getContainsId() {
        return this.m_containsClass.getLabel();
    }

    public void setContainsClass(RelationClass relationClass) {
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass2;
            relationClass2.setContainsClass((relationClass2 = (RelationClass)enumeration.nextElement()) == relationClass);
        }
        this.m_containsClass = relationClass;
    }

    protected RelationInstance newEdge(EntityInstance entityInstance, RelationClass relationClass, EntityInstance entityInstance2) {
        RelationInstance relationInstance = new RelationInstance(relationClass, entityInstance, entityInstance2);
        entityInstance.addSrcRelation(relationInstance);
        entityInstance2.addDstRelation(relationInstance);
        return relationInstance;
    }

    public boolean entityExists(String string) {
        return EntityCache.get(string) != null;
    }

    private void computeRelCoordinates() {
        this.m_rootInstance.computeRelCoordinates(this.m_rootInstance.xRelLocal(), this.m_rootInstance.yRelLocal(), this.m_rootInstance.widthRelLocal(), this.m_rootInstance.heightRelLocal());
    }

    public void emptyDiagram() {
        this.m_uses_local_coordinates = false;
        this.m_schemeSetup = true;
        this.setupUniversalScheme();
        this.m_defaultEntityClass = this.m_entityBaseClass;
        this.m_defaultRelationClass = this.m_relationBaseClass;
        EntityInstance entityInstance = this.m_entityBaseClass.newEntity("BLANK");
        EntityCache.put(entityInstance);
        this.m_rootInstance = entityInstance;
        entityInstance.prepostorder(1);
    }

    private void parseStream(InputStream inputStream, String string, URL uRL) {
        MsgOut.vprintln("Parse TA file: " + string);
        this.m_uses_local_coordinates = false;
        this.m_cIndex = 0;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            LandscapeTokenStream landscapeTokenStream = new LandscapeTokenStream(bufferedInputStream, string);
            while (true) {
                int n;
                if ((n = landscapeTokenStream.nextSection()) == 99) {
                    MsgOut.vprintln("");
                    break;
                }
                try {
                    switch (n) {
                        case 0: {
                            this.m_schemeSetup = true;
                            this.m_universalScheme = false;
                            this.processSchemeTuples(landscapeTokenStream);
                            this.updateProgress();
                            break;
                        }
                        case 1: {
                            if (!this.m_schemeSetup) {
                                this.m_schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            landscapeTokenStream.processSchemeAttributes(this);
                            this.updateProgress();
                            break;
                        }
                        case 2: {
                            if (!this.m_schemeSetup) {
                                this.m_schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            this.processFactTuples(landscapeTokenStream);
                            break;
                        }
                        case 3: {
                            landscapeTokenStream.processFactAttributes(this);
                            break;
                        }
                        case 4: {
                            if (this.m_context == null) {
                                this.parseFile(landscapeTokenStream.getIncludeFile(), null);
                            } else {
                                this.parseURL(landscapeTokenStream.getIncludeFile(), uRL);
                            }
                            MsgOut.vprintln("Back to TA file: " + string);
                        }
                    }
                }
                catch (IOException iOException) {
                    MsgOut.println("IO error reading landscape");
                    this.m_resString = iOException.toString();
                    break;
                }
            }
            bufferedInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            this.m_resString = exception.toString();
            System.out.println("Parse error: " + this.m_resString);
        }
    }

    private InputStream decompress(InputStream inputStream, String string, String string2) {
        InputStream inputStream2 = inputStream;
        int n = string.length();
        if (n > 4) {
            String string3 = string.substring(n - 4);
            if (string3.equalsIgnoreCase(".zip")) {
                ZipInputStream zipInputStream;
                try {
                    zipInputStream = new ZipInputStream(inputStream);
                    while (true) {
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (string2 != null && !string2.equalsIgnoreCase(zipEntry.getName())) {
                            zipInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Attempt to open " + string + (string2 == null ? "" : "#" + string2) + " as zip file failed");
                    this.m_resString = exception.toString();
                    zipInputStream = null;
                }
                return zipInputStream;
            }
            if (string3.equalsIgnoreCase(".jar")) {
                JarInputStream jarInputStream;
                try {
                    jarInputStream = new JarInputStream(inputStream);
                    while (true) {
                        ZipEntry zipEntry = jarInputStream.getNextEntry();
                        if (string2 != null && !string2.equalsIgnoreCase(zipEntry.getName())) {
                            jarInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Attempt to open " + string + (string2 == null ? "" : "#" + string2) + " as jar file failed");
                    this.m_resString = exception.toString();
                    jarInputStream = null;
                }
                return jarInputStream;
            }
            if (n > 5 && (string3 = string.substring(n - 5)).equalsIgnoreCase(".gzip")) {
                GZIPInputStream gZIPInputStream;
                try {
                    gZIPInputStream = new GZIPInputStream(inputStream);
                }
                catch (Exception exception) {
                    System.out.println("Attempt to open " + string + " as gzip file failed");
                    this.m_resString = exception.toString();
                    gZIPInputStream = null;
                }
                return gZIPInputStream;
            }
        }
        return inputStream;
    }

    private URL parseURL(String string, URL uRL) {
        int n;
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        String string2 = null;
        if (n2 > 2 && c == ']' && (n = string.lastIndexOf(91)) > 0 && n < n2 - 2) {
            string2 = string.substring(n + 1, n2 - 1);
            string = string.substring(0, n);
            if (this.m_zipEntry == null) {
                this.m_zipEntry = string2;
            }
            n2 = n;
            c = string.charAt(n2 - 1);
        }
        if (c == File.separatorChar) {
            string = string.substring(0, n2 - 1);
        }
        this.m_progressCount = 0;
        this.updateProgress();
        try {
            URL uRL2 = uRL == null ? new URL(string) : new URL(uRL, string);
            MsgOut.dprintln("Opening URL: " + string);
            InputStream inputStream = uRL2.openStream();
            inputStream = this.decompress(inputStream, string, string2);
            if (inputStream == null) {
                return null;
            }
            MsgOut.dprintln("opened");
            this.parseStream(inputStream, string, uRL2);
            return uRL2;
        }
        catch (Exception exception) {
            this.m_resString = exception.toString();
            return null;
        }
    }

    private File parseFile(String string, File file) {
        int n;
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        String string2 = null;
        if (n2 > 2 && c == ']' && (n = string.lastIndexOf(91)) > 0 && n < n2 - 2) {
            string2 = string.substring(n + 1, n2 - 1);
            if (this.m_zipEntry == null) {
                this.m_zipEntry = string2;
            }
            string = string.substring(0, n);
            n2 = n;
            c = string.charAt(n2 - 1);
        }
        if (c == File.separatorChar) {
            string = string.substring(0, n2 - 1);
        }
        this.m_progressCount = 0;
        this.updateProgress();
        try {
            Object object;
            File file2;
            if (file == null) {
                file2 = new File(string);
            } else {
                object = this.getDir(file);
                file2 = new File((String)object, string);
            }
            object = new FileInputStream(file2);
            object = this.decompress((InputStream)object, string, string2);
            if (object == null) {
                return null;
            }
            this.parseStream((InputStream)object, string, null);
            return file2;
        }
        catch (Exception exception) {
            this.m_resString = exception.toString();
            return null;
        }
    }

    public Ta(LandscapeEditorCore landscapeEditorCore) {
        this.m_ls = landscapeEditorCore;
        this.m_diagram = this.getDiagram();
        this.m_entityBaseClass = new EntityClass("$ENTITY", this.m_numEntityClasses++, null, this.m_diagram);
        this.m_entityClasses.put("$ENTITY", this.m_entityBaseClass);
        this.m_rootInstance = new EntityInstance(this.m_entityBaseClass, ROOT_ID);
        this.m_rootInstance.setRelLocal(0.0, 0.0, 1.0, 1.0);
        EntityCache.put(this.m_rootInstance);
        for (int i = 0; i < g_optionsAttributes.length; ++i) {
            this.m_rootInstance.addAttribute(new Attribute(g_optionsAttributes[i], null));
        }
        AttributeValueItem attributeValueItem = new AttributeValueItem(BG_STR);
        attributeValueItem.next = new AttributeValueItem(BG_STR);
        attributeValueItem.next.next = new AttributeValueItem(BG_STR);
        this.m_rootInstance.addAttribute(new Attribute("color", attributeValueItem));
        this.m_relationBaseClass = new RelationClass("$RELATION", this.m_numRelationClasses++, null, this.m_diagram);
        this.m_relationClasses.put("$RELATION", this.m_relationBaseClass);
        this.m_numToRel.addElement(this.m_relationBaseClass);
        RelationClass relationClass = new RelationClass(CONTAIN_ID, this.m_numRelationClasses++, this.m_relationBaseClass, this.m_diagram);
        relationClass.setCIndex(0);
        this.m_relationClasses.put(CONTAIN_ID, relationClass);
        this.m_numToRel.addElement(relationClass);
    }

    public LandscapeEditorCore getLs() {
        return this.m_ls;
    }

    public Enumeration enumRelationClasses() {
        return this.m_relationClasses.elements();
    }

    public Enumeration enumRelationClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_relationClasses);
    }

    public int numRelationClasses() {
        return this.m_numRelationClasses;
    }

    public Enumeration enumEntityClasses() {
        return this.m_entityClasses.elements();
    }

    public Enumeration enumEntityClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_entityClasses);
    }

    public int numEntityClasses() {
        return this.m_numEntityClasses;
    }

    public Object getContext() {
        return this.m_context;
    }

    public void setContext(Object object) {
        this.m_context = object;
    }

    public String getContextName() {
        String string = this.m_context instanceof File ? Util.nameFromPath(((File)this.m_context).getPath()) : this.m_rootInstance.getEntityLabel();
        if (this.m_zipEntry != null) {
            string = string + "[" + this.m_zipEntry + "]";
        }
        return string;
    }

    public String getDir(File file) {
        if (file.isAbsolute()) {
            return file.getParent();
        }
        return new File(file.getAbsolutePath()).getParent();
    }

    public String getDir() {
        return this.getDir((File)this.m_context);
    }

    public String getAbsolutePath() {
        if (this.m_context != null && this.m_context instanceof File) {
            return ((File)this.m_context).getAbsolutePath();
        }
        return null;
    }

    public RelationClass numToRelationClass(int n) {
        return (RelationClass)this.m_numToRel.elementAt(n);
    }

    public void saveDiagram(OutputStream outputStream, boolean bl) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        PrintStream printStream = new PrintStream(bufferedOutputStream);
        this.writeSchemeTuples(printStream);
        this.writeSchemeAttributes(printStream);
        this.writeFactTuples(printStream);
        this.writeFactAttributes(printStream);
        if (bl) {
            printStream.print("END\n");
        }
        printStream.flush();
        printStream.close();
        this.m_changedFlag = false;
    }

    public String loadTA(String string, Object object) {
        this.m_containsClass = null;
        this.m_resString = null;
        this.m_zipEntry = null;
        if (string == null) {
            this.emptyDiagram();
        } else {
            int n = string.length();
            if (n == 0) {
                this.emptyDiagram();
            } else if (object instanceof URL || Util.isHTTP(string)) {
                MsgOut.dprintln("Parse a URL");
                this.setContext(this.parseURL(string, (URL)object));
            } else {
                MsgOut.dprintln("Parse a file");
                this.setContext(this.parseFile(string, (File)object));
            }
        }
        if (this.m_defaultEntityClass == null) {
            this.m_defaultEntityClass = this.m_entityBaseClass;
        }
        if (this.m_defaultRelationClass == null) {
            this.m_defaultRelationClass = this.m_relationBaseClass;
        }
        StringCache.clear();
        RelationClass relationClass = null;
        Enumeration enumeration = this.m_relationClasses.elements();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass2 = (RelationClass)enumeration.nextElement();
            if (!relationClass2.isContainsClass()) continue;
            if (relationClass != null) {
                relationClass.setContainsClass(false);
            }
            relationClass = relationClass2;
        }
        if (relationClass == null) {
            relationClass = this.getRelationClass(CONTAIN_ID);
        }
        if (relationClass == null) {
            JOptionPane.showMessageDialog(this.m_ls.getFrame(), "No containing relation class defined", "Unable to build visualisation tree", 0);
            return "No contains relation class defined";
        }
        if (!this.m_diagram.establishRootInstance(relationClass)) {
            return "Contains class does not form a forest";
        }
        if (this.m_uses_local_coordinates) {
            this.computeRelCoordinates();
        }
        if (this.m_context == null) {
            return this.m_resString;
        }
        return null;
    }

    public int getNumberEntitiesLoaded() {
        return EntityCache.size();
    }

    public int getNumberRelationsLoaded() {
        return this.m_numberRelations;
    }
}

