/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyMenuItem;

public class TextTree
extends JComponent
implements MouseListener {
    public static final String m_helpStr = "Right click for menu.";
    protected static final String[] m_say = new String[]{"Table of contents is hidden", "Press Alt-v or click to show TOC"};
    protected static final int margin = 10;
    protected static final int say_height = 30;
    protected static final Color titleColor = Color.red.darker();
    public static final String DEFAULT_TOC_FONT_NAME = "Helvetica";
    public static final int DEFAULT_TOC_FONT_STYLE = 0;
    public static final int DEFAULT_TOC_FONT_SIZE = 11;
    protected static Font m_textFont = FontCache.get("Helvetica", 0, 11);
    protected LandscapeEditorCore m_ls;
    protected MyTree m_tree;
    protected JPanel m_say_panel;
    protected JComponent m_use;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected JLabel[] m_say_labels;
    protected boolean m_firsttime = true;

    public TextTree(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        this.setLayout(null);
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        this.m_say_panel = new JPanel();
        this.m_say_panel.setLayout(new GridLayout(0, 1));
        int n = m_say.length;
        this.m_say_labels = new JLabel[n];
        for (int i = 0; i < n; ++i) {
            JLabel jLabel;
            this.m_say_labels[i] = jLabel = new JLabel(m_say[i]);
            jLabel.setBackground(Diagram.boxColour);
            jLabel.setForeground(Color.red);
            jLabel.setFont(m_textFont);
            jLabel.setVisible(true);
            this.m_say_panel.add(jLabel);
        }
        this.m_say_panel.setSize(this.m_say_panel.getPreferredSize());
        this.fillTOC();
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(0, 0, jTabbedPane.getWidth(), jTabbedPane.getHeight());
        this.setBounds(0, 0, jTabbedPane.getWidth(), jTabbedPane.getHeight());
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab("TOC", null, this.m_scrollPane, m_helpStr);
        this.addMouseListener(this);
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void textFontChanged(Font font) {
        for (JLabel jLabel : this.m_say_labels) {
            jLabel.setFont(font);
        }
        this.m_tree.setFont(font);
        this.fillTOC();
    }

    public void firstTime() {
        this.m_firsttime = true;
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component component = this.m_tabbedPane.getSelectedComponent();
        return component != null && this.m_scrollPane == component;
    }

    protected JPopupMenu buildPopup() {
        Diagram diagram = this.m_ls.getDiagram();
        JPopupMenu jPopupMenu = new JPopupMenu("TOC options");
        if (this.m_use != null && this.m_use == this.m_tree && diagram != null) {
            Vector vector = diagram.getClipboard();
            TreePath[] treePathArray = this.m_tree.getSelectionPaths();
            if (vector == null || vector.size() == 0) {
                if (treePathArray != null && treePathArray.length > 0) {
                    MyMenuItem myMenuItem = Do.cutMenuItem(jPopupMenu, this.m_ls);
                    myMenuItem.setObject(this);
                    myMenuItem = Do.addcutMenuItem(jPopupMenu, this.m_ls);
                    myMenuItem.setObject(this);
                }
            } else if (treePathArray != null && treePathArray.length == 1) {
                MyMenuItem myMenuItem = Do.pasteMenuItem(jPopupMenu, this.m_ls);
                myMenuItem.setObject(this);
            }
        }
        Do.openCloseTOCMenuItem(jPopupMenu, this.m_ls);
        Do.alignTOCMenuItem(jPopupMenu, this.m_ls);
        this.m_ls.hideTOCMenuItem(jPopupMenu, this.m_ls);
        FontCache.setMenuTreeFont(jPopupMenu);
        return jPopupMenu;
    }

    public Vector getGroup() {
        int n;
        TreePath[] treePathArray;
        Vector<EntityInstance> vector = null;
        if (this.m_use != null && this.m_use == this.m_tree && (treePathArray = this.m_tree.getSelectionPaths()) != null && (n = treePathArray.length) > 0) {
            vector = new Vector<EntityInstance>(n);
            for (int i = 0; i < n; ++i) {
                MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[i].getLastPathComponent();
                EntityInstance entityInstance = (EntityInstance)((DefaultMutableTreeNode)mutableTreeNode).getUserObject();
                vector.add(entityInstance);
            }
        }
        return vector;
    }

    public EntityInstance targetEntity() {
        TreePath[] treePathArray;
        if (this.m_use != null && this.m_use == this.m_tree && (treePathArray = this.m_tree.getSelectionPaths()) != null && treePathArray.length == 1) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[0].getLastPathComponent();
            EntityInstance entityInstance = (EntityInstance)((DefaultMutableTreeNode)mutableTreeNode).getUserObject();
            return entityInstance;
        }
        return null;
    }

    protected void syncSizes() {
        Dimension dimension = this.m_use.getPreferredSize();
        this.m_use.setSize(dimension);
        this.setSize(dimension);
    }

    public void emptyTOC() {
        this.removeAll();
        this.m_use = null;
        if (this.m_tree != null) {
            this.m_tree = null;
        }
    }

    protected void fillTOC(DefaultMutableTreeNode defaultMutableTreeNode, EntityInstance entityInstance) {
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(entityInstance2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.fillTOC(defaultMutableTreeNode2, entityInstance2);
        }
    }

    protected void fillTOC() {
        JComponent jComponent;
        Diagram diagram = this.m_ls.getDiagram();
        this.removeAll();
        this.m_use = null;
        this.m_tree = null;
        if (this.m_firsttime && this.m_ls.isTocHidden()) {
            this.m_ls.setTocHiddenState(false);
            this.m_firsttime = false;
        }
        if (this.m_ls.isTocHidden() || diagram == null) {
            jComponent = this.m_say_panel;
            this.setSize(jComponent.getPreferredSize());
        } else {
            this.m_tree = new MyTree(this);
            this.m_tree.setBackground(Diagram.boxColour);
            this.m_tree.setFont(m_textFont);
            this.m_tree.setEditable(false);
            this.m_tree.setShowsRootHandles(true);
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.m_tree.getCellRenderer();
            defaultTreeCellRenderer.setBackgroundNonSelectionColor(Diagram.boxColour);
            this.m_tree.setCellRenderer(defaultTreeCellRenderer);
            this.m_tree.getSelectionModel().setSelectionMode(4);
            this.m_tree.setDragEnabled(true);
            EntityInstance entityInstance = diagram.getRootInstance();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(entityInstance);
            this.m_tree.setModel(new DefaultTreeModel(defaultMutableTreeNode, false));
            this.fillTOC(defaultMutableTreeNode, entityInstance);
            jComponent = this.m_tree;
        }
        this.add(jComponent);
        this.m_use = jComponent;
        this.syncSizes();
        jComponent.setVisible(true);
        this.repaint();
    }

    protected MutableTreeNode locateTreeNode(MutableTreeNode mutableTreeNode, EntityInstance entityInstance) {
        EntityInstance entityInstance2 = (EntityInstance)((DefaultMutableTreeNode)mutableTreeNode).getUserObject();
        if (entityInstance == entityInstance2) {
            return mutableTreeNode;
        }
        if (entityInstance2.hasDescendant(entityInstance)) {
            Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MutableTreeNode mutableTreeNode2 = this.locateTreeNode((MutableTreeNode)enumeration.nextElement(), entityInstance);
                if (mutableTreeNode2 == null) continue;
                return mutableTreeNode2;
            }
        }
        return null;
    }

    protected MutableTreeNode locateTreeNode(EntityInstance entityInstance) {
        MutableTreeNode mutableTreeNode;
        TreePath treePath;
        MutableTreeNode mutableTreeNode2 = null;
        if (entityInstance != null && (treePath = this.m_tree.getPathForRow(0)) != null && (mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent()) != null) {
            mutableTreeNode2 = this.locateTreeNode(mutableTreeNode, entityInstance);
        }
        return mutableTreeNode2;
    }

    private static void insertTOC(DefaultTreeModel defaultTreeModel, MutableTreeNode mutableTreeNode, EntityInstance entityInstance) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(entityInstance);
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            TextTree.insertTOC(defaultTreeModel, defaultMutableTreeNode, entityInstance2);
        }
    }

    public void insertTOC(EntityInstance entityInstance) {
        MutableTreeNode mutableTreeNode;
        if (this.m_use != null && this.m_use == this.m_tree && (mutableTreeNode = this.locateTreeNode(entityInstance.getContainedBy())) != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_tree.getModel();
            TextTree.insertTOC(defaultTreeModel, mutableTreeNode, entityInstance);
        }
    }

    public void deleteTOC(EntityInstance entityInstance) {
        MutableTreeNode mutableTreeNode;
        if (this.m_use != null && this.m_use == this.m_tree && (mutableTreeNode = this.locateTreeNode(entityInstance)) != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_tree.getModel();
            defaultTreeModel.removeNodeFromParent(mutableTreeNode);
        }
    }

    public void containerCut(EntityInstance entityInstance) {
        MutableTreeNode mutableTreeNode;
        if (this.m_use != null && this.m_use == this.m_tree && (mutableTreeNode = this.locateTreeNode(entityInstance)) != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_tree.getModel();
            MutableTreeNode mutableTreeNode2 = (MutableTreeNode)mutableTreeNode.getParent();
            Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MutableTreeNode mutableTreeNode3 = (MutableTreeNode)enumeration.nextElement();
                defaultTreeModel.removeNodeFromParent(mutableTreeNode3);
                defaultTreeModel.insertNodeInto(mutableTreeNode3, mutableTreeNode2, mutableTreeNode2.getChildCount());
            }
            defaultTreeModel.removeNodeFromParent(mutableTreeNode);
        }
    }

    public void containerUncut(EntityInstance entityInstance) {
        if (this.m_use != null && this.m_use == this.m_tree) {
            Enumeration enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                this.deleteTOC(entityInstance2);
            }
            this.insertTOC(entityInstance);
        }
    }

    public void validate() {
        this.m_use.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    public Dimension getPreferredSize() {
        if (this.m_use != null) {
            return this.m_use.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.m_use != null) {
            this.m_use.setBounds(n, n2, n3, n4);
        }
    }

    protected void closeAll() {
        int n;
        int n2 = n = this.m_tree.getRowCount();
        while (n2 > 0) {
            this.m_tree.collapseRow(--n2);
        }
    }

    protected void expandTo(EntityInstance entityInstance) {
        this.closeAll();
        this.m_tree.clearSelection();
        if (entityInstance != null) {
            for (int i = 0; i < this.m_tree.getRowCount(); ++i) {
                EntityInstance entityInstance2;
                TreePath treePath = this.m_tree.getPathForRow(i);
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                if (treeNode == null || (entityInstance2 = (EntityInstance)((DefaultMutableTreeNode)treeNode).getUserObject()) == null) continue;
                if (entityInstance2 == entityInstance) {
                    this.m_tree.setSelectionRow(i);
                    this.m_tree.scrollRowToVisible(i);
                    break;
                }
                if (!entityInstance2.hasDescendant(entityInstance)) continue;
                this.m_tree.expandRow(i);
            }
        }
    }

    public void toc_path() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            this.m_ls.setTocHidden(false);
            this.activate();
            EntityInstance entityInstance = diagram.getDrawRoot();
            this.expandTo(entityInstance);
            this.syncSizes();
        }
    }

    protected void expandAll() {
        for (int i = 0; i < this.m_tree.getRowCount(); ++i) {
            this.m_tree.expandRow(i);
        }
    }

    public void switch_TOC() {
        this.m_ls.setTocHidden(false);
        this.activate();
        int n = this.m_tree.getRowCount();
        if (n > 1) {
            this.closeAll();
        } else {
            this.expandAll();
        }
        this.syncSizes();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            if (this.m_ls.isTocHidden()) {
                this.m_ls.setTocHidden(false);
            }
        } else {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            JPopupMenu jPopupMenu = this.buildPopup();
            this.add(jPopupMenu);
            jPopupMenu.show(this, n, n2);
            this.remove(jPopupMenu);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class MyTree
    extends JTree
    implements MouseListener {
        protected TextTree m_tocBox;

        public MyTree(TextTree textTree2) {
            this.m_tocBox = textTree2;
            this.setCellRenderer(new MyTreeCellRenderer());
            this.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isMetaDown()) {
                int n;
                int n2 = mouseEvent.getX();
                TreePath treePath = this.getPathForLocation(n2, n = mouseEvent.getY());
                if (treePath == null) {
                    this.m_tocBox.mouseClicked(mouseEvent);
                } else {
                    Diagram diagram;
                    EntityInstance entityInstance;
                    TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                    if (treeNode != null && (entityInstance = (EntityInstance)((DefaultMutableTreeNode)treeNode).getUserObject()) != null && (diagram = TextTree.this.m_ls.getDiagram()) != null) {
                        diagram.navigateTo(entityInstance);
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            EntityInstance entityInstance;
            int n2;
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof EntityInstance && (n2 = (entityInstance = (EntityInstance)object2).numChildren()) > 1) {
                this.setText(entityInstance.getEntityLabel() + " (" + n2 + ")");
            }
            return component;
        }
    }
}

