/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.LineWalker;
import lsedit.MsgOut;
import lsedit.RelationClass;
import lsedit.ScreenPoint;

public class Util {
    public static final double ARROW_L_DEFAULT = 10.0;
    public static final double ARROW_TH_DEFAULT = 0.4;
    public static final int LINE_W_DEFAULT = 1;
    public static double ARROW_L = 10.0;
    public static double ARROW_TH = 0.4;
    public static int LINE_W = 1;
    public static final int LINE_STYLE_NORMAL = 0;
    public static final int LINE_STYLE_DASHED = 1;
    public static final int LINE_STYLE_DOTTED = 2;
    public static final int LINE_STYLE_INSCRIBED = 3;
    public static final String[] lineStyleName = new String[]{"Normal", "Dashed", "Dotted", "Inscribed"};
    protected static final int DASH_LEN = 4;
    protected static final int DASH_GAP = 3;
    protected static final int DOT_LEN = 0;
    protected static final int DOT_GAP = 4;
    protected static boolean reverseZflag = false;
    protected static final int GAP = 5;
    protected static final int INSET = 12;
    protected static final int OUTSET = 5;
    protected static final int DOT_LEN_REG = 0;
    protected static final int DOT_LEN_PRNT = 1;

    public static String formatFraction(double d) {
        if (d >= 1.0) {
            if (d == 1.0) {
                return "1";
            }
            return "" + d;
        }
        if (d <= 0.0) {
            if (d == 0.0) {
                return "0";
            }
            return "" + d;
        }
        int n = (int)(d * 10.0);
        int n2 = (int)(d * 100.0) - n * 10;
        if (n2 == 0) {
            return "0." + n;
        }
        return "0." + n + n2;
    }

    public static boolean isBlank(String string) {
        int n = string.length();
        while (n > 0) {
            if (string.charAt(--n) == ' ') continue;
            return false;
        }
        return true;
    }

    public static String getLineStyleName(int n) {
        if (n < 0 || n >= lineStyleName.length) {
            return "";
        }
        return lineStyleName[n];
    }

    public static boolean drawStringClipped(Graphics graphics, String string, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        double d5;
        String string2;
        int n;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = string.length();
        if ((double)fontMetrics.stringWidth(string) > d3) {
            for (n = n2 - 1; n >= 0; --n) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!((double)fontMetrics.stringWidth(stringBuilder.append(string.substring(0, n)).append("...").toString()) > d3)) break;
            }
        }
        if (n < 0) {
            return false;
        }
        if (n == n2 - 1) {
            string2 = string;
            double d6 = fontMetrics.stringWidth(string);
            d5 = bl ? d + d3 / 2.0 - d6 / 2.0 : d;
        } else {
            string2 = string.substring(0, n) + "...";
            d5 = d;
        }
        ScreenPoint screenPoint = bl ? new ScreenPoint(d5, d2 + d4 / 2.0 + (double)(fontMetrics.getHeight() / 2)) : new ScreenPoint(d5, d2 + (double)fontMetrics.getHeight());
        graphics.drawString(string2, screenPoint.x, screenPoint.y);
        if (bl2) {
            int n3 = fontMetrics.stringWidth(string2);
            graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint.x + n3, screenPoint.y);
        }
        return n == n2 - 1;
    }

    public static boolean drawStringClipped(Graphics graphics, String string, double d, double d2, double d3, double d4) {
        return Util.drawStringClipped(graphics, string, d, d2, d3, d4, false, false);
    }

    public static boolean drawUnderlinedStringClipped(Graphics graphics, String string, double d, double d2, double d3, double d4) {
        return Util.drawStringClipped(graphics, string, d, d2, d3, d4, false, true);
    }

    protected static int longestSubStr(String string, FontMetrics fontMetrics, int n) {
        int n2 = string.indexOf(10);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if (fontMetrics.stringWidth(string) <= n) {
            return string.length();
        }
        int n3 = -1;
        while ((n2 = string.indexOf(32, n3 + 1)) >= 0 && fontMetrics.stringWidth(string.substring(0, n2)) <= n) {
            n3 = n2;
        }
        if (n3 == -1) {
            return string.length();
        }
        return n3;
    }

    public static boolean drawStringWrapped(Graphics graphics, String string, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        double d5;
        int n;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Vector<String> vector = new Vector<String>();
        if (string.indexOf(32) < 0 && string.indexOf(10) < 0) {
            return Util.drawStringClipped(graphics, string, d, d2, d3, d4, bl, bl2);
        }
        while (true) {
            n = Util.longestSubStr(string, fontMetrics, (int)d3);
            vector.addElement(string.substring(0, n));
            if (n == string.length()) break;
            string = string.substring(n + 1);
        }
        int n2 = fontMetrics.getHeight() * 3 / 4;
        int n3 = vector.size() * n2;
        Enumeration enumeration = vector.elements();
        double d6 = d5 = bl ? d2 + (d4 - (double)n3) / 2.0 + (double)n2 : d2 + (double)n2;
        while (enumeration.hasMoreElements()) {
            double d7;
            String string2;
            string = (String)enumeration.nextElement();
            int n4 = string.length();
            for (n = n4 - 1; n >= 0 && (double)fontMetrics.stringWidth(string.substring(0, n)) > d3; --n) {
            }
            if (n < 0) continue;
            if (n == n4 - 1) {
                string2 = string;
                double d8 = fontMetrics.stringWidth(string);
                d7 = bl ? d + d3 / 2.0 - d8 / 2.0 : d;
            } else {
                string2 = string.substring(0, n);
                d7 = d;
            }
            ScreenPoint screenPoint = new ScreenPoint(d7, d5);
            graphics.drawString(string2, screenPoint.x, screenPoint.y);
            if (bl2) {
                int n5 = fontMetrics.stringWidth(string2);
                graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint.x + n5, screenPoint.y);
            }
            d5 += (double)n2;
        }
        return true;
    }

    public static boolean isHTTP(String string) {
        return string.length() > 7 && (string.substring(0, 7).equals("http://") || string.substring(0, 7).equals("HTTP://"));
    }

    public static String prefixOf(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static void drawFrame(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Diagram.boxColour);
        graphics.draw3DRect(0, 0, rectangle.width - 1, rectangle.height - 1, true);
        graphics.draw3DRect(1, 1, rectangle.width - 3, rectangle.height - 3, true);
    }

    public static double parseReal(String string) {
        return new Double(string);
    }

    public static int parseInt(String string) {
        return new Integer(string);
    }

    public static boolean parseBoolean(String string) {
        return string.equals("true");
    }

    protected static String qt(String string) {
        if (string.indexOf(32) >= 0) {
            return "\"" + string + "\"";
        }
        return string;
    }

    protected static String doExpand(String string, String string2, LandscapeEditorCore landscapeEditorCore) {
        boolean bl;
        String string3 = "";
        int n = 0;
        int n2 = string.length();
        MsgOut.dprintln("Expand: " + string);
        do {
            String string4;
            int n3;
            boolean bl2 = bl = ((n3 = string.indexOf(36, n)) == 0 || n3 > 0 && string.charAt(n3 - 1) != '\\') && n3 + 1 < n2;
            if (!bl) continue;
            int n4 = string.indexOf(36, n3 + 1);
            if (n4 < n3) {
                MsgOut.println("Missing delimitting '$' in expansion variable");
                return null;
            }
            string3 = string3 + string.substring(n, n3);
            String string5 = string.substring(n3 + 1, n4);
            if (string5.equals("ID")) {
                string3 = string3 + Util.qt(string2);
            } else if (string5.equals("IDPREFIX")) {
                int n5 = string2.lastIndexOf(46);
                string3 = n5 >= 0 ? string3 + Util.qt(string2.substring(0, n5)) : string3 + Util.qt(string2);
            } else if (string5.equals("IDSUFFIX")) {
                int n6 = string2.lastIndexOf(46);
                if (n6 >= 0) {
                    string3 = string3 + string2.substring(n6 + 1);
                }
            } else if (string5.equals("DGDIR")) {
                String string6 = landscapeEditorCore.getDiagram().getAbsolutePath();
                string4 = Util.dirFromPath(string6);
                string3 = string3 + string4;
            } else if (string5.equals("DGSUFFIX")) {
                String string7 = landscapeEditorCore.getDiagram().getAbsolutePath();
                string4 = Util.nameFromPath(string7);
                int n7 = string4.indexOf(46);
                if (n7 >= 0) {
                    string3 = string3 + string4.substring(n7 + 1);
                }
            } else {
                String string8 = landscapeEditorCore.getParameter(string5);
                if (string8 != null) {
                    string3 = string3 + Util.qt(string8);
                } else {
                    MsgOut.println("Parameter not found: '" + string5 + "'");
                    return "";
                }
            }
            n = n4 + 1;
        } while (bl && n < n2);
        if (n < n2) {
            string3 = string3 + string.substring(n);
        }
        MsgOut.dprintln("Result: " + string3);
        return string3;
    }

    public static String expand(String string, String string2, LandscapeEditorCore landscapeEditorCore) {
        String string3;
        String string4 = Util.doExpand(string, string2, landscapeEditorCore);
        while (!(string3 = string4).equals(string4 = Util.doExpand(string3, string2, landscapeEditorCore))) {
        }
        return string3;
    }

    public static String expand(String string, LandscapeEditorCore landscapeEditorCore) {
        return Util.expand(string, "", landscapeEditorCore);
    }

    public static JFrame getFrame(Component component) {
        while (component != null) {
            if (component instanceof JFrame) {
                return (JFrame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static String dirFromPath(String string) {
        int n;
        int n2 = string.lastIndexOf(47);
        if (n2 > (n = string.lastIndexOf(92))) {
            return string.substring(0, n2);
        }
        if (n > n2) {
            return string.substring(0, n);
        }
        return "";
    }

    public static String nameFromPath(String string) {
        int n;
        int n2 = string.lastIndexOf(47);
        if (n2 > (n = string.lastIndexOf(92))) {
            return string.substring(n2 + 1);
        }
        if (n > n2) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static boolean isBlack(Color color) {
        if (color == Color.black) {
            return true;
        }
        if (color.getRed() != 0) {
            return false;
        }
        if (color.getGreen() != 0) {
            return false;
        }
        return color.getBlue() == 0;
    }

    public static String quoted(String string) {
        if (string.indexOf(32) >= 0) {
            return "\"" + string + "\"";
        }
        return string;
    }

    protected static void drawLine(Graphics graphics, LineWalker lineWalker) {
        ScreenPoint screenPoint = new ScreenPoint(0.0, 0.0);
        ScreenPoint screenPoint2 = new ScreenPoint(0.0, 0.0);
        while (lineWalker.morePoints()) {
            lineWalker.nextPoints(screenPoint, screenPoint2);
            graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint2.x, screenPoint2.y);
        }
    }

    protected static void drawInscribedLine(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(Color.gray);
        graphics.drawLine(n, n2, n3, n4);
        graphics.setColor(Color.white);
        if (n == n3) {
            graphics.drawLine(n + 1, n2, n3 + 1, n4);
        } else {
            graphics.drawLine(n, n2 + 1, n3, n4 + 1);
        }
        graphics.setColor(color);
    }

    public static void drawTailPoint(Graphics graphics, int n, int n2) {
        int n3 = 3;
        graphics.fillOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
    }

    public static void drawOutlineBox(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(Color.gray);
        if (!bl) {
            graphics.drawRect(n, n2, n3, n4);
            return;
        }
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
        graphics.drawLine(n, n2 + n4, n, n2);
        graphics.setColor(Color.white);
        graphics.drawLine(n + 1, n2 + 1, n + n3, n2 + 1);
        graphics.drawLine(n + n3, n2 + 1, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2 + n4, n + 1, n2 + n4);
        graphics.drawLine(n + 1, n2 + n4, n + 1, n2 + 1);
    }

    public static void drawOutlineBox(Graphics graphics, Rectangle rectangle, boolean bl) {
        Util.drawOutlineBox(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
    }

    public static void drawGroupBox(Graphics graphics, int n, int n2, int n3, int n4, String string, boolean bl) {
        graphics.setFont(EntityInstance.getSmallFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getHeight();
        int n7 = Math.min(12, n3 / 12);
        if (n3 < n7 + 5) {
            Util.drawOutlineBox(graphics, n, n2, n3, n4, bl);
        } else {
            int n8 = n5 + 10 > n3 - n7 - 5 ? n + n3 - 5 : n + n7 + n5 + 10;
            graphics.setColor(Color.gray);
            if (bl) {
                graphics.drawLine(n, n2 + n4, n, n2);
                graphics.drawLine(n, n2, n + n7, n2);
                graphics.drawLine(n8, n2, n + n3, n2);
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
                graphics.setColor(Color.white);
                graphics.drawLine(n + 1, n2 + n4, n + 1, n2 + 1);
                graphics.drawLine(n + 1, n2 + 1, n + n7, n2 + 1);
                graphics.drawLine(n8, n2 + 1, n + n3, n2 + 1);
                graphics.drawLine(n + n3, n2 + 1, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2 + n4, n + 1, n2 + n4);
            } else {
                graphics.drawLine(n, n2 + n4, n, n2);
                graphics.drawLine(n, n2, n + n7, n2);
                graphics.drawLine(n8, n2, n + n3, n2);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2 + n4, n, n2 + n4);
            }
        }
    }

    public static void drawGroupBoxLabel(Graphics graphics, int n, int n2, int n3, String string) {
        graphics.setFont(EntityInstance.getSmallFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.getHeight();
        int n6 = Math.min(12, n3 / 12);
        if (n3 >= n6 + 5) {
            int n7 = n4 + 10 > n3 - n6 - 5 ? n + n3 - 5 : n + n6 + n4 + 10;
            Util.drawStringClipped(graphics, string, n + n6 + 5, n2 - n5 * 2 / 3, n7 - n - 10, 100.0);
        }
    }

    public static String mungeName(String string) {
        String string2 = string.replace(' ', '_');
        string2 = string2.replace('/', '-');
        string2 = string2.replace(',', '_');
        return string2.replace('\\', '-');
    }

    public static String hashEdge(RelationClass relationClass, EntityInstance entityInstance, EntityInstance entityInstance2) {
        return entityInstance.getId() + relationClass.getId() + entityInstance2.getId();
    }

    public static int round(double d) {
        return (int)(d + 0.5);
    }

    protected static int getDotLen(Graphics graphics) {
        return 0;
    }

    public static void drawSegment(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < LINE_W; ++i) {
            switch (n) {
                case 0: {
                    graphics.drawLine(n2 + n6, n3 + n7, n4 + n6, n5 + n7);
                    break;
                }
                case 2: {
                    LineWalker lineWalker = new LineWalker(n2 + n6, n3 + n7, n4 + n6, n5 + n7, Util.getDotLen(graphics), 4);
                    Util.drawLine(graphics, lineWalker);
                    break;
                }
                case 1: {
                    LineWalker lineWalker = new LineWalker(n2 + n6, n3 + n7, n4 + n6, n5 + n7, 4, 3);
                    Util.drawLine(graphics, lineWalker);
                    break;
                }
                case 3: {
                    Util.drawInscribedLine(graphics, n2, n3, n4, n5);
                }
            }
            n6 = -n6;
            n7 = -n7;
            if ((i & 1) != 0) continue;
            if (i == 0) {
                int n10 = n4 - n2;
                int n11 = n5 - n3;
                if (n10 <= 0 && n11 <= 0) {
                    n10 = -n10;
                    n11 = -n11;
                }
                if (n10 >= 0 && n11 >= 0) {
                    if (2 * n11 >= n10) {
                        n8 = 1;
                    }
                    if (2 * n10 >= n11) {
                        n9 = -1;
                    }
                } else {
                    if (n10 < 0) {
                        n10 = -n10;
                    }
                    if (n11 < 0) {
                        n11 = -n11;
                    }
                    if (2 * n11 >= n10) {
                        n8 = 1;
                    }
                    if (2 * n10 >= n11) {
                        n9 = 1;
                    }
                }
            }
            n6 += n8;
            n7 += n9;
        }
    }

    public static double getArrow(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        double d;
        int n5 = n - n3;
        int n6 = n2 - n4;
        if (n5 == 0 && n6 == 0) {
            d = 0.0;
        } else {
            double d2 = Math.atan2(n6, n5);
            d = Math.sqrt(n5 * n5 + n6 * n6);
            double d3 = Math.min(ARROW_L, d);
            double d4 = (double)n3 + d3 * Math.cos(d2 - ARROW_TH);
            double d5 = (double)n4 + d3 * Math.sin(d2 - ARROW_TH);
            double d6 = (double)n3 + d3 * Math.cos(d2 + ARROW_TH);
            double d7 = (double)n4 + d3 * Math.sin(d2 + ARROW_TH);
            nArray[0] = n3;
            nArray2[0] = n4;
            nArray[1] = (int)Math.round(d4);
            nArray2[1] = (int)Math.round(d5);
            nArray[2] = (int)Math.round(d6);
            nArray2[2] = (int)Math.round(d7);
            d = d3 / d;
        }
        return d;
    }

    public static double drawArrowHead(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        double d = Util.getArrow(n, n2, n3, n4, nArray, nArray2);
        if (d != 0.0) {
            if (LandscapeEditorCore.isFillArrowhead()) {
                graphics.fillPolygon(nArray, nArray2, 3);
            } else {
                graphics.drawPolygon(nArray, nArray2, 3);
            }
        }
        return d;
    }

    public static void drawArrow(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (Do.isCenterArrowhead()) {
            int n6 = n4;
            int n7 = n5;
            n4 = (n2 + n4) / 2;
            n5 = (n3 + n5) / 2;
            Util.drawSegment(graphics, n, n4, n5, n6, n7);
        }
        double d = Util.drawArrowHead(graphics, n2, n3, n4, n5);
        n4 -= (int)((double)(n4 - n2) * d);
        n5 -= (int)((double)(n5 - n3) * d);
        Util.drawSegment(graphics, n, n2, n3, n4, n5);
    }
}

