/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.Util;

public class ArrowDimensions
extends JDialog
implements ActionListener {
    double m_old_length;
    double m_old_arc;
    int m_old_width;
    double m_new_length;
    double m_new_arc;
    int m_new_width;
    boolean m_old_fill_arrowhead;
    boolean m_fill_arrowhead;
    boolean m_old_center_arrowhead;
    boolean m_center_arrowhead;
    boolean m_old_weighted_arrowhead;
    boolean m_weighted_arrowhead;
    JTextField m_length;
    JTextField m_arc;
    JTextField m_width;
    JCheckBox m_fill_checkbox;
    JCheckBox m_center_checkbox;
    JCheckBox m_weight_checkbox;
    JButton m_ok;
    JButton m_cancel;
    JButton m_default;
    JLabel m_message;

    protected ArrowDimensions(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore.getFrame(), "Modify arrow settings", true);
        JCheckBox jCheckBox;
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        this.m_old_width = Util.LINE_W;
        this.m_old_length = Util.ARROW_L;
        this.m_old_arc = Util.ARROW_TH;
        this.m_new_width = Util.LINE_W;
        this.m_new_length = Util.ARROW_L;
        this.m_new_arc = Util.ARROW_TH;
        this.m_fill_arrowhead = this.m_old_fill_arrowhead = landscapeEditorCore.isFillArrowhead();
        this.m_center_arrowhead = this.m_old_center_arrowhead = landscapeEditorCore.isCenterArrowhead();
        this.m_weighted_arrowhead = this.m_old_weighted_arrowhead = landscapeEditorCore.isWeightedArrowhead();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GridLayout gridLayout = new GridLayout(6, 1);
        gridLayout.setVgap(10);
        jPanel2.setLayout(gridLayout);
        gridLayout = new GridLayout(6, 1);
        gridLayout.setVgap(10);
        jPanel3.setLayout(gridLayout);
        gridLayout = new GridLayout(6, 1);
        gridLayout.setVgap(10);
        jPanel4.setLayout(gridLayout);
        jPanel.add("West", jPanel2);
        jPanel.add("East", jPanel4);
        jPanel.add("Center", jPanel3);
        JLabel jLabel = new JLabel("Width of edge:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_width = new JTextField("" + this.m_old_width, 6);
        this.m_width.setFont(font);
        jPanel3.add(this.m_width);
        jLabel = new JLabel("pixels", 2);
        jLabel.setFont(font2);
        jPanel4.add(jLabel);
        jLabel = new JLabel("Length of arrow edge:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_length = new JTextField("" + this.m_old_length, 6);
        this.m_length.setFont(font);
        jPanel3.add(this.m_length);
        jLabel = new JLabel("pixels", 2);
        jLabel.setFont(font2);
        jPanel4.add(jLabel);
        jLabel = new JLabel("Arc between edge and arrow edge:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_arc = new JTextField("" + this.m_old_arc, 6);
        this.m_arc.setFont(font);
        jPanel3.add(this.m_arc);
        jLabel = new JLabel("radians", 2);
        jLabel.setFont(font2);
        jPanel4.add(jLabel);
        jLabel = new JLabel("Fill arrow head:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_fill_checkbox = jCheckBox = new JCheckBox();
        jCheckBox.setBorderPaintedFlat(false);
        jCheckBox.setSelected(this.m_fill_arrowhead);
        jCheckBox.setEnabled(true);
        jCheckBox.setVisible(true);
        jPanel3.add(jCheckBox);
        jLabel = new JLabel("Center arrow head:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_center_checkbox = jCheckBox = new JCheckBox();
        jCheckBox.setBorderPaintedFlat(false);
        jCheckBox.setSelected(this.m_center_arrowhead);
        jCheckBox.setEnabled(true);
        jCheckBox.setVisible(true);
        jPanel3.add(jCheckBox);
        jLabel = new JLabel("Permanently weight arrow head:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_weight_checkbox = jCheckBox = new JCheckBox();
        jCheckBox.setBorderPaintedFlat(false);
        jCheckBox.setSelected(this.m_weighted_arrowhead);
        jCheckBox.setEnabled(true);
        jCheckBox.setVisible(true);
        jPanel3.add(jCheckBox);
        container.add("North", jPanel);
        this.m_message = new JLabel(" ", 0);
        this.m_message.setFont(font);
        this.m_message.setForeground(Color.RED);
        this.m_message.setSize(400, 50);
        container.add("Center", this.m_message);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 15, 15));
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(font2);
        jPanel5.add(this.m_ok);
        this.m_ok.addActionListener(this);
        this.m_default = new JButton("Default");
        this.m_default.setFont(font2);
        jPanel5.add(this.m_default);
        this.m_default.addActionListener(this);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(font2);
        jPanel5.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        container.add("South", jPanel5);
        this.pack();
        this.show();
    }

    public boolean hasChanged() {
        return this.m_old_length != this.m_new_length || this.m_old_arc != this.m_new_arc || this.m_old_width != this.m_new_width || this.m_old_fill_arrowhead != this.m_fill_arrowhead || this.m_old_center_arrowhead != this.m_center_arrowhead || this.m_weighted_arrowhead != this.m_old_weighted_arrowhead;
    }

    public static void create(LandscapeEditorCore landscapeEditorCore) {
        ArrowDimensions arrowDimensions = new ArrowDimensions(landscapeEditorCore);
        if (arrowDimensions.hasChanged()) {
            Util.LINE_W = arrowDimensions.m_new_width;
            Util.ARROW_L = arrowDimensions.m_new_length;
            Util.ARROW_TH = arrowDimensions.m_new_arc;
            landscapeEditorCore.setFillArrowheadState(arrowDimensions.m_fill_arrowhead);
            landscapeEditorCore.setCenterArrowheadState(arrowDimensions.m_center_arrowhead);
            landscapeEditorCore.setWeightedArrowheadState(arrowDimensions.m_weighted_arrowhead);
            landscapeEditorCore.repaint();
        }
        arrowDimensions.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_default) {
            this.m_width.setText("1");
            this.m_length.setText("10.0");
            this.m_arc.setText("0.4");
            this.m_message.setText("Values set to initial default");
            this.m_fill_checkbox.setSelected(true);
            this.m_center_checkbox.setSelected(false);
            this.m_weight_checkbox.setSelected(true);
            return;
        }
        if (object != this.m_cancel && object != this.m_ok) {
            return;
        }
        if (object == this.m_ok) {
            double d;
            double d2;
            int n;
            String string = this.m_width.getText();
            try {
                n = Integer.parseInt(string);
                if (n < 0) {
                    this.m_message.setText("Width negative");
                    return;
                }
            }
            catch (Throwable throwable) {
                this.m_message.setText("Width not an integer string value");
                return;
            }
            string = this.m_length.getText();
            try {
                d2 = Double.parseDouble(string);
                if (Double.isNaN(d2)) {
                    this.m_message.setText("Length is not a double precision number");
                    return;
                }
            }
            catch (Throwable throwable) {
                this.m_message.setText("Length is not a double precision string value");
                return;
            }
            if (d2 < 0.0) {
                this.m_message.setText("Length is negative");
                return;
            }
            string = this.m_arc.getText();
            try {
                d = Double.parseDouble(string);
                if (Double.isNaN(d)) {
                    this.m_message.setText("Arc is not a double precision number");
                    return;
                }
            }
            catch (Throwable throwable) {
                this.m_message.setText("Arc is not a double precision string value");
                return;
            }
            if (d < 0.0) {
                this.m_message.setText("Arc is negative");
                return;
            }
            if (d > 1.5) {
                this.m_message.setText("The maximum allowed arc angle is 1.5 (very near pi/2)");
                return;
            }
            this.m_new_width = n;
            this.m_new_length = d2;
            this.m_new_arc = d;
            this.m_fill_arrowhead = this.m_fill_checkbox.isSelected();
            this.m_center_arrowhead = this.m_center_checkbox.isSelected();
            this.m_weighted_arrowhead = this.m_weight_checkbox.isSelected();
        }
        this.setVisible(false);
    }
}

