/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import lsedit.Clipboard;
import lsedit.ClipboardEnumerator;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyMenuItem;
import lsedit.ReallyDelete;
import lsedit.RelationClass;
import lsedit.ToolBarEventHandler;

public class ClipboardBox
extends JComponent
implements ToolBarEventHandler,
MouseListener {
    protected static final int MARGIN = 5;
    protected static final int INDENT = 10;
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected JCheckBox m_addChk;
    protected ExpandedChkBox m_expandChk;
    protected static Dimension m_preferredSize = new Dimension(0, 0);
    public static final String m_helpStr = "This box shows the contents of the clipboard within the current diagram.";
    public static final String DEFAULT_CLIPBOARD_FONT_NAME = "Helvetica";
    public static final int DEFAULT_CLIPBOARD_FONT_STYLE = 0;
    public static final int DEFAULT_CLIPBOARD_FONT_SIZE = 11;
    protected static Font m_textFont = FontCache.get("Helvetica", 0, 11);
    protected static FontMetrics m_fm;
    protected static int m_fontheight;
    protected static int m_baseline;
    protected static int m_height;
    protected static int m_top;

    public void setTop() {
        FontMetrics fontMetrics;
        m_fm = fontMetrics = this.getFontMetrics(m_textFont);
        m_fontheight = fontMetrics.getHeight();
        m_baseline = m_fontheight - fontMetrics.getDescent();
        int n = 5;
        Dimension dimension = this.m_addChk.getPreferredSize();
        this.m_addChk.setBounds(5, n, dimension.width, dimension.height);
        dimension = this.m_expandChk.getPreferredSize();
        this.m_expandChk.setBounds(5, n += dimension.height, dimension.width, dimension.height);
        m_top = (n += dimension.height) + m_fontheight + m_baseline;
    }

    public ClipboardBox(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        this.setBackground(Diagram.boxColour);
        this.setToolTipText(m_helpStr);
        this.m_addChk = new JCheckBox("Add to clipboard");
        this.m_addChk.setFont(m_textFont);
        this.m_addChk.setForeground(Color.black);
        this.m_expandChk = new ExpandedChkBox("Expand trees");
        this.m_expandChk.setFont(m_textFont);
        this.m_expandChk.setForeground(Color.black);
        this.setTop();
        this.add(this.m_addChk);
        this.add(this.m_expandChk);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab("Clipboard", null, this.m_scrollPane, m_helpStr);
        this.addMouseListener(this);
        this.setNewPreferredSize();
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component component = this.m_tabbedPane.getSelectedComponent();
        return component != null && this.m_scrollPane == component;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void paintTree(Graphics graphics, EntityInstance entityInstance, RelationClass relationClass, int n) {
        String string = entityInstance.getEntityLabel();
        if (graphics == null) {
            int n2 = m_fm.stringWidth(string) + 10 + n;
            if (n2 > ClipboardBox.m_preferredSize.width) {
                ClipboardBox.m_preferredSize.width = n2;
            }
        } else {
            graphics.drawString(string, 5 + n, m_height);
        }
        m_height += m_fontheight;
        if (this.m_expandChk.isSelected()) {
            Enumeration enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                EntityInstance entityInstance3 = entityInstance2.getContainedBy(relationClass);
                if (entityInstance3 != entityInstance) continue;
                this.paintTree(graphics, entityInstance2, relationClass, n + 10);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        Clipboard clipboard;
        m_height = m_top;
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null && (clipboard = diagram.getClipboard()) != null && !clipboard.isEmpty()) {
            RelationClass relationClass = diagram.getContainsClass();
            if (graphics != null) {
                graphics.setFont(m_textFont);
                graphics.setColor(Color.BLACK);
            }
            ClipboardEnumerator clipboardEnumerator = clipboard.clipboardElements();
            while (clipboardEnumerator.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)clipboardEnumerator.nextElement();
                this.paintTree(graphics, entityInstance, relationClass, 0);
                m_height += m_fontheight;
            }
        }
    }

    protected void setNewPreferredSize() {
        int n = ClipboardBox.m_preferredSize.width;
        int n2 = ClipboardBox.m_preferredSize.height;
        Dimension dimension = this.m_addChk.getPreferredSize();
        ClipboardBox.m_preferredSize.width = 5 + dimension.width;
        this.paintComponent(null);
        ClipboardBox.m_preferredSize.height = m_height + m_fontheight;
        if (ClipboardBox.m_preferredSize.width != n || ClipboardBox.m_preferredSize.height != n2) {
            this.setPreferredSize(m_preferredSize);
            this.setSize(m_preferredSize);
            this.m_scrollPane.revalidate();
        }
    }

    public void clipboardChanged() {
        this.setNewPreferredSize();
        this.repaint();
    }

    public void textFontChanged(Font font) {
        m_textFont = font;
        this.m_addChk.setFont(font);
        this.m_expandChk.setFont(font);
        this.setTop();
        this.clipboardChanged();
    }

    public boolean isAddToClipboard() {
        return this.m_addChk.isSelected();
    }

    public void clear() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            diagram.setClipboard(null);
        }
        this.m_ls.doFeedback("Clipboard cleared");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Clipboard clipboard;
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null && (clipboard = diagram.getClipboard()) != null && !clipboard.isEmpty() && mouseEvent.isMetaDown()) {
            JPopupMenu jPopupMenu = new JPopupMenu("Clipboard options");
            new MyMenuItem(jPopupMenu, "Dispose", this, -1, 127, "Discard this clipboard");
            FontCache.setMenuTreeFont(jPopupMenu);
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void processKeyEvent(int n, int n2, Object object) {
        switch (n) {
            case 127: {
                ReallyDelete reallyDelete = new ReallyDelete(this.m_ls, "Delete Clipboard");
                reallyDelete.setLocation(this.m_tabbedPane.getX() + 20, this.m_tabbedPane.getY() + 20);
                reallyDelete.show();
                boolean bl = reallyDelete.confirmed();
                reallyDelete.dispose();
                if (!bl) break;
                this.clear();
                break;
            }
        }
    }

    public void showInfo(String string) {
    }

    protected class ExpandedChkBox
    extends JCheckBox
    implements ItemListener {
        ExpandedChkBox(String string) {
            super(string);
            this.setSelected(false);
            this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ClipboardBox.this.clipboardChanged();
        }
    }
}

