/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.EntityInstance;

public class EntityCache {
    private Entry[] m_table = null;
    private int m_last_index = 0;
    private int m_next = 0;
    private Entry m_current = null;
    private int m_count = 0;

    public int size() {
        return this.m_count;
    }

    public void clear() {
        this.m_table = null;
        this.m_count = 0;
        this.m_last_index = 0;
        this.m_next = 0;
        this.m_current = null;
    }

    public EntityCache() {
        this.clear();
    }

    public void put(EntityInstance entityInstance) {
        int n;
        Entry[] entryArray = this.m_table;
        if (entryArray == null) {
            this.m_table = entryArray = new Entry[262144];
        }
        this.m_last_index = n = entityInstance.getId().hashCode() & 0x3FFFF;
        Entry entry = entryArray[n];
        while (entry != null) {
            EntityInstance entityInstance2 = entry.m_value;
            if (entityInstance2.getId().equals(entityInstance.getId()) && entityInstance == entityInstance2) {
                return;
            }
            entry = entry.m_next;
        }
        entryArray[n] = new Entry(entityInstance, entryArray[n]);
        ++this.m_count;
    }

    public void remove(EntityInstance entityInstance) {
        Entry[] entryArray = this.m_table;
        if (entryArray != null) {
            int n = entityInstance.getId().hashCode() & 0x3FFFF;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entityInstance == entry.m_value) {
                    if (entry2 != null) {
                        entry2.m_next = entry.m_next;
                    } else {
                        entryArray[n] = entry.m_next;
                    }
                    entry.m_value = null;
                    --this.m_count;
                    return;
                }
                entry2 = entry;
                entry = entry.m_next;
            }
        }
        System.out.println("EntityCache: can't remove " + entityInstance);
    }

    public EntityInstance get(String string) {
        Entry[] entryArray = this.m_table;
        if (entryArray != null) {
            Entry entry = entryArray[string.hashCode() & 0x3FFFF];
            while (entry != null) {
                EntityInstance entityInstance = entry.m_value;
                if (string.equals(entityInstance.getId())) {
                    return entityInstance;
                }
                entry = entry.m_next;
            }
        }
        return null;
    }

    public EntityInstance someEntity() {
        if (this.m_count != 0) {
            Entry[] entryArray = this.m_table;
            Entry entry2 = entryArray[this.m_last_index];
            if (entry2 != null) {
                return entry2.m_value;
            }
            for (Entry entry2 : entryArray) {
                if (entry2 == null) continue;
                return entry2.m_value;
            }
        }
        return null;
    }

    protected EntityInstance getFirst(int n) {
        int n2 = this.m_table.length;
        for (int i = n; i < n2; ++i) {
            Entry entry = this.m_table[i];
            if (entry == null) continue;
            this.m_current = entry.m_next;
            this.m_next = ++i;
            return entry.m_value;
        }
        return null;
    }

    public EntityInstance getNext() {
        if (this.m_current != null) {
            EntityInstance entityInstance = this.m_current.m_value;
            this.m_current = this.m_current.m_next;
            return entityInstance;
        }
        return this.getFirst(this.m_next);
    }

    public EntityInstance getFirst() {
        return this.getFirst(0);
    }

    public void show() {
        Entry[] entryArray = this.m_table;
        if (entryArray == null) {
            System.out.println("Null Entity Cache");
        }
        if (this.m_count == 0) {
            System.out.println("Empty Entity Cache");
        }
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry entry = entryArray[i];
            if (entry == null) continue;
            System.out.print(i + ": ");
            while (entry != null) {
                System.out.print(" " + entry.m_value);
                entry = entry.m_next;
            }
            System.out.println("");
        }
    }

    static class Entry {
        public EntityInstance m_value;
        public Entry m_next;

        protected Entry(EntityInstance entityInstance, Entry entry) {
            this.m_value = entityInstance;
            this.m_next = entry;
        }
    }
}

