/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.undo.UndoableEdit;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.MyUndoableEdit;

public class EntityClass
extends LandscapeClassObject {
    public static final String ENTITY_BASE_CLASS_ID = "$ENTITY";
    public static final int ENTITY_STYLE_NONE = -1;
    public static final int ENTITY_STYLE_3DBOX = 0;
    public static final int ENTITY_STYLE_2DBOX = 1;
    public static final int ENTITY_STYLE_FILE = 2;
    public static final int ENTITY_STYLE_DISK = 3;
    public static final int ENTITY_STYLE_FOLDER = 4;
    public static final int ENTITY_STYLE_SOURCEOBJ = 5;
    public static final int ENTITY_STYLE_CLASS = 6;
    public static final int ENTITY_STYLE_GROUP = 7;
    public static final int ENTITY_STYLE_LABELLED_GROUP = 8;
    public static final int ENTITY_STYLE_TRIANGLE_UP = 9;
    public static final int ENTITY_STYLE_TRIANGLE_DOWN = 10;
    public static final int ENTITY_STYLE_ROMBUS_RIGHT = 11;
    public static final int ENTITY_STYLE_ROMBUS_LEFT = 12;
    public static final int ENTITY_STYLE_DIAMOND = 13;
    public static final int ENTITY_STYLE_PENTAGON = 14;
    public static final int ENTITY_STYLE_HEXAGON = 15;
    public static final int ENTITY_STYLE_OCTAGON = 16;
    public static final int ENTITY_STYLE_PAPER = 17;
    public static final String[] styleName = new String[]{"3D Box", "2D Box", "File", "Disk", "Folder", "Source Object", "Class", "Group", "Labelled Group", "Triangle", "Inverted Triangle", "Rombus", "Inverted Rombus", "Diamond", "Pentagon", "Hexagon", "Octagon", "Paper"};
    public static final int ENTITY_IMAGE_NONE = -1;
    public static final int ENTITY_IMAGE_ACTOR = 0;
    public static final int ENTITY_IMAGE_OVAL = 1;
    public static final int ENTITY_IMAGE_X = 2;
    public static final String[] imageName = new String[]{"Actor", "Oval", "X"};
    private boolean m_shown = true;

    public EntityClass(String string, int n, Diagram diagram) {
        this.setId(string);
        this.setNid(n);
        this.setLabel(string);
        this.setLandscapeObjectDiagram(diagram);
    }

    public static String getEntityStyleName(int n) {
        if (n < 0 || n >= styleName.length) {
            return "";
        }
        return styleName[n];
    }

    public String getStyleName(int n) {
        return EntityClass.getEntityStyleName(n);
    }

    public void updateImage(int n) {
        if (n != this.m_image) {
            new UpdateImage(this, n);
        }
    }

    public static String getImageName(int n) {
        if (n < 0 || n >= imageName.length) {
            return "";
        }
        return imageName[n];
    }

    public void setShown(boolean bl) {
        this.m_shown = bl;
    }

    public boolean isShown() {
        return this.m_shown;
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        printStream.print(this.qt(this.getId()) + " {\n");
        super.writeAttributes(printStream);
        printStream.print("}\n\n");
    }

    public EntityInstance newEntity(String string) {
        EntityInstance entityInstance = new EntityInstance(this, string);
        this.makeInstanceOfUs(entityInstance);
        return entityInstance;
    }

    public int getPrimaryAttributeCount() {
        return 8;
    }

    public String getLsAttributeNameAt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "id";
                break;
            }
            case 1: {
                string = "class_label";
                break;
            }
            case 2: {
                string = "class_description";
                break;
            }
            case 3: {
                string = "class_style";
                break;
            }
            case 4: {
                string = "class_image";
                break;
            }
            case 5: {
                string = "color";
                break;
            }
            case 6: {
                string = "labelcolor";
                break;
            }
            case 7: {
                string = "opencolor";
                break;
            }
            default: {
                string = super.getLsAttributeNameAt(n);
            }
        }
        return string;
    }

    public Object getLsAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
                break;
            }
            case 1: {
                object = this.getLabel();
                break;
            }
            case 2: {
                object = this.getDescription();
                break;
            }
            case 3: {
                object = new Integer(this.getStyle());
                break;
            }
            case 4: {
                object = new Integer(this.getImage());
                break;
            }
            case 5: {
                object = this.getObjectColor();
                break;
            }
            case 6: {
                object = this.getLabelColor();
                break;
            }
            case 7: {
                object = this.getColorWhenOpen();
                break;
            }
            default: {
                object = super.getLsAttributeValueAt(n);
            }
        }
        return object;
    }

    public void setAttributeValueAt(int n, Object object) {
        switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                this.updateLabel((String)object);
                break;
            }
            case 2: {
                this.updateDescription((String)object);
                break;
            }
            case 3: {
                this.updateStyle((Integer)object);
                break;
            }
            case 4: {
                this.updateImage((Integer)object);
                break;
            }
            case 5: {
                this.updateObjectColor((Color)object);
                break;
            }
            case 6: {
                this.updateLabelColor((Color)object);
                break;
            }
            case 7: {
                this.updateColorWhenOpen((Color)object);
                break;
            }
            default: {
                super.setAttributeValueAt(n, object);
            }
        }
    }

    public int getLsAttributeTypeAt(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 13;
                break;
            }
            case 4: {
                n2 = 17;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 8;
                break;
            }
            default: {
                n2 = super.getLsAttributeTypeAt(n);
            }
        }
        return n2;
    }

    class UpdateImage
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityClass m_o;
        int m_old;
        int m_new;

        UpdateImage(EntityClass entityClass2, int n) {
            this.m_o = entityClass2;
            this.m_old = entityClass2.getImage();
            this.m_new = n;
            if (EntityClass.this.logEdit(this)) {
                entityClass2.setImage(n);
            }
        }

        public String getPresentationName() {
            return this.m_o + " Image " + EntityClass.getImageName(this.m_new);
        }

        public void undo() {
            this.m_o.setImage(this.m_old);
        }

        public void redo() {
            this.m_o.setImage(this.m_new);
        }
    }
}

