/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import lsedit.Cardinal;
import lsedit.ClientSupplierSet;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.SrcCardinal;
import lsedit.Util;

public class EntityComponent
extends JComponent
implements Icon {
    public static final int MARGIN = 5;
    public static final int MIN_FLAP_HT = 3;
    public static final int MAX_FLAP_HT = 8;
    public static final int FLAP_MARGIN = 4;
    public static final int TINY_FLAP_WD = 10;
    public static final int MIN_FLAP_WD = 75;
    public static final int CONTENTS_FLAG_X = 3;
    public static final int CONTENTS_FLAG_Y = 9;
    public static final int CONTENTS_FLAG_DIM = 8;
    public static final int CONTENTS_FLAG_X_RESERVE = 11;
    public static final int CONTENTS_FLAG_Y_RESERVE = 17;
    private EntityInstance m_entityInstance;
    private double m_avgX;
    private Cardinal[] m_dstCardinals;
    private SrcCardinal[] m_srcCardinals;

    public EntityComponent(EntityInstance entityInstance) {
        this.m_entityInstance = entityInstance;
        this.setLayout(null);
        entityInstance.setSwingObject(this);
        this.setBounds(entityInstance.getX(), entityInstance.getY(), entityInstance.getWidth(), entityInstance.getHeight());
    }

    public String toString() {
        return "EntityComponent: " + this.m_entityInstance.toString();
    }

    public EntityInstance getEntityInstance() {
        return this.m_entityInstance;
    }

    public void resetDstCardinals(int n) {
        if (this.m_dstCardinals == null) {
            if (n > 0) {
                this.m_dstCardinals = new Cardinal[n];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Cardinal cardinal = this.m_dstCardinals[i];
                if (cardinal == null) continue;
                cardinal.reset();
            }
        }
    }

    public Cardinal[] getDstCardinals() {
        return this.m_dstCardinals;
    }

    public void resetSrcCardinals(int n) {
        if (this.m_srcCardinals == null) {
            if (n > 0) {
                this.m_srcCardinals = new SrcCardinal[n];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                SrcCardinal srcCardinal = this.m_srcCardinals[i];
                if (srcCardinal == null) continue;
                srcCardinal.reset();
            }
        }
    }

    public Cardinal[] getSrcCardinals() {
        return this.m_srcCardinals;
    }

    public void setAvgX(double d) {
        this.m_avgX = d;
    }

    public double getAvgX() {
        return this.m_avgX;
    }

    protected void setGraphicsColor(Graphics graphics, Color color, EntityInstance entityInstance) {
        Color color2 = color != null ? color : (entityInstance.red_closed() ? Color.red.darker() : entityInstance.getCurrentObjectColor());
        graphics.setColor(color2);
    }

    public void paintShape(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Color color) {
        if (n3 > 0 && n4 > 0) {
            EntityInstance entityInstance = this.m_entityInstance;
            int n5 = entityInstance.isDrawRoot() ? 0 : entityInstance.getInheritedStyle();
            switch (n5) {
                case 0: {
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fill3DRect(n + 1, n2 + 1, n3 - 1, n4 - 1, true);
                    }
                    this.setGraphicsColor(graphics, null, entityInstance);
                    graphics.draw3DRect(n, n2, n3, n4, true);
                    break;
                }
                case 1: {
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillRect(n, n2, n3, n4);
                    }
                    graphics.setColor(Color.black);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    break;
                }
                case 2: {
                    int n6 = Math.min(Math.min(n3, n4) / 2, 8);
                    int[] nArray3 = new int[6];
                    int[] nArray2 = new int[6];
                    nArray3[0] = n;
                    nArray2[0] = n2;
                    nArray3[1] = n + n3 - n6;
                    nArray2[1] = n2;
                    nArray3[2] = n + n3 - 1;
                    nArray2[2] = n2 + n6;
                    nArray3[3] = nArray3[2];
                    nArray2[3] = n2 + n4 - 1;
                    nArray3[4] = n;
                    nArray2[4] = nArray2[3];
                    nArray3[5] = nArray3[0];
                    nArray2[5] = nArray2[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray3, nArray2, 6);
                    }
                    graphics.setColor(Color.darkGray);
                    graphics.drawPolygon(nArray3, nArray2, 6);
                    nArray3[0] = nArray3[1];
                    nArray2[0] = nArray2[2];
                    nArray3[3] = nArray3[0];
                    nArray2[3] = nArray2[0];
                    graphics.drawPolygon(nArray3, nArray2, 4);
                    break;
                }
                case 3: {
                    int n7 = Math.min(Math.min(n3, n4) / 2, 8);
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillRect(n, n2 + n7 / 2, n3, n4 - n7);
                        graphics.fillOval(n, n2, n3, n7);
                        graphics.fillOval(n, n2 + n4 - n7, n3, n7);
                    }
                    graphics.setColor(Color.black);
                    graphics.drawOval(n, n2, n3, n7);
                    graphics.drawArc(n, n2 + n4 - n7 - 1, n3, n7, 180, 180);
                    graphics.drawLine(n, n2 + n7 / 2, n, n2 + n4 - n7 / 2);
                    graphics.drawLine(n + n3 - 1, n2 + n7 / 2, n + n3 - 1, n2 + n4 - n7 / 2);
                    break;
                }
                case 4: {
                    int n8 = (int)((double)n3 * 0.4);
                    int n9 = Math.max(3, Math.min(8, (int)((double)n4 * 0.2)));
                    int n10 = 4;
                    if (n8 < 75) {
                        n8 += n8 / 2;
                    }
                    if (n8 < 10) {
                        n8 = Math.min(n8 + 4, n3 - n3 / 3);
                        n10 = 0;
                    }
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillRect(n, n2, n3 - 1, n4 - 1);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    int n11 = n;
                    int n12 = n2 + n9;
                    int n13 = n + n3 - 1;
                    int n14 = n12;
                    if (entityInstance.isOpen()) {
                        graphics.drawLine(n11, n12, n13, n14);
                        break;
                    }
                    int n15 = n + n10;
                    int n16 = n2 + n9;
                    graphics.drawLine(n11, n12, n15, n16);
                    int n17 = n15 + n9 / 2;
                    int n18 = n2;
                    graphics.drawLine(n15, n16, n17, n18);
                    int n19 = n + n8;
                    int n20 = n18;
                    graphics.drawLine(n17, n18, n19, n20);
                    int n21 = n19 + n9 / 2;
                    int n22 = n12;
                    graphics.drawLine(n19, n20, n21, n22);
                    graphics.drawLine(n21, n22, n13, n14);
                    break;
                }
                case 5: {
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillOval(n, n2, n3, n4);
                    }
                    graphics.setColor(this.m_entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawOval(n, n2, n3, n4);
                    break;
                }
                case 6: {
                    int n23 = n3 / 5;
                    int n24 = n4 / 5;
                    int n25 = Math.min(n23, n24);
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillRoundRect(n, n2, n3, n4, n25, n25);
                    }
                    graphics.setColor(Color.black);
                    graphics.drawRoundRect(n, n2, n3, n4, n25, n25);
                    break;
                }
                case 7: {
                    this.setGraphicsColor(graphics, color, entityInstance);
                    Util.drawOutlineBox(graphics, n, n2, n3, n4);
                    break;
                }
                case 8: {
                    this.setGraphicsColor(graphics, color, entityInstance);
                    Util.drawGroupBox(graphics, n, n2, n3, n4, entityInstance.getEntityLabel());
                    break;
                }
                case 10: {
                    int[] nArray = new int[4];
                    int[] nArray3 = new int[4];
                    nArray[0] = n;
                    nArray3[0] = n2;
                    nArray[1] = n + n3 / 2;
                    nArray3[1] = n2 + n4 - 1;
                    nArray[2] = n + n3 - 1;
                    nArray3[2] = n2;
                    nArray[3] = nArray[0];
                    nArray3[3] = nArray3[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray, nArray3, 4);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawPolygon(nArray, nArray3, 4);
                    break;
                }
                case 9: {
                    int[] nArray = new int[4];
                    int[] nArray3 = new int[4];
                    nArray[0] = n;
                    nArray3[0] = n2 + n4 - 1;
                    nArray[1] = n + n3 / 2;
                    nArray3[1] = n2;
                    nArray[2] = n + n3 - 1;
                    nArray3[2] = n2 + n4 - 1;
                    nArray[3] = nArray[0];
                    nArray3[3] = nArray3[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray, nArray3, 4);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawPolygon(nArray, nArray3, 4);
                    break;
                }
                case 11: {
                    int[] nArray = new int[5];
                    int[] nArray3 = new int[5];
                    nArray[0] = n;
                    nArray3[0] = n2 + n4 - 1;
                    nArray[1] = n + n3 / 5;
                    nArray3[1] = n2;
                    nArray[2] = n + n3 - 1;
                    nArray3[2] = n2;
                    nArray[3] = n + n3 * 4 / 5;
                    nArray3[3] = n2 + n4 - 1;
                    nArray[4] = nArray[0];
                    nArray3[4] = nArray3[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray, nArray3, 5);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawPolygon(nArray, nArray3, 5);
                    break;
                }
                case 12: {
                    int[] nArray = new int[5];
                    int[] nArray3 = new int[5];
                    nArray[0] = n + n3 / 5;
                    nArray3[0] = n2 + n4 - 1;
                    nArray[1] = n;
                    nArray3[1] = n2;
                    nArray[2] = n + 4 * n3 / 5;
                    nArray3[2] = n2;
                    nArray[3] = n + n3 - 1;
                    nArray3[3] = n2 + n4 - 1;
                    nArray[4] = nArray[0];
                    nArray3[4] = nArray3[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray, nArray3, 5);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawPolygon(nArray, nArray3, 5);
                    break;
                }
                case 13: {
                    int[] nArray = new int[5];
                    int[] nArray3 = new int[5];
                    nArray[0] = n + n3 / 2;
                    nArray3[0] = n2;
                    nArray[1] = n + n3 - 1;
                    nArray3[1] = n2 + n4 / 2;
                    nArray[2] = nArray[0];
                    nArray3[2] = n2 + n4 - 1;
                    nArray[3] = n;
                    nArray3[3] = nArray3[1];
                    nArray[4] = nArray[0];
                    nArray3[4] = nArray3[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray, nArray3, 5);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawPolygon(nArray, nArray3, 5);
                    break;
                }
                case 17: {
                    int[] nArray = new int[4];
                    int[] nArray3 = new int[4];
                    int n26 = n2 + n4 * 4 / 5;
                    nArray[0] = n + 3 * n3 / 8;
                    nArray3[0] = n26;
                    nArray[1] = nArray[0];
                    nArray3[1] = n2 + 193 * n4 / 200;
                    nArray[2] = n + 2 * n3 / 3;
                    nArray3[2] = n26;
                    nArray[3] = nArray[0];
                    nArray3[3] = nArray3[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillRect(0, 0, n3, n26);
                        graphics.fillArc(n, n2 + n4 / 2, n3 / 2, n4 / 2, -180, 180);
                        graphics.fillPolygon(nArray, nArray3, 4);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawLine(n, n2, n, n2 + n4 * 3 / 4);
                    graphics.drawLine(n, n2, n + n3 - 1, n2);
                    graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n26);
                    graphics.drawLine(n + 2 * n3 / 3, n26, n + n3 - 1, n2 + n26);
                    graphics.drawArc(n, n2 + n4 / 2, n + n3 / 2, n2 + n4 / 2 - 1, -180, 120);
                    graphics.drawLine(nArray[1], nArray3[1], nArray[2], nArray3[2]);
                    break;
                }
                case 14: {
                    int[] nArray = new int[6];
                    int[] nArray3 = new int[6];
                    nArray[0] = n + n3 / 2;
                    nArray3[0] = n2;
                    nArray[1] = nArray[0] + 475 * n3 / 1000;
                    nArray3[1] = n2 + 345 * n4 / 1000;
                    nArray[2] = nArray[0] + 293 * n3 / 1000;
                    nArray3[2] = n2 + 904 * n4 / 1000;
                    nArray[3] = nArray[0] - 293 * n3 / 1000;
                    nArray3[3] = nArray3[2];
                    nArray[4] = nArray[0] - 475 * n3 / 1000;
                    nArray3[4] = nArray3[1];
                    nArray[5] = nArray[0];
                    nArray3[5] = nArray3[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray, nArray3, 6);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawPolygon(nArray, nArray3, 6);
                    break;
                }
                case 15: {
                    int[] nArray = new int[7];
                    int[] nArray3 = new int[7];
                    nArray[0] = n;
                    nArray3[0] = n2 + n4 / 2;
                    nArray[1] = n + n3 / 4;
                    nArray3[1] = n2 + 66 * n4 / 1000;
                    nArray[2] = n + 3 * n3 / 4;
                    nArray3[2] = nArray3[1];
                    nArray[3] = n + n3;
                    nArray3[3] = nArray3[0];
                    nArray[4] = nArray[2];
                    nArray3[4] = n2 + 934 * n4 / 1000;
                    nArray[5] = nArray[1];
                    nArray3[5] = nArray3[4];
                    nArray[6] = nArray[0];
                    nArray3[6] = nArray3[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray, nArray3, 7);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawPolygon(nArray, nArray3, 7);
                    break;
                }
                case 16: {
                    int[] nArray = new int[9];
                    int[] nArray3 = new int[9];
                    int n27 = 191 * n3 / 1000;
                    int n11 = 461 * n3 / 1000;
                    int n28 = 191 * n4 / 1000;
                    int n29 = 461 * n4 / 1000;
                    nArray[0] = n + n3 / 2 - n27;
                    nArray3[0] = n2 + n4 / 2 - n29;
                    nArray[1] = n + n3 / 2 + n27;
                    nArray3[1] = nArray3[0];
                    nArray[2] = n + n3 / 2 + n11;
                    nArray3[2] = n2 + n4 / 2 - n28;
                    nArray[3] = nArray[2];
                    nArray3[3] = n2 + n4 / 2 + n28;
                    nArray[4] = nArray[1];
                    nArray3[4] = n2 + n4 / 2 + n29;
                    nArray[5] = nArray[0];
                    nArray3[5] = nArray3[4];
                    nArray[6] = n + n3 / 2 - n11;
                    nArray3[6] = nArray3[3];
                    nArray[7] = nArray[6];
                    nArray3[7] = nArray3[2];
                    nArray[8] = nArray[0];
                    nArray3[8] = nArray3[0];
                    if (bl) {
                        this.setGraphicsColor(graphics, color, entityInstance);
                        graphics.fillPolygon(nArray, nArray3, 9);
                    }
                    graphics.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    graphics.drawPolygon(nArray, nArray3, 9);
                    break;
                }
            }
            int n30 = -1;
            if (!entityInstance.isDrawRoot() && !entityInstance.isOpen()) {
                n30 = entityInstance.getClassImage();
            }
            switch (n30) {
                case 0: {
                    this.setGraphicsColor(graphics, color, entityInstance);
                    Color color2 = ColorCache.getInverse(graphics.getColor().getRGB());
                    graphics.setColor(color2);
                    int n31 = n3;
                    if (n4 < n31) {
                        n31 = n4;
                    }
                    int n32 = n3 / 2;
                    int n33 = n4 / 2;
                    graphics.drawOval(n32 - n31 / 10, n33 - 7 * n31 / 20, n31 / 5, n31 / 5);
                    graphics.drawLine(n32, n33 - 3 * n31 / 20, n32, n33 + 3 * n31 / 20);
                    graphics.drawLine(n32 - n31 / 4, n33 - n31 / 20, n32 + n31 / 4, n33 - n31 / 20);
                    graphics.drawLine(n32, n33 + 3 * n31 / 20, n32 - n31 / 5, n33 + 2 * n31 / 5);
                    graphics.drawLine(n32, n33 + 3 * n31 / 20, n32 + n31 / 5, n33 + 2 * n31 / 5);
                    break;
                }
                case 1: {
                    this.setGraphicsColor(graphics, color, entityInstance);
                    Color color3 = ColorCache.getInverse(graphics.getColor().getRGB());
                    graphics.setColor(color3);
                    graphics.drawOval(n, n2, n3, n4);
                    break;
                }
                case 2: {
                    this.setGraphicsColor(graphics, color, entityInstance);
                    Color color4 = ColorCache.getInverse(graphics.getColor().getRGB());
                    graphics.setColor(color4);
                    int n34 = n3;
                    if (n4 < n34) {
                        n34 = n4;
                    }
                    int n35 = n3 / 2;
                    int n36 = n4 / 2;
                    graphics.drawLine(n35 - n34 / 4, n36 - n34 / 4, n35 + n34 / 4, n36 + n34 / 4);
                    graphics.drawLine(n35 + n34 / 4, n36 - n34 / 4, n35 - n34 / 4, n36 + n34 / 4);
                    break;
                }
            }
        }
    }

    public void paintMap(Graphics graphics, int n, int n2, int n3, int n4, EntityInstance entityInstance, int n5) {
        if (n3 > 0 && n4 > 0) {
            EntityInstance entityInstance2 = this.m_entityInstance;
            Color color = entityInstance2 == entityInstance ? Color.green : entityInstance2.getInheritedObjectColor();
            this.paintShape(graphics, n, n2, n3, n4, !entityInstance2.hasChildren() || n5 == 1, color);
            if (n5 < 1) {
                Enumeration enumeration = entityInstance2.getChildren();
                while (enumeration.hasMoreElements()) {
                    EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
                    int n6 = n + (int)((double)n3 * entityInstance3.xRelLocal());
                    int n7 = n2 + (int)((double)n4 * entityInstance3.yRelLocal());
                    int n8 = (int)((double)n3 * entityInstance3.widthRelLocal());
                    int n9 = (int)((double)n4 * entityInstance3.heightRelLocal());
                    entityInstance3.paintMap(graphics, n6, n7, n8, n9, entityInstance, n5 + 1);
                }
            }
        }
    }

    protected void drawTopLeftLabel(Graphics graphics) {
        EntityInstance entityInstance = this.m_entityInstance;
        switch (entityInstance.getInheritedStyle()) {
            case 4: {
                graphics.setFont(EntityInstance.getSmallFont());
                int n = (int)((double)this.getWidth() * 0.4);
                int n2 = Math.max(3, Math.min(8, (int)((double)this.getHeight() * 0.2)));
                if (n < 75) {
                    n += n / 2;
                }
                if (n < 10) {
                    n = Math.min(n + 4, this.getWidth() - this.getWidth() / 3);
                }
                Util.drawStringClipped(graphics, entityInstance.getEntityLabel(), 4 + n2 / 2 + 2, 0.0, n, this.getHeight() - 10);
                break;
            }
            case 6: {
                graphics.setFont(EntityInstance.getOpenClassFont());
                Util.drawStringClipped(graphics, entityInstance.getEntityLabel(), 15.0, 5.0, this.getWidth() - 10, this.getHeight() - 10);
                break;
            }
            default: {
                graphics.setFont(EntityInstance.getSmallFont());
                Util.drawStringClipped(graphics, entityInstance.getEntityLabel(), 5.0, 5.0, this.getWidth() - 10, this.getHeight() - 10);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        EntityInstance entityInstance = this.m_entityInstance;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = 5;
        this.paintShape(graphics, 0, 0, n2, n3, true, null);
        Diagram diagram = entityInstance.getDiagram();
        LandscapeEditorCore landscapeEditorCore = diagram.getLs();
        if (landscapeEditorCore.isShowGrid() && entityInstance == diagram.getDrawRoot() && (n = diagram.getGrid()) > 1) {
            int n5;
            graphics.setColor(Color.WHITE);
            for (n5 = n; n5 < n3; n5 += n) {
                graphics.drawLine(0, n5, n2 - 1, n5);
            }
            for (n5 = n; n5 < n2; n5 += n) {
                graphics.drawLine(n5, 0, n5, n3 - 1);
            }
        }
        if (entityInstance.isMarked(4096)) {
            graphics.setColor(Color.white);
            graphics.drawRect(0, 0, n2, n3);
            graphics.drawRect(1, 1, n2 - 1, n3 - 1);
        }
        if (entityInstance.close_with_children_under_drawroot() && n2 > 11 && n3 > 17) {
            graphics.setColor(ColorCache.getInverse(entityInstance.getInheritedObjectColor().getRGB()));
            graphics.drawRect(3, 9, 8, 8);
            graphics.drawLine(4, 13, 10, 13);
            graphics.drawLine(7, 10, 7, 16);
            n4 += 11;
        }
        graphics.setColor(entityInstance.getCurrentLabelColor());
        switch (entityInstance.getInheritedStyle()) {
            case 8: {
                Util.drawGroupBoxLabel(graphics, 0, 0, n2, entityInstance.getEntityLabel());
                break;
            }
            default: {
                if (entityInstance.isOpen()) {
                    this.drawTopLeftLabel(graphics);
                    break;
                }
                String string = entityInstance.getEntityLabel();
                if (!entityInstance.isMarked(6)) {
                    graphics.setFont(entityInstance.getAdjustedClosedFont());
                } else {
                    graphics.setFont(ClientSupplierSet.getClientSupplierFont());
                    EntityInstance entityInstance2 = entityInstance.getContainedBy();
                    if (entityInstance2 != null) {
                        string = entityInstance2.getEntityLabel() + " .\n" + string;
                    }
                }
                Util.drawStringWrapped(graphics, string, n4, 5.0, this.getWidth() - 5 - n4, this.getHeight() - 10, true, false);
            }
        }
        if (entityInstance.getGroupFlag()) {
            graphics.setColor(entityInstance.getInheritedLabelColor());
            int n6 = n = n3 < 20 ? 4 : 6;
            if (entityInstance.getGroupKeyFlag()) {
                graphics.fillRect(1, 1, n, n);
                graphics.fillRect(n2 / 2 - n / 2, 1, n, n);
                graphics.fillRect(n2 - n, 1, n, n);
                graphics.fillRect(1, n3 / 2 - n / 2, n, n);
                graphics.fillRect(n2 - n, n3 / 2 - n / 2, n, n);
                graphics.fillRect(1, n3 - n, n, n);
                graphics.fillRect(n2 / 2 - n / 2, n3 - n, n, n);
                graphics.fillRect(n2 - n, n3 - n, n, n);
            } else {
                graphics.drawRect(1, 1, n, n);
                graphics.drawRect(n2 / 2 - n / 2, 1, n, n);
                graphics.drawRect(n2 - n - 1, 1, n, n);
                graphics.drawRect(1, n3 / 2 - n / 2, n, n);
                graphics.drawRect(n2 - n - 1, n3 / 2 - n / 2, n, n);
                graphics.drawRect(1, n3 - n - 1, n, n);
                graphics.drawRect(n2 / 2 - n / 2, n3 - n - 1, n, n);
                graphics.drawRect(n2 - n - 1, n3 - n - 1, n, n);
            }
        }
    }

    public int getIconWidth() {
        return this.getWidth();
    }

    public int getIconHeight() {
        return this.getHeight();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.translate(n, n2);
        this.paintComponent(graphics);
    }
}

