/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.FontCache;

public class FindBox
extends JDialog
implements ActionListener {
    protected JButton m_findButton;
    protected JButton m_canButton;
    protected JTextField m_patternField;
    protected JComboBox m_classes;
    protected JCheckBox m_caseSensitive;
    protected String m_pattern;
    protected EntityClass m_entityClass;

    public FindBox(JFrame jFrame, Diagram diagram) {
        super(jFrame, "Find Landscape Entities", true);
        Container container = this.getContentPane();
        this.m_pattern = null;
        this.m_entityClass = null;
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        container.setLayout(new BorderLayout());
        this.setFont(font);
        JLabel jLabel = new JLabel("Any java.util.regex.Pattern:");
        jLabel.setFont(font);
        container.add((Component)jLabel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.m_patternField = new JTextField("", 30);
        this.m_patternField.setFont(font);
        jPanel.add((Component)this.m_patternField, "North");
        this.m_classes = new JComboBox();
        this.m_classes.addItem("");
        Enumeration enumeration = diagram.enumEntityClassesInOrder();
        while (enumeration.hasMoreElements()) {
            EntityClass entityClass = (EntityClass)enumeration.nextElement();
            this.m_classes.addItem(entityClass);
        }
        jPanel.add((Component)this.m_classes, "Center");
        this.m_caseSensitive = new JCheckBox("Case sensitive");
        this.m_caseSensitive.setFont(font2);
        this.m_caseSensitive.setSelected(true);
        jPanel.add((Component)this.m_caseSensitive, "South");
        container.add((Component)jPanel, "Center");
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.m_findButton = new JButton("Find");
        this.m_findButton.setFont(font2);
        jPanel.add(this.m_findButton);
        this.m_findButton.addActionListener(this);
        this.m_canButton = new JButton("Cancel");
        this.m_canButton.setFont(font2);
        jPanel.add(this.m_canButton);
        this.m_canButton.addActionListener(this);
        container.add((Component)jPanel, "South");
        this.pack();
        if (jFrame != null) {
            this.setLocation(jFrame.getX() + 200, jFrame.getY() + 300);
        }
        this.setVisible(true);
    }

    public Pattern pattern() {
        Pattern pattern;
        if (this.m_pattern == null || this.m_pattern.equals("") || this.m_pattern.equals("*")) {
            pattern = null;
        } else {
            try {
                int n = this.m_caseSensitive.isSelected() ? 0 : 2;
                pattern = Pattern.compile(this.m_pattern, n |= 0x20);
            }
            catch (Exception exception) {
                System.out.println("Syntax error is regular expression '" + this.m_pattern + "'");
                pattern = null;
            }
        }
        return pattern;
    }

    public EntityClass entityClass() {
        return this.m_entityClass;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_findButton || object == this.m_canButton) {
            if (object == this.m_findButton) {
                this.m_pattern = this.m_patternField.getText();
                int n = this.m_classes.getSelectedIndex();
                if (n > 0) {
                    this.m_entityClass = (EntityClass)this.m_classes.getSelectedItem();
                }
            }
            this.setVisible(false);
        }
    }
}

