/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import lsedit.ColorCache;
import lsedit.FontCache;
import lsedit.StringLinizer;

public class HelpBox
extends JPanel {
    protected static final int GAP = 5;
    protected static final int HELP_WIDTH = 250;
    protected static final Color BACKGROUND_COLOUR = ColorCache.get(1.0f, 1.0f, 0.85f);
    protected static final Font textFont = FontCache.get("Helvetica", 0, 11);
    protected String text;
    protected boolean horizFit = false;

    protected void drawText(Graphics graphics, Rectangle rectangle) {
        int n = 5;
        int n2 = 5;
        String string = this.text;
        graphics.setColor(Color.black);
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight() - 2;
        n2 += n3;
        StringLinizer stringLinizer = new StringLinizer(string, fontMetrics, rectangle.width - 10);
        while (stringLinizer.hasMoreLines()) {
            String string2 = stringLinizer.nextLine();
            graphics.drawString(string2, n, n2);
            n2 += n3 + 2;
        }
    }

    protected int countLines(Graphics graphics, int n) {
        int n2 = 5;
        int n3 = 5;
        graphics.setFont(textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.text;
        StringLinizer stringLinizer = new StringLinizer(string, fontMetrics, n);
        int n4 = 0;
        while (stringLinizer.hasMoreLines()) {
            String string2 = stringLinizer.nextLine();
            ++n4;
        }
        return n4;
    }

    protected void setSize(Graphics graphics) {
        if (this.text != null) {
            graphics.setFont(textFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = this.horizFit ? fontMetrics.stringWidth(this.text) + 10 : 250;
            int n2 = fontMetrics.getHeight();
            int n3 = this.countLines(graphics, n - 10);
            this.setSize(n, n2 * n3 + 10);
        }
    }

    public HelpBox() {
        this.setBackground(BACKGROUND_COLOUR);
        this.setSize(250, 5);
        this.setVisible(false);
    }

    public void paintComponent(Graphics graphics) {
        this.setSize(graphics);
        Rectangle rectangle = this.getBounds();
        graphics.clearRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        if (this.text != null) {
            this.drawText(graphics, rectangle);
        }
    }

    public void set(String string, boolean bl) {
        this.text = string;
        this.repaint();
        this.horizFit = bl;
    }

    public void set(String string) {
        this.set(string, false);
    }
}

