/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.HiGraph;
import lsedit.HiGraphException;

public class HiArc {
    private HiGraph m_from;
    private HiGraph m_to;
    private boolean m_inclusion;
    private boolean m_reversed = false;
    private int m_cutvalue = 0;
    private int m_weight = 0;
    private int m_minlength = 0;
    int m_fromX;
    int m_fromY;
    int m_toX;
    int m_toY;

    HiArc(HiGraph hiGraph, HiGraph hiGraph2, boolean bl) {
        this.m_from = hiGraph;
        this.m_to = hiGraph2;
        this.m_inclusion = bl;
    }

    HiArc(HiGraph hiGraph, HiGraph hiGraph2) {
        this(hiGraph, hiGraph2, false);
    }

    public String toString() {
        String string = "";
        string = "(weight=" + this.m_weight + " minlength=" + this.m_minlength + ")";
        if (this.m_from == null || this.m_to == null) {
            System.out.println("Broken arc");
        }
        String string2 = this.m_inclusion ? "=" : "-";
        string = this.m_reversed ? string + this.m_from.label() + "<" + string2 + this.m_to.label() : string + this.m_from.label() + string2 + ">" + this.m_to.label();
        return string;
    }

    public HiGraph from() {
        return this.m_from;
    }

    void from(HiGraph hiGraph) {
        this.m_from = hiGraph;
    }

    public HiGraph to() {
        return this.m_to;
    }

    public boolean onSide() {
        return false;
    }

    public boolean inclusion() {
        return this.m_inclusion;
    }

    void reverse(boolean bl) {
        this.m_reversed = bl;
    }

    void reverse() {
        HiGraph hiGraph = this.m_from;
        this.m_from = this.m_to;
        this.m_to = hiGraph;
        this.m_reversed = !this.m_reversed;
    }

    boolean reversed() {
        return this.m_reversed;
    }

    void cutValue(int n) {
        this.m_cutvalue = n;
    }

    int cutValue() {
        return this.m_cutvalue;
    }

    public void setWeight(int n) {
        this.m_weight = n;
    }

    int getWeight() {
        return this.m_weight;
    }

    void setMinlength(int n) {
        this.m_minlength = n;
    }

    int getMinlength() {
        return this.m_minlength;
    }

    void dispose() throws HiGraphException {
        if (this.m_from == null) {
            throw new HiGraphException("Removing a non-existant arc");
        }
        this.m_from = null;
        this.m_to = null;
    }
}

